/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.AcroField;
import com.renderx.pdflib.ColorSpace;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.Resources;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.Sort;
import java.util.Enumeration;

public class Page
extends PDFObject {
    IndirectObject parent_id;
    List contentIDs;
    List annotIDs;
    int markedContentsCount;
    int structParents;
    boolean specifiedTabOrder;
    Hashtable pageboundaries;
    List printermarks;
    Hashtable acroFields;
    Resources resources;
    float width;
    float height;
    String number;
    String js_open = null;
    String js_close = null;
    boolean hasTransparencyGroup;
    ColorSpace colorSpace;

    Page(IndirectObject indirectObject, float f, float f2, String string) {
        super(indirectObject);
        this.width = f;
        this.height = f2;
        this.contentIDs = new List();
        this.annotIDs = new List();
        this.markedContentsCount = -1;
        this.structParents = -1;
        this.pageboundaries = new Hashtable();
        this.printermarks = new List();
        this.acroFields = new Hashtable();
        this.number = string;
        this.specifiedTabOrder = false;
        this.colorSpace = ColorSpace.cs_undefined;
        this.hasTransparencyGroup = false;
    }

    String getType() {
        return "Page";
    }

    void addResources(IndirectObject indirectObject) {
        this.resources = new Resources(indirectObject);
    }

    void addContentID(IndirectObject indirectObject) {
        this.contentIDs.append(indirectObject);
    }

    void addLinkID(IndirectObject indirectObject) {
        this.annotIDs.append(indirectObject);
    }

    void addAcroField(AcroField acroField) {
        this.acroFields.put(acroField.getID(), new Integer(acroField.getFieldNo()));
        this.addLinkID(acroField.getID());
    }

    void setMarkedContentID() {
        ++this.markedContentsCount;
    }

    int getMarkedContentID() {
        return this.markedContentsCount;
    }

    void setStructParents(int n) {
        this.structParents = n;
    }

    int getStructParents() {
        return this.structParents;
    }

    void setSize(int n, int n2) {
    }

    void setTabOrder() {
        this.specifiedTabOrder = true;
    }

    void setJSOpen(String string) {
        this.js_open = string;
    }

    void setJSClose(String string) {
        this.js_close = string;
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        Object object;
        boolean bl;
        pDFOutputStream.println("/Parent " + this.parent_id.toStringR());
        float[] fArray = this.getBleeds();
        float[] fArray2 = this.getCropOffsets();
        pDFOutputStream.println("/MediaBox [" + PDFOutputStream.pdf_float(-fArray2[0]) + " " + PDFOutputStream.pdf_float(-fArray2[1]) + " " + PDFOutputStream.pdf_float(this.width + fArray2[2]) + " " + PDFOutputStream.pdf_float(this.height + fArray2[3]) + "]");
        pDFOutputStream.println("/CropBox [" + PDFOutputStream.pdf_float(-fArray2[0]) + " " + PDFOutputStream.pdf_float(-fArray2[1]) + " " + PDFOutputStream.pdf_float(this.width + fArray2[2]) + " " + PDFOutputStream.pdf_float(this.height + fArray2[3]) + "]");
        pDFOutputStream.println("/BleedBox [" + PDFOutputStream.pdf_float(-fArray[0]) + " " + PDFOutputStream.pdf_float(-fArray[1]) + " " + PDFOutputStream.pdf_float(this.width + fArray[2]) + " " + PDFOutputStream.pdf_float(this.height + fArray[3]) + "]");
        pDFOutputStream.println("/TrimBox [0 0 " + PDFOutputStream.pdf_float(this.width) + " " + PDFOutputStream.pdf_float(this.height) + "]");
        this.contentIDs.unshift(new IndirectObject(pDFOutputStream.lastObjectNumber));
        pDFOutputStream.println("/Resources " + this.resources.getID().toStringR());
        pDFOutputStream.printVector("Contents", this.contentIDs);
        pDFOutputStream.print("\n");
        boolean bl2 = bl = this.hasTransparencyGroup && !pDFOutputStream.doc.hasPDFA() && !pDFOutputStream.doc.hasPDFX();
        if (bl) {
            object = null;
            if (this.colorSpace.cs == 2) {
                object = "/DeviceCMYK";
            } else if (this.colorSpace.cs == 1) {
                object = "/DeviceRGB";
            } else if (this.colorSpace.cs == 4) {
                object = "/DeviceGray";
            }
            if (object != null) {
                pDFOutputStream.println("/Group <</Type/Group /S/Transparency /CS" + (String)object + ">>");
            }
        }
        if (!this.acroFields.isEmpty()) {
            object = new List();
            Enumeration enumeration = this.acroFields.keys();
            while (enumeration.hasMoreElements()) {
                ((List)object).append(enumeration.nextElement());
            }
            List list = Sort.sort((List)object, (Sort.Cmp)new CmpFields(this.acroFields));
            List list2 = (List)list.clone();
            List list3 = new List();
            Enumeration enumeration2 = this.annotIDs.elements();
            while (enumeration2.hasMoreElements()) {
                Object e = enumeration2.nextElement();
                list3.append(list2.contains(e) ? list.shift() : e);
            }
            this.annotIDs = list3;
        }
        pDFOutputStream.printVector("Annots", this.annotIDs);
        pDFOutputStream.print("\n");
        if (this.js_open != null || this.js_close != null) {
            pDFOutputStream.print("/AA<<");
            if (this.js_open != null) {
                pDFOutputStream.print("/O <</JS");
                pDFOutputStream.printStringPDFEncoding(this.js_open);
                pDFOutputStream.print("/S/JavaScript>>");
            }
            if (this.js_close != null) {
                pDFOutputStream.print("/C <</JS");
                pDFOutputStream.printStringPDFEncoding(this.js_close);
                pDFOutputStream.print("/S/JavaScript>>");
            }
            pDFOutputStream.print(">>");
        }
        if (this.structParents != -1) {
            pDFOutputStream.println("/StructParents " + this.structParents);
        }
        if (this.specifiedTabOrder) {
            pDFOutputStream.println("/Tabs /S");
        }
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        this.resources.write(pDFOutputStream);
        float[] fArray = this.getBleeds();
        pDFOutputStream.lastObjectNumber = pDFOutputStream.beginStream((IndirectObject)new IndirectObject((int)pDFOutputStream.lastObjectNumber)).num;
        pDFOutputStream.println("q");
        pDFOutputStream.println(PDFOutputStream.pdf_float(-fArray[0]) + " " + PDFOutputStream.pdf_float(-fArray[1]) + " m");
        pDFOutputStream.println(PDFOutputStream.pdf_float(this.width + fArray[2]) + " " + PDFOutputStream.pdf_float(-fArray[1]) + " l");
        pDFOutputStream.println(PDFOutputStream.pdf_float(this.width + fArray[2]) + " " + PDFOutputStream.pdf_float(this.height + fArray[3]) + " l");
        pDFOutputStream.println(PDFOutputStream.pdf_float(-fArray[0]) + " " + PDFOutputStream.pdf_float(this.height + fArray[3]) + " l");
        pDFOutputStream.println("h");
        pDFOutputStream.println("W n");
        pDFOutputStream.endStream();
    }

    public float[] getBleeds() {
        float[] fArray = new float[4];
        int n = 0;
        while (n < fArray.length) {
            fArray[n] = 0.0f;
            ++n;
        }
        if (this.pageboundaries.containsKey("BLEED")) {
            fArray = (float[])this.pageboundaries.get("BLEED");
        }
        return fArray;
    }

    public float[] getCropOffsets() {
        float[] fArray = new float[4];
        int n = 0;
        while (n < fArray.length) {
            fArray[n] = 0.0f;
            ++n;
        }
        if (this.pageboundaries.containsKey("CROP_OFFSET")) {
            fArray = (float[])this.pageboundaries.get("CROP_OFFSET");
        }
        float[] fArray2 = this.getBleeds();
        int n2 = 0;
        while (n2 < fArray.length) {
            if (fArray[n2] < fArray2[n2]) {
                fArray[n2] = fArray2[n2];
            }
            ++n2;
        }
        return fArray;
    }

    public float getBleedMarkWidth() {
        return this.pageboundaries.containsKey("BLEED_MARK_WIDTH") ? new Float((String)this.pageboundaries.get("BLEED_MARK_WIDTH")).floatValue() : 0.0f;
    }

    public float getCropMarkWidth() {
        return this.pageboundaries.containsKey("CROP_MARK_WIDTH") ? new Float((String)this.pageboundaries.get("CROP_MARK_WIDTH")).floatValue() : 0.0f;
    }

    private class CmpFields
    implements Sort.Cmp {
        Hashtable h;

        public CmpFields() {
            this.h = new Hashtable();
        }

        public CmpFields(Hashtable hashtable) {
            this.h = hashtable;
        }

        public int cmp(Object object, Object object2) {
            return ((Integer)this.h.get(object)).compareTo((Integer)this.h.get(object2));
        }
    }
}

