/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.graphics.vector.PaintServer;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;

public abstract class PDFPattern
extends PDFObject {
    final PaintServer paintServer;

    PDFPattern(IndirectObject indirectObject, PaintServer paintServer) {
        super(indirectObject);
        this.paintServer = paintServer;
    }

    abstract String getPatternType();

    void writeBody(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.println("/Type /Pattern");
        pDFOutputStream.println("/PatternType " + this.getPatternType());
        this.writePatternContent(pDFOutputStream);
        pDFOutputStream.print("/Matrix [");
        double[] dArray = this.paintServer.matrix;
        int n = 0;
        while (n < dArray.length) {
            pDFOutputStream.print(PDFOutputStream.pdf_float(dArray[n]));
            if (n < dArray.length - 1) {
                pDFOutputStream.print(" ");
            }
            ++n;
        }
        pDFOutputStream.println("]");
    }

    abstract void writePatternContent(PDFOutputStream var1);

    abstract void writeSubObjects(PDFOutputStream var1);
}

