/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics;

import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.Media;
import com.renderx.graphics.ObjectRecordCoordinator;
import com.renderx.util.SeekableInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.InflaterInputStream;

public class Flash
extends Media {
    long NBITSLENGTH = 5L;
    private boolean isCompressed = false;
    private byte[] fileSize = new byte[4];
    private byte version;

    public Flash() {
        this.mimetype = "application/x-shockwave-flash";
    }

    public void parse() throws IOException, ImageFormatException {
        Object object;
        this.canCopyData = true;
        SeekableInput seekableInput = this.openSeekableImageStream();
        try {
            object = new byte[3];
            seekableInput.readFully((byte[])object);
            if (object[0] == 70 && object[1] == 87 && object[2] == 83) {
                this.isCompressed = false;
            } else if (object[0] == 67 && object[1] == 87 && object[2] == 83) {
                this.isCompressed = true;
            } else {
                throw new ImageFormatException("Invalid SWF signature in file '" + this.toDisplayString() + "'");
            }
            this.version = seekableInput.readByte();
            seekableInput.readFully(this.fileSize);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            seekableInput.close();
            throw throwable;
        }
        seekableInput.close();
        object = this.openImageStream();
        try {
            try {
                ((InputStream)object).skip(8L);
                if (this.isCompressed) {
                    object = new InflaterInputStream((InputStream)object);
                }
                long[] lArray = this.readBits((InputStream)object, this.NBITSLENGTH, 0L, 0L);
                long l = lArray[0];
                lArray = this.readBits((InputStream)object, l, lArray[1], lArray[2]);
                long l2 = this.correctSign(lArray[0], l);
                lArray = this.readBits((InputStream)object, l, lArray[1], lArray[2]);
                long l3 = this.correctSign(lArray[0], l);
                lArray = this.readBits((InputStream)object, l, lArray[1], lArray[2]);
                long l4 = this.correctSign(lArray[0], l);
                lArray = this.readBits((InputStream)object, l, lArray[1], lArray[2]);
                long l5 = this.correctSign(lArray[0], l);
                this.pxWidth = Math.abs(l3 - l2) / 20L;
                this.pxHeight = Math.abs(l5 - l4) / 20L;
            }
            catch (EOFException eOFException) {
                throw new ImageFormatException("Premature end of file or corrupt data in FLASH media " + this.toDisplayString(), this.mimetype);
            }
            Object var15_13 = null;
        }
        catch (Throwable throwable) {
            Object var15_14 = null;
            ((InputStream)object).close();
            throw throwable;
        }
        ((InputStream)object).close();
        this.setDimensions();
    }

    long[] readBits(InputStream inputStream, long l, long l2, long l3) throws IOException {
        long l4 = 0L;
        if (l <= l2) {
            l4 = l3 >> (int)(l2 - l);
            l3 &= (long)((1 << (int)(l2 -= l)) - 1);
        } else {
            int n;
            l4 = l3;
            long l5 = (l - l2) / 8L;
            int n2 = 0;
            while ((long)n2 < l5) {
                n = inputStream.read();
                if (n < 0) {
                    throw new EOFException();
                }
                l4 = (l4 << 8) + (long)n;
                ++n2;
            }
            if ((l2 = (8L - (l - l2) % 8L) % 8L) > 0L) {
                n = inputStream.read();
                if (n < 0) {
                    throw new EOFException();
                }
                l3 = n & (1 << (int)l2) - 1;
                l4 = (l4 << (int)(8L - l2)) + (long)(n >> (int)l2);
            } else {
                l3 = 0L;
            }
        }
        return new long[]{l4, l2, l3};
    }

    long correctSign(long l, long l2) {
        if (l >> (int)(l2 - 1L) != 0L) {
            return -(((l ^ 0xFFFFFFFFFFFFFFFFL) & (long)((1 << (int)(l2 - 1L)) - 1)) + 1L);
        }
        return l;
    }

    public void copyData(OutputStream outputStream, ObjectRecordCoordinator objectRecordCoordinator) throws IOException, ImageFormatException {
        InputStream inputStream = this.openImageStream();
        try {
            int n;
            byte[] byArray = new byte[objectRecordCoordinator != null ? objectRecordCoordinator.getRecordLength() : 8192];
            while ((n = inputStream.read(byArray)) != -1) {
                if (objectRecordCoordinator != null) {
                    objectRecordCoordinator.beginRecord(outputStream, n);
                }
                outputStream.write(byArray, 0, n);
                if (objectRecordCoordinator == null) continue;
                objectRecordCoordinator.endRecord(outputStream, n);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }
}

