/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts;

import com.renderx.fonts.FontConfigurationException;
import com.renderx.fonts.FontRecord;
import com.renderx.fonts.FontRecords;
import com.renderx.fonts.GlyphList;
import com.renderx.sax.ConfigHandler;
import com.renderx.sax.ConfigHandlerAdapter;
import com.renderx.sax.InputSource;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.DefaultErrorHandler;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.URLCache;
import com.renderx.util.URLSpec;
import com.renderx.util.UnicodeData;
import com.renderx.util.User;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class FontCatalog {
    private static final String DEFAULT_FAMILY = "Helvetica";
    private static final String FONTLIST = "resource:com/renderx/fonts/fonts.xml";
    private static final int WEIGHT_100 = 0;
    private static final int WEIGHT_200 = 1;
    private static final int WEIGHT_300 = 2;
    private static final int WEIGHT_400 = 3;
    private static final int WEIGHT_500 = 4;
    private static final int WEIGHT_600 = 5;
    private static final int WEIGHT_700 = 6;
    private static final int WEIGHT_800 = 7;
    private static final int WEIGHT_900 = 8;
    private static final int WEIGHT_TOTAL = 9;
    private static final int WEIGHT_NORMAL = 3;
    private static final int WEIGHT_BOLD = 6;
    private static final int WEIGHT_DEFAULT = 3;
    private static final int STYLE_NORMAL = 0;
    private static final int STYLE_ITALIC = 1;
    private static final int STYLE_OBLIQUE = 2;
    private static final int STYLE_BACKSLANT = 3;
    private static final int STYLE_TOTAL = 4;
    private static final int STYLE_SLANTED = 2;
    private static final int STYLE_DEFAULT = 0;
    private static final Hashtable styleIndexes = new Hashtable();
    private static final int VARIANT_NORMAL = 0;
    private static final int VARIANT_SMALLCAPS = 1;
    private static final int VARIANT_TOTAL = 2;
    private static final int VARIANT_DEFAULT = 0;
    private static final Hashtable variantIndexes;
    static final double DEFAULT_EXTRA_SLANT_ANGLE = 12.0;
    static final double DEFAULT_SMALLCAP_SIZE_RATIO = 0.8;
    private final Hashtable catalog = new Hashtable();
    private final Hashtable aliases = new Hashtable();
    private final Hashtable languageAliases = new Hashtable();
    private final ErrorHandler errHandler;
    private final URLCache cache;
    private FontFamilyDescriptor defaultFamily = null;
    private String configFileName = null;

    private static final int getWeightIndex(int n) {
        if (n <= 100) {
            return 0;
        }
        if (n <= 200) {
            return 1;
        }
        if (n <= 300) {
            return 2;
        }
        if (n <= 400) {
            return 3;
        }
        if (n <= 500) {
            return 4;
        }
        if (n <= 600) {
            return 5;
        }
        if (n <= 700) {
            return 6;
        }
        if (n <= 800) {
            return 7;
        }
        return 8;
    }

    private static final int getStyleIndex(String string) {
        if (string == null) {
            return 0;
        }
        Integer n = (Integer)styleIndexes.get(string.trim().toLowerCase());
        return n == null ? 0 : n;
    }

    private static final int getVariantIndex(String string) {
        if (string == null) {
            return 0;
        }
        Integer n = (Integer)variantIndexes.get(string.trim().toLowerCase());
        return n == null ? 0 : n;
    }

    public FontCatalog() throws IOException, FontConfigurationException {
        this(new DefaultErrorHandler());
    }

    public FontCatalog(ErrorHandler errorHandler) throws IOException, FontConfigurationException {
        this(new URLCache(errorHandler), errorHandler);
    }

    public FontCatalog(URLCache uRLCache, ErrorHandler errorHandler) throws IOException, FontConfigurationException {
        this(User.getProperty("com.renderx.xep.CONFIG"), uRLCache, errorHandler);
    }

    public FontCatalog(String string, URLCache uRLCache, ErrorHandler errorHandler) throws IOException, FontConfigurationException {
        this(new URLSpec(string == null ? FONTLIST : string), uRLCache, errorHandler);
    }

    public FontCatalog(URLSpec uRLSpec, URLCache uRLCache, ErrorHandler errorHandler) throws IOException, FontConfigurationException {
        this.cache = uRLCache;
        this.errHandler = errorHandler;
        GlyphList.init();
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(new ConfigHandlerAdapter(new Config(), uRLSpec));
            xMLReader.parse(new InputSource(uRLSpec));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new FontConfigurationException("Cannot parse " + uRLSpec + ": " + exception.toString());
        }
    }

    public FontCatalog(org.xml.sax.InputSource inputSource, XMLReader xMLReader, URLCache uRLCache, ErrorHandler errorHandler) throws IOException, FontConfigurationException {
        this.cache = uRLCache;
        this.errHandler = errorHandler;
        GlyphList.init();
        try {
            xMLReader.setContentHandler(new ConfigHandlerAdapter(new Config(), new URLSpec(inputSource.getSystemId())));
            xMLReader.parse(inputSource);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new FontConfigurationException("Cannot parse " + inputSource.getSystemId() + ": " + exception.toString());
        }
    }

    private static final String makeFamilyName(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isSpaceChar(c) && c != '\'' && c != '\"') {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString().toLowerCase();
    }

    public FontRecord getFontRecord(String string, int n, String string2, String string3) {
        return this.getFontRecord(string, n, string2, string3, 0);
    }

    public FontRecord getFontRecord(String string, int n, String string2, String string3, int n2) {
        FontFamilyDescriptor fontFamilyDescriptor = (FontFamilyDescriptor)this.catalog.get(FontCatalog.makeFamilyName(string));
        if (fontFamilyDescriptor == null) {
            fontFamilyDescriptor = this.defaultFamily;
        }
        int n3 = FontCatalog.getWeightIndex(n);
        int n4 = FontCatalog.getStyleIndex(string2);
        int n5 = FontCatalog.getVariantIndex(string3);
        return fontFamilyDescriptor.fonts.getFontRecord(n3, n4, n5, n2);
    }

    public List findAll(String string, int n, String string2, String string3, String string4, ErrorHandler errorHandler) {
        int n2;
        int n3 = FontCatalog.getWeightIndex(n);
        int n4 = FontCatalog.getStyleIndex(string2);
        int n5 = FontCatalog.getVariantIndex(string3);
        List list = new List();
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ",");
        if (!stringTokenizer.hasMoreTokens()) {
            int[] nArray = this.defaultFamily.fonts.getAllSizes();
            int n6 = 0;
            while (n6 < nArray.length) {
                list.append(this.defaultFamily.fonts.getFontRecord(n3, n4, n5, nArray[n6]));
                ++n6;
            }
            return list;
        }
        Hashtable hashtable = null;
        if (string4 != null && (hashtable = (Hashtable)this.languageAliases.get(string4 = string4.toLowerCase().trim())) == null && (n2 = string4.indexOf(45)) != -1) {
            string4 = string4.substring(0, n2).trim();
            hashtable = (Hashtable)this.languageAliases.get(string4);
        }
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            Object object2;
            String string5 = FontCatalog.makeFamilyName(stringTokenizer.nextToken());
            List list2 = null;
            if (hashtable != null) {
                list2 = (List)hashtable.get(string5);
            }
            if (list2 == null) {
                list2 = (List)this.aliases.get(string5);
            }
            if (list2 == null) {
                object2 = (FontFamilyDescriptor)this.catalog.get(string5);
                if (object2 == null) continue;
                object = ((FontFamilyDescriptor)object2).fonts.getAllSizes();
                int n7 = 0;
                while (n7 < ((int[])object).length) {
                    FontRecord fontRecord = ((FontFamilyDescriptor)object2).fonts.getFontRecord(n3, n4, n5, object[n7]);
                    if (fontRecord.getMetric() != null) {
                        list.append(fontRecord);
                    }
                    ++n7;
                }
                continue;
            }
            object2 = list2.elements();
            while (object2.hasMoreElements()) {
                object = (FontFamilyDescriptor)this.catalog.get((String)object2.nextElement());
                if (object == null) continue;
                int[] nArray = object.fonts.getAllSizes();
                int n8 = 0;
                while (n8 < nArray.length) {
                    FontRecord fontRecord = object.fonts.getFontRecord(n3, n4, n5, nArray[n8]);
                    if (fontRecord.getMetric() != null) {
                        list.append(fontRecord);
                    }
                    ++n8;
                }
            }
        }
        if (list.isEmpty()) {
            if (errorHandler != null) {
                errorHandler.warning("could not find any font family matching \"" + string + "\"; replaced by " + this.defaultFamily.familyName);
            }
            int[] nArray = this.defaultFamily.fonts.getAllSizes();
            int n9 = 0;
            while (n9 < nArray.length) {
                list.append(this.defaultFamily.fonts.getFontRecord(n3, n4, n5, nArray[n9]));
                ++n9;
            }
        }
        return list;
    }

    public void printWarning(String string) {
        if (this.errHandler == null) {
            return;
        }
        ErrorHandler errorHandler = this.errHandler;
        synchronized (errorHandler) {
            this.errHandler.warning(this.configFileName + ": " + string);
        }
    }

    public void printError(String string) {
        if (this.errHandler == null) {
            return;
        }
        ErrorHandler errorHandler = this.errHandler;
        synchronized (errorHandler) {
            this.errHandler.error(this.configFileName + ": " + string);
        }
    }

    public void printException(String string, Exception exception) {
        if (this.errHandler == null) {
            return;
        }
        ErrorHandler errorHandler = this.errHandler;
        synchronized (errorHandler) {
            this.errHandler.exception(this.configFileName + ": " + string, exception);
        }
    }

    static {
        styleIndexes.put("normal", new Integer(0));
        styleIndexes.put("italic", new Integer(1));
        styleIndexes.put("oblique", new Integer(2));
        styleIndexes.put("backslant", new Integer(3));
        variantIndexes = new Hashtable();
        variantIndexes.put("normal", new Integer(0));
        variantIndexes.put("small-caps", new Integer(1));
    }

    private class Config
    implements ConfigHandler {
        private static final String NSURI = "http://www.renderx.com/XEP/config";
        private String defaultFamilyName = "Helvetica";
        private int skip = 0;
        private final List tmpAliases = new List();

        private Config() {
        }

        public void startDocument(Hashtable hashtable) {
            hashtable.put("embed", "auto");
            hashtable.put("subset", "true");
            hashtable.put("ligatures", "");
            FontCatalog.this.configFileName = (String)hashtable.get("document");
        }

        public void endDocument(Hashtable hashtable) throws SAXException {
            FontCatalog.this.defaultFamily = (FontFamilyDescriptor)FontCatalog.this.catalog.get(FontCatalog.makeFamilyName(this.defaultFamilyName));
            if (FontCatalog.this.defaultFamily == null) {
                throw new SAXException("Default font family '" + this.defaultFamilyName + "' is not defined in the configuration file");
            }
            if (((FontCatalog)FontCatalog.this).defaultFamily.fonts.getFontRecord(3, 0, 0, 0).getMetric() == null) {
                throw new SAXException("Default font family '" + this.defaultFamilyName + "' is not accessible; cannot proceed");
            }
            this.processAliases();
        }

        public void startElement(String string, String string2, String string3, Attributes attributes, Hashtable hashtable) {
            String string4;
            String string5;
            Object object;
            CharSequence charSequence;
            String string6;
            String string7;
            if (this.skip > 0) {
                ++this.skip;
                return;
            }
            if (!"".equals(string) && !NSURI.equals(string)) {
                return;
            }
            String string8 = attributes.getValue("embed");
            if (string8 != null) {
                hashtable.put("embed", string8);
            }
            if ((string7 = attributes.getValue("subset")) != null) {
                hashtable.put("subset", string7);
            }
            if ((string6 = attributes.getValue("ligatures")) != null) {
                charSequence = new StringBuffer();
                int n = 0;
                while (n < string6.length()) {
                    char c = string6.charAt(n);
                    if (c != ' ' && c != ',' && string6.indexOf(c) == n) {
                        object = (char[])UnicodeData.LIGATURES.get(c);
                        if (object != null && ((Object)object).length > 1) {
                            ((StringBuffer)charSequence).append(c);
                        } else {
                            FontCatalog.this.printWarning("Character U+" + Integer.toHexString(c) + " is not recognized as a ligature; character ignored");
                        }
                    }
                    ++n;
                }
                hashtable.put("ligatures", ((StringBuffer)charSequence).toString());
            }
            if ((charSequence = attributes.getValue("initial-encoding")) != null) {
                hashtable.put("initial-encoding", charSequence);
            }
            if ((string5 = attributes.getValue("encoding")) != null) {
                hashtable.put("encoding", string5);
            }
            if ((string4 = attributes.getValue("codepage-name")) != null) {
                hashtable.put("codepage-name", string4);
            }
            if ((object = attributes.getValue("codepage-file")) != null) {
                hashtable.put("codepage-file", object);
            }
            if (string2.equals("fonts")) {
                String string9 = attributes.getValue("default-family");
                if (string9 != null) {
                    this.defaultFamilyName = string9;
                }
            } else if (string2.equals("font-family")) {
                if (hashtable.get("family") != null) {
                    FontCatalog.this.printError("Nested 'font-family' elements are not permitted: inner element ignored");
                    this.skip = 1;
                    return;
                }
                String string10 = this.getRequiredValue(string2, attributes, "name");
                if (string10 != null) {
                    hashtable.put("family", new FontFamilyDescriptor(string10));
                }
            } else if (string2.equals("font")) {
                Hashtable hashtable2 = new Hashtable();
                hashtable2.put("embed", hashtable.get("embed"));
                hashtable2.put("subset", hashtable.get("subset"));
                hashtable2.put("ligatures", hashtable.get("ligatures"));
                hashtable2.put("initial-encoding", hashtable.get("initial-encoding"));
                this.copyProperty(hashtable2, attributes, "weight");
                this.copyProperty(hashtable2, attributes, "style");
                this.copyProperty(hashtable2, attributes, "variant");
                hashtable2.put("encoding", hashtable.get("encoding"));
                hashtable2.put("codepage-name", hashtable.get("codepage-name"));
                this.copyURLProperty(hashtable2, (String)hashtable.get("codepage-file"), (URLSpec)hashtable.get("base"), "codepage-file");
                this.copyProperty(hashtable2, attributes, "size");
                hashtable.put("font-properties", hashtable2);
            } else if (string2.equals("font-data")) {
                Hashtable hashtable3 = (Hashtable)hashtable.get("font-properties");
                if (hashtable3 == null) {
                    FontCatalog.this.printError("'font-data' element outside of 'font'; element ignored");
                    return;
                }
                URLSpec uRLSpec = (URLSpec)hashtable.get("base");
                this.copyURLProperty(hashtable3, attributes, uRLSpec, "afm");
                this.copyURLProperty(hashtable3, attributes, uRLSpec, "pfa");
                this.copyURLProperty(hashtable3, attributes, uRLSpec, "pfb");
                this.copyURLProperty(hashtable3, attributes, uRLSpec, "ttf");
                this.copyURLProperty(hashtable3, attributes, uRLSpec, "otf");
                this.copyURLProperty(hashtable3, attributes, uRLSpec, "ttc");
                this.copyURLProperty(hashtable3, attributes, uRLSpec, "glyph-list");
                this.copyProperty(hashtable3, attributes, "subfont");
                this.copyURLProperty(hashtable3, attributes, uRLSpec, "charset-file");
                this.copyProperty(hashtable3, attributes, "charset-name");
            } else if (string2.equals("transform")) {
                Hashtable hashtable4 = (Hashtable)hashtable.get("font-properties");
                if (hashtable4 == null) {
                    FontCatalog.this.printError("'transform' element outside of 'font'; element ignored");
                    return;
                }
                this.copyProperty(hashtable4, attributes, "slant-angle");
                this.copyProperty(hashtable4, attributes, "smallcap-size");
            } else if (string2.equals("language")) {
                String string11 = this.getRequiredValue(string2, attributes, "codes");
                if (string11 == null) {
                    return;
                }
                if ("".equals(string11.replace(',', ' ').trim())) {
                    FontCatalog.this.printError("'codes' attribute on 'language' element contains no meaningful tokens: '" + string11 + "'");
                    this.skip = 1;
                    return;
                }
                hashtable.put("language-codes", string11);
            } else if (string2.equals("font-alias")) {
                String string12 = this.getRequiredValue(string2, attributes, "name");
                String string13 = this.getRequiredValue(string2, attributes, "value");
                if (string12 != null && string13 != null) {
                    this.tmpAliases.append(hashtable.get("language-codes"));
                    this.tmpAliases.append(string12.trim());
                    this.tmpAliases.append(string13.trim());
                }
            }
        }

        public void endElement(String string, String string2, String string3, Hashtable hashtable) {
            if (this.skip > 0) {
                --this.skip;
                return;
            }
            if (!"".equals(string) && !NSURI.equals(string)) {
                return;
            }
            if (string2.equals("font-family")) {
                FontFamilyDescriptor fontFamilyDescriptor = (FontFamilyDescriptor)hashtable.get("family");
                try {
                    fontFamilyDescriptor.fillAllSlots();
                }
                catch (FontConfigurationException fontConfigurationException) {
                    FontCatalog.this.printException("Cannot configure font family '" + fontFamilyDescriptor.familyName + "'", fontConfigurationException);
                }
                String string4 = FontCatalog.makeFamilyName(fontFamilyDescriptor.familyName);
                if (FontCatalog.this.catalog.get(string4) != null) {
                    FontCatalog.this.printError("Font family '" + fontFamilyDescriptor.familyName + "' defined twice; first definition preserved");
                } else {
                    FontCatalog.this.catalog.put(string4, fontFamilyDescriptor);
                }
            } else if (string2.equals("font")) {
                FontFamilyDescriptor fontFamilyDescriptor = (FontFamilyDescriptor)hashtable.get("family");
                if (fontFamilyDescriptor == null) {
                    FontCatalog.this.printError("'font' element outside of 'font-family' ignored");
                    return;
                }
                try {
                    fontFamilyDescriptor.addFontRecord((Hashtable)hashtable.get("font-properties"));
                }
                catch (FontConfigurationException fontConfigurationException) {
                    FontCatalog.this.printException("Cannot add font descriptor to font family '" + fontFamilyDescriptor.familyName + "'; element skipped", fontConfigurationException);
                }
            }
        }

        public void characters(char[] cArray, int n, int n2, Hashtable hashtable) {
            if (this.skip > 0) {
                return;
            }
        }

        public void processingInstruction(String string, String string2, Hashtable hashtable) {
            if (this.skip > 0) {
                return;
            }
        }

        private final String getRequiredValue(String string, Attributes attributes, String string2) {
            String string3 = attributes.getValue(string2);
            if (string3 == null) {
                FontCatalog.this.printError("Mandatory attribute '" + string2 + "' is missing on element '" + string + "'; element skipped");
                this.skip = 1;
            }
            return string3;
        }

        private final void copyURLProperty(Hashtable hashtable, Attributes attributes, URLSpec uRLSpec, String string) {
            String string2 = attributes.getValue(string);
            this.copyURLProperty(hashtable, string2, uRLSpec, string);
        }

        private final void copyURLProperty(Hashtable hashtable, String string, URLSpec uRLSpec, String string2) {
            if (string != null) {
                try {
                    hashtable.put(string2, new URLSpec(uRLSpec, string));
                }
                catch (MalformedURLException malformedURLException) {
                    FontCatalog.this.printException("Error processing attribute '" + string2 + "' on element 'font-data'; attribute ignored", malformedURLException);
                }
            }
        }

        private final void copyProperty(Hashtable hashtable, Attributes attributes, String string) {
            String string2 = attributes.getValue(string);
            if (string2 != null) {
                hashtable.put(string, string2);
            }
        }

        private void processAliases() {
            Enumeration enumeration = this.tmpAliases.elements();
            while (enumeration.hasMoreElements()) {
                Object object;
                String string = (String)enumeration.nextElement();
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)enumeration.nextElement();
                String string4 = FontCatalog.makeFamilyName(string2);
                if (FontCatalog.this.aliases.get(string4) != null && string == null) {
                    FontCatalog.this.printWarning("Alias '" + string2 + "' redefined; the first definition is kept");
                    continue;
                }
                List list = new List();
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken().trim();
                    if (object == null || ((String)object).length() == 0) continue;
                    if (FontCatalog.this.catalog.get(FontCatalog.makeFamilyName((String)object)) == null) {
                        FontCatalog.this.printWarning("Alias '" + string2 + "' contains reference to an undefined font family '" + (String)object + "'");
                        continue;
                    }
                    list.append(FontCatalog.makeFamilyName((String)object));
                }
                if (list.isEmpty()) {
                    FontCatalog.this.printError("No meaningful family names in the value of alias: '" + string2 + "'='" + string3 + "'");
                    continue;
                }
                if (string == null) {
                    FontCatalog.this.aliases.put(string4, list);
                    continue;
                }
                object = new StringTokenizer(string, " \t\r\n,");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string5 = ((StringTokenizer)object).nextToken().toLowerCase();
                    Hashtable hashtable = (Hashtable)FontCatalog.this.languageAliases.get(string5);
                    if (hashtable == null) {
                        hashtable = new Hashtable();
                        FontCatalog.this.languageAliases.put(string5, hashtable);
                    }
                    hashtable.put(string4, list);
                }
            }
        }
    }

    private class FontFamilyDescriptor {
        final String familyName;
        final FontRecords fonts = new FontRecords();

        FontFamilyDescriptor(String string) {
            this.familyName = string.trim();
        }

        void addFontRecord(Hashtable hashtable) throws FontConfigurationException {
            int n = 3;
            String string = (String)hashtable.get("weight");
            if (string != null) {
                if ("normal".equalsIgnoreCase(string = string.trim())) {
                    n = 3;
                } else if ("bold".equalsIgnoreCase(string)) {
                    n = 6;
                } else if ("100".equalsIgnoreCase(string)) {
                    n = 0;
                } else if ("200".equalsIgnoreCase(string)) {
                    n = 1;
                } else if ("300".equalsIgnoreCase(string)) {
                    n = 2;
                } else if ("400".equalsIgnoreCase(string)) {
                    n = 3;
                } else if ("500".equalsIgnoreCase(string)) {
                    n = 4;
                } else if ("600".equalsIgnoreCase(string)) {
                    n = 5;
                } else if ("700".equalsIgnoreCase(string)) {
                    n = 6;
                } else if ("800".equalsIgnoreCase(string)) {
                    n = 7;
                } else if ("900".equalsIgnoreCase(string)) {
                    n = 8;
                } else {
                    FontCatalog.this.printError("Unrecognized weight value '" + string + "' in font family " + this.familyName);
                }
            }
            int n2 = 0;
            String string2 = (String)hashtable.get("style");
            if (string2 != null) {
                Integer n3 = (Integer)styleIndexes.get(string2.trim().toLowerCase());
                if (n3 == null) {
                    FontCatalog.this.printError("Unrecognized style value '" + string2 + "' in font family " + this.familyName);
                } else {
                    n2 = n3;
                }
            }
            int n4 = 0;
            String string3 = (String)hashtable.get("variant");
            if (string3 != null) {
                Integer n5 = (Integer)variantIndexes.get(string3.trim().toLowerCase());
                if (n5 == null) {
                    FontCatalog.this.printError("Unrecognized variant value '" + string3 + "' in font family " + this.familyName);
                } else {
                    n4 = n5;
                }
            }
            this.fonts.putFontRecord(n, n2, n4, new FontRecord(this.familyName, hashtable, FontCatalog.this.cache, FontCatalog.this.errHandler));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void fillAllSlots() throws FontConfigurationException {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int[] nArray = this.fonts.getAllSizes();
            int n6 = 0;
            while (n6 < nArray.length) {
                n5 = 0;
                while (n5 < 4) {
                    n4 = 0;
                    while (n4 < 2) {
                        n3 = 0;
                        while (n3 < 9 && this.fonts.getFontRecord(n3, n5, n4, nArray[n6]) == null) {
                            ++n3;
                        }
                        if (n3 != 9) {
                            n2 = 0;
                            while (n2 < n3) {
                                this.fonts.putFontRecord(n2, n5, n4, this.fonts.getFontRecord(n3, n5, n4, nArray[n6]));
                                ++n2;
                            }
                            while (n3 < 9) {
                                n = n3;
                                n3 = n + 1;
                                while (n3 < 9 && this.fonts.getFontRecord(n3, n5, n4, nArray[n6]) == null) {
                                    ++n3;
                                }
                                if (n3 == 9) {
                                    n2 = n + 1;
                                    while (n2 < 9) {
                                        this.fonts.putFontRecord(n2, n5, n4, this.fonts.getFontRecord(n, n5, n4, nArray[n6]));
                                        ++n2;
                                    }
                                    continue;
                                }
                                n2 = n + 1;
                                while (n2 < n3) {
                                    this.fonts.putFontRecord(n2, n5, n4, this.fonts.getFontRecord(n2 - n <= n3 - n2 ? n : n3, n5, n4, nArray[n6]));
                                    ++n2;
                                }
                            }
                        }
                        ++n4;
                    }
                    ++n5;
                }
                ++n6;
            }
            n = 0;
            while (n < nArray.length) {
                n3 = 0;
                while (n3 < 9) {
                    n4 = 0;
                    while (n4 < 2) {
                        block31: {
                            block30: {
                                if (this.fonts.getFontRecord(n3, 2, n4, nArray[n]) == null && this.fonts.getFontRecord(n3, 1, n4, nArray[n]) != null) {
                                    this.fonts.putFontRecord(n3, 2, n4, this.fonts.getFontRecord(n3, 1, n4, nArray[n]));
                                } else if (this.fonts.getFontRecord(n3, 2, n4, nArray[n]) != null && this.fonts.getFontRecord(n3, 1, n4, nArray[n]) == null) {
                                    this.fonts.putFontRecord(n3, 1, n4, this.fonts.getFontRecord(n3, 2, n4, nArray[n]));
                                }
                                if (this.fonts.getFontRecord(n3, 0, n4, nArray[n]) != null) break block30;
                                n2 = 0;
                                while (n2 < 4 && this.fonts.getFontRecord(n3, n2, n4, nArray[n]) == null) {
                                    ++n2;
                                }
                                if (n2 == 4) break block31;
                                this.fonts.putFontRecord(n3, 0, n4, this.fonts.getFontRecord(n3, n2, n4, nArray[n]));
                            }
                            if (this.fonts.getFontRecord(n3, 2, n4, nArray[n]) == null) {
                                this.fonts.putFontRecord(n3, 2, n4, this.fonts.getFontRecord(n3, 0, n4, nArray[n]).cloneRecord());
                                this.fonts.getFontRecord((int)n3, (int)2, (int)n4, (int)nArray[n]).extraSlantAngle = 12.0;
                                this.fonts.putFontRecord(n3, 1, n4, this.fonts.getFontRecord(n3, 2, n4, nArray[n]));
                            }
                            if (this.fonts.getFontRecord(n3, 3, n4, nArray[n]) == null) {
                                this.fonts.putFontRecord(n3, 3, n4, this.fonts.getFontRecord(n3, 0, n4, nArray[n]).cloneRecord());
                                this.fonts.getFontRecord((int)n3, (int)3, (int)n4, (int)nArray[n]).extraSlantAngle = -12.0;
                            }
                        }
                        ++n4;
                    }
                    ++n3;
                }
                ++n;
            }
            int n7 = 0;
            while (n7 < nArray.length) {
                n3 = 0;
                while (n3 < 9) {
                    n5 = 0;
                    while (n5 < 4) {
                        if (this.fonts.getFontRecord(n3, n5, 0, nArray[n7]) == null) {
                            if (this.fonts.getFontRecord(n3, n5, 1, nArray[n7]) == null) throw new FontConfigurationException("No meaningful font records in the descriptor");
                            this.fonts.putFontRecord(n3, n5, 0, this.fonts.getFontRecord(n3, n5, 1, nArray[n7]));
                        } else if (this.fonts.getFontRecord(n3, n5, 1, nArray[n7]) == null) {
                            this.fonts.putFontRecord(n3, n5, 1, this.fonts.getFontRecord(n3, n5, 0, nArray[n7]).cloneRecord());
                            this.fonts.getFontRecord((int)n3, (int)n5, (int)1, (int)nArray[n7]).makeSmallCaps = true;
                            this.fonts.getFontRecord((int)n3, (int)n5, (int)1, (int)nArray[n7]).smallCapSizeRatio = 0.8;
                        }
                        ++n5;
                    }
                    ++n3;
                }
                ++n7;
            }
        }
    }
}

