/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep;

import com.renderx.sax.JAXPTransformerAdapter;
import com.renderx.util.Hashtable;
import com.renderx.util.User;
import com.renderx.xep.FOTarget;
import com.renderx.xep.Formatter;
import com.renderx.xep.lib.DefaultLogger;
import com.renderx.xep.lib.Logger;
import java.io.IOException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class FOTransformer {
    private static final String DEFAULT_RESOLVER_CLASS_NAME = "none";
    private final Transformer transformer;
    private final Formatter engine;
    private Logger storedLogger = null;
    private URIResolver storedResolver = null;
    private ErrorListener storedListener = null;
    private final Hashtable storedParameters = new Hashtable();

    public FOTransformer(Formatter formatter) {
        this(formatter, new DefaultLogger());
    }

    public FOTransformer(Formatter formatter, Logger logger) {
        this((Transformer)null, formatter, logger);
    }

    public FOTransformer(Source source, Formatter formatter) throws TransformerConfigurationException {
        this(source, formatter, (Logger)new DefaultLogger());
    }

    public FOTransformer(Source source, Formatter formatter, Logger logger) throws TransformerConfigurationException {
        this(FOTransformer.createTransformer(source, new LoggerListener(logger)), formatter, logger);
    }

    public FOTransformer(Transformer transformer, Formatter formatter) {
        this(transformer, formatter, (Logger)new DefaultLogger());
    }

    public FOTransformer(Transformer transformer, Formatter formatter, Logger logger) {
        this.transformer = transformer;
        this.engine = formatter;
        this.storedLogger = logger;
    }

    private static Transformer createTransformer(Source source, ErrorListener errorListener) throws TransformerConfigurationException {
        TransformerFactory transformerFactory = FOTransformer.createTransformerFactory(errorListener);
        Transformer transformer = transformerFactory.newTransformer(source);
        transformer.setErrorListener(errorListener);
        URIResolver uRIResolver = transformerFactory.getURIResolver();
        if (uRIResolver != null) {
            transformer.setURIResolver(uRIResolver);
        }
        return transformer;
    }

    private static TransformerFactory createTransformerFactory(ErrorListener errorListener) throws TransformerConfigurationException {
        TransformerFactory transformerFactory = null;
        try {
            transformerFactory = TransformerFactory.newInstance();
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw new TransformerConfigurationException(transformerFactoryConfigurationError.toString());
        }
        if (!transformerFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
            throw new TransformerConfigurationException("TransformerFactory does not support SAX result: cannot create FOTransformer");
        }
        transformerFactory.setErrorListener(errorListener);
        String string = User.getProperty("com.renderx.jaxp.uriresolver");
        if (string == null) {
            string = DEFAULT_RESOLVER_CLASS_NAME;
        }
        if (!DEFAULT_RESOLVER_CLASS_NAME.equals(string)) {
            try {
                transformerFactory.setURIResolver((URIResolver)Class.forName(string).newInstance());
            }
            catch (Exception exception) {
                throw new TransformerConfigurationException("Cannot create URI resolver " + string + ": " + exception.toString());
            }
        }
        return transformerFactory;
    }

    private XMLReader getReader() throws SAXException {
        if (this.transformer == null) {
            return null;
        }
        return new JAXPTransformerAdapter(this.transformer);
    }

    public void transform(Source source, FOTarget fOTarget) throws TransformerException, SAXException, IOException {
        if (this.transformer == null) {
            this.engine.render(source, fOTarget, this.storedLogger);
        } else {
            ContentHandler contentHandler = this.engine.createContentHandler(source.getSystemId(), fOTarget, this.storedLogger);
            if (this.storedListener == null) {
                this.transformer.setErrorListener(new ErrorListener(){

                    public void warning(TransformerException transformerException) throws TransformerException {
                        FOTransformer.this.storedLogger.warning(transformerException.getMessageAndLocation());
                    }

                    public void error(TransformerException transformerException) throws TransformerException {
                        FOTransformer.this.storedLogger.error(transformerException.getMessageAndLocation());
                    }

                    public void fatalError(TransformerException transformerException) throws TransformerException {
                        FOTransformer.this.storedLogger.exception(transformerException.getMessageAndLocation(), transformerException);
                    }
                });
            }
            this.transformer.transform(source, new SAXResult(contentHandler));
        }
    }

    public void clearParameters() {
        if (this.transformer == null) {
            this.storedParameters.clear();
        } else {
            this.transformer.clearParameters();
        }
    }

    public Object getParameter(String string) {
        return this.transformer == null ? this.storedParameters.get(string) : this.transformer.getParameter(string);
    }

    public void setParameter(String string, Object object) {
        if (this.transformer == null) {
            this.storedParameters.put(string, object);
        } else {
            this.transformer.setParameter(string, object);
        }
    }

    public URIResolver getURIResolver() {
        return this.transformer == null ? this.storedResolver : this.transformer.getURIResolver();
    }

    public ErrorListener getErrorListener() {
        return this.transformer == null ? this.storedListener : this.transformer.getErrorListener();
    }

    public void setURIResolver(URIResolver uRIResolver) {
        if (this.transformer == null) {
            this.storedResolver = uRIResolver;
        } else {
            this.transformer.setURIResolver(uRIResolver);
        }
    }

    public void setErrorListener(ErrorListener errorListener) {
        if (this.transformer == null) {
            this.storedListener = errorListener;
        } else {
            this.transformer.setErrorListener(errorListener);
        }
    }

    public Logger getLogger() {
        return this.storedLogger;
    }

    public void setLogger(Logger logger) {
        this.storedLogger = logger;
        if (this.transformer != null) {
            this.transformer.setErrorListener(new LoggerListener(logger));
        }
    }

    private static class LoggerListener
    implements ErrorListener {
        private final Logger logger;

        LoggerListener(Logger logger) {
            this.logger = logger;
        }

        public void warning(TransformerException transformerException) throws TransformerException {
            if (this.logger != Logger.NULL_LOGGER) {
                this.logger.warning(transformerException.getMessageAndLocation());
            }
        }

        public void error(TransformerException transformerException) throws TransformerException {
            if (this.logger != Logger.NULL_LOGGER) {
                this.logger.error(transformerException.getMessageAndLocation());
            }
        }

        public void fatalError(TransformerException transformerException) throws TransformerException {
            if (this.logger != Logger.NULL_LOGGER) {
                this.logger.exception(transformerException.getMessageAndLocation(), transformerException);
            }
        }
    }
}

