/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.util;

import com.renderx.util.Array;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LZWDecoderStream
extends FilterOutputStream {
    int initialCodeSize = -1;
    boolean LSBfirst = true;
    int earlyCodeSwitch = 0;
    int CLEAR = 0;
    int EOD = 0;
    int code = 0;
    int codeSize = -1;
    int codeMask = 0;
    int oldCode = -1;
    boolean stop = false;
    byte[] currentChar = null;
    byte[] prefix = null;
    int bits = 0;
    int bitCount = 0;
    int codetableLength = 0;
    final Array codetable = new Array();
    byte[] buffer = new byte[65536];
    int bufferCounter = 0;
    boolean countData = false;
    int bytesToDecode = 0;
    boolean overflowPending = false;

    public LZWDecoderStream(OutputStream outputStream, int n, boolean bl, boolean bl2, int n2) {
        super(outputStream);
        this.LSBfirst = bl;
        int n3 = this.earlyCodeSwitch = bl2 ? 1 : 0;
        if (n2 == -1) {
            this.countData = false;
        } else {
            this.countData = true;
            this.bytesToDecode = n2;
        }
        this.initialCodeSize = n + 1;
        this.CLEAR = 1 << n;
        this.EOD = this.CLEAR + 1;
        int n4 = 0;
        while (n4 <= this.EOD) {
            this.codetable.put(n4, new byte[]{(byte)n4});
            ++n4;
        }
        this.clear();
    }

    public void write(byte[] byArray) throws IOException {
        int n = 0;
        while (n < byArray.length) {
            this.write(byArray[n] & 0xFF);
            ++n;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.write(byArray[n + n3] & 0xFF);
            ++n3;
        }
    }

    public void write(int n) throws IOException {
        if (this.stop) {
            return;
        }
        this.bits = this.LSBfirst ? (this.bits |= n << this.bitCount) : this.bits << 8 | n;
        this.bitCount += 8;
        while (this.bitCount >= this.codeSize) {
            if (this.LSBfirst) {
                this.code = this.bits & this.codeMask;
                this.bits >>= this.codeSize;
            } else {
                this.code = this.bits >> this.bitCount - this.codeSize;
            }
            this.bitCount -= this.codeSize;
            this.bits &= (1 << this.bitCount) - 1;
            this.dispatch();
            if (this.code != this.EOD) continue;
            this.stop = true;
            this.flush();
            return;
        }
    }

    void clear() {
        this.overflowPending = false;
        this.codeSize = this.initialCodeSize;
        this.codeMask = (1 << this.codeSize) - 1;
        this.oldCode = -1;
        this.currentChar = null;
        this.prefix = null;
        this.codetableLength = this.EOD + 1;
    }

    void dispatch() throws IOException {
        if (this.code == this.CLEAR) {
            this.clear();
            return;
        }
        if (this.code == this.EOD) {
            return;
        }
        if (this.overflowPending) {
            throw new IOException("LZWDecoder: LZW overflow - codeword length > 12");
        }
        if (this.code > this.codetableLength) {
            throw new IOException("LZWDecoder: unexpected code in data stream " + this.code + "(codetable length is " + this.codetableLength + ")");
        }
        if (this.code < this.codetableLength) {
            this.currentChar = (byte[])this.codetable.get(this.code);
            if (this.oldCode != -1) {
                this.codetable.put(this.codetableLength, this.addByte(this.prefix, this.currentChar[0]));
                ++this.codetableLength;
            }
        } else {
            this.currentChar = this.addByte(this.prefix, this.prefix[0]);
            this.codetable.put(this.codetableLength, this.currentChar);
            ++this.codetableLength;
        }
        this.bufferedWrite(this.currentChar);
        if (this.countData) {
            this.bytesToDecode -= this.currentChar.length;
            if (this.bytesToDecode <= 0) {
                this.code = this.EOD;
                return;
            }
        }
        this.prefix = this.currentChar;
        this.oldCode = this.code;
        if (this.codetableLength + this.earlyCodeSwitch >> this.codeSize != 0) {
            if (this.codeSize == 12) {
                this.overflowPending = true;
            } else {
                ++this.codeSize;
            }
            this.codeMask = (1 << this.codeSize) - 1;
        }
    }

    public void flush() throws IOException {
        this.out.write(this.buffer, 0, this.bufferCounter);
        this.bufferCounter = 0;
        this.out.flush();
    }

    byte[] addByte(byte[] byArray, byte by) {
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = by;
        return byArray2;
    }

    void bufferedWrite(byte[] byArray) throws IOException {
        if (65536 - this.bufferCounter < byArray.length) {
            this.out.write(this.buffer, 0, this.bufferCounter);
            this.bufferCounter = 0;
        }
        System.arraycopy(byArray, 0, this.buffer, this.bufferCounter, byArray.length);
        this.bufferCounter += byArray.length;
    }
}

