/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.sax;

import com.renderx.sax.ConfigHandler;
import com.renderx.sax.InputSource;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.Hashtable;
import com.renderx.util.Stack;
import com.renderx.util.URLSpec;
import java.io.IOException;
import java.net.MalformedURLException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigHandlerAdapter
extends DefaultHandler {
    private final ConfigHandler handler;
    private final Stack contextStack = new Stack();
    private final URLSpec doc;
    private boolean insideHref = false;
    private String expectedElementName = null;
    private String expectedNamespaceURI = null;
    private int nestedFragments = 0;

    private Hashtable peekContext() throws SAXException {
        if (this.contextStack.isEmpty()) {
            throw new SAXException("Context stack underflow; probably bad order of calls to SAX ContextHandler");
        }
        return (Hashtable)this.contextStack.peek();
    }

    public ConfigHandlerAdapter(ConfigHandler configHandler, URLSpec uRLSpec) {
        this.handler = configHandler;
        this.doc = uRLSpec;
    }

    public void startDocument() throws SAXException {
        if (this.nestedFragments++ == 0) {
            Hashtable hashtable = new Hashtable();
            hashtable.put("base", this.doc);
            hashtable.put("document", this.doc.toString());
            this.contextStack.push(hashtable);
            this.handler.startDocument(hashtable);
        }
    }

    public void endDocument() throws SAXException {
        if (--this.nestedFragments == 0) {
            this.handler.endDocument(this.peekContext());
            this.contextStack.pop();
            if (!this.contextStack.isEmpty()) {
                throw new SAXException("Context stack is not empty after the end of the document is reached; probably bad order of calls to SAX ContextHandler");
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.insideHref) {
            throw new SAXException("Elements with 'href' attribute must be empty");
        }
        Hashtable hashtable = this.peekContext();
        if (this.expectedElementName != null) {
            if (!this.expectedElementName.equals(string2)) {
                throw new SAXException("In remote fragment " + hashtable.get("document") + ", root element '" + string2 + "' does not match the referring element '" + this.expectedElementName + "'");
            }
            if (!this.expectedNamespaceURI.equals(string)) {
                throw new SAXException("In remote fragment " + hashtable.get("document") + ", root namespace '" + string + "' does not match the referring element namespace '" + this.expectedNamespaceURI + "'");
            }
            this.expectedElementName = null;
            this.expectedNamespaceURI = null;
        }
        Hashtable hashtable2 = (Hashtable)hashtable.clone();
        this.contextStack.push(hashtable2);
        try {
            String string4 = attributes.getValue("href");
            if (string4 == null) {
                String string5 = attributes.getValue("http://www.w3.org/XML/1998/namespace", "base");
                if (string5 != null) {
                    URLSpec uRLSpec = new URLSpec((URLSpec)hashtable2.get("base"), string5);
                    hashtable2.put("base", uRLSpec);
                }
                this.handler.startElement(string, string2, string3, attributes, hashtable2);
            } else {
                this.expectedElementName = string2;
                this.expectedNamespaceURI = string;
                URLSpec uRLSpec = new URLSpec((URLSpec)hashtable2.get("base"), string4);
                hashtable2.put("base", uRLSpec);
                hashtable2.put("document", uRLSpec.toString());
                XMLReader xMLReader = XMLReaderFactory.createXMLReader();
                xMLReader.setContentHandler(this);
                xMLReader.parse(new InputSource(uRLSpec));
                this.insideHref = true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new SAXException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.insideHref) {
            this.insideHref = false;
        } else {
            this.handler.endElement(string, string2, string3, this.peekContext());
        }
        this.contextStack.pop();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.insideHref) {
            throw new SAXException("Elements with 'href' attribute must be empty");
        }
        this.handler.characters(cArray, n, n2, this.peekContext());
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.insideHref) {
            throw new SAXException("Elements with 'href' attribute must be empty");
        }
        this.handler.processingInstruction(string, string2, this.peekContext());
    }
}

