/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pslib;

import com.renderx.pslib.InternalException;
import com.renderx.pslib.PSOutputStream;
import com.renderx.util.Hashtable;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class Names {
    private Hashtable targets = new Hashtable();
    private Hashtable usedTargets = new Hashtable();
    private Hashtable mangled2normal = new Hashtable();
    private Hashtable normal2mangled = new Hashtable();

    void addDestination(String string, int n, float f, float f2) {
        if (this.targets.containsKey(string)) {
            return;
        }
        this.targets.put(string, new Destination(n, f, f2));
    }

    Destination getDestination(String string) {
        return (Destination)this.targets.get(string);
    }

    void markUsed(String string) {
        this.usedTargets.put(string, string);
    }

    void write(PSOutputStream pSOutputStream, boolean bl) throws IOException {
        Enumeration enumeration = bl ? this.usedTargets.keys() : this.targets.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Destination destination = (Destination)this.targets.get(string);
            if (destination == null) continue;
            pSOutputStream.print("[/Dest /" + string);
            pSOutputStream.print(" /Page " + destination.page + " /View [/XYZ " + destination.x + " " + destination.y + " 0]");
            pSOutputStream.println(" /DEST pdfmark");
        }
    }

    String makePSName(String string) {
        int n;
        String string2 = (String)this.normal2mangled.get(string);
        if (string2 != null) {
            return string2;
        }
        if (new StringTokenizer(string, "$+-_.:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz").hasMoreTokens()) {
            string2 = "";
            int n2 = 0;
            while (n2 < string.length()) {
                n = string.charAt(n2);
                if ("$+-_.:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".indexOf(n) != -1) {
                    string2 = string2 + (char)n;
                }
                ++n2;
            }
        } else {
            string2 = string;
        }
        if (string2.length() > 127) {
            string2 = string2.substring(0, 127);
        }
        if (string2.length() == 0 || this.mangled2normal.get(string2) != null) {
            String string3 = string2;
            if (string3.length() > 118) {
                string3 = string3.substring(0, 118);
            }
            n = 0;
            while (true) {
                String string4 = "x" + Integer.toHexString(n);
                string2 = string3 + string4;
                if (this.mangled2normal.get(string2) == null) break;
                ++n;
            }
        }
        if (this.mangled2normal.get(string2) != null) {
            throw new InternalException("Cannot generate a unique PostScript name from string " + string);
        }
        this.normal2mangled.put(string, string2);
        this.mangled2normal.put(string2, string);
        return string2;
    }

    static class Destination {
        int page = -1;
        float x = 0.0f;
        float y = 0.0f;

        Destination(int n, float f, float f2) {
            this.page = n;
            this.x = f;
            this.y = f2;
        }
    }
}

