/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib.parser;

import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.parser.PDFElement;
import com.renderx.pdflib.parser.PDFInstance;
import com.renderx.util.List;
import java.io.IOException;

public class PDFString
extends PDFElement {
    String text;
    int strlen;

    public PDFString(String string) {
        this.text = string;
        this.strlen = this.text.length();
    }

    String getString() {
        return this.text;
    }

    public void quote(PDFOutputStream pDFOutputStream) {
        int n = 0;
        while (n < this.strlen) {
            byte by = (byte)this.text.charAt(n);
            if (0 <= by && by < 32) {
                pDFOutputStream.print('\\');
                pDFOutputStream.print(48 + (by >> 6 & 7));
                pDFOutputStream.print(48 + (by >> 3 & 7));
                pDFOutputStream.print(48 + (by & 7));
            } else if (by == 40 || by == 41 || by == 92) {
                pDFOutputStream.print('\\');
                pDFOutputStream.print(by);
            } else {
                pDFOutputStream.print(by);
            }
            ++n;
        }
    }

    public void quote(PDFOutputStream pDFOutputStream, byte by) {
        if (0 <= by && by < 32) {
            pDFOutputStream.print('\\');
            pDFOutputStream.print(48 + (by >> 6 & 7));
            pDFOutputStream.print(48 + (by >> 3 & 7));
            pDFOutputStream.print(48 + (by & 7));
        } else if (by == 40 || by == 41 || by == 92) {
            pDFOutputStream.print('\\');
            pDFOutputStream.print(by);
        } else {
            pDFOutputStream.print(by);
        }
    }

    public void quote(PDFOutputStream pDFOutputStream, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        int n = 0;
        while (n < byArray.length) {
            this.quote(pDFOutputStream, byArray[n]);
            ++n;
        }
    }

    public void unicode_quote(PDFOutputStream pDFOutputStream) {
        int n = this.text.length();
        byte[] byArray = new byte[n * 2 + 2];
        byArray[0] = -2;
        byArray[1] = -1;
        int n2 = 0;
        while (n2 < n) {
            char c = this.text.charAt(n2);
            byArray[n2 * 2 + 2] = (byte)(c >> 8 & 0xFF);
            byArray[n2 * 2 + 3] = (byte)(c & 0xFF);
            ++n2;
        }
        this.quote(pDFOutputStream, pDFOutputStream.getUseEncryption() ? pDFOutputStream.encryptArray(byArray) : byArray);
    }

    public void pdfencoding_quote(PDFOutputStream pDFOutputStream) {
        byte[] byArray = new byte[this.strlen];
        int n = 0;
        while (n < this.strlen) {
            char c = this.text.charAt(n);
            switch (c) {
                case '\u02c6': {
                    byArray[n] = 26;
                    break;
                }
                case '\u02d9': {
                    byArray[n] = 27;
                    break;
                }
                case '\u02dd': {
                    byArray[n] = 28;
                    break;
                }
                case '\u02db': {
                    byArray[n] = 29;
                    break;
                }
                case '\u02da': {
                    byArray[n] = 30;
                    break;
                }
                case '\u02dc': {
                    byArray[n] = 31;
                    break;
                }
                case '\u2022': {
                    byArray[n] = -128;
                    break;
                }
                case '\u2020': {
                    byArray[n] = -127;
                    break;
                }
                case '\u2021': {
                    byArray[n] = -126;
                    break;
                }
                case '\u2026': {
                    byArray[n] = -125;
                    break;
                }
                case '\u2014': {
                    byArray[n] = -124;
                    break;
                }
                case '\u2013': {
                    byArray[n] = -123;
                    break;
                }
                case '\u0192': {
                    byArray[n] = -122;
                    break;
                }
                case '\u2044': {
                    byArray[n] = -121;
                    break;
                }
                case '\u2039': {
                    byArray[n] = -120;
                    break;
                }
                case '\u203a': {
                    byArray[n] = -119;
                    break;
                }
                case '\u2212': {
                    byArray[n] = -118;
                    break;
                }
                case '\u2030': {
                    byArray[n] = -117;
                    break;
                }
                case '\u201e': {
                    byArray[n] = -116;
                    break;
                }
                case '\u201c': {
                    byArray[n] = -115;
                    break;
                }
                case '\u201d': {
                    byArray[n] = -114;
                    break;
                }
                case '\u2018': {
                    byArray[n] = -113;
                    break;
                }
                case '\u2019': {
                    byArray[n] = -112;
                    break;
                }
                case '\u201a': {
                    byArray[n] = -111;
                    break;
                }
                case '\u2122': {
                    byArray[n] = -110;
                    break;
                }
                case '\ufb01': {
                    byArray[n] = -109;
                    break;
                }
                case '\ufb02': {
                    byArray[n] = -108;
                    break;
                }
                case '\u0141': {
                    byArray[n] = -107;
                    break;
                }
                case '\u0152': {
                    byArray[n] = -106;
                    break;
                }
                case '\u0160': {
                    byArray[n] = -105;
                    break;
                }
                case '\u0178': {
                    byArray[n] = -104;
                    break;
                }
                case '\u017d': {
                    byArray[n] = -103;
                    break;
                }
                case '\u0131': {
                    byArray[n] = -102;
                    break;
                }
                case '\u0142': {
                    byArray[n] = -101;
                    break;
                }
                case '\u0153': {
                    byArray[n] = -100;
                    break;
                }
                case '\u0161': {
                    byArray[n] = -99;
                    break;
                }
                case '\u017e': {
                    byArray[n] = -98;
                    break;
                }
                case '\u20ac': {
                    byArray[n] = -96;
                    break;
                }
                case '\u0100': 
                case '\u0102': 
                case '\u0104': {
                    byArray[n] = 65;
                    break;
                }
                case '\u0101': 
                case '\u0103': 
                case '\u0105': {
                    byArray[n] = 97;
                    break;
                }
                case '\u0106': 
                case '\u0108': 
                case '\u010a': 
                case '\u010c': {
                    byArray[n] = 67;
                    break;
                }
                case '\u0107': 
                case '\u0109': 
                case '\u010b': 
                case '\u010d': {
                    byArray[n] = 99;
                    break;
                }
                case '\u010e': {
                    byArray[n] = 68;
                    break;
                }
                case '\u0110': {
                    byArray[n] = -48;
                    break;
                }
                case '\u010f': 
                case '\u0111': {
                    byArray[n] = 100;
                    break;
                }
                case '\u0112': 
                case '\u0114': 
                case '\u0116': 
                case '\u0118': 
                case '\u011a': {
                    byArray[n] = 69;
                    break;
                }
                case '\u0113': 
                case '\u0115': 
                case '\u0117': 
                case '\u0119': 
                case '\u011b': {
                    byArray[n] = 101;
                    break;
                }
                case '\u011c': 
                case '\u011e': 
                case '\u0120': 
                case '\u0122': {
                    byArray[n] = 71;
                    break;
                }
                case '\u011d': 
                case '\u011f': 
                case '\u0121': 
                case '\u0123': {
                    byArray[n] = 103;
                    break;
                }
                case '\u0124': 
                case '\u0126': {
                    byArray[n] = 72;
                    break;
                }
                case '\u0125': 
                case '\u0127': {
                    byArray[n] = 104;
                    break;
                }
                case '\u0128': 
                case '\u012a': 
                case '\u012c': 
                case '\u012e': 
                case '\u0130': {
                    byArray[n] = 73;
                    break;
                }
                case '\u0129': 
                case '\u012b': 
                case '\u012d': 
                case '\u012f': {
                    byArray[n] = 105;
                    break;
                }
                case '\u0132': 
                case '\u0134': {
                    byArray[n] = 74;
                    break;
                }
                case '\u0133': 
                case '\u0135': {
                    byArray[n] = 106;
                    break;
                }
                case '\u0136': {
                    byArray[n] = 75;
                    break;
                }
                case '\u0137': 
                case '\u0138': {
                    byArray[n] = 107;
                    break;
                }
                case '\u0139': 
                case '\u013b': 
                case '\u013d': 
                case '\u013f': {
                    byArray[n] = 76;
                    break;
                }
                case '\u013a': 
                case '\u013c': 
                case '\u013e': 
                case '\u0140': {
                    byArray[n] = 108;
                    break;
                }
                case '\u0143': 
                case '\u0145': 
                case '\u0147': 
                case '\u014a': {
                    byArray[n] = 78;
                    break;
                }
                case '\u0144': 
                case '\u0146': 
                case '\u0148': 
                case '\u0149': 
                case '\u014b': {
                    byArray[n] = 110;
                    break;
                }
                case '\u014c': 
                case '\u014e': 
                case '\u0150': {
                    byArray[n] = 79;
                    break;
                }
                case '\u014d': 
                case '\u014f': 
                case '\u0151': {
                    byArray[n] = 111;
                    break;
                }
                case '\u0154': 
                case '\u0156': 
                case '\u0158': {
                    byArray[n] = 82;
                    break;
                }
                case '\u0155': 
                case '\u0157': 
                case '\u0159': {
                    byArray[n] = 114;
                    break;
                }
                case '\u015a': 
                case '\u015c': 
                case '\u015e': {
                    byArray[n] = 83;
                    break;
                }
                case '\u015b': 
                case '\u015d': 
                case '\u015f': 
                case '\u017f': {
                    byArray[n] = 115;
                    break;
                }
                case '\u0162': 
                case '\u0164': 
                case '\u0166': {
                    byArray[n] = 84;
                    break;
                }
                case '\u0163': 
                case '\u0165': 
                case '\u0167': {
                    byArray[n] = 116;
                    break;
                }
                case '\u0168': 
                case '\u016a': 
                case '\u016c': 
                case '\u016e': 
                case '\u0170': 
                case '\u0172': {
                    byArray[n] = 85;
                    break;
                }
                case '\u0169': 
                case '\u016b': 
                case '\u016d': 
                case '\u016f': 
                case '\u0171': 
                case '\u0173': {
                    byArray[n] = 117;
                    break;
                }
                case '\u0174': {
                    byArray[n] = 87;
                    break;
                }
                case '\u0175': {
                    byArray[n] = 119;
                    break;
                }
                case '\u0176': {
                    byArray[n] = 89;
                    break;
                }
                case '\u0177': {
                    byArray[n] = 121;
                    break;
                }
                case '\u0179': 
                case '\u017b': {
                    byArray[n] = 90;
                    break;
                }
                case '\u017a': 
                case '\u017c': {
                    byArray[n] = 122;
                    break;
                }
                case '\u00a0': {
                    byArray[n] = 32;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    byArray[n] = (byte)c;
                    break;
                }
                default: {
                    byArray[n] = ' ' <= c && c < '\u0080' || '\u00a0' < c && c <= '\u00ff' ? (int)c : -128;
                }
            }
            ++n;
        }
        this.quote(pDFOutputStream, pDFOutputStream.getUseEncryption() ? pDFOutputStream.encryptArray(byArray) : byArray);
    }

    public void write(PDFOutputStream pDFOutputStream, PDFInstance pDFInstance) throws IOException {
        this.strlen = this.text.length();
        byte[] byArray = new byte[this.strlen];
        int n = 0;
        while (n < this.strlen) {
            byArray[n] = (byte)this.text.charAt(n);
            ++n;
        }
        pDFOutputStream.write(40);
        this.quote(pDFOutputStream, pDFOutputStream.getUseEncryption() ? pDFOutputStream.encryptArray(byArray) : byArray);
        pDFOutputStream.write(41);
    }

    List getIndirectObjects() {
        return new List();
    }

    public String toString() {
        return this.text;
    }
}

