/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.graphics.vector.Gradient;
import com.renderx.graphics.vector.PaintServer;
import com.renderx.graphics.vector.Pattern;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFException;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.ShadingPattern;
import com.renderx.pdflib.TilingPattern;
import com.renderx.util.Hashtable;

public class Patterns {
    private int patternsCount = -1;
    private Hashtable patterns = new Hashtable();
    private Hashtable patternsOID = new Hashtable();

    Patterns() {
    }

    String getPDFPatternName(PaintServer paintServer) {
        return (String)this.patterns.get(paintServer);
    }

    void addPattern(PaintServer paintServer, IndirectObject indirectObject) {
        ++this.patternsCount;
        this.patterns.put(paintServer, "P" + this.patternsCount);
        this.patternsOID.put(paintServer, indirectObject);
    }

    IndirectObject getPatternOID(PaintServer paintServer) {
        return (IndirectObject)this.patternsOID.get(paintServer);
    }

    void write(PDFOutputStream pDFOutputStream) {
        Object object;
        while (!this.patterns.isEmpty()) {
            object = (PaintServer)this.patterns.keys().nextElement();
            PDFObject pDFObject = null;
            try {
                if (object instanceof Gradient) {
                    pDFObject = new ShadingPattern(this.getPatternOID((PaintServer)object), (Gradient)object);
                } else if (object instanceof Pattern) {
                    pDFObject = new TilingPattern(this.getPatternOID((PaintServer)object), (Pattern)object);
                }
                pDFObject.write(pDFOutputStream);
            }
            catch (UnregisteredMIMETypeException unregisteredMIMETypeException) {
                throw new PDFException(unregisteredMIMETypeException);
            }
            this.patterns.remove(object);
        }
        object = this.patterns;
        synchronized (object) {
            this.patterns.clear();
        }
    }

    boolean isEmpty() {
        return this.patterns.isEmpty();
    }
}

