/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.util.Hashtable;

public class NameTree
extends PDFObject {
    Hashtable names = new Hashtable();
    NamedDestination[] sortbuffer = null;
    Subtree[] kids = null;
    public static final int NODESIZE = 16;

    NameTree(IndirectObject indirectObject) {
        super(indirectObject);
    }

    public void addName(String string, IndirectObject indirectObject, float f, float f2) {
        if (!this.names.containsKey(string)) {
            this.names.put(string, new Target(indirectObject, f, f2));
        }
    }

    public void addName(String string, String string2) {
        if (!this.names.containsKey(string)) {
            this.names.put(string, new JavaScript(string2));
        }
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        String string;
        String string2;
        Object object;
        if (!this.names.isEmpty() && (object = this.names.get(string2 = (String)this.names.keys().nextElement())) instanceof JavaScript) {
            pDFOutputStream.print("/Names[");
            pDFOutputStream.print("(");
            pDFOutputStream.printStringPDFEncoding(string2);
            pDFOutputStream.print(")");
            JavaScript javaScript = (JavaScript)object;
            javaScript.print(pDFOutputStream);
            pDFOutputStream.print("]");
            return;
        }
        this.sortbuffer = new NamedDestination[this.names.size()];
        int n = 0;
        object = this.names.keys();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            this.sortbuffer[n++] = new NamedDestination(pDFOutputStream.getNextID(), string, (Target)this.names.get(string));
        }
        string = this.sortbuffer[0].name;
        n = 1;
        while (n < this.sortbuffer.length) {
            String string3 = this.sortbuffer[n].name;
            if (string.compareTo(string3) < 0) {
                string = string3;
            }
            ++n;
        }
        this.sortTargets(0, this.sortbuffer.length - 1, string);
        this.kids = this.enumerateKids(pDFOutputStream, 0, this.sortbuffer.length - 1);
    }

    private Subtree[] enumerateKids(PDFOutputStream pDFOutputStream, int n, int n2) {
        if (n2 - n < 16) {
            pDFOutputStream.println("/Names [");
            int n3 = n;
            while (n3 <= n2) {
                pDFOutputStream.print_annotation(this.sortbuffer[n3].name);
                pDFOutputStream.println(" " + this.sortbuffer[n3].getID().toStringR());
                ++n3;
            }
            pDFOutputStream.println("]");
            return null;
        }
        int n4 = 16;
        int n5 = (n2 - n + 16) / 16;
        while (n5 > 16) {
            n4 *= 16;
            n5 = (n5 + 16 - 1) / 16;
        }
        pDFOutputStream.print("/Kids [");
        Subtree[] subtreeArray = new Subtree[n5];
        int n6 = 0;
        while (n6 < n5) {
            int n7 = n + n4 - 1;
            if (n7 > n2) {
                n7 = n2;
            }
            subtreeArray[n6] = new Subtree(pDFOutputStream.getNextID(), n, n7);
            n += n4;
            pDFOutputStream.print(" " + subtreeArray[n6].getID().toStringR());
            ++n6;
        }
        pDFOutputStream.println("]");
        return subtreeArray;
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        Object object;
        if (!this.names.isEmpty() && (object = this.names.get((String)this.names.keys().nextElement())) instanceof JavaScript) {
            return;
        }
        if (this.kids != null) {
            int n = 0;
            while (n < this.kids.length) {
                this.kids[n].write(pDFOutputStream);
                ++n;
            }
            this.kids = null;
        }
        int n = 0;
        while (n < this.sortbuffer.length) {
            this.sortbuffer[n].write(pDFOutputStream);
            ++n;
        }
        this.sortbuffer = null;
    }

    /*
     * Unable to fully structure code
     */
    private void sortTargets(int var1_1, int var2_2, String var3_3) {
        if (var1_1 >= var2_2) {
            return;
        }
        if (var1_1 == var2_2 - 1) {
            if (this.sortbuffer[var1_1].name.compareTo(this.sortbuffer[var2_2].name) > 0) {
                var4_4 = this.sortbuffer[var1_1];
                this.sortbuffer[var1_1] = this.sortbuffer[var2_2];
                this.sortbuffer[var2_2] = var4_4;
            }
            return;
        }
        var4_5 = null;
        var5_6 = 0;
        var5_6 = var1_1;
        while (var5_6 <= var2_2) {
            var4_5 = this.sortbuffer[var5_6].name;
            if (!var4_5.equals(var3_3)) break;
            ++var5_6;
        }
        if (var5_6 > var2_2) {
            return;
        }
        var6_7 = var1_1;
        var7_8 = var2_2;
        ** GOTO lbl34
        {
            ++var6_7;
            do {
                if (this.sortbuffer[var6_7].name.compareTo(var4_5) <= 0) continue block1;
                while (this.sortbuffer[var7_8].name.compareTo(var4_5) > 0) {
                    --var7_8;
                }
                if (var6_7 >= var7_8) break block1;
                var8_9 = this.sortbuffer[var6_7];
                this.sortbuffer[var6_7] = this.sortbuffer[var7_8];
                this.sortbuffer[var7_8] = var8_9;
                ++var6_7;
                --var7_8;
lbl34:
                // 2 sources

            } while (var6_7 <= var7_8);
        }
        this.sortTargets(var1_1, var7_8, var4_5);
        this.sortTargets(var6_7, var2_2, var3_3);
    }

    static class JavaScript {
        String script;

        JavaScript(String string) {
            this.script = string;
        }

        void print(PDFOutputStream pDFOutputStream) {
            pDFOutputStream.print("<</JS");
            pDFOutputStream.printStringPDFEncoding(this.script);
            pDFOutputStream.print("/S/JavaScript>>");
        }
    }

    static class Target {
        IndirectObject page;
        float x;
        float y;

        Target(IndirectObject indirectObject, float f, float f2) {
            this.page = indirectObject;
            this.x = f;
            this.y = f2;
        }
    }

    class Subtree
    extends PDFObject {
        int start = -1;
        int end = -1;
        Subtree[] kids = null;

        Subtree(IndirectObject indirectObject, int n, int n2) {
            super(indirectObject);
            this.start = n;
            this.end = n2;
        }

        void writeBody(PDFOutputStream pDFOutputStream) {
            pDFOutputStream.print("/Limits [");
            pDFOutputStream.print_annotation(NameTree.this.sortbuffer[this.start].name);
            pDFOutputStream.print(" ");
            pDFOutputStream.print_annotation(NameTree.this.sortbuffer[this.end].name);
            pDFOutputStream.println("]");
            this.kids = NameTree.this.enumerateKids(pDFOutputStream, this.start, this.end);
        }

        void writeSubObjects(PDFOutputStream pDFOutputStream) {
            if (this.kids != null) {
                int n = 0;
                while (n < this.kids.length) {
                    this.kids[n].write(pDFOutputStream);
                    ++n;
                }
                this.kids = null;
            }
        }
    }

    static class NamedDestination
    extends PDFObject {
        String name;
        Target target;

        NamedDestination(IndirectObject indirectObject, String string, Target target) {
            super(indirectObject);
            this.name = string;
            this.target = target;
        }

        void writeBody(PDFOutputStream pDFOutputStream) {
            pDFOutputStream.print("/D [" + this.target.page.toStringR() + " /XYZ " + PDFOutputStream.pdf_float_coarse(this.target.x) + " " + PDFOutputStream.pdf_float_coarse(this.target.y) + " 0]");
        }

        void writeSubObjects(PDFOutputStream pDFOutputStream) {
        }
    }
}

