/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.fonts.FontDescriptor;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.OneByteTTFont;
import com.renderx.pdflib.PDFFont;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.T1Font;
import com.renderx.pdflib.TTFont;
import com.renderx.util.Array;
import com.renderx.util.Hashtable;
import java.util.Enumeration;

public class Fonts {
    int fontsCount = -1;
    Hashtable fontsName = new Hashtable();
    Hashtable fontsOID = new Hashtable();
    Hashtable fontsDesc = new Hashtable();
    boolean enableFontsSubset = true;

    Fonts() {
    }

    public void setEnableFontsSubset(boolean bl) {
        this.enableFontsSubset = bl;
    }

    public boolean getEnableFontsSubset() {
        return this.enableFontsSubset;
    }

    void addFont(FontDescriptor fontDescriptor, int n, IndirectObject indirectObject) {
        ++this.fontsCount;
        String string = fontDescriptor.record.getMetric().fontName + "+" + n;
        this.fontsName.put(string, "F" + this.fontsCount);
        this.fontsOID.put(string, indirectObject);
        this.fontsDesc.put(string, fontDescriptor);
    }

    String getPDFFontName(FontDescriptor fontDescriptor, int n) {
        return (String)this.fontsName.get(fontDescriptor.record.getMetric().fontName + "+" + n);
    }

    IndirectObject getFontOID(FontDescriptor fontDescriptor, int n) {
        return (IndirectObject)this.fontsOID.get(fontDescriptor.record.getMetric().fontName + "+" + n);
    }

    void write(PDFOutputStream pDFOutputStream) {
        this.write(pDFOutputStream, null);
    }

    void write(PDFOutputStream pDFOutputStream, Hashtable hashtable) {
        int n;
        Array array = new Array();
        Enumeration enumeration = this.fontsName.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            int n3 = 0;
            n3 = 0;
            while (n3 < n2) {
                if (array.get(n3).toString().compareTo(e.toString()) > 0) break;
                ++n3;
            }
            n = n2;
            while (n > n3) {
                array.put(n, array.get(n - 1));
                --n;
            }
            array.put(n3, e);
            ++n2;
        }
        int n4 = 0;
        while (n4 < array.length()) {
            PDFFont pDFFont;
            String string = (String)array.get(n4);
            n = new Integer(string.substring(string.lastIndexOf("+") + 1));
            FontDescriptor fontDescriptor = (FontDescriptor)this.fontsDesc.get(string);
            if (fontDescriptor.record.datatype == 1) {
                pDFFont = new T1Font((IndirectObject)this.fontsOID.get(string), fontDescriptor, n);
                pDFFont.setEnableSubset(this.enableFontsSubset);
                pDFFont.write(pDFOutputStream);
            } else if (fontDescriptor.record.datatype == 2) {
                if (!fontDescriptor.record.embed) {
                    pDFFont = new OneByteTTFont((IndirectObject)this.fontsOID.get(string), fontDescriptor, n);
                    pDFFont.write(pDFOutputStream);
                    if (fontDescriptor.hasUnmappedChars) {
                        pDFOutputStream.warning("Some characters from '" + fontDescriptor.record.getMetric().fullName + "' font cannot be represented if the font is unembedded.");
                        fontDescriptor.hasUnmappedChars = false;
                    }
                } else {
                    pDFFont = new TTFont((IndirectObject)this.fontsOID.get(string), fontDescriptor, n);
                    pDFFont.setEnableSubset(this.enableFontsSubset);
                    pDFFont.write(pDFOutputStream);
                }
            } else if (fontDescriptor.record.datatype == 3) {
                pDFFont = new T1Font((IndirectObject)this.fontsOID.get(string), fontDescriptor, n);
                pDFFont.setEnableSubset(this.enableFontsSubset);
                pDFFont.write(pDFOutputStream);
            } else if (fontDescriptor.record.datatype == 4) {
                pDFFont = new TTFont((IndirectObject)this.fontsOID.get(string), fontDescriptor, n);
                pDFFont.setEnableSubset(this.enableFontsSubset);
                pDFFont.write(pDFOutputStream);
            }
            ++n4;
        }
    }
}

