/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class AbstractHintRecord {
    ByteArrayOutputStream bitsS;
    byte lastbyte;
    int freeBits = 8;

    void writeBits(int n, int n2) {
        while (this.freeBits < n2) {
            int n3 = -1 << n2 - this.freeBits;
            this.lastbyte = (byte)(this.lastbyte | (n & n3) >> n2 - this.freeBits);
            n2 -= this.freeBits;
            this.bitsS.write(this.lastbyte);
            this.freeBits = 8;
            this.lastbyte = 0;
            n &= (n3 ^= 0xFFFFFFFF);
        }
        if (n2 > 0) {
            this.lastbyte = (byte)(this.lastbyte | n << this.freeBits - n2 & 0xFF);
            this.freeBits -= n2;
        }
    }

    void flush() {
        this.bitsS.write(this.lastbyte);
    }

    abstract byte[] getBytes() throws IOException;

    byte[] int2TwoBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    byte[] int2FourBytes(int n) {
        byte[] byArray = new byte[4];
        byArray[0] = (byte)(n >> 24 & 0xFF);
        byArray[2] = (byte)(n >> 16 & 0xFF);
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        return byArray;
    }

    byte[] long2FourBytes(long l) {
        byte[] byArray = new byte[4];
        byArray[0] = (byte)(l >> 24 & 0xFFL);
        byArray[2] = (byte)(l >> 16 & 0xFFL);
        byArray[2] = (byte)(l >> 8 & 0xFFL);
        byArray[3] = (byte)(l & 0xFFL);
        return byArray;
    }

    int bits4number(int n) {
        double d = Math.log(n) / Math.log(2.0);
        return d == (double)Math.round(d) ? (int)d : (int)(d + 1.0);
    }
}

