/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics.vector;

import com.renderx.util.MathUtils;
import java.io.IOException;
import java.io.PrintStream;

public abstract class GraphicObject {
    public static boolean isIdentityTransform(double[] dArray) {
        return dArray[0] == 1.0 && dArray[1] == 0.0 && dArray[2] == 0.0 && dArray[3] == 1.0 && dArray[4] == 0.0 && dArray[5] == 0.0;
    }

    public static double[] multipleMatrix(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray2[0] * dArray[0] + dArray2[1] * dArray[2], dArray2[0] * dArray[1] + dArray2[1] * dArray[3], dArray2[2] * dArray[0] + dArray2[3] * dArray[2], dArray2[2] * dArray[1] + dArray2[3] * dArray[3], dArray2[4] * dArray[0] + dArray2[5] * dArray[2] + dArray[4], dArray2[4] * dArray[1] + dArray2[5] * dArray[3] + dArray[5]};
        return dArray3;
    }

    public static double[] transform(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6) {
        return GraphicObject.multipleMatrix(dArray, new double[]{d, d2, d3, d4, d5, d6});
    }

    public static double[] rotate(double[] dArray, double d) {
        double d2 = MathUtils.getSine(d);
        double d3 = MathUtils.getCosine(d);
        if (d2 == 1.0 || d2 == -1.0) {
            d3 = 0.0;
        }
        if (d3 == 1.0 || d3 == -1.0) {
            d2 = 0.0;
        }
        return GraphicObject.multipleMatrix(dArray, new double[]{d3, d2, -d2, d3, 0.0, 0.0});
    }

    public static double[] translate(double[] dArray, double d, double d2) {
        return GraphicObject.multipleMatrix(dArray, new double[]{1.0, 0.0, 0.0, 1.0, d, d2});
    }

    public static double[] scale(double[] dArray, double d, double d2) {
        return GraphicObject.multipleMatrix(dArray, new double[]{d, 0.0, 0.0, d2, 0.0, 0.0});
    }

    public static double[] skew(double[] dArray, double d, double d2) {
        return GraphicObject.multipleMatrix(dArray, new double[]{1.0, Math.tan(d2), Math.tan(d), 1.0, 0.0, 0.0});
    }

    public static double[] reverseMatrix(double[] dArray) {
        double[] dArray2 = new double[6];
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        double d5 = dArray[4];
        double d6 = dArray[5];
        dArray2[0] = d4 / (d * d4 - d3 * d2);
        dArray2[1] = -d2 / (d * d4 - d3 * d2);
        dArray2[2] = -d3 / (d * d4 - d3 * d2);
        dArray2[3] = d / (d * d4 - d3 * d2);
        dArray2[4] = (d3 * d6 - d4 * d5) / (d * d4 - d3 * d2);
        dArray2[5] = (d2 * d5 - d * d6) / (d * d4 - d3 * d2);
        return dArray2;
    }

    public static double[] transformPoint(double[] dArray, double d, double d2) {
        double[] dArray2 = new double[]{dArray[0] * d + dArray[2] * d2 + dArray[4], dArray[1] * d + dArray[3] * d2 + dArray[5]};
        return dArray2;
    }

    public abstract void dump(PrintStream var1, String var2) throws IOException;
}

