/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics;

import com.renderx.graphics.BitmapImage;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.ObjectRecordCoordinator;
import com.renderx.graphics.PNGPredictor;
import com.renderx.util.SeekableInput;
import com.renderx.util.URLSpec;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class PNGImage
extends BitmapImage {
    private long dataOffset = -1L;
    private boolean interlaced = false;
    private int bitDepth = 0;
    private int bitsPerPixel = 0;
    private int colorType = 0;
    private static final double SRGB_GAMMA = 2.2;
    private static final double GAMMA_TOLERANCE = 0.05;
    private double gammaExponent = 1.0;
    boolean needsGammaCorrection = false;
    private static final int PNG_COLOR_GRAY = 0;
    private static final int PNG_COLOR_RGB = 2;
    private static final int PNG_COLOR_PALETTE = 3;
    private static final int PNG_COLOR_GRAY_ALPHA = 4;
    private static final int PNG_COLOR_RGB_ALPHA = 6;
    private static final String[] colorTypeNames = new String[]{"Grayscale", "Error", "Truecolor", "Index", "Grayscale with alpha", "Error", "Truecolor with alpha"};
    private static final String[] filterTypeNames = new String[]{"None", "Sub", "Up", "Average", "Paeth"};

    public PNGImage() {
        this.mimetype = "image/png";
    }

    byte computeGammaCorrection(int n) {
        double d = (double)(n & 0xFF) / 255.0;
        d = Math.pow(d, this.gammaExponent);
        return (byte)Math.round(d * 255.0);
    }

    public void parse() throws IOException, ImageFormatException {
        this.canExpandData = true;
        this.canCopyData = false;
        this.compressionMethod = (short)2;
        this.predictor = (short)2;
        SeekableInput seekableInput = this.openSeekableImageStream();
        try {
            byte[] byArray = new byte[8];
            seekableInput.readFully(byArray);
            if (byArray[0] != -119 || byArray[1] != 80 || byArray[2] != 78 || byArray[3] != 71 || byArray[4] != 13 || byArray[5] != 10 || byArray[6] != 26 || byArray[7] != 10) {
                throw new ImageFormatException("Corrupt signature in PNG image " + this.toDisplayString());
            }
            int n = 0;
            byte[] byArray2 = new byte[4];
            while (true) {
                this.dataOffset = seekableInput.getFilePointer();
                n = seekableInput.readInt();
                seekableInput.readFully(byArray2);
                if (byArray2[0] == 73 && byArray2[1] == 72 && byArray2[2] == 68 && byArray2[3] == 82) {
                    this.parse_IHDR_chunk(seekableInput, n);
                    continue;
                }
                if (byArray2[0] == 80 && byArray2[1] == 76 && byArray2[2] == 84 && byArray2[3] == 69) {
                    this.parse_PLTE_chunk(seekableInput, n);
                    continue;
                }
                if (byArray2[0] == 116 && byArray2[1] == 82 && byArray2[2] == 78 && byArray2[3] == 83) {
                    this.parse_tRNS_chunk(seekableInput, n);
                    continue;
                }
                if (byArray2[0] == 112 && byArray2[1] == 72 && byArray2[2] == 89 && byArray2[3] == 115) {
                    this.parse_pHYs_chunk(seekableInput, n);
                    continue;
                }
                if (byArray2[0] == 103 && byArray2[1] == 65 && byArray2[2] == 77 && byArray2[3] == 65) {
                    this.parse_gAMA_chunk(seekableInput, n);
                    continue;
                }
                if (byArray2[0] == 73 && byArray2[1] == 68 && byArray2[2] == 65 && byArray2[3] == 84) break;
                if (byArray2[0] == 73 && byArray2[1] == 69 && byArray2[2] == 78 && byArray2[3] == 68) {
                    throw new ImageFormatException("Premature IEND chunk in PNG image " + this.toDisplayString() + ": no data chunks found");
                }
                if ((byArray2[0] & 0x20) == 0) {
                    throw new ImageFormatException("Unknown critical chunk type [" + Integer.toHexString(byArray2[0]) + "h " + Integer.toHexString(byArray2[1]) + "h " + Integer.toHexString(byArray2[2]) + "h " + Integer.toHexString(byArray2[3]) + "h]" + " in PNG image " + this.toDisplayString());
                }
                seekableInput.skipBytes(n + 4);
            }
            this.setDimensions();
            this.canCopyData = !(this.bitDepth > 8 || this.colorType != 0 && this.colorType != 2 && this.colorType != 3 || this.interlaced || this.needsGammaCorrection && this.colorType != 3);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            seekableInput.close();
            throw throwable;
        }
        seekableInput.close();
    }

    private void parse_IHDR_chunk(SeekableInput seekableInput, long l) throws IOException, ImageFormatException {
        this.pxWidth = seekableInput.readInt();
        this.pxHeight = seekableInput.readInt();
        this.bitDepth = seekableInput.readUnsignedByte();
        this.colorType = seekableInput.readUnsignedByte();
        switch (this.colorType) {
            case 0: {
                if (this.bitDepth == 1 || this.bitDepth == 2 || this.bitDepth == 4 || this.bitDepth == 8 || this.bitDepth == 16) {
                    this.bitsPerComponent = this.bitDepth == 16 ? 8 : this.bitDepth;
                    this.bitsPerPixel = this.bitDepth;
                    this.colorSpace = (short)4;
                    break;
                }
                throw new ImageFormatException("Invalid bit depth " + this.bitDepth + " for color type " + this.colorType + " (" + colorTypeNames[this.colorType] + ") in PNG image " + this.toDisplayString());
            }
            case 4: {
                this.separatedAlphaChannel = true;
                if (this.bitDepth == 8 || this.bitDepth == 16) {
                    this.bitsPerComponent = 8;
                    this.bitsPerPixel = 2 * this.bitDepth;
                    this.colorSpace = (short)4;
                    break;
                }
                throw new ImageFormatException("Invalid bit depth " + this.bitDepth + " for color type " + this.colorType + " (" + colorTypeNames[this.colorType] + ") in PNG image " + this.toDisplayString());
            }
            case 6: {
                this.separatedAlphaChannel = true;
            }
            case 2: {
                if (this.bitDepth == 8 || this.bitDepth == 16) {
                    this.bitsPerComponent = 8;
                    this.bitsPerPixel = this.bitDepth * 3;
                    if (this.colorType == 6) {
                        this.bitsPerPixel += this.bitDepth;
                    }
                    this.colorSpace = 1;
                    break;
                }
                throw new ImageFormatException("Invalid bit depth " + this.bitDepth + " for color type " + this.colorType + " (" + colorTypeNames[this.colorType] + ") in PNG image " + this.toDisplayString());
            }
            case 3: {
                if (this.bitDepth == 1 || this.bitDepth == 2 || this.bitDepth == 4 || this.bitDepth == 8) {
                    this.bitsPerPixel = this.bitsPerComponent = this.bitDepth;
                    this.colorSpace = (short)6;
                    break;
                }
                throw new ImageFormatException("Invalid bit depth " + this.bitDepth + " for color type " + this.colorType + " (" + colorTypeNames[this.colorType] + ") in PNG image " + this.toDisplayString());
            }
            default: {
                throw new ImageFormatException("Invalid color type " + this.colorType + " in PNG image " + this.toDisplayString());
            }
        }
        if (seekableInput.readByte() != 0) {
            throw new ImageFormatException("Unknown (non-standard) compression method in PNG image " + this.toDisplayString());
        }
        if (seekableInput.readByte() != 0) {
            throw new ImageFormatException("Unknown (non-standard) filtering method in PNG image " + this.toDisplayString());
        }
        int n = seekableInput.readUnsignedByte();
        if (n > 1) {
            throw new ImageFormatException("Unknown (non-standard) interlace method in PNG image " + this.toDisplayString());
        }
        this.interlaced = n == 1;
        seekableInput.skipBytes(4);
    }

    private void parse_PLTE_chunk(SeekableInput seekableInput, int n) throws IOException, ImageFormatException {
        if (this.colorType != 3) {
            seekableInput.skipBytes(n);
        } else {
            this.colorTable = new byte[n];
            seekableInput.readFully(this.colorTable);
            if (this.needsGammaCorrection) {
                int n2 = 0;
                while (n2 < n) {
                    this.colorTable[n2] = this.computeGammaCorrection(this.colorTable[n2]);
                    ++n2;
                }
                this.needsGammaCorrection = false;
            }
        }
        seekableInput.skipBytes(4);
    }

    private void parse_gAMA_chunk(SeekableInput seekableInput, int n) throws IOException, ImageFormatException {
        double d = (double)((long)seekableInput.readInt() & 0xFFFFFFFFL) / 100000.0;
        if (d == 0.0) {
            throw new ImageFormatException("Zero gamma in PNG image " + this.toDisplayString());
        }
        this.gammaExponent = 1.0 / (2.2 * d);
        boolean bl = this.needsGammaCorrection = Math.abs(this.gammaExponent - 1.0) > 0.05;
        if (this.colorSpace != 6 && this.bitsPerComponent < 8) {
            this.needsGammaCorrection = false;
        }
        seekableInput.skipBytes(4);
    }

    private void parse_tRNS_chunk(SeekableInput seekableInput, int n) throws IOException, ImageFormatException {
        block0 : switch (this.colorType) {
            case 0: {
                this.transparentColor = new byte[1];
                if (this.bitDepth == 16) {
                    this.transparentColor[0] = seekableInput.readByte();
                    seekableInput.skipBytes(1);
                } else {
                    seekableInput.skipBytes(1);
                    this.transparentColor[0] = seekableInput.readByte();
                }
                if (this.rightRange(this.transparentColor[0])) break;
                this.transparentColor = null;
                break;
            }
            case 2: {
                this.transparentColor = new byte[3];
                if (this.bitDepth == 16) {
                    this.transparentColor[0] = seekableInput.readByte();
                    seekableInput.skipBytes(1);
                    this.transparentColor[1] = seekableInput.readByte();
                    seekableInput.skipBytes(1);
                    this.transparentColor[2] = seekableInput.readByte();
                    seekableInput.skipBytes(1);
                } else {
                    seekableInput.skipBytes(1);
                    this.transparentColor[0] = seekableInput.readByte();
                    seekableInput.skipBytes(1);
                    this.transparentColor[1] = seekableInput.readByte();
                    seekableInput.skipBytes(1);
                    this.transparentColor[2] = seekableInput.readByte();
                }
                if (this.rightRange(this.transparentColor[0]) && this.rightRange(this.transparentColor[1]) && this.rightRange(this.transparentColor[2])) break;
                this.transparentColor = null;
                break;
            }
            case 3: {
                int n2 = 0;
                while (n2 < n && n2 < 256) {
                    if (seekableInput.readByte() == 0) {
                        this.transparentColor = new byte[1];
                        this.transparentColor[0] = (byte)n2;
                        seekableInput.skipBytes(n - n2 - 1);
                        break block0;
                    }
                    ++n2;
                }
                break;
            }
            case 4: 
            case 6: {
                seekableInput.skipBytes(n);
            }
        }
        seekableInput.skipBytes(4);
    }

    private void parse_pHYs_chunk(SeekableInput seekableInput, int n) throws IOException, ImageFormatException {
        double d = (long)seekableInput.readInt() & 0xFFFFFFFFL;
        if (d == 0.0) {
            throw new ImageFormatException("Zero horizontal resolution in PNG image " + this.toDisplayString());
        }
        double d2 = (long)seekableInput.readInt() & 0xFFFFFFFFL;
        if (d2 == 0.0) {
            throw new ImageFormatException("Zero vertical resolution in PNG image " + this.toDisplayString());
        }
        int n2 = seekableInput.readUnsignedByte();
        if (n2 == 0) {
            double d3 = Math.sqrt(d2 / d);
            this.horzResolution /= d3;
            this.vertResolution *= d3;
            this.noResolution = false;
        } else if (n2 == 1) {
            this.horzResolution = d * 0.0254;
            this.vertResolution = d2 * 0.0254;
            this.noResolution = false;
        } else {
            throw new ImageFormatException("Invalid unit type " + n2 + " in PNG image " + this.toDisplayString());
        }
        seekableInput.skipBytes(4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copyData(OutputStream outputStream, ObjectRecordCoordinator objectRecordCoordinator) throws IOException, ImageFormatException {
        if (!this.canCopyData) {
            throw new ImageFormatException("Cannot copy compressed stream with alpha channel and/or 16-bit color from PNG image " + this.toDisplayString());
        }
        SeekableInput seekableInput = this.openSeekableImageStream();
        try {
            seekableInput.seek(this.dataOffset);
            byte[] byArray = new byte[objectRecordCoordinator != null ? objectRecordCoordinator.getRecordLength() : 8192];
            block2: while (true) {
                int n = seekableInput.readInt();
                byte[] byArray2 = new byte[4];
                seekableInput.readFully(byArray2);
                if (byArray2[0] != 73 || byArray2[1] != 68 || byArray2[2] != 65 || byArray2[3] != 84) break;
                while (true) {
                    if (n <= 0) {
                        seekableInput.skipBytes(4);
                        continue block2;
                    }
                    int n2 = n > byArray.length ? byArray.length : n;
                    seekableInput.readFully(byArray, 0, n2);
                    if (objectRecordCoordinator != null) {
                        objectRecordCoordinator.beginRecord(outputStream, n2);
                    }
                    outputStream.write(byArray, 0, n2);
                    if (objectRecordCoordinator != null) {
                        objectRecordCoordinator.endRecord(outputStream, n2);
                    }
                    n -= n2;
                }
                break;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            seekableInput.close();
            throw throwable;
        }
        seekableInput.close();
    }

    public void expandData(OutputStream outputStream, ObjectRecordCoordinator objectRecordCoordinator) throws IOException, ImageFormatException {
        this.expandData(outputStream, objectRecordCoordinator, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void expandData(OutputStream outputStream, ObjectRecordCoordinator objectRecordCoordinator, boolean bl) throws IOException, ImageFormatException {
        SeekableInput seekableInput = this.openSeekableImageStream();
        Inflater inflater = new Inflater(false);
        inflater.reset();
        try {
            seekableInput.seek(this.dataOffset);
            PNGDecoder pNGDecoder = null;
            pNGDecoder = this.interlaced ? new PNGInterlacedDecoder(outputStream, bl) : new PNGSequentialDecoder(outputStream, bl);
            int n = 0;
            byte[] byArray = new byte[4];
            byte[] byArray2 = new byte[8192];
            byte[] byArray3 = new byte[8192];
            block4: while (true) {
                n = seekableInput.readInt();
                seekableInput.readFully(byArray);
                if (byArray[0] != 73 || byArray[1] != 68 || byArray[2] != 65 || byArray[3] != 84) break;
                while (true) {
                    if (n <= 0) {
                        seekableInput.skipBytes(4);
                        continue block4;
                    }
                    int n2 = n > byArray2.length ? byArray2.length : n;
                    seekableInput.readFully(byArray2, 0, n2);
                    if (inflater.finished()) {
                        throw new ImageFormatException("Too much data in PNG image " + this.toDisplayString());
                    }
                    if (inflater.needsDictionary()) {
                        throw new ImageFormatException("Incorrect compressed data format (dictionary required) in PNG image " + this.toDisplayString());
                    }
                    inflater.setInput(byArray2, 0, n2);
                    int n3 = 0;
                    try {
                        while ((n3 = inflater.inflate(byArray3)) > 0) {
                            pNGDecoder.write(byArray3, 0, n3);
                        }
                    }
                    catch (DataFormatException dataFormatException) {
                        throw new ImageFormatException("Bad data stream in PNG image " + this.toDisplayString() + ": " + dataFormatException.toString());
                    }
                    n -= n2;
                }
                break;
            }
            if (!inflater.finished()) {
                throw new ImageFormatException("Premature end of data in PNG image " + this.toDisplayString());
            }
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            seekableInput.close();
            inflater.end();
            throw throwable;
        }
        seekableInput.close();
        inflater.end();
    }

    protected boolean rightRange(int n) {
        return (n & 0xFF) >> this.bitDepth == 0;
    }

    public static void main(String[] stringArray) {
        PNGImage pNGImage = new PNGImage();
        if (stringArray.length == 0) {
            System.err.println("Usage: " + pNGImage.getClass().getName() + " <image file name>");
            return;
        }
        try {
            pNGImage.source = new URLSpec(stringArray[0]);
            pNGImage.parse();
            System.out.println(pNGImage.toString());
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        catch (ImageFormatException imageFormatException) {
            System.err.println(imageFormatException);
        }
    }

    class PNGInterlacedDecoder
    extends PNGDecoder {
        int pass = 0;
        int lineno = 0;
        byte[][] accumulator = null;
        int pixelsPerByte = 1;
        int mask = 0;
        int[] pixelMasks = new int[]{0, 128, 192, 224, 240, 248, 252, 254, 255};
        int[] size_x = new int[7];
        int[] size_y = new int[7];
        int[] offset_x = new int[]{0, 4, 0, 2, 0, 1};
        int[] offset_y = new int[]{0, 0, 2, 0, 1, 0};
        int[] step_x = new int[]{8, 8, 4, 4, 2, 2};
        int[] step_y = new int[]{4, 4, 4, 2, 2, 1};

        public PNGInterlacedDecoder(OutputStream outputStream, boolean bl) {
            super(outputStream, bl);
            this.pixelsPerByte = 8 / PNGImage.this.bitsPerComponent;
            this.mask = this.pixelMasks[PNGImage.this.bitsPerComponent];
            this.size_x[0] = (PNGImage.this.pxWidth + 7) / 8;
            this.size_y[0] = (PNGImage.this.pxHeight + 7) / 8;
            this.size_x[1] = (PNGImage.this.pxWidth + 3) / 8;
            this.size_y[1] = (PNGImage.this.pxHeight + 7) / 8;
            this.size_x[2] = (PNGImage.this.pxWidth + 3) / 4;
            this.size_y[2] = (PNGImage.this.pxHeight + 3) / 8;
            this.size_x[3] = (PNGImage.this.pxWidth + 1) / 4;
            this.size_y[3] = (PNGImage.this.pxHeight + 3) / 4;
            this.size_x[4] = (PNGImage.this.pxWidth + 1) / 2;
            this.size_y[4] = (PNGImage.this.pxHeight + 1) / 4;
            this.size_x[5] = PNGImage.this.pxWidth / 2;
            this.size_y[5] = (PNGImage.this.pxHeight + 1) / 2;
            this.size_x[6] = PNGImage.this.pxWidth;
            this.size_y[6] = PNGImage.this.pxHeight / 2;
            this.accumulator = new byte[(PNGImage.this.pxHeight + 1) / 2][(PNGImage.this.pxWidth * (PNGImage.this.bitsPerComponent * this.elementSize) + 7) / 8];
            int n = 0;
            while (n < this.accumulator.length) {
                int n2 = 0;
                while (n2 < this.accumulator[n].length) {
                    this.accumulator[n][n2] = 0;
                    ++n2;
                }
                ++n;
            }
            this.pass = 0;
            this.lineno = 0;
            this.initLines(this.size_x[this.pass]);
        }

        protected void terminateScanline() throws IOException, ImageFormatException {
            if (this.pass == 6) {
                this.writeLine(this.readyLine);
                if (++this.lineno < this.accumulator.length) {
                    this.writeLine(this.accumulator[this.lineno]);
                }
            } else {
                int n = this.offset_x[this.pass] * this.elementSize;
                int n2 = this.step_x[this.pass] * this.elementSize;
                byte[] byArray = this.accumulator[this.offset_y[this.pass] + this.step_y[this.pass] * this.lineno];
                if (this.elementSize == 3) {
                    int n3 = 0;
                    while (n3 < this.readyLine.length) {
                        byArray[n] = this.readyLine[n3];
                        byArray[n + 1] = this.readyLine[n3 + 1];
                        byArray[n + 2] = this.readyLine[n3 + 2];
                        n += n2;
                        n3 += 3;
                    }
                } else if (PNGImage.this.bitsPerComponent == 8) {
                    int n4 = 0;
                    while (n4 < this.readyLine.length) {
                        byArray[n] = this.readyLine[n4];
                        n += n2;
                        ++n4;
                    }
                } else {
                    int n5 = 0;
                    while (n5 < this.readyLine.length) {
                        int n6 = 0;
                        while (n6 < 8 && n < PNGImage.this.pxWidth) {
                            int n7 = this.readyLine[n5] << n6 & this.mask;
                            int n8 = n / this.pixelsPerByte;
                            byArray[n8] = (byte)(byArray[n8] | n7 >> n % this.pixelsPerByte * PNGImage.this.bitsPerComponent);
                            n += n2;
                            n6 += PNGImage.this.bitsPerComponent;
                        }
                        ++n5;
                    }
                }
                if (++this.lineno == this.size_y[this.pass]) {
                    this.nextPass();
                }
            }
        }

        protected void nextPass() throws IOException, ImageFormatException {
            while (++this.pass < 6 && (this.size_x[this.pass] == 0 || this.size_y[this.pass] == 0)) {
            }
            if (this.pass == 6) {
                this.writeLine(this.accumulator[0]);
                if (this.size_x[this.pass] == 0 || this.size_y[this.pass] == 0) {
                    return;
                }
            }
            this.lineno = 0;
            this.initLines(this.size_x[this.pass]);
        }
    }

    class PNGSequentialDecoder
    extends PNGDecoder {
        public PNGSequentialDecoder(OutputStream outputStream, boolean bl) {
            super(outputStream, bl);
            this.initLines(PNGImage.this.pxWidth);
        }

        protected void terminateScanline() throws IOException {
            this.writeLine(this.readyLine);
        }
    }

    abstract class PNGDecoder {
        OutputStream out = null;
        byte[] currentLine = null;
        byte[] readyLine = null;
        int elementSize = 1;
        int lineSize = 1;
        int cursor = 0;
        int byteCount = 0;
        boolean[] byteSieve = new boolean[8];
        byte[] gammaLUT = null;
        PNGPredictor pred = null;
        private byte[] gammaTable = null;
        boolean alphaChannel = false;

        public PNGDecoder(OutputStream outputStream, boolean bl) {
            this.out = outputStream;
            int n = this.elementSize = PNGImage.this.colorSpace == 1 ? 3 : 1;
            if (bl) {
                this.elementSize = 1;
            }
            this.alphaChannel = bl;
            this.initSieve();
            if (PNGImage.this.bitsPerComponent == 8 && PNGImage.this.needsGammaCorrection) {
                this.gammaLUT = new byte[256];
                int n2 = 0;
                while (n2 < 256) {
                    this.gammaLUT[n2] = PNGImage.this.computeGammaCorrection(n2);
                    ++n2;
                }
            }
        }

        public void initSieve() {
            if (PNGImage.this.bitDepth == 16) {
                this.byteSieve[7] = true;
                this.byteSieve[5] = true;
                this.byteSieve[3] = true;
                this.byteSieve[1] = true;
                if (PNGImage.this.colorType == 4) {
                    if (this.alphaChannel) {
                        this.byteSieve[4] = true;
                        this.byteSieve[0] = true;
                    } else {
                        this.byteSieve[6] = true;
                        this.byteSieve[2] = true;
                    }
                } else if (PNGImage.this.colorType == 6) {
                    if (this.alphaChannel) {
                        this.byteSieve[4] = true;
                        this.byteSieve[2] = true;
                        this.byteSieve[0] = true;
                    } else {
                        this.byteSieve[6] = true;
                    }
                }
            } else if (PNGImage.this.colorType == 4) {
                if (this.alphaChannel) {
                    this.byteSieve[6] = true;
                    this.byteSieve[4] = true;
                    this.byteSieve[2] = true;
                    this.byteSieve[0] = true;
                } else {
                    this.byteSieve[7] = true;
                    this.byteSieve[5] = true;
                    this.byteSieve[3] = true;
                    this.byteSieve[1] = true;
                }
            } else if (PNGImage.this.colorType == 6) {
                if (this.alphaChannel) {
                    this.byteSieve[2] = true;
                    this.byteSieve[1] = true;
                    this.byteSieve[0] = true;
                    this.byteSieve[6] = true;
                    this.byteSieve[5] = true;
                    this.byteSieve[4] = true;
                } else {
                    this.byteSieve[7] = true;
                    this.byteSieve[3] = true;
                }
            }
        }

        public void write(byte[] byArray) throws IOException, ImageFormatException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException, ImageFormatException {
            while (n2 > 0) {
                this.write(byArray[n]);
                ++n;
                --n2;
            }
        }

        public void write(int n) throws IOException, ImageFormatException {
            if (this.pred == null && this.byteCount == 0) {
                this.pred = PNGPredictor.getPredictor(n & 0xFF);
                this.cursor = 0;
                return;
            }
            if (this.byteSieve[this.byteCount++ & 7]) {
                if (this.byteCount == this.lineSize) {
                    this.swapLines();
                }
                return;
            }
            this.currentLine[this.cursor] = this.pred.decode(n, this.cursor, this.readyLine, this.currentLine, this.elementSize);
            ++this.cursor;
            if (this.byteCount == this.lineSize) {
                this.swapLines();
            }
        }

        private void swapLines() throws IOException, ImageFormatException {
            this.byteCount = 0;
            byte[] byArray = this.readyLine;
            this.readyLine = this.currentLine;
            this.currentLine = byArray;
            this.pred = null;
            this.terminateScanline();
        }

        void initLines(int n) {
            this.lineSize = (n * PNGImage.this.bitsPerPixel + 7) / 8;
            int n2 = (n * (PNGImage.this.bitsPerComponent * this.elementSize) + 7) / 8;
            this.currentLine = new byte[n2];
            this.readyLine = new byte[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.readyLine[n3] = 0;
                this.currentLine[n3] = 0;
                ++n3;
            }
            this.pred = null;
            this.byteCount = 0;
            this.cursor = 0;
        }

        protected void writeLine(byte[] byArray) throws IOException {
            if (this.gammaLUT == null) {
                this.out.write(byArray);
            } else {
                int n = 0;
                while (n < byArray.length) {
                    this.out.write(this.gammaLUT[byArray[n] & 0xFF]);
                    ++n;
                }
            }
        }

        protected abstract void terminateScanline() throws IOException, ImageFormatException;
    }
}

