/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.crypto;

import com.renderx.crypto.CryptoException;
import junit.framework.Assert;
import junit.framework.TestCase;

public final class RC4 {
    private final int[] sBox = new int[256];
    private int x;
    private int y;

    public RC4(byte[] byArray) {
        this.makeKey(byArray);
    }

    public void crypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.rc4(byArray, n, n2, byArray2, n3);
    }

    public byte[] crypt(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        this.rc4(byArray, 0, byArray.length, byArray2, 0);
        return byArray2;
    }

    private void rc4(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = 0;
        while (n4 < n2) {
            this.x = this.x + 1 & 0xFF;
            this.y = this.sBox[this.x] + this.y & 0xFF;
            int n5 = this.sBox[this.x];
            this.sBox[this.x] = this.sBox[this.y];
            this.sBox[this.y] = n5;
            int n6 = this.sBox[this.x] + this.sBox[this.y] & 0xFF;
            byArray2[n3++] = (byte)(byArray[n++] ^ this.sBox[n6]);
            ++n4;
        }
    }

    private void makeKey(byte[] byArray) throws CryptoException {
        byte[] byArray2 = (byte[])byArray.clone();
        if (byArray2 == null) {
            throw new CryptoException("Null user key");
        }
        int n = byArray2.length;
        if (n == 0) {
            throw new CryptoException("Invalid user key length");
        }
        this.y = 0;
        this.x = 0;
        int n2 = 0;
        while (n2 < 256) {
            this.sBox[n2] = n2;
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < 256) {
            n4 = (byArray2[n3] & 0xFF) + this.sBox[n5] + n4 & 0xFF;
            int n6 = this.sBox[n5];
            this.sBox[n5] = this.sBox[n4];
            this.sBox[n4] = n6;
            n3 = (n3 + 1) % n;
            ++n5;
        }
    }

    public static final class Test
    extends TestCase {
        public void testRC4() {
            RC4 rC4 = new RC4("testkey".getBytes());
            byte[] byArray = "test message".getBytes();
            byte[] byArray2 = rC4.crypt(rC4.crypt(byArray));
            int n = 0;
            while (n < byArray.length) {
                Assert.assertEquals((byte)byArray2[n], (byte)byArray[n]);
                ++n;
            }
        }
    }
}

