package com.renderx.xepx.x4u.as;

import java.awt.*;
import javax.swing.*;

/***************************************************************************
 * <p>Title: XEP Assistant </p>
 * <p>Description: XEP Assistant UI
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Zenteq.am</p>
 * @author: Angelina Andriasyan
 **************************************************************************/
public class Assistant {

	public static void main(String[] args) {

		Settings settings = new Settings();
		settings.setXEPConfigPath(args);

		Logger logger = new Logger();
		Formatter formatter = new Formatter(settings,logger);
		UI ui = new UI();

		ui.logtab = new LogTab(logger);
		ui.timer = new Timer(100,	new TimerListener(settings,formatter,ui)); 
		ui.rootframe = new RootFrame(settings,formatter,ui);

		ui.rootframe.validate();

		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize(); 
		Dimension frameSize = ui.rootframe.getSize();

		if (frameSize.height > screenSize.height) {
			frameSize.height = screenSize.height;
		}
		if (frameSize.width > screenSize.width) {
			frameSize.width = screenSize.width;
		}

		ui.rootframe.setLocation(
				(screenSize.width-frameSize.width)/2,
				(screenSize.height-frameSize.height)/2);
		ui.rootframe.setDefaultCloseOperation(ui.rootframe.DO_NOTHING_ON_CLOSE);
		ui.rootframe.setVisible(true);

	}
}
