/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.cmp;

import com.renderx.hyphen.Hyphenator;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.Stack;
import com.renderx.util.URLSpec;
import com.renderx.xep.cmp.Flow;
import com.renderx.xep.cmp.Item;
import com.renderx.xep.cmp.ListContext;
import com.renderx.xep.cmp.TableContext;
import com.renderx.xep.cmp.Tokenizer;
import com.renderx.xep.lib.InternalException;
import com.renderx.xep.lib.Session;
import com.renderx.xep.lib.Util;
import com.renderx.xep.pre.AttList;
import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.Attributed;
import com.renderx.xep.pre.CompilerException;
import com.renderx.xep.pre.Elem;
import com.renderx.xep.pre.ElementHandler;
import com.renderx.xep.pre.PIHandler;
import java.net.MalformedURLException;
import java.util.Enumeration;

class FlowHandler
implements ElementHandler,
PIHandler {
    private Item.Block fakeblock;
    private Item.Span fakespan;
    private final Session session;
    private Stack contexts = new Stack();
    private Stack inlinecontexts = new Stack();
    private Stack captions = new Stack();
    private Stack tables = new Stack();
    private Stack lists = new Stack();
    private Stack exceptions = new Stack();
    private Stack ids = new Stack();
    private Stack keys = new Stack();
    private Hashtable keytab = new Hashtable();
    private boolean vacuumMode = false;
    private List vacuumStartBars = new List();
    private List vacuumEndBars = new List();
    private Flow vacuumFlow = null;
    private Context context = null;
    private Item.ListBlock list = null;
    private Item.Table table = null;
    private Item.Block b = null;
    private Item.Span s = null;
    private Item.Image rmo = null;
    private Item.PDFComment pdfc = null;
    private Tokenizer tokenizer = new Tokenizer();
    private Hyphenator hyphenator = null;
    private String currentLanguage = "";
    private boolean bow = true;
    private Item bos = null;
    private Attributed a0 = null;
    private Item.TextTraits tt0 = null;
    private Item.Id id;
    private Item.Key key;
    private static final Attr.Word uppercase = Attr.newWord("uppercase");
    private static final Attr.Word lowercase = Attr.newWord("lowercase");
    private static final Attr.Word capitalize = Attr.newWord("capitalize");

    private void endVacuumBar(Item.ChangeBar changeBar) {
        if (this.vacuumStartBars.isPair()) {
            if (this.vacuumStartBars.contains(changeBar.pair)) {
                this.vacuumStartBars = this.vacuumStartBars.remove(changeBar.pair);
                return;
            }
            throw new InternalException("Mismatched change-bar-end element of class " + changeBar.cbclass + " in table vacuum.");
        }
        this.vacuumEndBars.snoc(changeBar);
    }

    private void startVacuumBar(Item.ChangeBar changeBar) {
        this.vacuumStartBars.snoc(changeBar);
    }

    FlowHandler(Flow flow, Session session) {
        this.session = session;
        this.fakeblock = new Item.Block(AttList.empty, session);
        this.fakespan = new Item.Span(AttList.empty, session);
        this.id = new Item.Id(AttList.empty);
        this.id.desc_count = 0;
        this.ids.push(this.id);
        this.key = new Item.Key(AttList.empty, session);
        this.key.desc_count = 0;
        this.keys.push(this.key);
        this.pushContext(new Context(flow));
    }

    private void pushContext(Context context) {
        this.context = context;
        this.contexts.push(this.context);
        this.b = context.blocks.isEmpty() ? this.fakeblock : (Item.Block)context.blocks.peek();
        this.s = context.spans.isEmpty() ? this.fakespan : (Item.Span)context.spans.peek();
    }

    private void popContext() {
        this.contexts.pop();
        if (!this.contexts.isEmpty()) {
            this.context = (Context)this.contexts.peek();
            this.b = this.context.blocks.isEmpty() ? this.fakeblock : (Item.Block)this.context.blocks.peek();
            this.s = this.context.spans.isEmpty() ? this.fakespan : (Item.Span)this.context.spans.peek();
        } else {
            this.context = null;
            this.b = null;
            this.s = null;
        }
    }

    private void pushId(Attributed attributed) {
        this.id = new Item.Id(attributed);
        this.ids.push(this.id);
        this.id.desc_count = 0;
        this.context.flow.append(this.id);
    }

    private void popId() {
        Item.Lid lid = new Item.Lid(this.id.a, this.id.id);
        this.context.flow.append(lid);
        this.ids.pop();
        this.id = (Item.Id)this.ids.peek();
    }

    private void pushKey(Attributed attributed) {
        this.key = new Item.Key(attributed, this.session);
        this.keys.push(this.key);
        this.key.desc_count = 0;
        this.context.flow.append(this.key);
    }

    private void popKey() {
        Item.Endk endk = new Item.Endk(this.key.a, this.key.id);
        this.context.flow.append(endk);
        this.keys.pop();
        this.key = (Item.Key)this.keys.peek();
    }

    private void addZWLeader(AttList attList) {
    }

    private void pcdata(AttList attList) {
        Object object;
        String string = attList.get(Attn.$TEXT).word();
        boolean bl = this.b.wrap && this.s.get(Attn.$keep_together_within_line) == Attr.auto;
        string = this.tokenizer.tokenize(attList, string, this.b);
        if (this.tt0 != null) {
            this.tt0.thai_case |= this.b.tt.thai_case;
        }
        if (bl && attList.get(Attn.$hyphenate).bool()) {
            object = attList.get(Attn.$language).word();
            Attr attr = attList.get(Attn.$country);
            if (attr != Attr.none) {
                object = (String)object + "-" + attr.word();
            }
            if (!((String)object).equals(this.currentLanguage)) {
                this.hyphenator = this.session.config.hyphenFactory.getHyphenator((String)object);
                this.currentLanguage = object;
            }
            if (this.hyphenator != null) {
                string = this.hyphenator.hyphenate(string, attList.get(Attn.$hyphenation_remain_character_count).count(), attList.get(Attn.$hyphenation_push_character_count).count());
            }
        }
        object = new char[string.length()];
        string.getChars(0, string.length(), (char[])object, 0);
        short s = 0;
        int n = 0;
        int n2 = 0;
        while (n2 != ((Object)object).length) {
            Object object2 = object[n2];
            if (object2 == 10) {
                if (n != 0) {
                    this.addText((char[])object, n, attList, s);
                    n = 0;
                }
                AttList attList2 = (AttList)attList.clone();
                attList2.put(Attn.$leader_length_minimum, Attr.newLength(0));
                attList2.put(Attn.$leader_length_optimum, Attr.newLength(0));
                attList2.put(Attn.$leader_length_maximum, Attr.newLength(0));
                Item.Leader leader = new Item.Leader(attList2, this.session);
                leader.span = new Item.Span(attList, this.session);
                this.startSpan(leader.span);
                this.context.flow.append(leader);
                this.endSpan();
                this.context.flow.append(Item.endl);
                s = 0;
                this.bow = true;
            } else if (object2 == 173) {
                if (bl) {
                    if (n != 0) {
                        this.addText((char[])object, n, attList, (short)(s | 0x20));
                        n = 0;
                    }
                    s = 1;
                }
            } else if (object2 == 8203) {
                if (n != 0) {
                    this.addText((char[])object, n, attList, s);
                    n = 0;
                }
                if (bl) {
                    s = 1;
                }
                this.bow = true;
            } else {
                if (n != 0 && (object[n - 1] == 32 != (object2 == 32) || object[n - 1] == 160 != (object2 == 160))) {
                    this.addText((char[])object, n, attList, s);
                    n = 0;
                    s = 0;
                }
                object[n++] = object2;
            }
            ++n2;
        }
        if (n != 0) {
            this.addText((char[])object, n, attList, s);
        }
        attList.remove(Attn.$TEXT);
    }

    private short bos(short s) {
        if (this.bos != null) {
            this.bos.setFlags(s & 1);
            s = (short)(s & 0xFFFFFFFE);
            this.bos = null;
        }
        return s;
    }

    private void setPhraseBreak(Item item) {
        this.context.flow.append(item.setFlags(this.bos(this.tokenizer.a >= 1 ? (short)1 : 0)));
    }

    private void addText(char[] cArray, int n, AttList attList, short s) {
        s = this.bos(s);
        Attr attr = attList.get(Attn.$text_transform);
        if (attr != Attr.none) {
            if (attr == uppercase) {
                int n2 = 0;
                while (n2 != n) {
                    cArray[n2] = Character.toUpperCase(cArray[n2]);
                    ++n2;
                }
            } else if (attr == lowercase) {
                int n3 = 0;
                while (n3 != n) {
                    cArray[n3] = Character.toLowerCase(cArray[n3]);
                    ++n3;
                }
            } else if (attr == capitalize) {
                int n4 = 0;
                while (n4 != n) {
                    cArray[n4] = this.bow ? Character.toUpperCase(cArray[n4]) : Character.toLowerCase(cArray[n4]);
                    this.bow = !Character.isLetter(cArray[n4]);
                    ++n4;
                }
            }
        }
        Item.Text text = new Item.Text(cArray, n, attList, this.session, this.a0, this.tt0);
        text.setFlags(s);
        this.a0 = text.a;
        this.tt0 = text.tt;
        this.context.flow.append(text);
    }

    private void swap(Attributed attributed, Attn attn, Attn attn2) {
        if (attributed.containsKey(attn)) {
            if (attributed.containsKey(attn2)) {
                Attr attr = attributed.get(attn2);
                attributed.put(attn2, attributed.get(attn));
                attributed.put(attn, attr);
            } else {
                attributed.put(attn2, attributed.remove(attn));
            }
        } else if (attributed.containsKey(attn2)) {
            attributed.put(attn, attributed.remove(attn2));
        }
    }

    private boolean rotated(Attributed attributed) {
        return Util.phi(attributed.get(Attn.$reference_orientation).count()) != 0 || this.session.config.ROTATE_ZERO_DEGREES && attributed.containsKey(Attn.$reference_orientation) || Attr.dim_range(attributed, Attn.$block_progression_dimension_minimum, Attn.$block_progression_dimension_optimum, Attn.$block_progression_dimension_maximum, 0) != Integer.MIN_VALUE;
    }

    private void arot(Attributed attributed, Attributed attributed2) {
        if (attributed.get(Attn.$reference_orientation).count() % 180 == 0) {
            Attn[] attnArray = new Attn[]{Attn.$reference_orientation, Attn.$writing_mode, Attn.$display_align, Attn.$overflow, Attn.$block_progression_dimension_minimum, Attn.$block_progression_dimension_optimum, Attn.$block_progression_dimension_maximum};
            int n = 0;
            while (n != attnArray.length) {
                Attn attn = attnArray[n];
                if (attributed.containsKey(attn)) {
                    attributed2.put(attn, attributed.get(attn));
                }
                ++n;
            }
        } else {
            Attn[] attnArray;
            Attn[] attnArray2 = new Attn[]{Attn.$reference_orientation, Attn.$writing_mode, Attn.$display_align, Attn.$overflow, Attn.$inline_progression_dimension_minimum, Attn.$inline_progression_dimension_optimum, Attn.$inline_progression_dimension_maximum};
            int n = 0;
            while (n != attnArray2.length) {
                attnArray = attnArray2[n];
                if (attributed.containsKey((Attn)attnArray)) {
                    attributed2.put((Attn)attnArray, attributed.get((Attn)attnArray));
                }
                ++n;
            }
            attnArray = new Attn[]{Attn.$block_progression_dimension_minimum, Attn.$inline_progression_dimension_minimum, Attn.$block_progression_dimension_optimum, Attn.$inline_progression_dimension_optimum, Attn.$block_progression_dimension_maximum, Attn.$inline_progression_dimension_maximum};
            int n2 = 0;
            while (n2 != attnArray.length) {
                this.swap(attributed, attnArray[n2], attnArray[n2 + 1]);
                n2 += 2;
            }
        }
    }

    private void startBlock(Item.Block block) {
        if (block instanceof Item.Frame && block.get(Attn.$absolute_position) != Attr.auto) {
            this.startExpt(block.get(Attn.$absolute_position) == Attr.newWord("fixed") ? new Item.Fixed(block.a) : new Item.Absolute(block.a));
            AttList attList = (AttList)block.a.clone();
            Attn[] attnArray = new Attn[]{Attn.$start_indent, Attn.$end_indent, Attn.$margin_before, Attn.$margin_after, Attn.$margin_start, Attn.$margin_end, Attn.$border_before_width_length, Attn.$border_after_width_length, Attn.$border_start_width_length, Attn.$border_end_width_length, Attn.$padding_before_length, Attn.$padding_after_length, Attn.$padding_start_length, Attn.$padding_end_length, Attn.$inline_progression_dimension_minimum, Attn.$inline_progression_dimension_optimum, Attn.$inline_progression_dimension_maximum, Attn.$block_progression_dimension_minimum, Attn.$block_progression_dimension_optimum, Attn.$block_progression_dimension_maximum, Attn.$background_color, Attn.$background_image};
            int n = 0;
            while (n != attnArray.length) {
                attList.remove(attnArray[n]);
                ++n;
            }
            block.a = attList;
            ((Item.Frame)block).mode = (short)2;
            this.context.flow.append(block);
            this.context.blocks.push(block);
            this.b = block;
        } else {
            if (block.get(Attn.$keep_with_previous_within_column) != Attr.auto || block.get(Attn.$keep_with_previous_within_page) != Attr.auto) {
                this.context.flow.append(new Item.Keep((Attributed)block));
            }
            if (block.get(Attn.$break_before) != Attr.auto) {
                this.context.flow.append(new Item.Break(block, "before"));
            }
            if (block.get(Attn.$clear) != Attr.none) {
                this.context.flow.append(new Item.Clear(block.a));
            }
            if (block.get(Attn.$span) == Attr.all) {
                this.context.flow.append(new Item.Wide(block.a, this.session));
            }
            this.context.flow.append(Item.empty);
            Item.Space.Display display = new Item.Space.Display(block, "space-before");
            if (!display.nil) {
                this.context.flow.append(display);
            }
            this.context.flow.append(block);
            this.context.blocks.push(block);
            if (this.rotated(block)) {
                AttList attList = new AttList();
                block.collapse = false;
                block.a = (AttList)block.a.clone();
                this.arot(block.a, attList);
                this.startRotated(attList);
            } else {
                this.b = block;
            }
        }
        this.bow = true;
    }

    private void endBlock() {
        if (this.b instanceof Item.Frame && ((Item.Frame)this.b).mode == 2) {
            this.context.flow.append(Item.endf);
            this.endExpt();
        } else {
            if (this.b instanceof Item.Frame && ((Item.Frame)this.b).mode == 1) {
                this.endRotated();
            }
            Item.Block block = this.b;
            this.context.blocks.pop();
            this.b = this.context.blocks.isEmpty() ? this.fakeblock : (Item.Block)this.context.blocks.peek();
            this.context.flow.append(block instanceof Item.Frame ? Item.endf : (block instanceof Item.ListItem ? Item.endli : Item.endb));
            if (block.get(Attn.$keep_with_next_within_column) != Attr.auto || block.get(Attn.$keep_with_next_within_page) != Attr.auto) {
                this.context.flow.append(new Item.Keep((Attributed)block));
            }
            Item.Space.Display display = new Item.Space.Display(block, "space-after");
            if (!display.nil) {
                this.context.flow.append(display);
            }
            if (block.get(Attn.$span) == Attr.all) {
                this.context.flow.append(Item.endw);
            }
            if (block.get(Attn.$break_after) != Attr.auto) {
                this.context.flow.append(new Item.Break(block, "after"));
            }
        }
        this.bow = true;
    }

    private void startOuter(Item.Frame frame) {
        this.context.flow.append(frame);
        this.context.blocks.push(frame);
        this.b = frame;
    }

    private void endOuter() {
        this.context.blocks.pop();
        this.b = this.context.blocks.isEmpty() ? this.fakeblock : (Item.Block)this.context.blocks.peek();
        this.context.flow.append(Item.endf);
    }

    private void startInner(Item.Frame frame) {
        if (frame.get(Attn.$keep_with_previous_within_column) != Attr.auto || frame.get(Attn.$keep_with_previous_within_page) != Attr.auto) {
            this.context.flow.append(new Item.Keep((Attributed)frame));
        }
        if (frame.get(Attn.$break_before) != Attr.auto) {
            this.context.flow.append(new Item.Break(frame, "before"));
        }
        if (frame.get(Attn.$clear) != Attr.none) {
            this.context.flow.append(new Item.Clear(frame.a));
        }
        this.context.flow.append(Item.empty);
        this.context.flow.append(frame);
        this.context.blocks.push(frame);
        this.b = frame;
        this.bow = true;
    }

    private void endInner() {
        Item.Block block = this.b;
        this.context.blocks.pop();
        this.b = this.context.blocks.isEmpty() ? this.fakeblock : (Item.Block)this.context.blocks.peek();
        this.context.flow.append(Item.endf);
        if (block.get(Attn.$keep_with_next_within_column) != Attr.auto || block.get(Attn.$keep_with_next_within_page) != Attr.auto) {
            this.context.flow.append(new Item.Keep((Attributed)block));
        }
        if (block.get(Attn.$break_after) != Attr.auto) {
            this.context.flow.append(new Item.Break(block, "after"));
        }
        this.bow = true;
    }

    private void startRotated(Attributed attributed) {
        AttList attList = (AttList)attributed.clone();
        Attn[] attnArray = new Attn[]{Attn.$reference_orientation, Attn.$inline_progression_dimension_minimum, Attn.$inline_progression_dimension_optimum, Attn.$inline_progression_dimension_maximum, Attn.$block_progression_dimension_minimum, Attn.$block_progression_dimension_optimum, Attn.$block_progression_dimension_maximum};
        int n = 0;
        while (n != attnArray.length) {
            attList.remove(attnArray[n]);
            ++n;
        }
        Item.Frame frame = new Item.Frame(attList, this.session);
        frame.mode = 1;
        this.context.flow.append(new Item.Rotated(attributed)).append(new Item.Jump("rotated:" + frame.bno)).append(frame);
        this.context.blocks.push(frame);
        this.b = frame;
    }

    private void endRotated() {
        Item.Block block = this.b;
        this.context.blocks.pop();
        this.b = this.context.blocks.isEmpty() ? this.fakeblock : (Item.Block)this.context.blocks.peek();
        this.context.flow.append(Item.endf).append(Item.eofl).append(new Item.Label("rotated:" + block.bno));
    }

    private void startSpan(Item.Span span) {
        Attn[] attnArray;
        if (span.writing_mode != this.b.writing_mode) {
            attnArray = new Attn[]{Attn.$border_end_color, Attn.$border_start_color, Attn.$border_end_style, Attn.$border_start_style, Attn.$border_end_width_conditionality, Attn.$border_start_width_conditionality, Attn.$border_end_width_length, Attn.$border_start_width_length, Attn.$padding_end_conditionality, Attn.$padding_start_conditionality, Attn.$padding_end_length, Attn.$padding_start_length, Attn.$margin_end, Attn.$margin_start};
            int n = 0;
            while (n != attnArray.length) {
                this.swap(span, attnArray[n], attnArray[n + 1]);
                n += 2;
            }
        }
        if (this.bos == null && (this.s.get(Attn.$keep_together_within_line) != Attr.auto || span.get(Attn.$keep_with_previous_within_line) != Attr.auto)) {
            this.tokenizer.a = (short)-1;
        }
        attnArray = new Item.Space.Inline(span, span.writing_mode == this.s.writing_mode ? "space-start" : "space-end");
        if (!attnArray.nil) {
            this.context.flow.append(attnArray);
            if (this.bos == null) {
                this.bos = attnArray;
            }
        }
        this.context.flow.append(span);
        if (this.bos == null) {
            this.bos = span;
        }
        this.context.spans.push(span);
        this.s = span;
    }

    private void endSpan() {
        this.context.flow.append(Item.ends);
        Item.Span span = this.s;
        this.context.spans.pop();
        this.s = this.context.spans.isEmpty() ? this.fakespan : (Item.Span)this.context.spans.peek();
        Item.Space.Inline inline = new Item.Space.Inline(span, span.writing_mode == this.s.writing_mode ? "space-end" : "space-start");
        if (!inline.nil) {
            this.context.flow.append(inline);
        }
        if (this.bos == null && (this.s.get(Attn.$keep_together_within_line) != Attr.auto || span.get(Attn.$keep_with_next_within_line) != Attr.auto)) {
            this.tokenizer.a = (short)-1;
        }
    }

    private void startExpt(Item.Exception exception) {
        this.bos(this.tokenizer.a >= 1 ? (short)1 : 0);
        this.tokenizer.a = 0;
        this.inlinecontexts.push(new InlineContext(this.tokenizer.a, this.bos, this.bow));
        this.exceptions.push(exception);
        this.pushContext(new Context(exception.flow));
    }

    private void endExpt() {
        this.popContext();
        this.context.flow.append(this.exceptions.pop());
        InlineContext inlineContext = (InlineContext)this.inlinecontexts.pop();
        this.tokenizer.a = inlineContext.tokenizer_a;
        this.bos = inlineContext.bos;
        this.bow = inlineContext.bow;
    }

    private void startRowgroup(short s, AttList attList) {
        Flow flow = new Flow();
        Flow flow2 = new Flow();
        this.context = new Context(flow, this.context.blocks, this.context.spans);
        this.contexts.push(new Context(flow2, this.context.blocks, this.context.spans)).push(this.context);
        this.startBlock(new Item.Block(attList, this.session));
        this.popContext();
        this.table.context.startRowgroup(s, attList, flow, flow2);
    }

    private void endRowgroup(short s) {
        this.endBlock();
        this.popContext();
        this.table.context.endRowgroup(s);
    }

    private void fakeChangeBars(Item.ChangeBar.Type type, String string) {
        Stack stack = new Stack();
        Enumeration enumeration = this.session.cbStack.elements();
        while (enumeration.hasMoreElements()) {
            Item.ChangeBar changeBar = (Item.ChangeBar)enumeration.nextElement();
            Item.ChangeBar changeBar2 = new Item.ChangeBar(changeBar.attlist, this.session.nextno(), type);
            this.context.flow.append(changeBar2);
            if (type == Item.ChangeBar.FSTART) {
                stack.snoc(changeBar2);
                continue;
            }
            changeBar.pair = changeBar2;
            changeBar2.pair = changeBar;
        }
        if (type == Item.ChangeBar.FSTART) {
            this.session.cbStack.clear().append(stack);
        }
    }

    private void flushEndChangeBars() {
        while (this.vacuumEndBars.isPair()) {
            Item.ChangeBar changeBar = (Item.ChangeBar)this.vacuumEndBars.shift();
            this.vacuumFlow.append(changeBar);
        }
    }

    private void flushStartChangeBars() {
        while (this.vacuumStartBars.isPair()) {
            Item.ChangeBar changeBar = (Item.ChangeBar)this.vacuumStartBars.shift();
            this.vacuumFlow.append(changeBar);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void startElement(short var1_1, AttList var2_2) throws CompilerException {
        ++this.id.desc_count;
        ++this.key.desc_count;
        if (var2_2.containsKey(Attn.$index_key)) {
            var2_2.put(Attn.$key, var2_2.get(Attn.$index_key));
            var2_2.remove(Attn.$index_key);
        }
        switch (var1_1) {
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 0: {
                this.pcdata(var2_2);
                break;
            }
            case 20: {
                this.startBlock(new Item.Block(var2_2, this.session));
                break;
            }
            case 21: {
                v0 = var3_3 = var2_2.get(Attn.$absolute_position) != Attr.auto;
                if (var3_3) {
                    this.fakeChangeBars(Item.ChangeBar.FEND, "before start of absolute or fixed container");
                }
                var4_4 = new Item.Frame(var2_2, this.session);
                this.startBlock(var4_4);
                if (var3_3) {
                    this.fakeChangeBars(Item.ChangeBar.FSTART, "after start of absolute or fixed container");
                }
                this.session.PDFFormFieldHolders.push(var4_4);
                break;
            }
            case 24: {
                this.b.proplist.put(var1_1, var2_2);
                break;
            }
            case 109: {
                this.b.proplist.put(var1_1, var2_2);
                break;
            }
            case 22: 
            case 27: {
                var5_5 = new Item.Span(var2_2, this.session);
                this.startSpan(var5_5);
                this.session.PDFFormFieldHolders.push(var5_5);
                break;
            }
            case 28: {
                this.startSpan(new Item.Span(var2_2, this.session));
                break;
            }
            case 48: {
                this.startSpan(new Item.Anchor(var2_2, this.session));
                break;
            }
            case 29: {
                var6_6 = new Item.Leader(var2_2, this.session);
                var6_6.span = new Item.Span(var2_2, this.session);
                this.startSpan(var6_6.span);
                this.setPhraseBreak(var6_6);
                this.pushContext(new Context(new Flow(), this.context.blocks, this.context.spans));
                break;
            }
            case 25: 
            case 122: 
            case 124: {
                var7_9 = new Item.Span(var2_2, this.session);
                if (var2_2.get(Attn.$src) != Attr.none) {
                    var6_7 /* !! */  = new Item.Image(var2_2, this.session);
                    var6_7 /* !! */ .span = var7_9;
                    if (var1_1 == 124) {
                        this.rmo = var6_7 /* !! */ ;
                        this.rmo.isRMO = true;
                        this.rmo.rmoName = var2_2.get(Attn.$name).word();
                    }
                } else {
                    var8_32 = (AttList)var2_2.clone();
                    var8_32.put(Attn.$leader_length_minimum, Attr.newLength(0));
                    var8_32.put(Attn.$leader_length_optimum, Attr.newLength(0));
                    var8_32.put(Attn.$leader_length_maximum, Attr.newLength(0));
                    var6_7 /* !! */  = new Item.Leader(var8_32, this.session);
                    ((Item.Leader)var6_7 /* !! */ ).span = var7_9;
                }
                this.startSpan(var7_9);
                this.setPhraseBreak(var6_7 /* !! */ );
                this.tokenizer.a = 0;
                this.endSpan();
                break;
            }
            case 46: {
                break;
            }
            case 47: {
                this.fakeChangeBars(Item.ChangeBar.FEND, "before start of footnote");
                this.startExpt(new Item.Footnote(var2_2));
                this.startBlock(new Item.Block(var2_2, this.session));
                this.fakeChangeBars(Item.ChangeBar.FSTART, "after start of footnote");
                break;
            }
            case 30: {
                this.startExpt(new Item.PageNumber(var2_2));
                break;
            }
            case 31: {
                this.setPhraseBreak(new Item.PageId(var2_2, this.session));
                this.tokenizer.a = 0;
                break;
            }
            case 201: {
                this.setPhraseBreak(new Item.PageLid(var2_2, this.session));
                this.tokenizer.a = 0;
                break;
            }
            case 108: 
            case 209: {
                this.startExpt(new Item.PageKey(var2_2));
                break;
            }
            case 210: {
                var2_2.put(Attn.$ref_key, var2_2.get(Attn.$ref_index_key));
                var2_2.remove(Attn.$ref_index_key);
                if (var2_2.containsKey(Attn.$page_number_treatment)) {
                    var2_2.put(Attn.$link_back, Attr.Bool.create(var2_2.get(Attn.$page_number_treatment).word().equals("link")));
                    var2_2.remove(Attn.$page_number_treatment);
                }
                if (var2_2.containsKey(Attn.$merge_sequential_page_numbers)) {
                    var2_2.put(Attn.$merge_subsequent_page_numbers, Attr.Bool.create(var2_2.get(Attn.$merge_sequential_page_numbers).word().equals("merge")));
                    var2_2.remove(Attn.$merge_sequential_page_numbers);
                }
            }
            case 110: {
                var6_8 = (Item.PageKey)this.exceptions.car();
                if (var2_2.containsKey(Attn.$list_separator)) {
                    var6_8.a.put(Attn.$list_separator, var2_2.get(Attn.$list_separator));
                }
                if (var2_2.containsKey(Attn.$range_separator)) {
                    var6_8.a.put(Attn.$range_separator, var2_2.get(Attn.$range_separator));
                }
                var6_8.terms.snoc(new Item.PageKey.Term(var2_2, this.session));
                break;
            }
            case 41: {
                this.vacuumMode = true;
                this.vacuumFlow = this.context.flow;
                this.list = new Item.ListBlock((Attributed)var2_2, new ListContext(var2_2, this.session));
                this.startBlock(this.list);
                this.lists.push(this.list);
                break;
            }
            case 42: {
                var7_10 = new Flow();
                var8_33 = new Flow();
                this.context = new Context(var7_10, this.context.blocks, this.context.spans);
                this.contexts.push(new Context(var8_33, this.context.blocks, this.context.spans)).push(this.context);
                this.startBlock(new Item.ListItem(var2_2, this.session));
                this.list.context.startRow(var2_2, var7_10, var8_33);
                break;
            }
            case 43: 
            case 44: {
                var7_11 = new Flow();
                this.pushContext(new Context(var7_11, this.context.blocks, this.context.spans));
                this.list.context.startCell(var2_2, var7_11);
                this.startBlock(new Item.Block(var2_2, this.session));
                this.flushEndChangeBars();
                this.vacuumFlow = var7_11;
                this.vacuumMode = false;
                this.flushStartChangeBars();
                break;
            }
            case 32: {
                this.startBlock(new Item.Block(var2_2, this.session));
                var7_12 = this.b.get(Attn.$caption_side);
                if (var7_12 != Attr.newWord("after") && var7_12 != Attr.newWord("end")) break;
                this.captions.push(new Flow());
                break;
            }
            case 33: {
                var7_13 = this.b.get(Attn.$caption_side);
                if (var7_13 == Attr.newWord("after") || var7_13 == Attr.newWord("end")) {
                    this.fakeChangeBars(Item.ChangeBar.FEND, "before start of table-caption");
                    var8_34 = (Flow)this.captions.peek();
                    this.pushContext(new Context(var8_34, this.context.blocks, this.context.spans));
                    var2_2.put(Attn.$keep_with_previous_within_column, Attr.always);
                    this.fakeChangeBars(Item.ChangeBar.FSTART, "after start of table-caption");
                } else {
                    var2_2.put(Attn.$keep_with_next_within_column, Attr.always);
                }
                this.startBlock(new Item.Frame(var2_2, this.session));
                break;
            }
            case 34: {
                this.vacuumMode = true;
                this.vacuumFlow = this.context.flow;
                this.table = new Item.Table((Attributed)var2_2, new TableContext(var2_2, this.session));
                this.startBlock(this.table);
                this.tables.push(this.table);
                break;
            }
            case 35: {
                this.table.context.column(var2_2);
                break;
            }
            case 36: {
                var2_2.put(Attn.$keep_together_within_column, Attr.always);
                var2_2.put(Attn.$keep_with_next_within_column, Attr.always);
                this.startRowgroup((short)0, var2_2);
                break;
            }
            case 37: {
                this.startRowgroup((short)2, var2_2);
                break;
            }
            case 38: {
                this.startRowgroup((short)1, var2_2);
                break;
            }
            case 39: {
                this.table.context.startRow(var2_2);
                break;
            }
            case 40: {
                var7_14 = new Flow();
                var8_35 = new Flow();
                var9_51 = new Flow();
                var12_68 = new AttList();
                var13_69 = (AttList)var2_2.clone();
                var12_68.put(Attn.$writing_mode, this.table.get(Attn.$writing_mode));
                var12_68.put(Attn.$intrusion_displace, this.table.get(Attn.$intrusion_displace));
                var14_70 = Attr.newLength(this.table.get(Attn.$border_separation_block_progression_direction).length() / 2);
                var13_69.put(Attn.$margin_before, (Attr)var14_70);
                var13_69.put(Attn.$margin_after, (Attr)var14_70);
                var13_69.put(Attn.$margin_start, Attr.zerolength);
                var13_69.put(Attn.$margin_end, Attr.zerolength);
                var13_69.remove(Attn.$keep_together_within_column);
                var13_69.remove(Attn.$keep_together_within_page);
                this.pushContext(new Context(var8_35, this.context.blocks, this.context.spans));
                this.context.flow = var7_14;
                var10_71 = new Item.Frame(var12_68, this.session);
                this.startOuter(var10_71);
                if (this.rotated(var2_2)) {
                    var14_70 = new AttList();
                    this.arot(var13_69, (Attributed)var14_70);
                    var11_93 = new Item.Frame(var13_69, this.session);
                    this.startInner(var11_93);
                    this.context.flow = var8_35;
                    this.pushContext(new Context(var9_51, this.context.blocks, this.context.spans));
                    this.startRotated((Attributed)var14_70);
                } else {
                    var11_93 = new Item.Frame(var13_69, this.session);
                    this.startInner(var11_93);
                    this.context.flow = var8_35;
                    this.pushContext(new Context(var9_51, this.context.blocks, this.context.spans));
                }
                var11_93.collapse = false;
                this.table.context.startCell(var2_2, var10_71, var11_93, var7_14, var9_51, var8_35);
                this.flushEndChangeBars();
                this.vacuumFlow = var9_51;
                this.vacuumMode = false;
                this.flushStartChangeBars();
                break;
            }
            case 49: {
                break;
            }
            case 50: {
                var7_15 = new Flow();
                v1 = this.b.bno > this.s.sno ? (this.b.markers != null ? this.b.markers : (this.b.markers = new Hashtable())) : (this.s.markers != null ? this.s.markers : (this.s.markers = new Hashtable()));
                var8_36 = v1;
                var9_52 = var2_2.get(Attn.$marker_class_name);
                var8_36.put(var9_52, var7_15);
                this.pushContext(new Context(var7_15));
                break;
            }
            case 51: {
                this.startExpt(new Item.Remark(var2_2));
                break;
            }
            case 45: {
                v2 = var7_16 = var2_2.get(Attn.$float) != Attr.none;
                if (var7_16) {
                    this.fakeChangeBars(Item.ChangeBar.FEND, "before start of float");
                }
                var8_37 = new AttList();
                if (var2_2.get(Attn.$float) != Attr.none) {
                    this.startExpt(new Item.Float(var2_2));
                    var8_37.put(Attn.$float, var2_2.get(Attn.$float));
                }
                this.startBlock(new Item.Frame(var8_37, this.session));
                if (!var7_16) break;
                this.fakeChangeBars(Item.ChangeBar.FSTART, "after start of float");
                break;
            }
            case 101: {
                var2_2.put(Attn.$span, Attr.all);
                var2_2.put(Attn.$start_indent, Attr.zerolength);
                var2_2.put(Attn.$end_indent, Attr.zerolength);
                this.startBlock(new Item.Frame(var2_2, this.session));
                break;
            }
            case 107: {
                this.context.flow.append(new Item.Pinpoint(var2_2));
                break;
            }
            case 111: 
            case 206: {
                var7_17 = new Item.Key((Attributed)var2_2.clone(), this.session);
                this.context.flow.append(var7_17);
                var2_2.remove(Attn.$key);
                break;
            }
            case 112: 
            case 207: {
                this.context.flow.append(new Item.Endk(var2_2, var2_2.get(Attn.$ref_id)));
                break;
            }
            case 202: {
                var7_18 = new Item.ChangeBar(var2_2, this.session.nextno(), Item.ChangeBar.START);
                this.session.cbStack.push(var7_18);
                if (this.vacuumMode) {
                    this.startVacuumBar(var7_18);
                    break;
                }
                this.context.flow.append(var7_18);
                break;
            }
            case 203: {
                var7_19 = var2_2.get(Attn.$change_bar_class).word();
                if (this.session.cbStack.isEmpty()) {
                    this.session.warning("Stray change-bar-end element of class " + var7_19 + " (ignored)");
                    break;
                }
                var8_38 = null;
                var9_53 = this.session.cbStack.elements();
                while (var9_53.hasMoreElements()) {
                    var8_38 = (Item.ChangeBar)var9_53.nextElement();
                    if (var7_19.equals(var8_38.cbclass)) {
                        var10_72 /* !! */  = new Item.ChangeBar(var8_38.attlist, this.session.nextno(), Item.ChangeBar.END);
                        var8_38.pair = var10_72 /* !! */ ;
                        var10_72 /* !! */ .pair = var8_38;
                        if (this.vacuumMode) {
                            this.endVacuumBar((Item.ChangeBar)var10_72 /* !! */ );
                            break;
                        }
                        this.context.flow.append((Object)var10_72 /* !! */ );
                        break;
                    }
                    var8_38 = null;
                }
                if (var8_38 != null) {
                    var10_72 /* !! */  = this.session.cbStack.remove(var8_38);
                    this.session.cbStack.clear().append(var10_72 /* !! */ );
                    break;
                }
                this.session.warning("Mismatched change-bar-end element of class " + var7_19 + " (ignored)");
                break;
            }
            case 125: {
                if (this.rmo != null) {
                    if (this.rmo.flashvars == null) {
                        this.rmo.flashvars = new Item.Image.FlashVars(this.rmo);
                    }
                    var7_20 = var2_2.get(Attn.$name).word();
                    var8_39 = var2_2.containsKey(Attn.$value) == false;
                    var9_54 = var8_39 != false ? var2_2.get(Attn.$flash_var_content).word() : var2_2.get(Attn.$value).word();
                    this.rmo.flashvars.vars.put(var7_20, new Item.Image.FlashVars.FlashVar(this.rmo.flashvars, var7_20, var9_54, var8_39));
                    break;
                }
                this.session.error("rx:flash-var not inside of an rx:rich-media-object");
                break;
            }
            case 126: {
                if (this.rmo == null) ** GOTO lbl346
                if (this.rmo.rmoResources == null) {
                    this.rmo.rmoResources = new Hashtable();
                }
                var7_21 = var2_2.get(Attn.$name).word();
                var8_40 = null;
                if (!var2_2.containsKey(Attn.$src) || !var2_2.containsKey(Attn.$image_base_url)) ** GOTO lbl342
                try {
                    var9_55 = new URLSpec(var2_2.get(Attn.$image_base_url).word());
                    var10_73 = new URLSpec(var9_55, var2_2.get(Attn.$src).word());
                    var8_40 = var10_73.toString();
                    ** GOTO lbl343
                }
                catch (MalformedURLException var9_56) {
                    this.session.warning("failed to create an URL from '" + var2_2.get(Attn.$image_base_url).word() + "' and '" + var2_2.get(Attn.$src).word() + ": " + var9_56);
                    break;
                }
lbl342:
                // 1 sources

                var8_40 = var2_2.get(Attn.$rich_media_resource_content).word();
lbl343:
                // 2 sources

                this.rmo.rmoResources.put(var7_21, var8_40);
                break;
lbl346:
                // 1 sources

                this.session.error("rx:media-resource not inside of rx:rich-media-object");
                break;
            }
            case 113: {
                var7_22 = new Item.PDFFormField(var2_2, this.session);
                var7_22.fieldno = ++this.session.lastPDFFormFieldNo;
                var8_41 = this.session.PDFFormFieldHolders;
                if (!var8_41.isEmpty()) {
                    var9_57 = var8_41.peek();
                    if (var9_57 instanceof Item.Inline) {
                        var10_74 = (Item.Inline)var9_57;
                        var10_74.pdfformfield = var7_22;
                        break;
                    }
                    if (var9_57 instanceof Item.Frame) {
                        var10_75 = (Item.Frame)var9_57;
                        var10_75.pdfformfield = var7_22;
                        break;
                    }
                    this.session.error("Not an Inline or Frame on session.PDFFormFieldHolders:" + var9_57.getClass().getName());
                    break;
                }
                this.session.error("'rx:pdf-form-field' must be a direct child of 'fo:inline' or 'fo:block-container'.");
                break;
            }
            case 114: {
                var7_23 = new Item.PDFFormFieldText(var2_2, this.session);
                var8_42 = this.session.PDFFormFieldHolders;
                if (!var8_42.isEmpty()) {
                    var9_58 = var8_42.peek();
                    if (var9_58 instanceof Item.Inline) {
                        var10_76 = (Item.Inline)var9_58;
                        if (var10_76.pdfformfield != null) {
                            var10_76.pdfformfield.content.snoc(var7_23);
                            break;
                        }
                        this.session.error("'rx:pdf-form-field-text' must be a direct child of 'rx:pdf-form-field'.");
                        break;
                    }
                    if (var9_58 instanceof Item.Frame) {
                        var10_77 = (Item.Frame)var9_58;
                        if (var10_77.pdfformfield != null) {
                            var10_77.pdfformfield.content.snoc(var7_23);
                            break;
                        }
                        this.session.error("'rx:pdf-form-field-text' must be a direct child of 'rx:pdf-form-field'.");
                        break;
                    }
                    this.session.error("Not an Inline or Frame on session.PDFFormFieldHolders:" + var9_58.getClass().getName());
                    break;
                }
                this.session.error("'rx:pdf-form-field' must be a direct child of 'fo:inline' or 'fo:block-container'.");
                break;
            }
            case 115: {
                var7_24 = new Item.PDFFormFieldRadio(var2_2, this.session);
                var8_43 = this.session.PDFFormFieldHolders;
                if (!var8_43.isEmpty()) {
                    var9_59 = var8_43.peek();
                    if (var9_59 instanceof Item.Inline) {
                        var10_78 = (Item.Inline)var9_59;
                        if (var10_78.pdfformfield != null) {
                            var10_78.pdfformfield.content.snoc(var7_24);
                            break;
                        }
                        this.session.error("'rx:pdf-form-field-radio-button' must be a direct child of 'rx:pdf-form-field'.");
                        break;
                    }
                    if (var9_59 instanceof Item.Frame) {
                        var10_79 = (Item.Frame)var9_59;
                        if (var10_79.pdfformfield != null) {
                            var10_79.pdfformfield.content.snoc(var7_24);
                            break;
                        }
                        this.session.error("'rx:pdf-form-field-radio-button' must be a direct child of 'rx:pdf-form-field'.");
                        break;
                    }
                    this.session.error("Not an Inline or Frame on session.PDFFormFieldHolders:" + var9_59.getClass().getName());
                    break;
                }
                this.session.error("'rx:pdf-form-field' must be a direct child of 'fo:inline' or 'fo:block-container'.");
                break;
            }
            case 116: {
                var7_25 = new Item.PDFFormFieldCheckbox(var2_2, this.session);
                var8_44 = this.session.PDFFormFieldHolders;
                if (!var8_44.isEmpty()) {
                    var9_60 = var8_44.peek();
                    if (var9_60 instanceof Item.Inline) {
                        var10_80 = (Item.Inline)var9_60;
                        if (var10_80.pdfformfield != null) {
                            var10_80.pdfformfield.content.snoc(var7_25);
                            break;
                        }
                        this.session.error("'rx:pdf-form-field-checkbox' must be a direct child of 'rx:pdf-form-field'.");
                        break;
                    }
                    if (var9_60 instanceof Item.Frame) {
                        var10_81 = (Item.Frame)var9_60;
                        if (var10_81.pdfformfield != null) {
                            var10_81.pdfformfield.content.snoc(var7_25);
                            break;
                        }
                        this.session.error("'rx:pdf-form-field-checkbox' must be a direct child of 'rx:pdf-form-field'.");
                        break;
                    }
                    this.session.error("Not an Inline or Frame on session.PDFFormFieldHolders:" + var9_60.getClass().getName());
                    break;
                }
                this.session.error("'rx:pdf-form-field' must be a direct child of 'fo:inline' or 'fo:block-container'.");
                break;
            }
            case 117: {
                var7_26 = new Item.PDFFormFieldListbox(var2_2, this.session);
                var8_45 = this.session.PDFFormFieldHolders;
                if (!var8_45.isEmpty()) {
                    var9_61 = var8_45.peek();
                    if (var9_61 instanceof Item.Inline) {
                        var10_82 = (Item.Inline)var9_61;
                        if (var10_82.pdfformfield != null) {
                            var10_82.pdfformfield.content.snoc(var7_26);
                            break;
                        }
                        this.session.error("'rx:pdf-form-field-listbox' must be a direct child of 'rx:pdf-form-field'.");
                        break;
                    }
                    if (var9_61 instanceof Item.Frame) {
                        var10_83 = (Item.Frame)var9_61;
                        if (var10_83.pdfformfield != null) {
                            var10_83.pdfformfield.content.snoc(var7_26);
                            break;
                        }
                        this.session.error("'rx:pdf-form-field-listbox' must be a direct child of 'rx:pdf-form-field'.");
                        break;
                    }
                    this.session.error("Not an Inline or Frame on session.PDFFormFieldHolders:" + var9_61.getClass().getName());
                    break;
                }
                this.session.error("'rx:pdf-form-field' must be a direct child of 'fo:inline' or 'fo:block-container'.");
                break;
            }
            case 118: {
                var7_27 = new Item.PDFFormFieldCombobox(var2_2, this.session);
                var8_46 = this.session.PDFFormFieldHolders;
                if (!var8_46.isEmpty()) {
                    var9_62 = var8_46.peek();
                    if (var9_62 instanceof Item.Inline) {
                        var10_84 = (Item.Inline)var9_62;
                        if (var10_84.pdfformfield != null) {
                            var10_84.pdfformfield.content.snoc(var7_27);
                            break;
                        }
                        this.session.error("'rx:pdf-form-field-combobox' must be a direct child of 'rx:pdf-form-field'.");
                        break;
                    }
                    if (var9_62 instanceof Item.Frame) {
                        var10_85 = (Item.Frame)var9_62;
                        if (var10_85.pdfformfield != null) {
                            var10_85.pdfformfield.content.snoc(var7_27);
                            break;
                        }
                        this.session.error("'rx:pdf-form-field-combobox' must be a direct child of 'rx:pdf-form-field'.");
                        break;
                    }
                    this.session.error("Not an Inline or Frame on session.PDFFormFieldHolders:" + var9_62.getClass().getName());
                    break;
                }
                this.session.error("'rx:pdf-form-field' must be a direct child of 'fo:inline' or 'fo:block-container'.");
                break;
            }
            case 119: {
                var7_28 = new Item.PDFFormFieldReset(var2_2, this.session);
                var8_47 = this.session.PDFFormFieldHolders;
                if (!var8_47.isEmpty()) {
                    var9_63 = var8_47.peek();
                    if (var9_63 instanceof Item.Inline) {
                        var10_86 = (Item.Inline)var9_63;
                        if (var10_86.pdfformfield != null) {
                            var10_86.pdfformfield.content.snoc(var7_28);
                            break;
                        }
                        this.session.error("'rx:pdf-form-field-reset' must be a direct child of 'rx:pdf-form-field'.");
                        break;
                    }
                    if (var9_63 instanceof Item.Frame) {
                        var10_87 = (Item.Frame)var9_63;
                        if (var10_87.pdfformfield != null) {
                            var10_87.pdfformfield.content.snoc(var7_28);
                            break;
                        }
                        this.session.error("'rx:pdf-form-field-reset' must be a direct child of 'rx:pdf-form-field'.");
                        break;
                    }
                    this.session.error("Not an Inline or Frame on session.PDFFormFieldHolders:" + var9_63.getClass().getName());
                    break;
                }
                this.session.error("'rx:pdf-form-field' must be a direct child of 'fo:inline' or 'fo:block-container'.");
                break;
            }
            case 120: {
                var7_29 = new Item.PDFFormFieldSubmit(var2_2, this.session);
                var8_48 = this.session.PDFFormFieldHolders;
                if (!var8_48.isEmpty()) {
                    var9_64 = var8_48.peek();
                    if (var9_64 instanceof Item.Inline) {
                        var10_88 = (Item.Inline)var9_64;
                        if (var10_88.pdfformfield != null) {
                            var10_88.pdfformfield.content.snoc(var7_29);
                            break;
                        }
                        this.session.error("'rx:pdf-form-field-submit' must be a direct child of 'rx:pdf-form-field'.");
                        break;
                    }
                    if (var9_64 instanceof Item.Frame) {
                        var10_89 = (Item.Frame)var9_64;
                        if (var10_89.pdfformfield != null) {
                            var10_89.pdfformfield.content.snoc(var7_29);
                            break;
                        }
                        this.session.error("'rx:pdf-form-field-submit' must be a direct child of 'rx:pdf-form-field'.");
                        break;
                    }
                    this.session.error("Not an Inline or Frame on session.PDFFormFieldHolders:" + var9_64.getClass().getName());
                    break;
                }
                this.session.error("'rx:pdf-form-field' must be a direct child of 'fo:inline' or 'fo:block-container'.");
                break;
            }
            case 121: {
                var7_30 = new Item.PDFFormFieldOption(var2_2, this.session);
                var8_49 = this.session.PDFFormFieldHolders;
                if (!var8_49.isEmpty()) {
                    var9_65 = var8_49.peek();
                    if (var9_65 instanceof Item.Inline) {
                        var10_90 = (Item.Inline)var9_65;
                        if (var10_90.pdfformfield != null) {
                            ((Item.PDFFormField)var10_90.pdfformfield.content.car()).content.snoc(var7_30);
                            break;
                        }
                        this.session.error("'rx:pdf-form-field-option' must be a direct child of a direct child of 'rx:pdf-form-field'.");
                        break;
                    }
                    if (var9_65 instanceof Item.Frame) {
                        var10_91 = (Item.Frame)var9_65;
                        if (var10_91.pdfformfield != null) {
                            ((Item.PDFFormField)var10_91.pdfformfield.content.car()).content.snoc(var7_30);
                            break;
                        }
                        this.session.error("'rx:pdf-form-field-option' must be a direct child of a direct child of 'rx:pdf-form-field'.");
                        break;
                    }
                    this.session.error("Not an Inline or Frame on session.PDFFormFieldHolders:" + var9_65.getClass().getName());
                    break;
                }
                this.session.error("'rx:pdf-form-field' must be a direct child of 'fo:inline' or 'fo:block-container'.");
                break;
            }
            case 127: {
                var7_31 = new Item.Span(var2_2, this.session);
                var8_50 = new Item.PDFComment(var2_2, this.session);
                var8_50.span = var7_31;
                this.pdfc = var8_50;
                var8_50.span = var7_31;
                this.startSpan(var7_31);
                this.setPhraseBreak(var8_50);
                this.tokenizer.a = 0;
                this.endSpan();
                break;
            }
            case 128: {
                if (this.pdfc != null) {
                    this.pdfc.sticky_note = new Item.PDFComment.StickyNote(this.pdfc);
                    if (var2_2.containsKey(Attn.$open)) {
                        this.pdfc.sticky_note.open = var2_2.get(Attn.$open).bool();
                    }
                    if (!var2_2.containsKey(Attn.$icon_type)) break;
                    this.pdfc.sticky_note.icon_type = this.pdfc.getIconName(var2_2.get(Attn.$icon_type).word());
                    break;
                }
                this.session.error("rx:pdf-sticky-note not inside of an rx:pdf-comment");
                break;
            }
            case 129: {
                if (this.pdfc != null) {
                    this.pdfc.file_attachment = new Item.PDFComment.FileAttachment(this.pdfc);
                    if (var2_2.containsKey(Attn.$icon_type)) {
                        this.pdfc.file_attachment.icon_type = this.pdfc.getIconName(var2_2.get(Attn.$icon_type).word());
                    }
                    this.pdfc.file_attachment.filename = var2_2.get(Attn.$filename).word();
                    if (!var2_2.containsKey(Attn.$src) || !var2_2.containsKey(Attn.$image_base_url)) break;
                    try {
                        var9_66 = new URLSpec(var2_2.get(Attn.$image_base_url).word());
                        var10_92 = new URLSpec(var9_66, var2_2.get(Attn.$src).word());
                        this.pdfc.file_attachment.file = var10_92.toString();
                    }
                    catch (MalformedURLException var9_67) {
                        this.session.warning("failed to create an URL from '" + var2_2.get(Attn.$image_base_url).word() + "' and '" + var2_2.get(Attn.$src).word() + ": " + var9_67);
                    }
                    break;
                }
                this.session.error("rx:pdf-file-attachment not inside of an rx:pdf-comment");
                break;
            }
            case 23: 
            case 26: {
                this.pushContext(new Context(new Flow(), this.context.blocks, this.context.spans));
                break;
            }
            default: {
                throw new CompilerException("Invalid element " + Elem.getName(var1_1));
            }
        }
        if (var2_2.containsKey(Attn.$id)) {
            this.pushId(var2_2);
        }
        if (var2_2.containsKey(Attn.$key)) {
            this.pushKey(var2_2);
        }
    }

    public void endElement(short s) throws CompilerException {
        if (this.id.desc_count == 0) {
            this.popId();
        }
        switch (s) {
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 0: {
                break;
            }
            case 20: {
                this.endBlock();
                break;
            }
            case 21: {
                boolean bl;
                boolean bl2 = bl = this.b.get(Attn.$absolute_position) != Attr.auto;
                if (bl) {
                    this.fakeChangeBars(Item.ChangeBar.FEND, "before end of absolute or fixed container");
                }
                this.endBlock();
                if (bl) {
                    this.fakeChangeBars(Item.ChangeBar.FSTART, "after end of absolute or fixed container");
                }
                this.session.PDFFormFieldHolders.pop();
                break;
            }
            case 24: {
                break;
            }
            case 109: {
                break;
            }
            case 22: 
            case 27: {
                this.endSpan();
                this.session.PDFFormFieldHolders.pop();
                break;
            }
            case 48: {
                this.endSpan();
                break;
            }
            case 28: {
                this.endSpan();
                break;
            }
            case 29: {
                this.popContext();
                this.tokenizer.a = 0;
                this.endSpan();
                this.bow = true;
                break;
            }
            case 25: 
            case 122: 
            case 124: {
                if (s == 124) {
                    this.rmo = null;
                }
                this.bow = true;
                break;
            }
            case 46: {
                break;
            }
            case 47: {
                this.fakeChangeBars(Item.ChangeBar.FEND, "before end of footnote");
                this.endBlock();
                this.endExpt();
                this.fakeChangeBars(Item.ChangeBar.FSTART, "after end of footnote");
                break;
            }
            case 30: {
                this.endExpt();
                break;
            }
            case 31: {
                break;
            }
            case 201: {
                break;
            }
            case 108: 
            case 209: {
                this.endExpt();
                break;
            }
            case 110: 
            case 210: {
                break;
            }
            case 41: {
                this.flushEndChangeBars();
                this.list.context.gen(this.list, this.context.flow);
                this.lists.pop();
                this.list = this.lists.isEmpty() ? null : (Item.ListBlock)this.lists.peek();
                this.endBlock();
                this.vacuumMode = false;
                this.vacuumFlow = this.context.flow;
                this.flushStartChangeBars();
                break;
            }
            case 42: {
                this.popContext();
                this.endBlock();
                this.popContext();
                this.list.context.endRow();
                break;
            }
            case 43: 
            case 44: {
                this.endBlock();
                this.popContext();
                this.list.context.endCell();
                this.vacuumMode = true;
                break;
            }
            case 32: {
                Attr attr = this.b.get(Attn.$caption_side);
                if (attr == Attr.newWord("after") || attr == Attr.newWord("end")) {
                    Flow flow = (Flow)this.captions.pop();
                    this.context.flow.append(flow);
                }
                this.endBlock();
                break;
            }
            case 33: {
                this.endBlock();
                Attr attr = this.b.get(Attn.$caption_side);
                if (attr != Attr.newWord("after") && attr != Attr.newWord("end")) break;
                this.fakeChangeBars(Item.ChangeBar.FEND, "before end of table-caption");
                this.popContext();
                this.fakeChangeBars(Item.ChangeBar.FSTART, "after end of table-caption");
                break;
            }
            case 34: {
                this.flushEndChangeBars();
                this.table.context.gen(this.table, this.context.flow);
                this.tables.pop();
                this.table = this.tables.isEmpty() ? null : (Item.Table)this.tables.peek();
                this.endBlock();
                this.vacuumMode = false;
                this.vacuumFlow = this.context.flow;
                this.flushStartChangeBars();
                break;
            }
            case 35: {
                break;
            }
            case 36: {
                this.endRowgroup((short)0);
                break;
            }
            case 37: {
                this.endRowgroup((short)2);
                break;
            }
            case 38: {
                this.endRowgroup((short)1);
                break;
            }
            case 39: {
                this.table.context.endRow();
                break;
            }
            case 40: {
                if (((Item.Frame)this.b).mode == 1) {
                    this.endRotated();
                }
                this.popContext();
                this.endInner();
                this.endOuter();
                this.popContext();
                this.table.context.endCell();
                this.vacuumMode = true;
                break;
            }
            case 49: {
                break;
            }
            case 50: {
                this.popContext();
                break;
            }
            case 51: {
                this.endExpt();
                break;
            }
            case 45: {
                Attr attr = this.b.get(Attn.$float);
                if (attr != Attr.none) {
                    this.fakeChangeBars(Item.ChangeBar.FEND, "before end of float");
                }
                this.endBlock();
                if (attr != Attr.none) {
                    this.endExpt();
                }
                if (attr == Attr.none) break;
                this.fakeChangeBars(Item.ChangeBar.FSTART, "after end of float");
                break;
            }
            case 101: {
                this.endBlock();
                break;
            }
            case 107: {
                break;
            }
            case 111: 
            case 206: {
                break;
            }
            case 112: 
            case 207: {
                break;
            }
            case 202: 
            case 203: {
                break;
            }
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                break;
            }
            case 127: {
                if (s == 127) {
                    this.pdfc = null;
                }
                this.bow = true;
                break;
            }
            case 128: 
            case 129: {
                break;
            }
            case 125: 
            case 126: {
                break;
            }
            case 23: 
            case 26: {
                this.popContext();
                break;
            }
            default: {
                throw new CompilerException("Invalid element " + Elem.getName(s));
            }
        }
        --this.id.desc_count;
        if (this.key.desc_count == 0) {
            this.popKey();
        }
        --this.key.desc_count;
    }

    public void processingInstruction(String string, String string2) throws CompilerException {
        this.context.flow.append(new Item.PI(string, string2));
    }

    private static class InlineContext {
        short tokenizer_a;
        Item bos;
        boolean bow;

        InlineContext(short s, Item item, boolean bl) {
            this.tokenizer_a = s;
            this.bos = item;
            this.bow = bl;
        }
    }

    private static class Context {
        Flow flow;
        Stack blocks;
        Stack spans;

        Context() {
            this(new Flow(), new Stack(), new Stack());
        }

        Context(Flow flow) {
            this(flow, new Stack(), new Stack());
        }

        Context(Flow flow, Stack stack, Stack stack2) {
            this.flow = flow;
            this.blocks = stack;
            this.spans = stack2;
        }
    }
}

