/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.util;

import com.renderx.util.SeekableInput;
import java.io.IOException;

public class SeekableInputOffsetFilter
implements SeekableInput {
    private final SeekableInput in;
    private final long offset;

    public SeekableInputOffsetFilter(SeekableInput seekableInput, long l) throws IOException {
        seekableInput.seek(l);
        this.in = seekableInput;
        if (l > seekableInput.length()) {
            throw new IllegalArgumentException("Offset value is out of parent stream bounds");
        }
        this.offset = l;
    }

    public long length() throws IOException {
        return this.in.length() - this.offset;
    }

    public void seek(long l) throws IOException {
        this.in.seek(l + this.offset);
    }

    public long getFilePointer() throws IOException {
        return this.in.getFilePointer() - this.offset;
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.in.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    public void close() throws IOException {
        this.in.close();
    }

    public long readUnsignedInt() throws IOException {
        return this.in.readUnsignedInt();
    }

    public void readFully(byte[] byArray) throws IOException {
        this.in.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.in.readFully(byArray, n, n2);
    }

    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.in.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.in.readChar();
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public String readLine() throws IOException {
        return this.in.readLine();
    }

    public String readUTF() throws IOException {
        return this.in.readUTF();
    }
}

