/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.svg.css;

import com.renderx.svg.css.CSSParseException;
import com.renderx.svg.css.Lexer;
import com.renderx.util.DefaultErrorHandler;
import com.renderx.util.ErrorHandler;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;

public class Style
extends Hashtable {
    public static final String IMPORTANT = "important";
    private int current;
    private final Lexer lexer;

    public Style() {
        this.lexer = null;
    }

    public Style(Lexer lexer, ErrorHandler errorHandler) {
        this.lexer = lexer;
        this.current = this.lexer.getType();
        this.parse(errorHandler);
    }

    public Style(String string, ErrorHandler errorHandler) {
        this.lexer = new Lexer(string);
        this.current = this.lexer.nextIgnoreSpaces();
        this.parse(errorHandler);
    }

    public Enumeration properties() {
        return this.keys();
    }

    public String getValue(String string) {
        Expression expression = (Expression)this.get(string);
        return expression == null ? null : expression.toString();
    }

    public String getCleanValue(String string) {
        Expression expression = (Expression)this.get(string);
        return expression == null ? null : expression.value;
    }

    public boolean isImportant(String string) {
        Expression expression = (Expression)this.get(string);
        return expression == null ? false : expression.important;
    }

    private void parse(ErrorHandler errorHandler) {
        block7: while (true) {
            switch (this.current) {
                case 0: 
                case 2: {
                    return;
                }
                case 8: {
                    this.current = this.lexer.nextIgnoreSpaces();
                    continue block7;
                }
                case 20: {
                    break;
                }
                default: {
                    this.errorForward(new CSSParseException("Expected identifier"), errorHandler);
                    continue block7;
                }
            }
            String string = this.lexer.getStringValue();
            Expression expression = new Expression();
            try {
                this.current = this.lexer.nextIgnoreSpaces();
                if (this.current != 16) {
                    throw new CSSParseException("Expected symbol ':'");
                }
                this.current = this.lexer.nextIgnoreSpaces();
                if (this.current == -1) {
                    throw new CSSParseException("Expected expression");
                }
                expression.value = this.parseExpression();
                if (this.current == 23) {
                    this.current = this.lexer.nextIgnoreSpaces();
                    if (this.current == -1) {
                        throw new CSSParseException("Expected expression");
                    }
                    if (!this.lexer.getStringValue().equalsIgnoreCase(IMPORTANT)) {
                        throw new CSSParseException("Expected important symbol");
                    }
                    expression.important = true;
                    this.current = this.lexer.nextIgnoreSpaces();
                }
                if (this.current == 8 || this.current == 2 || this.current == 0) {
                    this.put(string, expression);
                    continue;
                }
                throw new CSSParseException("Expected end of expression");
            }
            catch (CSSParseException cSSParseException) {
                this.errorForward(cSSParseException, errorHandler);
                continue;
            }
            break;
        }
    }

    private String parseExpression() throws CSSParseException {
        StringBuffer stringBuffer = new StringBuffer(this.parseTerm());
        while (true) {
            boolean bl = false;
            if (this.current == 6 || this.current == 10) {
                bl = true;
                stringBuffer.append(this.lexer.getStringValue());
                this.current = this.lexer.nextIgnoreSpaces();
            }
            switch (this.current) {
                case 0: 
                case 2: 
                case 8: 
                case 23: {
                    if (bl) {
                        throw new CSSParseException("Unexpected end of expression");
                    }
                    return stringBuffer.toString();
                }
            }
            if (!bl) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.parseTerm());
        }
    }

    private String parseTerm() throws CSSParseException {
        String string = "";
        switch (this.current) {
            case 4: 
            case 5: {
                string = this.lexer.getStringValue();
                this.current = this.lexer.nextIgnoreSpaces();
            }
        }
        switch (this.current) {
            case 27: {
                string = string + this.lexer.getStringValue();
                this.current = this.lexer.nextToken();
                if (this.current != 51 && this.current != 20) {
                    throw new CSSParseException("Error in a hexcolor operand");
                }
                string = string + this.lexer.getStringValue();
                this.current = this.lexer.nextIgnoreSpaces();
                break;
            }
            case 19: 
            case 20: 
            case 51: {
                string = string + this.lexer.getStringValue();
                this.current = this.lexer.nextIgnoreSpaces();
                break;
            }
            case 52: {
                string = string + this.parseFunction();
                break;
            }
            default: {
                throw new CSSParseException("Error in an operand");
            }
        }
        return string;
    }

    private String parseFunction() throws CSSParseException {
        int n = 1;
        String string = this.lexer.getStringValue();
        while (n > 0) {
            switch (this.lexer.nextToken()) {
                case -1: 
                case 0: {
                    throw new CSSParseException("Error in a function");
                }
                case 17: 
                case 18: {
                    break;
                }
                case 15: {
                    --n;
                    string = string + this.lexer.getStringValue();
                    break;
                }
                case 14: {
                    ++n;
                }
                default: {
                    string = string + this.lexer.getStringValue();
                }
            }
        }
        this.current = this.lexer.nextIgnoreSpaces();
        return string;
    }

    private void errorForward(CSSParseException cSSParseException, ErrorHandler errorHandler) {
        int n = 1;
        while (true) {
            switch (this.current) {
                case 0: {
                    return;
                }
                case 8: {
                    if (n > 1) break;
                }
                case 2: {
                    if (--n == 0) {
                        return;
                    }
                }
                case -1: {
                    break;
                }
                case 1: {
                    ++n;
                }
            }
            this.current = this.lexer.nextIgnoreSpaces();
        }
    }

    public void merge(Style style) {
        if (style == null) {
            return;
        }
        Enumeration enumeration = style.properties();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Expression expression = (Expression)style.get(string);
            Expression expression2 = (Expression)this.get(string);
            if (expression2 != null && expression2.important && !expression.important) continue;
            this.put(string, expression);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        char[] cArray = new char[8192];
        int n = 0;
        block0: while (true) {
            InputStreamReader inputStreamReader;
            if ((n = (inputStreamReader = new InputStreamReader(System.in)).read(cArray)) < 0) {
                System.exit(0);
            }
            Style style = new Style(new String(cArray, 0, n), (ErrorHandler)new DefaultErrorHandler());
            Enumeration enumeration = style.properties();
            while (true) {
                if (!enumeration.hasMoreElements()) continue block0;
                String string = (String)enumeration.nextElement();
                String string2 = style.getValue(string);
                System.err.println(string + "=\"" + string2 + "\"");
            }
            break;
        }
    }

    static final class Expression {
        String value = null;
        boolean important = false;

        Expression() {
        }

        public String toString() {
            return this.value.toString() + (this.important ? " !important" : "");
        }
    }
}

