/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.crypto.Hex;
import com.renderx.crypto.MD5;
import com.renderx.crypto.RC4;
import com.renderx.crypto.RC4OutputStream;
import com.renderx.pdflib.PDFException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Random;

class Encryption {
    static byte[] ps = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    byte[] obuf = new byte[32];
    byte[] ubuf = new byte[32];
    byte[] ovalue = new byte[32];
    byte[] uvalue = new byte[32];
    byte[] basickey = new byte[32];
    byte[] currentkey = new byte[10];
    int pnumber = -64;
    byte[] pvalue = new byte[]{-64, -1, -1, -1};
    byte[] ID = null;

    public Encryption(String string, String string2, int n, String string3) {
        this.generateP(n);
        this.ID = Encryption.generateID(string3);
        this.generateOU(string2, string);
        this.basickey = this.genKeyStd(this.ubuf);
    }

    void generateP(int n) {
        this.pnumber = n;
        this.pvalue[0] = (byte)(n & 0xFF);
        this.pvalue[1] = (byte)(n >> 8 & 0xFF);
        this.pvalue[2] = (byte)(n >> 16 & 0xFF);
        this.pvalue[3] = (byte)(n >> 24 & 0xFF);
    }

    byte[] prepareStr(String string) {
        byte[] byArray = new byte[32];
        int n = string.length();
        int n2 = 0;
        if (n < 32) {
            n2 = 32 - n;
        } else {
            n = 32;
        }
        int n3 = 0;
        while (n3 < n) {
            byArray[n3] = (byte)string.charAt(n3);
            ++n3;
        }
        System.arraycopy(ps, 0, byArray, n, 32 - n);
        return byArray;
    }

    void generateOU(String string, String string2) {
        this.obuf = this.prepareStr(string);
        MD5 mD5 = new MD5();
        byte[] byArray = new byte[32];
        byte[] byArray2 = new byte[5];
        byArray = mD5.digest(this.obuf);
        System.arraycopy(byArray, 0, byArray2, 0, 5);
        this.ubuf = this.prepareStr(string2);
        this.ovalue = this.encrypt(byArray2, this.ubuf);
        this.generateU();
    }

    void generateU() {
        byte[] byArray = this.genKeyStd(this.ubuf);
        this.uvalue = this.encrypt(byArray, ps);
    }

    byte[] genKeyStd(byte[] byArray) {
        byte[] byArray2 = new byte[this.ubuf.length + this.ovalue.length + this.pvalue.length + this.ID.length];
        System.arraycopy(this.ubuf, 0, byArray2, 0, this.ubuf.length);
        System.arraycopy(this.ovalue, 0, byArray2, this.ubuf.length, this.ovalue.length);
        System.arraycopy(this.pvalue, 0, byArray2, this.ubuf.length + this.ovalue.length, this.pvalue.length);
        System.arraycopy(this.ID, 0, byArray2, this.ubuf.length + this.ovalue.length + this.pvalue.length, this.ID.length);
        MD5 mD5 = new MD5();
        byte[] byArray3 = mD5.digest(byArray2);
        byte[] byArray4 = new byte[5];
        System.arraycopy(byArray3, 0, byArray4, 0, 5);
        return byArray4;
    }

    void generateCurrentKey(int n) {
        byte[] byArray = new byte[10];
        System.arraycopy(this.basickey, 0, byArray, 0, 5);
        byte[] byArray2 = new byte[4];
        byArray[5] = (byte)(n & 0xFF);
        byArray[6] = (byte)(n >> 8 & 0xFF);
        byArray[7] = (byte)(n >> 16 & 0xFF);
        byArray[8] = 0;
        byArray[9] = 0;
        MD5 mD5 = new MD5();
        System.arraycopy(mD5.digest(byArray), 0, this.currentkey, 0, 10);
    }

    OutputStream getCipherOutputStream(OutputStream outputStream) {
        try {
            return new RC4OutputStream(outputStream, this.currentkey);
        }
        catch (Exception exception) {
            throw new PDFException(exception);
        }
    }

    byte[] encrypt(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = null;
        try {
            RC4 rC4 = new RC4(byArray);
            byArray3 = rC4.crypt(byArray2);
        }
        catch (Exception exception) {
            throw new PDFException(exception);
        }
        return byArray3;
    }

    byte[] encryptArray(byte[] byArray) {
        return this.encrypt(this.currentkey, byArray);
    }

    byte[] encryptStr(String string) {
        int n = string.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)string.charAt(n2);
            ++n2;
        }
        byte[] byArray2 = this.encrypt(this.currentkey, byArray);
        return byArray2;
    }

    public static void main(String[] stringArray) {
    }

    public static byte[] generateID(String string) {
        MD5 mD5 = new MD5();
        String string2 = new Date().toString() + string + new Random().nextFloat();
        int n = string2.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)string2.charAt(n2);
            ++n2;
        }
        return mD5.digest(byArray);
    }

    public String IDtoStr() {
        return Hex.toString(this.ID);
    }

    static void print_array(String string, byte[] byArray) {
        System.out.println("--- " + string + " ---");
        System.out.println(Hex.toString(byArray));
    }
}

