/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts;

import com.renderx.fonts.CharMetrics;
import com.renderx.fonts.Diacritics;
import com.renderx.fonts.Encoding;
import com.renderx.fonts.FontFileFormatError;
import com.renderx.fonts.GlyphList;
import com.renderx.fonts.KernVector;
import com.renderx.fonts.Metric;
import com.renderx.util.Hashtable;
import com.renderx.util.LineEnumerator;
import com.renderx.util.UnicodeTable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class AFMMetric
extends Metric {
    private static final Hashtable KP = new Hashtable();
    private static final Hashtable K = new Hashtable();
    private static final Hashtable KW = new Hashtable();
    private static final short KP_ = 0;
    private static final short KP_H = 1;
    private static final short KP_X = 2;
    private static final short KP_Y = 3;
    private static final short K_C = 0;
    private static final short K_CH = 1;
    private static final short K_WX = 2;
    private static final short K_W0X = 3;
    private static final short K_W1X = 4;
    private static final short K_WY = 5;
    private static final short K_W0Y = 6;
    private static final short K_W1Y = 7;
    private static final short K_W = 8;
    private static final short K_W0 = 9;
    private static final short K_W1 = 10;
    private static final short K_VV = 11;
    private static final short K_N = 12;
    private static final short K_B = 13;
    private static final short K_L = 14;
    private static final short KW_FontName = 0;
    private static final short KW_FullName = 1;
    private static final short KW_FamilyName = 2;
    private static final short KW_Version = 3;
    private static final short KW_Notice = 4;
    private static final short KW_CharacterSet = 5;
    private static final short KW_EncodingScheme = 6;
    private static final short KW_Weight = 7;
    private static final short KW_ItalicAngle = 8;
    private static final short KW_UnderlinePosition = 9;
    private static final short KW_UnderlineThickness = 10;
    private static final short KW_CapHeight = 11;
    private static final short KW_XHeight = 12;
    private static final short KW_Ascender = 13;
    private static final short KW_Descender = 14;
    private static final short KW_CharWidth = 15;
    private static final short KW_StdHW = 16;
    private static final short KW_StdVW = 17;
    private static final short KW_FontBBox = 18;
    private static final short KW_IsFixedPitch = 19;
    private static final short KW_IsCIDFont = 20;
    private static final short KW_StartCharMetrics = 21;
    private static final short KW_StartKernPairs = 22;
    private static final short KW_StartTrackKern = 23;
    private static final short KW_EndFontMetrics = 24;
    public String encodingScheme = "";
    public String characterSet = "";
    public Encoding builtinEncoding = new Encoding();

    public AFMMetric(InputStream inputStream) throws IOException, FontFileFormatError {
        this(inputStream, GlyphList.dflt);
    }

    /*
     * Enabled aggressive block sorting
     */
    public AFMMetric(InputStream inputStream, GlyphList glyphList) throws IOException, FontFileFormatError {
        int n = 0;
        while (n < 256) {
            this.builtinEncoding.assignCode('\u0000', null);
            ++n;
        }
        LineEnumerator lineEnumerator = new LineEnumerator(inputStream);
        block27: while (lineEnumerator.hasMoreLines()) {
            Object object;
            String string = lineEnumerator.nextLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreTokens() || !((object = KW.get(stringTokenizer.nextToken().trim())) instanceof Short)) continue;
            switch ((Short)object) {
                case 0: {
                    this.fontName = AFMMetric.parseName(string);
                    break;
                }
                case 1: {
                    this.fullName = AFMMetric.parseName(string);
                    break;
                }
                case 2: {
                    this.family = AFMMetric.parseName(string);
                    break;
                }
                case 3: {
                    this.version = AFMMetric.parseName(string);
                    break;
                }
                case 4: {
                    this.notice = AFMMetric.parseName(string);
                    break;
                }
                case 5: {
                    this.characterSet = AFMMetric.parseName(string);
                    break;
                }
                case 6: {
                    this.encodingScheme = AFMMetric.parseName(string);
                    break;
                }
                case 7: {
                    this.weight = AFMMetric.parseName(string);
                    break;
                }
                case 8: {
                    this.italicAngle = AFMMetric.parseFloat(stringTokenizer.nextToken());
                    break;
                }
                case 9: {
                    this.underlinePosition = AFMMetric.parseFloat(stringTokenizer.nextToken());
                    break;
                }
                case 10: {
                    this.underlineThickness = AFMMetric.parseFloat(stringTokenizer.nextToken());
                    break;
                }
                case 11: {
                    this.capHeight = AFMMetric.parseFloat(stringTokenizer.nextToken());
                    break;
                }
                case 12: {
                    this.xHeight = AFMMetric.parseFloat(stringTokenizer.nextToken());
                    break;
                }
                case 13: {
                    this.ascender = AFMMetric.parseFloat(stringTokenizer.nextToken());
                    break;
                }
                case 14: {
                    this.descender = AFMMetric.parseFloat(stringTokenizer.nextToken());
                    break;
                }
                case 16: {
                    this.stdHW = AFMMetric.parseFloat(stringTokenizer.nextToken());
                    break;
                }
                case 17: {
                    this.stdVW = AFMMetric.parseFloat(stringTokenizer.nextToken());
                    break;
                }
                case 18: {
                    this.fontBBox = AFMMetric.parseFloatArray(stringTokenizer, 4);
                    break;
                }
                case 19: {
                    this.isFixedPitch = "true".equals(stringTokenizer.nextToken());
                    break;
                }
                case 20: {
                    this.isCIDFont = "true".equals(stringTokenizer.nextToken());
                    break;
                }
                case 15: {
                    this.wx = AFMMetric.parseFloat(stringTokenizer.nextToken());
                    this.wy = AFMMetric.parseFloat(stringTokenizer.nextToken());
                    this.isFixedPitch = true;
                    break;
                }
                case 21: {
                    this.readCharMetrics(lineEnumerator, glyphList);
                    break;
                }
                case 22: {
                    this.readKernPairs(lineEnumerator, glyphList);
                    break;
                }
                case 24: {
                    break block27;
                }
            }
        }
        this.checkData();
    }

    private static final String parseName(String string) throws FontFileFormatError {
        int n = string.indexOf(" ");
        if (n == -1) {
            n = string.indexOf("\t");
        }
        if (n == -1) {
            throw new FontFileFormatError("Expect at least two tokens of the line");
        }
        return string.substring(n + 1).trim();
    }

    private static final int parseHexInt(String string) throws FontFileFormatError {
        if (!string.startsWith("<") && !string.endsWith(">")) {
            throw new FontFileFormatError("Expected a hex number in angle brackets");
        }
        return Integer.parseInt(string.substring(1, string.length() - 1), 16);
    }

    private static final float parseFloat(String string) throws NumberFormatException {
        return Float.valueOf(string).floatValue();
    }

    private static final float[] parseFloatArray(StringTokenizer stringTokenizer, int n) throws FontFileFormatError {
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < fArray.length) {
            if (!stringTokenizer.hasMoreTokens()) {
                throw new FontFileFormatError("Too few numbers in the array: expected " + n);
            }
            fArray[n2] = AFMMetric.parseFloat(stringTokenizer.nextToken());
            ++n2;
        }
        if (stringTokenizer.hasMoreTokens()) {
            throw new FontFileFormatError("Too many numbers in the array: expected " + n);
        }
        return fArray;
    }

    private void readCharMetrics(LineEnumerator lineEnumerator, GlyphList glyphList) throws IOException, FontFileFormatError {
        String string = null;
        while (!"EndCharMetrics".equals(string = lineEnumerator.nextLine().trim())) {
            Object object;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            if (!stringTokenizer.hasMoreTokens()) continue;
            CharMetrics charMetrics = new CharMetrics();
            while (stringTokenizer.hasMoreTokens()) {
                object = new StringTokenizer(stringTokenizer.nextToken().trim());
                Short s = (Short)K.get(((StringTokenizer)object).nextToken().trim());
                if (s == null) continue;
                switch (s) {
                    case 0: {
                        int n = Integer.parseInt(((StringTokenizer)object).nextToken());
                        if (n == -1) break;
                        charMetrics.c = n;
                        break;
                    }
                    case 1: {
                        int n = AFMMetric.parseHexInt(((StringTokenizer)object).nextToken());
                        if (n == -1) break;
                        charMetrics.c = n;
                        break;
                    }
                    case 2: 
                    case 3: {
                        charMetrics.wx = AFMMetric.parseFloat(((StringTokenizer)object).nextToken());
                        break;
                    }
                    case 4: {
                        float f = AFMMetric.parseFloat(((StringTokenizer)object).nextToken());
                        if (charMetrics.wx != Float.MIN_VALUE) break;
                        charMetrics.wx = f;
                        break;
                    }
                    case 5: 
                    case 6: {
                        charMetrics.wy = AFMMetric.parseFloat(((StringTokenizer)object).nextToken());
                        break;
                    }
                    case 7: {
                        float f = AFMMetric.parseFloat(((StringTokenizer)object).nextToken());
                        if (charMetrics.wy != Float.MIN_VALUE) break;
                        charMetrics.wy = f;
                        break;
                    }
                    case 8: 
                    case 9: {
                        float[] fArray = AFMMetric.parseFloatArray((StringTokenizer)object, 2);
                        charMetrics.wx = fArray[0];
                        charMetrics.wy = fArray[1];
                        break;
                    }
                    case 10: {
                        float[] fArray = AFMMetric.parseFloatArray((StringTokenizer)object, 2);
                        if (charMetrics.wx == Float.MIN_VALUE) {
                            charMetrics.wx = fArray[0];
                        }
                        if (charMetrics.wy != Float.MIN_VALUE) break;
                        charMetrics.wy = fArray[1];
                        break;
                    }
                    case 12: {
                        charMetrics.n = ((StringTokenizer)object).nextToken();
                        break;
                    }
                    case 13: {
                        charMetrics.b = AFMMetric.parseFloatArray((StringTokenizer)object, 4);
                        break;
                    }
                }
            }
            if (charMetrics.n == null) continue;
            ++this.numGlyphs;
            if (".notdef".equals(charMetrics.n) && this.missingGlyph == null) {
                this.missingGlyph = charMetrics;
            }
            if ((object = (Object)glyphList.getUnicodes(charMetrics.n)) != null) {
                charMetrics.uc = (char)object[0];
                int n = 0;
                while (n < ((Object)object).length) {
                    if (0 <= charMetrics.c && charMetrics.c < 256) {
                        this.uniTable.put((char)object[n], charMetrics);
                        if (charMetrics.c == 32 == (object[n] == 32)) {
                            this.builtinEncoding.uni2byte.put((char)object[n], new Integer(charMetrics.c));
                            this.builtinEncoding.table[charMetrics.c] = charMetrics;
                            this.builtinEncoding.byte2uni[charMetrics.c] = (char)object[n];
                        }
                    } else if (this.uniTable.get((char)object[n]) == null) {
                        this.uniTable.put((char)object[n], charMetrics);
                    }
                    ++n;
                }
            }
            if (charMetrics.wx == Float.MIN_VALUE) {
                charMetrics.wx = this.wx;
            }
            if (charMetrics.wy == Float.MIN_VALUE) {
                charMetrics.wy = this.wy;
            }
            if (Diacritics.diacritics[charMetrics.uc]) {
                charMetrics.wx = 0.0f;
            }
            if (charMetrics.b == null) {
                charMetrics.b = this.fontBBox;
                continue;
            }
            if (this.capHeight == Float.MIN_VALUE && charMetrics.uc == 'H') {
                this.capHeight = charMetrics.b[3];
            }
            if (this.xHeight != Float.MIN_VALUE || charMetrics.uc != 'x') continue;
            this.xHeight = charMetrics.b[3];
        }
    }

    private void readKernPairs(LineEnumerator lineEnumerator, GlyphList glyphList) throws IOException, FontFileFormatError {
        String string = null;
        while (!"EndKernPairs".equals(string = lineEnumerator.nextLine().trim())) {
            Short s;
            double d = 0.0;
            double d2 = 0.0;
            char[] cArray = null;
            char[] cArray2 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreTokens() || (s = (Short)KP.get(stringTokenizer.nextToken().trim())) == null || s == 1) continue;
            cArray = glyphList.getUnicodes(stringTokenizer.nextToken());
            cArray2 = glyphList.getUnicodes(stringTokenizer.nextToken());
            switch (s) {
                case 0: {
                    d = AFMMetric.parseFloat(stringTokenizer.nextToken());
                    d2 = AFMMetric.parseFloat(stringTokenizer.nextToken());
                    break;
                }
                case 2: {
                    d = AFMMetric.parseFloat(stringTokenizer.nextToken());
                    break;
                }
                case 3: {
                    d2 = AFMMetric.parseFloat(stringTokenizer.nextToken());
                }
            }
            if (cArray == null || cArray2 == null) continue;
            int n = 0;
            while (n < cArray.length) {
                CharMetrics charMetrics = this.ucm(cArray[n]);
                if (charMetrics != null) {
                    if (charMetrics.kernTable == null) {
                        charMetrics.kernTable = new UnicodeTable();
                    }
                    int n2 = 0;
                    while (n2 < cArray2.length) {
                        KernVector kernVector = new KernVector();
                        kernVector.X = d;
                        kernVector.Y = d2;
                        charMetrics.kernTable.put(cArray2[n2], kernVector);
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    public void dump(PrintStream printStream) {
        super.dump(printStream);
        printStream.println("\nAFM-specific font data:");
        printStream.println("  Character set: " + this.characterSet);
        printStream.println("  Encoding scheme: " + this.encodingScheme);
        printStream.println("  Built-in encoding:");
        this.builtinEncoding.dump(printStream);
    }

    public static void main(String[] stringArray) throws Exception {
        GlyphList.init();
        switch (stringArray.length) {
            case 1: {
                new AFMMetric(new FileInputStream(stringArray[0])).dump(System.out);
                break;
            }
            case 2: {
                new AFMMetric(new FileInputStream(stringArray[0]), new GlyphList(new FileInputStream(stringArray[1]))).dump(System.out);
                break;
            }
            default: {
                System.err.println("Usage: java com.renderx.fonts.AFMMetric <AFM filename> [<glyph list file name>]");
            }
        }
    }

    static {
        KP.put("KP", new Short(0));
        KP.put("KPH", new Short(1));
        KP.put("KPX", new Short(2));
        KP.put("KPY", new Short(3));
        K.put("C", new Short(0));
        K.put("CH", new Short(1));
        K.put("WX", new Short(2));
        K.put("W0X", new Short(3));
        K.put("W1X", new Short(4));
        K.put("WY", new Short(5));
        K.put("W0Y", new Short(6));
        K.put("W1Y", new Short(7));
        K.put("W", new Short(8));
        K.put("W0", new Short(9));
        K.put("W1", new Short(10));
        K.put("VV", new Short(11));
        K.put("N", new Short(12));
        K.put("B", new Short(13));
        K.put("L", new Short(14));
        KW.put("FontName", new Short(0));
        KW.put("FullName", new Short(1));
        KW.put("FamilyName", new Short(2));
        KW.put("Version", new Short(3));
        KW.put("Notice", new Short(4));
        KW.put("CharacterSet", new Short(5));
        KW.put("EncodingScheme", new Short(6));
        KW.put("Weight", new Short(7));
        KW.put("ItalicAngle", new Short(8));
        KW.put("UnderlinePosition", new Short(9));
        KW.put("UnderlineThickness", new Short(10));
        KW.put("CapHeight", new Short(11));
        KW.put("XHeight", new Short(12));
        KW.put("Ascender", new Short(13));
        KW.put("Descender", new Short(14));
        KW.put("CharWidth", new Short(15));
        KW.put("StdHW", new Short(16));
        KW.put("StdVW", new Short(17));
        KW.put("FontBBox", new Short(18));
        KW.put("IsFixedPitch", new Short(19));
        KW.put("IsCIDFont", new Short(20));
        KW.put("StartCharMetrics", new Short(21));
        KW.put("StartKernPairs", new Short(22));
        KW.put("StartKernPairs0", new Short(22));
        KW.put("StartKernPairs1", new Short(22));
        KW.put("EndFontMetrics", new Short(24));
    }
}

