/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afpcommon.CodePage;
import com.renderx.afplib.AFP;
import com.renderx.afplib.AFPDocument;
import com.renderx.afplib.AFPInternalException;
import com.renderx.afplib.AffineTransform;
import com.renderx.afplib.ConfigManager;
import com.renderx.afplib.FontFactory;
import com.renderx.afplib.InvokeMediumMap;
import com.renderx.afplib.PageDecorator;
import com.renderx.afplib.Point2D;
import com.renderx.afplib.Tag;
import com.renderx.afplib.Util;
import com.renderx.afplib.XBarcode;
import com.renderx.afplib.XFont;
import com.renderx.afplib.XGraphic;
import com.renderx.afplib.XLine;
import com.renderx.afplib.XPolygon;
import com.renderx.afplib.XRect;
import com.renderx.afplib.XSvg;
import com.renderx.afplib.XTextDecoderSingleton;
import com.renderx.afplib.XTextPiece;
import com.renderx.afplib.XYObject;
import com.renderx.fonts.AFPMetric;
import com.renderx.fonts.Metric;
import com.renderx.graphics.Image;
import com.renderx.graphics.ImageFactory;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.svg.SVGImage;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.URLSpec;
import com.renderx.xep.lib.Session;
import com.renderx.xep.pre.Attr;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class XPage {
    private AFPDocument document;
    private Point2D size;
    private AffineTransform at = new AffineTransform();
    private int page_number;
    private String textCodePage;
    private ErrorHandler logger;
    protected Session session;
    private Map afpFonts;
    private Hashtable generatedFonts = new Hashtable();
    private int lastFontLocalID = 0;
    private XFont currentStyle;
    private ArrayList primitives = new ArrayList();
    private ArrayList decorators = new ArrayList();
    private ArrayList pageTags = new ArrayList();
    private int currentRotation = 0;
    private Point2D clipFrom = null;
    private Point2D clipTill = null;
    private XPolygon polygon = null;
    private AFP afp;
    private String AFPPageName;
    FontFactory fontFactory = null;
    private ConfigManager optionsManager;
    private ArrayList codePages;

    public boolean isPtocaLevelSupported(int n) {
        return n <= this.optionsManager.getPtocaLevels();
    }

    public boolean isGocaLevelSupported(int n) {
        return n <= this.optionsManager.getGocaLevels();
    }

    public boolean isBcocaLevelSupported(int n) {
        return n <= this.optionsManager.getBcocaLevels();
    }

    public XPage(AFPDocument aFPDocument, Attributes attributes, String string, Session session, ErrorHandler errorHandler, Map map, Map map2, ConfigManager configManager, ArrayList arrayList) {
        this(aFPDocument, string, session, errorHandler, map, map2, new Point2D(Util.parseLength(attributes.getValue("width")), Util.parseLength(attributes.getValue("height"))), Integer.parseInt(attributes.getValue("page-number")), attributes.getValue("page-id"), configManager, arrayList);
    }

    public XPage(AFPDocument aFPDocument, String string, Session session, ErrorHandler errorHandler, Map map, Map map2, Point2D point2D, int n, String string2, ConfigManager configManager, ArrayList arrayList) {
        this.codePages = arrayList;
        this.document = aFPDocument;
        this.afp = aFPDocument.afp;
        this.generatedFonts.clear();
        this.lastFontLocalID = 0;
        this.textCodePage = string;
        this.session = session;
        this.logger = errorHandler;
        this.afpFonts = map;
        this.size = point2D;
        this.page_number = n;
        this.optionsManager = configManager;
        this.AFPPageName = Util.name08("", String.valueOf(this.page_number));
        CodePage codePage = new CodePage("T1V10500", "Cp500", 0, 127, true);
        this.fontFactory = new FontFactory(this.generatedFonts, map, session, errorHandler, codePage, 0);
        this.initCurrentStyle(codePage);
    }

    private void initCurrentStyle(CodePage codePage) {
        this.afp.utf8TextDecoder = XTextDecoderSingleton.getInstance(this.codePages);
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", "family", "family", "Helvetica");
        attributesImpl.addAttribute("", "", "weight", "weight", "700");
        attributesImpl.addAttribute("", "", "style", "style", "normal");
        attributesImpl.addAttribute("", "", "variant", "variant", "normal");
        attributesImpl.addAttribute("", "", "size", "size", "14000");
        this.setTextStyle(attributesImpl, codePage);
    }

    public void begin() throws IOException {
        try {
            this.logger.info("pageBegin " + this.AFPPageName);
            if (this.size.isZeroAny()) {
                this.session.warning("Page dimensions are wrong: (" + this.size.toString() + ")");
            }
            this.processPageDecorators(true);
            this.afp.startAccumulation();
            this.afp.writeModcaSFNamed("BPG", this.AFPPageName);
            this.afp.writeAccumulatedLength(1);
            this.processPageDecorators(false);
            this.pageEnvironmentGroup();
            this.afp.processTags(this.pageTags);
        }
        catch (Exception exception) {
            this.logger.exception("Can't begin a page", exception);
        }
    }

    private void pageEnvironmentGroup() throws IOException, AFPInternalException {
        Point2D point2D = this.size.toAFPCoordinates();
        this.afp.startAccumulation();
        this.afp.writeModcaSFNamed("BAG", "AEG00001");
        this.afp.writeAccumulatedLength(1);
        this.processFonts();
        this.afp.writePageDescriptor(point2D);
        this.afp.writeModcaSF("PTD", 22);
        this.afp.writePageUnitBaseBytes();
        this.afp.writeResolutionBytes();
        this.afp.writeNBytes(point2D.x, 3);
        this.afp.writeNBytes(point2D.y, 3);
        this.afp.writeNBytes(0L, 2);
        this.afp.flush();
        this.afp.writeModcaSFNamed("EAG", "AEG00001");
    }

    public void end() throws IOException, AFPInternalException {
        this.afp.startAccumulation();
        this.afp.writeModcaSFNamed("EPG", this.AFPPageName);
        this.afp.writeAccumulatedLength(1);
    }

    public void render() {
        try {
            this.begin();
            this.processPrimitives();
            this.end();
        }
        catch (Exception exception) {
            this.logger.exception("Error on page " + this.page_number, exception);
        }
    }

    private final boolean isPtocaObject(Object object) {
        return !(object instanceof XGraphic) && !(object instanceof XSvg) && !(object instanceof XBarcode);
    }

    private void processPrimitives() throws IOException, AFPInternalException {
        XYObject xYObject = null;
        for (int i = 0; i < this.primitives.size(); ++i) {
            xYObject = (XYObject)this.primitives.get(i);
            if (this.isPtocaObject(xYObject)) {
                this.afp.ptoca.begin();
            } else {
                this.afp.ptoca.end();
            }
            try {
                int n;
                for (n = 0; n < 2; ++n) {
                    xYObject.writeToAFP(this.afp);
                    if (this.afp.ptoca.checkBuffer()) break;
                }
                if (n != 2) continue;
                throw new Exception("unable to restart PTOCA sequence");
            }
            catch (Exception exception) {
                this.logger.exception("Error on page " + this.page_number + " while processing primitive " + xYObject + ".", exception);
            }
        }
        if (this.isPtocaObject(xYObject)) {
            this.afp.ptoca.end();
        }
    }

    public void addText(Attributes attributes, Attr.Color color, int n, int n2) {
        int n3 = Util.parseLength(attributes.getValue("x"));
        int n4 = Util.parseLength(attributes.getValue("y"));
        this.addText(n3, n4, attributes.getValue("value"), Util.parseLength(attributes.getValue("width")), color, n, n2);
    }

    void addText(int n, int n2, String string, int n3, Attr.Color color, int n4, int n5) {
        Point2D point2D = this.toPageCoordinates(n, n2);
        this.reRotatePoint(point2D);
        XFont xFont = this.getCurrentStyleWithCharset(string);
        int n6 = 0;
        Metric metric = xFont.font.getMetric();
        if (metric != null && metric instanceof AFPMetric) {
            n6 = ((AFPMetric)metric).wordSpacing;
        } else {
            String[] stringArray = (String[])this.afpFonts.get(xFont.font.familyName);
            String string2 = stringArray.length >= 9 ? stringArray[8].trim() : "";
            double d = string2 == null || string2.length() == 0 ? 0.0 : Double.parseDouble(string2);
            n6 = XPage.calcWordSpacingValue(xFont, d, n5);
        }
        XTextPiece.generate(point2D.toAFPCoordinates(), string, n3, xFont, color, n4, n6, this.currentRotation, this.logger, this.primitives, this, this.optionsManager);
    }

    private static int calcWordSpacingValue(XFont xFont, double d, int n) {
        int n2 = (int)Math.round(d * (double)xFont.size / 1000.0) + n;
        int n3 = AFP.toAFPCoordinates(n2);
        return n3;
    }

    public void addGraphic(Attributes attributes, ImageFactory imageFactory, String string, boolean bl) throws IOException, ImageFormatException, UnregisteredMIMETypeException {
        try {
            float f = Float.parseFloat(attributes.getValue("scale-x"));
            float f2 = Float.parseFloat(attributes.getValue("scale-y"));
            if (f == 0.0f || f2 == 0.0f) {
                return;
            }
            Point2D point2D = new Point2D(Util.parseLength(attributes.getValue("x-from")), Util.parseLength(attributes.getValue("y-from")));
            Point2D point2D2 = new Point2D(Util.parseLength(attributes.getValue("width")), Util.parseLength(attributes.getValue("height")));
            String string2 = attributes.getValue("type");
            String string3 = attributes.getValue("src");
            String string4 = attributes.getValue("base");
            int n = string2.indexOf(59);
            String string5 = n == -1 ? string2 : string2.substring(0, n);
            this.addGraphic(imageFactory, string, bl, f, f2, point2D, point2D2, string5, string3, string4);
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.exception("Bad number in one of <image> attributes", numberFormatException);
        }
        catch (MalformedURLException malformedURLException) {
            this.logger.exception("Bad image or other object URL", malformedURLException);
        }
        catch (IOException iOException) {
            this.logger.exception("Failed to read image file", iOException);
        }
        catch (ImageFormatException imageFormatException) {
            this.logger.exception("Cannot parse image file", imageFormatException);
        }
        catch (UnregisteredMIMETypeException unregisteredMIMETypeException) {
            this.logger.error("Unknown MIME type: " + attributes.getValue("type"));
        }
    }

    private void addGraphic(ImageFactory imageFactory, String string, boolean bl, float f, float f2, Point2D point2D, Point2D point2D2, String string2, String string3, String string4) throws IOException, ImageFormatException, UnregisteredMIMETypeException, MalformedURLException {
        Point2D point2D3 = this.toPageCoordinates(point2D.x, point2D.y + point2D2.y).toAFPCoordinates();
        Image image = imageFactory.makeImage(new URLSpec(string4 == null ? null : new URLSpec(string4), string3), string2);
        String string5 = string;
        boolean bl2 = bl;
        if (!bl2 && this.optionsManager.isAllImagesToResource()) {
            bl2 = true;
            File file = new File(image.source.url.getFile());
            string5 = Util.name8(file.getName());
        }
        if (image instanceof SVGImage) {
            this.primitives.add(new XSvg(this, image, string3, string4, string2, point2D3, f, f2, point2D2.toAFPCoordinates(), this.currentRotation, this.clipFrom != null ? this.clipFrom.toAFPCoordinates() : null, this.clipTill != null ? this.clipTill.toAFPCoordinates() : null, this.logger, this.fontFactory, this.optionsManager));
        } else {
            this.primitives.add(new XGraphic(this.document, image, string3, string4, string2, point2D3, f, f2, point2D2.toAFPCoordinates(), this.currentRotation, this.clipFrom != null ? this.clipFrom.toAFPCoordinates() : null, this.clipTill != null ? this.clipTill.toAFPCoordinates() : null, string5, bl2, this.optionsManager, this.session, this));
        }
    }

    public void setRotation(Attributes attributes) {
        String string = attributes.getValue("phi");
        if (string == null) {
            return;
        }
        int n = Integer.parseInt(string.trim());
        this.currentRotation += n;
        this.currentRotation %= 360;
        this.at.rotate(Math.toRadians(n), 0.0, 0.0);
    }

    public void setClipOn(Attributes attributes) {
        int n = Util.parseLength(attributes.getValue("x-from"));
        int n2 = Util.parseLength(attributes.getValue("y-from"));
        int n3 = Util.parseLength(attributes.getValue("x-till"));
        int n4 = Util.parseLength(attributes.getValue("y-till"));
        Point2D point2D = this.toPageCoordinates(n, n2);
        Point2D point2D2 = this.toPageCoordinates(n3, n4);
        this.clipFrom = point2D;
        this.clipTill = point2D2;
    }

    public void setClipOff() {
        this.clipTill = null;
        this.clipFrom = null;
    }

    public void setTranslation(Attributes attributes) {
        float f = Float.parseFloat(attributes.getValue("x"));
        float f2 = Float.parseFloat(attributes.getValue("y"));
        this.at.translate(f, f2);
    }

    protected void resetTranslations() {
        this.at.setToIdentity();
    }

    public void addLine(Attributes attributes, Attr.Color color) {
        int n = Util.parseLength(attributes.getValue("x-from"));
        int n2 = Util.parseLength(attributes.getValue("y-from"));
        int n3 = Util.parseLength(attributes.getValue("x-till"));
        int n4 = Util.parseLength(attributes.getValue("y-till"));
        int n5 = Util.parseLength(attributes.getValue("thickness"));
        String string = Util.parseString(attributes.getValue("style"));
        this.addLine(n, n2, n3, n4, n5, string, color);
    }

    public void addLine(int n, int n2, int n3, int n4, int n5, String string, Attr.Color color) {
        Point2D point2D = this.toPageCoordinates(n, n2);
        Point2D point2D2 = this.toPageCoordinates(n3, n4);
        XLine[] xLineArray = XLine.generate(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), n5, string, color, 0, this.logger);
        for (int i = 0; i < xLineArray.length; ++i) {
            this.primitives.add(xLineArray[i]);
        }
    }

    public void addRectangle(Attributes attributes, Attr.Color color) {
        int n = Util.parseLength(attributes.getValue("x-from"));
        int n2 = Util.parseLength(attributes.getValue("y-from"));
        int n3 = Util.parseLength(attributes.getValue("x-till"));
        int n4 = Util.parseLength(attributes.getValue("y-till"));
        this.addRectangle(n, n2, n3, n4, color);
    }

    public void addRectangle(int n, int n2, int n3, int n4, Attr.Color color) {
        Point2D point2D = this.toPageCoordinates(n, n2);
        Point2D point2D2 = this.toPageCoordinates(n3, n4);
        int n5 = Math.min(point2D.getX(), point2D2.getX());
        int n6 = Math.min(point2D.getY(), point2D2.getY());
        int n7 = Math.max(point2D.getX(), point2D2.getX());
        int n8 = Math.max(point2D.getY(), point2D2.getY());
        int n9 = Math.abs(n7 - n5);
        int n10 = Math.abs(n8 - n6);
        this.reRotatePoint(point2D);
        this.primitives.add(new XRect(new Point2D(n5, n6), new Point2D(n9, n10), color, this.currentRotation));
    }

    public void addShadedRectangle(Attributes attributes, Attr.Color color) {
        int n = Util.parseLength(attributes.getValue("x-from"));
        int n2 = Util.parseLength(attributes.getValue("y-from"));
        int n3 = Util.parseLength(attributes.getValue("x-till"));
        int n4 = Util.parseLength(attributes.getValue("y-till"));
        Point2D point2D = this.toPageCoordinates(n, n2);
        Point2D point2D2 = this.toPageCoordinates(n3, n4);
        int n5 = AFP.toAFPCoordinates(Math.min(point2D.getX(), point2D2.getX()));
        int n6 = AFP.toAFPCoordinates(Math.min(point2D.getY(), point2D2.getY()));
        int n7 = AFP.toAFPCoordinates(Math.max(point2D.getX(), point2D2.getX()));
        int n8 = AFP.toAFPCoordinates(Math.max(point2D.getY(), point2D2.getY()));
        int n9 = Math.abs(n7 - n5);
        int n10 = Math.abs(n8 - n6);
        XGraphic xGraphic = new XGraphic(this, color, new Point2D(n5, n6), new Point2D(n9, n10), this.optionsManager, this.session);
        this.primitives.add(xGraphic);
    }

    public void setupPolygon(Attr.Color color, Attributes attributes) {
        int n = Util.parseLength(attributes.getValue("x-from"));
        int n2 = Util.parseLength(attributes.getValue("y-from"));
        Point2D point2D = this.toPageCoordinates(n, n2);
        this.polygon = new XPolygon(point2D, color, this.currentRotation);
    }

    public void addPoint(Attributes attributes) {
        int n = Util.parseLength(attributes.getValue("x-till"));
        int n2 = Util.parseLength(attributes.getValue("y-till"));
        Point2D point2D = this.toPageCoordinates(n, n2);
        this.polygon.addPoint(point2D);
    }

    public void addPolygon() {
        this.primitives.add(this.polygon);
        this.polygon = null;
    }

    public void addPageDecorator(PageDecorator pageDecorator) {
        this.decorators.add(pageDecorator);
    }

    public void addPageTag(Tag tag) {
        this.pageTags.add(tag);
    }

    public void addIMM(String string) {
        try {
            String[] stringArray = string.split("\\s+");
            String string2 = "";
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].trim().split("=", 2);
                stringArray2[1] = stringArray2[1].split("\"")[1];
                if (stringArray2[0].equals("name")) {
                    string2 = stringArray2[1].trim();
                    continue;
                }
                if (!stringArray2[0].equals("force")) continue;
                bl = Util.parseBoolean(stringArray2[1]);
            }
            this.addPageDecorator(new InvokeMediumMap(string2, bl));
        }
        catch (Exception exception) {
            this.logger.exception("Can't process <?xep-afp-invoke-medium-map " + string + " ?>.", exception);
        }
    }

    void processPageDecorators(boolean bl) throws IOException, AFPInternalException {
        for (int i = 0; i < this.decorators.size(); ++i) {
            PageDecorator pageDecorator = (PageDecorator)this.decorators.get(i);
            pageDecorator.writeToAfp(bl, this.afp);
        }
    }

    private void processFonts() {
        try {
            XFont xFont;
            Enumeration enumeration = this.generatedFonts.keys();
            int n = 1;
            while (enumeration.hasMoreElements()) {
                xFont = (XFont)enumeration.nextElement();
                if (xFont.isExternalCodedFont()) {
                    xFont.writeCodedFont(this.afp);
                }
                ++n;
            }
            enumeration = this.generatedFonts.keys();
            n = 1;
            while (enumeration.hasMoreElements()) {
                xFont = (XFont)enumeration.nextElement();
                if (!xFont.isExternalCodedFont()) {
                    xFont.writeCodedFont(this.afp);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.logger.exception("Can't process page fonts", exception);
        }
    }

    public XFont getCurrentStyle() {
        return this.currentStyle;
    }

    private XFont getCurrentStyleWithCharset(String string) {
        CodePage codePage = this.afp.utf8TextDecoder.getCodePage(string);
        return this.getCurrentStyleWithCharset(codePage);
    }

    public XFont getCurrentStyleWithCharset(CodePage codePage) {
        XFont xFont = this.currentStyle;
        this.afp.utf8TextDecoder = XTextDecoderSingleton.getInstance(this.codePages);
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", "family", "family", xFont.family);
        attributesImpl.addAttribute("", "", "weight", "weight", "" + xFont.weight);
        attributesImpl.addAttribute("", "", "style", "style", xFont.style);
        attributesImpl.addAttribute("", "", "variant", "variant", xFont.variant);
        attributesImpl.addAttribute("", "", "size", "size", "" + xFont.size);
        this.setTextStyle(attributesImpl, codePage);
        xFont = (XFont)this.currentStyle.clone();
        return xFont;
    }

    public void setTextStyle(Attributes attributes) {
        this.currentStyle = this.fontFactory.getXFont(attributes);
    }

    public void setTextStyle(Attributes attributes, CodePage codePage) {
        this.currentStyle = this.fontFactory.getXFont(attributes, codePage);
    }

    public final Point2D toPageCoordinates(int n, int n2) {
        Point2D point2D = new Point2D(n, n2);
        return this.toPageCoordinates(point2D);
    }

    private Point2D toPageCoordinates(Point2D point2D) {
        Point2D point2D2 = this.at.transform(point2D, null);
        point2D2.setLocation(point2D2.getX(), this.size.y - point2D2.getY());
        return point2D2;
    }

    private void reRotatePoint(Point2D point2D) {
        int n = 0;
        int n2 = 0;
        if (this.currentRotation == 0) {
            n = point2D.getX();
            n2 = point2D.getY();
        } else if (this.currentRotation == 90) {
            n = this.size.y - point2D.getY();
            n2 = point2D.getX();
        } else if (this.currentRotation == 180) {
            n = this.size.x - point2D.getX();
            n2 = this.size.y - point2D.getY();
        } else if (this.currentRotation == 270) {
            n = point2D.getY();
            n2 = this.size.x - point2D.getX();
        }
        point2D.setLocation(n, n2);
    }

    public void printTextStyles() {
        this.logger.info("Page text styles: ");
        Enumeration enumeration = this.generatedFonts.keys();
        while (enumeration.hasMoreElements()) {
            XFont xFont = (XFont)enumeration.nextElement();
            Object object = this.generatedFonts.get(xFont);
            this.logger.info(" [" + xFont + "] = " + object);
        }
    }

    public void setTextStyle(XFont xFont) {
        this.currentStyle = this.fontFactory.setTextStyle(xFont);
    }

    public AFPDocument getDocument() {
        return this.document;
    }

    public AFP getAFP() {
        return this.afp;
    }

    public void registerHighlightColor(Attr.Color.SpotColor spotColor) {
        try {
            this.afp.highlightColors.registerColor(spotColor, this.afp.errorHandler);
        }
        catch (AFPInternalException aFPInternalException) {
            this.logger.warning("Could not register Spot Color: " + spotColor.toString());
        }
    }

    public int getPrimitivesCount() {
        return this.primitives.size();
    }

    public ConfigManager getConfig() {
        return this.optionsManager;
    }
}

