/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afplib.AFP;
import com.renderx.afplib.AFPDocument;
import com.renderx.afplib.AFPInternalException;
import com.renderx.afplib.ConfigManager;
import com.renderx.afplib.Point2D;
import com.renderx.afplib.XImage;
import com.renderx.afplib.XPage;
import com.renderx.afplib.XYObject;
import com.renderx.afplib.orders.IocaOrders;
import com.renderx.afplib.orders.ModcaOrders;
import com.renderx.graphics.Image;
import com.renderx.graphics.ImageFormatException;
import com.renderx.xep.lib.Session;
import com.renderx.xep.pre.Attr;
import java.io.IOException;

public class XGraphic
extends XYObject {
    public static byte MO_POSITION = 0;
    public static byte MO_POSITION_AND_TRIM = (byte)16;
    public static byte MO_SCALE_TO_FIT = (byte)32;
    public static byte MO_CENTER_AND_TRIM = (byte)48;
    public static byte MO_POINT_TO_PELL = (byte)65;
    public static byte MO_POINT_TO_PELL_DOUBLE_DOT = (byte)66;
    public static byte MO_REPLICATE_AND_TRIM = (byte)80;
    public static byte MO_SCALE_TO_FILL = (byte)96;
    protected AFPDocument document;
    protected XPage page;
    public String src;
    public String xmlbase;
    public String mimeType;
    public float scale_x = 1.0f;
    public float scale_y = 1.0f;
    public Point2D size;
    public Point2D clipFrom = new Point2D(0, 0);
    public Point2D clipTill = new Point2D(0, 0);
    public byte mappingOption = MO_SCALE_TO_FIT;
    public String afpObjectToken = null;
    public boolean embedToResource = true;
    public Image image;
    private boolean isShadingPattern = false;
    private ConfigManager optionsManager;
    private IocaOrders iocaOrders;
    private ModcaOrders modcaOrders;

    public XGraphic(AFPDocument aFPDocument, Image image, String string, String string2, String string3, Point2D point2D, float f, float f2, Point2D point2D2, int n, Point2D point2D3, Point2D point2D4, String string4, boolean bl, ConfigManager configManager, Session session, XPage xPage) {
        super(point2D, n);
        this.document = aFPDocument;
        this.image = image;
        this.src = string;
        this.xmlbase = string2;
        this.isShadingPattern = false;
        this.mimeType = string3;
        this.scale_x = f;
        this.scale_y = f2;
        this.size = point2D2;
        this.clipFrom = point2D3;
        this.clipTill = point2D4;
        this.afpObjectToken = string4;
        this.embedToResource = bl;
        this.optionsManager = configManager;
        this.page = xPage;
        this.iocaOrders = new IocaOrders(this.page.getAFP(), session);
        this.modcaOrders = new ModcaOrders(this.page.getAFP(), session);
    }

    public XGraphic(XPage xPage, Attr.Color color, Point2D point2D, Point2D point2D2, ConfigManager configManager, Session session) {
        super(point2D, 0);
        this.page = xPage;
        this.document = xPage.getDocument();
        this.image = null;
        this.src = null;
        this.isShadingPattern = true;
        this.xmlbase = null;
        this.color = color;
        this.mimeType = "image/tiff";
        this.scale_x = 1.0f;
        this.scale_y = 1.0f;
        this.size = point2D2;
        this.afpObjectToken = null;
        this.embedToResource = false;
        this.optionsManager = configManager;
        this.iocaOrders = new IocaOrders(this.page.getAFP(), session);
        this.modcaOrders = new ModcaOrders(this.page.getAFP(), session);
    }

    public final boolean isShadingPattern() {
        return this.isShadingPattern;
    }

    public void writeObjectAreaSize(AFP aFP) throws ImageFormatException, IOException, AFPInternalException {
        aFP.writeTriplet_0x4C_ObjectAreaSize(this.size);
    }

    public void writeToAFP(AFP aFP) throws IOException {
        if (AFP.getMoDcaEmbeddableObjectType(this.mimeType) == null) {
            aFP.errorHandler.error("Can't process graphic object " + this.src + ". Object format " + this.mimeType + " is not supported.");
            return;
        }
        String string = "MO:DCA-P";
        try {
            if (this.document.isUsingResource() && this.afpObjectToken != null) {
                string = "MO:DCA-L";
                if (this.embedToResource) {
                    this.document.embedObjectToResources(this);
                }
                this.document.placeReferenceToResourceToAFPDS(this);
            } else if (this.scale_x != 0.0f && this.scale_y != 0.0f) {
                this.embedBileveledObjectToMoDcaPStream(aFP);
            }
        }
        catch (Exception exception) {
            aFP.errorHandler.exception("Error while processing graphic object " + this.src + ", object format " + this.mimeType + ". MO:DCA stream type is " + string + ".", exception);
        }
    }

    public final void embedBileveledObjectToMoDcaPStream(AFP aFP) throws IOException, ImageFormatException, AFPInternalException {
        XImage xImage = XImage.createImageProcessor(this, this.optionsManager);
        xImage.loadImage();
        if (this.isShadingPattern()) {
            this.mappingOption = xImage.graphic.mappingOption;
        }
        if (xImage.pixelSize.isZeroAny()) {
            return;
        }
        if (this.clipTill != null && this.clipFrom != null && (this.size.x <= xImage.pixelSize.x || this.size.y <= xImage.pixelSize.y)) {
            if (this.clipTill.x > 0 && this.origin.x + this.size.x > this.clipTill.x) {
                this.mappingOption = MO_POSITION_AND_TRIM;
                this.size.x = this.clipTill.x - this.origin.x;
            }
            if (this.clipFrom.y > 0 && this.origin.y + this.size.y > this.clipFrom.y) {
                this.mappingOption = MO_POSITION_AND_TRIM;
                this.size.y = this.clipFrom.y - this.origin.y;
            }
        }
        String string = aFP.genImageName(this.image);
        int n = 1;
        aFP.writeModcaSFNamed("BIM", string);
        aFP.writeModcaSFNamed("BOG", string);
        this.modcaOrders.writeSF_OBD(this.size);
        this.modcaOrders.writeSF_OBP(this.origin, n, this.rotation);
        this.modcaOrders.writeSF_MIO(this.mappingOption);
        this.modcaOrders.writeSF_IDD(xImage.pixelSize, xImage.resolution);
        this.iocaOrders.writeFunctionSetIdentification(10);
        aFP.writeModcaSF("EOG");
        aFP.writeNBytes(-281474976710656L, 8);
        aFP.writeModcaSF("IPD", 31 + xImage.getExtrasSize());
        aFP.writeIocaLSDF(112, 0);
        this.iocaOrders.writeBeginImageContent();
        this.iocaOrders.writeImageSize(xImage);
        this.iocaOrders.writeImageEncoding(xImage);
        aFP.writeIocaLSDF(150, 1);
        aFP.writeByte(xImage.getIDESize());
        xImage.writeExtras(aFP);
        xImage.writeImageData(aFP);
        aFP.writeModcaSF("IPD", 12);
        this.iocaOrders.writeEndImageContent();
        aFP.writeIocaLSDF(113, 0);
        aFP.flush();
        aFP.writeModcaSF("EIM");
        aFP.flush();
    }

    public XPage getPage() {
        return this.page;
    }

    public final void writeIPO(AFP aFP) throws IOException, AFPInternalException {
        aFP.writeSF_IPO(this.origin, this.afpObjectToken);
    }
}

