package com.renderx.xepx.x4u.ct;

import javax.swing.JPanel;

/**
 * <p>Description: UI for Common formatter options
 * <p>Usage: KernelPanel(Document doc)
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Zenteq.am</p>
 * @author not attributable
 * @version 1.0
 */

import javax.swing.*;
import java.awt.*;
import javax.swing.border.*;
import java.awt.event.*;
import org.w3c.dom.*;
import java.util.*;
import java.net.*;

public class KernelPanel extends JPanel{// implements ActionListener{
  Document doc;
  DOMWalker model;// = new DOMWalker(doc);
//  Element configElement;
  String currTextValue = "";
  GridBagLayout kernelGBLayout = new GridBagLayout();
  JFileChooser fc;
  JTextField licenseFileName = new JTextField("lisense.txt");
  JLabel licenseLabel = new JLabel("License:");
  JButton licenseBrowseButton = new JButton("Browse");
  JTextField tempFileName = new JTextField(/*"tmp"*/);
  JButton tmpBrowseButton = new JButton("Browse");
  JCheckBox tmpCheckBox = new JCheckBox("Use temp folder",false);
  JLabel baseDefaultLabel = new JLabel("Base path");
  JButton baseDefaultButton = new JButton("Change");
  JTextField baseDefaultName = new JTextField();
  JLabel lngDefaultLabel = new JLabel("Default language:");
  JLabel fntDefaultLabel = new JLabel("Default font family:");
	JCheckBox schemaCheckBox = new JCheckBox("Enable 'Folio'",false);
  JComboBox lngDefComboBox;
  JComboBox fntDefComboBox;

  void getValuesFromDOM(){
//    lngDefComboBox = new JComboBox(DOMWalker.getLanguages(doc));
    ArrayList l = new ArrayList( Arrays.asList(DOMWalker.getLanguages()));// new ArrayList(DOMWalker.allLanguages);
    l.add(FontsPanel.COMBO_VALUE[0].toString());
    lngDefComboBox = new JComboBox((String[]) l.toArray(new String[l.size()]));
    String slct = getAttribValue("languages","default-language");
    lngDefComboBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        defaultLng_actionPerformed(e);
     }
    });


    for (int i = 0; i < l.size(); i++) {
      if (slct.equalsIgnoreCase(l.get(i).toString())){
        lngDefComboBox.setSelectedItem(slct);
        break;
      }
    }
    l = new ArrayList( Arrays.asList(DOMWalker.getFonts()));//DOMWalker.allFontFamilies);
    l.add(FontsPanel.COMBO_VALUE[0].toString());
    fntDefComboBox = new JComboBox(l.toArray(new String[l.size()]));
    slct = getAttribValue("fonts","default-family");
    fntDefComboBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        defaultFnt_actionPerformed(e);
     }
    });

    for (int i = 0; i < l.size(); i++) {
      if (slct.equalsIgnoreCase(l.get(i).toString())){
        fntDefComboBox.setSelectedItem(slct);
        break;
      }
    }
    String tmp = DOMWalker.cnfRoot.getAttribute("xml:base");

    if(tmp != null && tmp.length() > 0)
      baseDefaultName.setText(DOMWalker.cnfRoot.getAttribute("xml:base"));
    else
      baseDefaultName.setText(DOMWalker.VAL_UNDEF);
    NodeList opt = doc.getDocumentElement().getChildNodes();
    String licValue = "license.txt";
    String tmpValue = null;
		boolean enable_folio = false;
    for (int i = 0; i < opt.getLength(); i++) {
      if(opt.item(i).getNodeName().equalsIgnoreCase("options")){
        NodeList lst = opt.item(i).getChildNodes();
        for (int j = 0; j < lst.getLength(); j++) {
          if(lst.item(j).getNodeName().equalsIgnoreCase("option")){
            String val = lst.item(j).getAttributes().getNamedItem("name").getNodeValue();
            if (val.equalsIgnoreCase("LICENSE"))
              licValue = lst.item(j).getAttributes().getNamedItem("value").getNodeValue();
            else if (val.equalsIgnoreCase("TMPDIR"))
              tmpValue = lst.item(j).getAttributes().getNamedItem("value").getNodeValue();
						else if (val.equalsIgnoreCase("ENABLE_FOLIO"))
							enable_folio = "true".equalsIgnoreCase(lst.item(j).getAttributes().getNamedItem("value").getNodeValue());
          }
        }
        break;
      }
    }
    licenseFileName.setText(licValue);
		schemaCheckBox.setSelected(enable_folio);
    if(tmpValue != null && !tmpValue.equalsIgnoreCase("none") && !tmpValue.equals("") ){
      tempFileName.setText(tmpValue);
      this.tmpCheckBox.setSelected(true);
      tempFileName.setEditable(true);
      tempFileName.setEnabled(true);
      this.tmpBrowseButton.setEnabled(true);
    }
  }

  String getAttribValue(String elName,String attr){
     String res = FontsPanel.COMBO_VALUE[0];
    NodeList nl = ((Element)this.doc.getDocumentElement()).getElementsByTagName(elName);
    if(nl.getLength() > 0 && nl.item(0).getAttributes().getNamedItem(attr) !=null)
      return nl.item(0).getAttributes().getNamedItem(attr).getNodeValue();
    return res;
  }

  public KernelPanel(Document doc){
    this.doc = doc;
    model = DOMWalker.getDOMWalker(doc);/////new DOMWalker(doc);
 //   configElement = (Element)doc.getElementsByTagName("config").item(0);
    tempFileName.setEnabled(false);
    tempFileName.setEditable(false);
    tmpBrowseButton.setEnabled(false);
    tempFileName.setName("tempFileName");
    tempFileName.addFocusListener(new java.awt.event.FocusAdapter() {
               public void focusLost(FocusEvent e) {
                 textField_focusLost(e);
               }
               public void focusGained(FocusEvent e) {
                 textField_focusGained(e);
               }
             });
    tmpBrowseButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        fileBrowse_actionPerformed(tempFileName,e,JFileChooser.DIRECTORIES_ONLY);
     }});

    tmpCheckBox.setHorizontalTextPosition(SwingConstants.LEADING);
    tmpCheckBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        tmpCheckBox_actionPerformed(e);
      }
    });
    schemaCheckBox.setHorizontalTextPosition(SwingConstants.LEADING);
    schemaCheckBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        schemaCheckBox_actionPerformed(e);
      }
    });
		
    getValuesFromDOM();
    baseDefaultName.setName("baseDefaultName");
    baseDefaultName.addFocusListener(new java.awt.event.FocusAdapter() {
               public void focusLost(FocusEvent e) {
                 textField_focusLost(e);
               }
               public void focusGained(FocusEvent e) {
                 textField_focusGained(e);
               }
             });

    this.setBorder(BorderFactory.createCompoundBorder(new EtchedBorder(EtchedBorder.RAISED,Color.white,new Color(148, 145, 140)),BorderFactory.createEmptyBorder(5,5,5,5)));
    baseDefaultButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        fileBrowse_actionPerformed(baseDefaultName,e,JFileChooser.DIRECTORIES_ONLY);
    }});
    licenseFileName.setName("licenseFileName");
    licenseFileName.addFocusListener(new java.awt.event.FocusAdapter() {
               public void focusLost(FocusEvent e) {
                 textField_focusLost(e);
               }
               public void focusGained(FocusEvent e) {
                 textField_focusGained(e);
               }
             });

    licenseBrowseButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        fileBrowse_actionPerformed(licenseFileName,e,JFileChooser.FILES_ONLY);
    }});

  this.setLayout(kernelGBLayout);
  this.add(baseDefaultButton,     new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
          ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(20, 5, 10, 5), 0, 0));
  this.add(baseDefaultName,      new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
          ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(20, 5, 10, 5), 0, 0));
  this.add(baseDefaultLabel,      new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
          ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(20, 12, 10, 5), 0, 0));
  this.add(lngDefaultLabel,      new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
          ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(20, 12, 10, 5), 0, 0));
  this.add(fntDefaultLabel,      new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
          ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(20, 12, 10, 5), 0, 0));
  this.add(tmpBrowseButton,         new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0
          ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(20, 11, 10, 10), 0, 0));
  this.add(tempFileName,         new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0
          ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(20, 5, 10, 5), 0, 0));
  this.add(tmpCheckBox,         new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
          ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(20, 10, 10, 5), 0, 0));
  this.add(schemaCheckBox,       new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0
          ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(20, 5, 10, 5), 0, 0));										
  this.add(licenseBrowseButton,      new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0
          ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(20, 5, 10, 10), 0, 0));
  this.add(licenseFileName,      new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0
          ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(20, 5, 10, 5), 0, 0));
  this.add(licenseLabel,     new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
          ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(20, 12, 10, 5), 0, 0));
  this.add(lngDefComboBox,        new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
          ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(20, 5, 10, 5), 0, 0));
  this.add(fntDefComboBox,     new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
          ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(20, 5, 10, 5), 0, 0));

  }

  void fileBrowse_actionPerformed(JTextField textFild, ActionEvent e, int mode) {
    fc = new JFileChooser();
    fc.setFileSelectionMode(mode);
//    Element nd = (Element)doc.getElementsByTagName("config").item(0);
    int returnVal = fc.showOpenDialog(this);
    if (returnVal == JFileChooser.APPROVE_OPTION) {
        if(textFild.getName().equalsIgnoreCase("baseDefaultName")){
          try {
          textFild.setText(fc.getSelectedFile().toURL().toExternalForm());
          DOMWalker.cnfRoot.setAttribute("xml:base",baseDefaultName.getText().trim());
        }
        catch (MalformedURLException ex) {
          textFild.setText("Invalid URL for xml:base. Value not defined");
        }
     }
     else if(textFild.getName().equalsIgnoreCase("licenseFileName") ||
               textFild.getName().equalsIgnoreCase("tempFileName")){
       textFild.setText(fc.getSelectedFile().getAbsolutePath());
       String attName = (textFild.getName().equalsIgnoreCase("licenseFileName"))?"LICENSE":"TMPDIR";
       model.setNameValueAttrs(model.cnfRoot.getElementsByTagName("options").item(0),
                               "option",attName,textFild.getText());
     }
    }
  }

  void tmpCheckBox_actionPerformed(ActionEvent e) {
    boolean state = tmpCheckBox.isSelected();
    tempFileName.setEnabled(state);
    tempFileName.setEditable(state);
    tmpBrowseButton.setEnabled(state);
    if(!state || tempFileName.getText().trim().equals("")) //model.removeNode(doc.getElementsByTagName("options").item(0),"option","name","TMPDIR");
    {
      Element options = (Element)doc.getElementsByTagName("options").item(0);
      model.setNameValueAttrs(options, "option", "TMPDIR", "none");
      tempFileName.setText("none");
    }

  }

  void textField_focusLost(FocusEvent e) {
    String cmd = ( (JTextField) e.getSource()).getName();
    String tmp;
    if(cmd.equalsIgnoreCase("baseDefaultName") && currTextValue != tempFileName.getText().trim()){
      tmp = baseDefaultName.getText().trim();
      if (tmp.length() == 0 || tmp.equalsIgnoreCase(DOMWalker.VAL_UNDEF)) {
        DOMWalker.cnfRoot.removeAttribute("xml:base");
        baseDefaultName.setText(DOMWalker.VAL_UNDEF);
      }
      else DOMWalker.cnfRoot.setAttribute("xml:base", tmp);
    }
    else{
      String attValue = null;
      String attName = null;
//      Node parent = model.optRoot;//doc.getElementsByTagName("options").item(0);
      if (cmd.equalsIgnoreCase("tempFileName") && currTextValue != tempFileName.getText().trim()) {
        attName  = "TMPDIR";
        attValue = tempFileName.getText().trim();
        if(attValue.equals("") || attValue.equalsIgnoreCase("none"))
        {
          attValue = "none";
          tempFileName.setText("none");
        }
      }
      else if(cmd.equalsIgnoreCase("licenseFileName") &&
              currTextValue != licenseFileName.getText().trim()){
        attName = "LICENSE";
        attValue = licenseFileName.getText().trim();
      }
      if(attName != null){
        if (attValue.length() == 0)
          model.removeNode(model.optRoot, "option", "name", attName);
        else
          model.setNameValueAttrs(model.optRoot,"option",attName,attValue);
      }
    }
  }

  void textField_focusGained(FocusEvent e) {
    currTextValue = ( (JTextField) e.getSource()).getText().trim();
  }

  void  defaultFnt_actionPerformed(ActionEvent e){
    model.fntRoot.setAttribute("default-family", this.fntDefComboBox.getSelectedItem().toString());
  }

  void  defaultLng_actionPerformed(ActionEvent e){
    model.lngRoot.setAttribute("default-language", this.lngDefComboBox.getSelectedItem().toString());
  }
  void schemaCheckBox_actionPerformed(ActionEvent e){
		Element options = (Element)doc.getElementsByTagName("options").item(0);
		model.setNameValueAttrs(options, "option", "ENABLE_FOLIO", ""+this.schemaCheckBox.isSelected());
  }
}
