/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.gen.backends;

import com.renderx.graphics.ImageFactory;
import com.renderx.pslib.PSDocument;
import com.renderx.pslib.Strings;
import com.renderx.util.Base32;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.URLSpec;
import com.renderx.xep.gen.H4base;
import com.renderx.xep.gen.backends.Stamp;
import com.renderx.xep.gen.backends.Sticker;
import com.renderx.xep.lib.InternalException;
import com.renderx.xep.lib.Session;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class H4PS
extends H4base {
    private static final short O_LANGUAGE_LEVEL = 0;
    private static final short O_UNICODE_ANNOTATIONS = 1;
    private static final short O_DROP_UNUSED_DESTINATIONS = 2;
    private static final short O_CLONE_EPS = 3;
    private static final short O_PAGE_DEVICE = 4;
    private static final short O_INITIAL_ZOOM = 5;
    private static final short O_VIEW_MODE = 6;
    private static final short O_CROP_OFFSET = 7;
    private static final short O_CROP_MARK_WIDTH = 8;
    private static final short O_BLEED = 9;
    private static final short O_BLEED_MARK_WIDTH = 10;
    private static final short O_PRINTER_MARK = 11;
    private static final short O_XEP_COMMENT = 12;
    private static final short O_PAGE_LABELING = 13;
    private static final short O_IMAGE_INLINE_THRESHOLD = 14;
    private static final Hashtable optab = new Hashtable();
    private PSDocument ps = null;
    private int LANGUAGE_LEVEL;
    private boolean UNICODE_ANNOTATIONS;
    private boolean DROP_UNUSED_DESTINATIONS;
    private boolean CLONE_EPS;
    private Hashtable PAGE_DEVICE = new Hashtable();
    private String ZOOM;
    private String VIEW_MODE;
    private Hashtable PAGE_BOUNDARIES = new Hashtable();
    private List PRINTER_MARKS = new List();
    private boolean needsAnnotation = false;
    private int IMAGE_INLINE_THRESHOLD;
    private int skip = 0;
    private int customcommentscount = 0;

    public H4PS(OutputStream outputStream, Session session, Properties properties) throws IOException {
        super(outputStream, session, properties);
    }

    protected void resetDefaultOptions() {
        this.LANGUAGE_LEVEL = 3;
        this.UNICODE_ANNOTATIONS = true;
        this.DROP_UNUSED_DESTINATIONS = true;
        this.CLONE_EPS = true;
        this.ZOOM = "auto";
        this.VIEW_MODE = "auto";
        this.PAGE_BOUNDARIES = new Hashtable();
        this.PRINTER_MARKS = new List();
        this.IMAGE_INLINE_THRESHOLD = 0;
    }

    protected void setOption(String string, String string2) {
        Object object = optab.get(string);
        if (object == null) {
            this.session.warning("Unrecognized PostScript option " + string + ": setting ignored");
            return;
        }
        switch ((Short)object) {
            case 0: {
                string2 = string2.trim();
                if ("2".equals(string2) || "3".equals(string2)) {
                    this.LANGUAGE_LEVEL = Integer.parseInt(string2);
                    break;
                }
                this.session.warning("Incorrect or unsupported LANGUAGE_LEVEL value: " + string2 + "; setting ignored");
                break;
            }
            case 1: {
                string2 = string2.trim().toLowerCase();
                if ("true".equals(string2) || "yes".equals(string2)) {
                    this.UNICODE_ANNOTATIONS = true;
                    break;
                }
                if ("false".equals(string2) || "no".equals(string2)) {
                    this.UNICODE_ANNOTATIONS = false;
                    break;
                }
                this.session.warning("Invalid UNICODE_ANNOTATIONS value: " + string2 + "; setting ignored");
                break;
            }
            case 2: {
                string2 = string2.trim().toLowerCase();
                if ("true".equals(string2) || "yes".equals(string2)) {
                    this.DROP_UNUSED_DESTINATIONS = true;
                    break;
                }
                if ("false".equals(string2) || "no".equals(string2)) {
                    this.DROP_UNUSED_DESTINATIONS = false;
                    break;
                }
                this.session.warning("Invalid value for DROP_UNUSED_DESTINATIONS: " + string2 + "; setting ignored");
                break;
            }
            case 3: {
                string2 = string2.trim().toLowerCase();
                if ("true".equals(string2) || "yes".equals(string2)) {
                    this.CLONE_EPS = true;
                    break;
                }
                if ("false".equals(string2) || "no".equals(string2)) {
                    this.CLONE_EPS = false;
                    break;
                }
                this.session.warning("Invalid CLONE_EPS value: " + string2 + "; setting ignored");
                break;
            }
            case 4: {
                string2 = string2.trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                if (!stringTokenizer.hasMoreTokens()) break;
                String string3 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) {
                    this.session.warning("No value specified for PAGE_DEVICE parameter " + string3 + "; setting ignored");
                    break;
                }
                string2 = string2.substring(string3.length()).trim();
                if (this.ps != null) {
                    this.ps.setPageDeviceEntry(string3, string2);
                    break;
                }
                this.PAGE_DEVICE.put(string3, string2);
                break;
            }
            case 12: {
                this.ps.setCustomComment(string + "_" + this.customcommentscount++, string2);
                break;
            }
            case 13: {
                this.ps.setPageLabel(string2);
                break;
            }
            case 5: {
                this.ZOOM = string2;
                break;
            }
            case 6: {
                this.VIEW_MODE = string2;
                break;
            }
            case 7: 
            case 9: {
                float[] fArray = this.parseOffsets(string, string2);
                if (this.ps != null) {
                    this.ps.setPageBoundaryEntry(string, fArray);
                    break;
                }
                this.PAGE_BOUNDARIES.put(string, fArray);
                break;
            }
            case 8: 
            case 10: {
                string2 = string2.trim();
                if ("none".equals(string2)) {
                    string2 = "0pt";
                }
                try {
                    string2 = String.valueOf(H4PS.parseLengthSpecifier(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    this.session.error(numberFormatException.getMessage() + "; option '" + string + "' ignored");
                }
                if (this.ps != null) {
                    this.ps.setPageBoundaryEntry(string, string2);
                    break;
                }
                this.PAGE_BOUNDARIES.put(string, string2);
                break;
            }
            case 11: {
                String string4 = this.resolveURL(string, string2);
                if (this.ps != null) {
                    this.ps.setPrinterMarkEntry(string4);
                    break;
                }
                this.PRINTER_MARKS.append(string4);
                break;
            }
            case 14: {
                this.IMAGE_INLINE_THRESHOLD = Integer.parseInt(string2);
                if (this.IMAGE_INLINE_THRESHOLD != -1) break;
                this.IMAGE_INLINE_THRESHOLD = Integer.MAX_VALUE;
            }
        }
    }

    private final float[] parseOffsets(String string, String string2) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        string2.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ,\t\n\r\f");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
            ++n;
        }
        stringTokenizer = new StringTokenizer(string2);
        try {
            switch (n) {
                case 1: {
                    if (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        string3.trim();
                        f = H4PS.parseLengthSpecifier(string3);
                        f2 = H4PS.parseLengthSpecifier(string3);
                        f3 = H4PS.parseLengthSpecifier(string3);
                        f4 = H4PS.parseLengthSpecifier(string3);
                    }
                    break;
                }
                case 2: {
                    if (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        string4.trim();
                        f = H4PS.parseLengthSpecifier(string4);
                        f3 = H4PS.parseLengthSpecifier(string4);
                        if (stringTokenizer.hasMoreTokens()) {
                            string4 = stringTokenizer.nextToken();
                            string4.trim();
                            f2 = H4PS.parseLengthSpecifier(string4);
                            f4 = H4PS.parseLengthSpecifier(string4);
                        }
                    }
                    break;
                }
                case 3: {
                    if (stringTokenizer.hasMoreTokens()) {
                        String string5 = stringTokenizer.nextToken();
                        string5.trim();
                        f = H4PS.parseLengthSpecifier(string5);
                        if (stringTokenizer.hasMoreTokens()) {
                            string5 = stringTokenizer.nextToken();
                            string5.trim();
                            f2 = H4PS.parseLengthSpecifier(string5);
                            f4 = H4PS.parseLengthSpecifier(string5);
                            if (stringTokenizer.hasMoreTokens()) {
                                string5 = stringTokenizer.nextToken();
                                string5.trim();
                                f3 = H4PS.parseLengthSpecifier(string5);
                            }
                        }
                    }
                    break;
                }
                case 4: {
                    if (stringTokenizer.hasMoreTokens()) {
                        String string6 = stringTokenizer.nextToken();
                        string6.trim();
                        f = H4PS.parseLengthSpecifier(string6);
                        if (stringTokenizer.hasMoreTokens()) {
                            string6 = stringTokenizer.nextToken();
                            string6.trim();
                            f2 = H4PS.parseLengthSpecifier(string6);
                            if (stringTokenizer.hasMoreTokens()) {
                                string6 = stringTokenizer.nextToken();
                                string6.trim();
                                f3 = H4PS.parseLengthSpecifier(string6);
                                if (stringTokenizer.hasMoreTokens()) {
                                    string6 = stringTokenizer.nextToken();
                                    string6.trim();
                                    f4 = H4PS.parseLengthSpecifier(string6);
                                }
                            }
                        }
                    }
                    break;
                }
                default: {
                    this.session.warning("Incorrect number of tokens in " + string + "; setting ignored");
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.session.warning(numberFormatException.getMessage() + "; option '" + string + "' ignored");
        }
        return new float[]{f4, f3, f2, f};
    }

    private static final float parseLengthSpecifier(String string) throws NumberFormatException {
        double d = 1.0;
        if (string.endsWith("pt")) {
            d = 1.0;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("in")) {
            d = 72.0;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("px")) {
            d = 0.6;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("pc")) {
            d = 12.0;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("cm")) {
            d = 28.346456692913385;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("mm")) {
            d = 2.834645669291339;
            string = string.substring(0, string.length() - 2);
        } else {
            throw new NumberFormatException("Unknown measurement units in '" + string + "'");
        }
        return (float)(Double.valueOf(string.trim()) * d);
    }

    private final String resolveURL(String string, String string2) {
        String string3;
        if (string2 != null && string2.trim().startsWith("url") && (string3 = string2.trim().substring(3).trim()).length() > 2 && string3.charAt(0) == '(' && string3.charAt(string3.length() - 1) == ')' && (string3 = string3.substring(1, string3.length() - 1).trim()).length() > 2) {
            if (string3.charAt(0) == '\'' && string3.charAt(string3.length() - 1) == '\'' || string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
                string3 = string3.substring(1, string3.length() - 1);
            }
            return string3;
        }
        this.session.warning("Incorrect syntax in " + string + "; should be: url('<sorce name>')");
        return string2;
    }

    public String outFormat() {
        return "ps";
    }

    protected String getPropertyPrefix() {
        return "com.renderx.xep.H4PS.";
    }

    protected String getProcessingInstructionPrefix() {
        return "xep-postscript-";
    }

    protected String getProcessingInstructionXepCommentPrefix() {
        return "xep-postscript-comment";
    }

    protected String getProcessingInstructionXepPagePrefix() {
        return "xep-postscript-page";
    }

    private void initDocument() {
        Object object;
        String string;
        if (this.ps == null) {
            return;
        }
        this.ps.setLanguageLevel(this.LANGUAGE_LEVEL);
        this.ps.setUnicodeAnnotations(this.UNICODE_ANNOTATIONS);
        this.ps.setCloneEps(this.CLONE_EPS);
        this.ps.setDestinationTreatment(this.DROP_UNUSED_DESTINATIONS);
        this.ps.setInitialZoom(this.ZOOM);
        this.ps.setViewMode(this.VIEW_MODE);
        if (this.session.config.ANNOTATION != null) {
            this.needsAnnotation = true;
        }
        this.ps.setImageInlineThreshold(this.IMAGE_INLINE_THRESHOLD);
        Enumeration enumeration = this.PAGE_DEVICE.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = (String)this.PAGE_DEVICE.get(string);
            this.ps.setPageDeviceEntry(string, (String)object);
        }
        enumeration = this.PAGE_BOUNDARIES.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.PAGE_BOUNDARIES.get(string);
            this.ps.setPageBoundaryEntry(string, object);
        }
        enumeration = this.PRINTER_MARKS.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.ps.setPrinterMarkEntry(string);
        }
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        try {
            this.ps = new PSDocument(this.outstream, this.session.config.TMPDIR, (ImageFactory)this.session.config.imageFactory, this.session.config.fontCatalog, (ErrorHandler)this.session);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalException("fatal error at the end of document " + exception);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.ps.endDocument();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new InternalException("fatal error at the end of document " + exception);
        }
        super.endDocument();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.skip > 0) {
            ++this.skip;
            return;
        }
        if (!"http://www.renderx.com/XEP/xep".equals(string)) {
            this.skip = 1;
            return;
        }
        try {
            switch ((Short)H4base.idtab.get(string2)) {
                case 0: {
                    String string4;
                    this.initDocument();
                    this.ps.setInfo("Producer", Strings.normalize_space(attributes.getValue("producer")));
                    this.ps.setInfo("Creator", Strings.normalize_space(attributes.getValue("creator")));
                    this.ps.setInfo("Author", Strings.normalize_space(attributes.getValue("author")));
                    this.ps.setInfo("Title", Strings.normalize_space(attributes.getValue("title")));
                    this.ps.setInfo("Subject", Strings.normalize_space(attributes.getValue("subject")));
                    this.ps.setInfo("Keywords", Strings.normalize_space(attributes.getValue("keywords")));
                    int n = 0;
                    while (n < attributes.getLength()) {
                        string4 = attributes.getLocalName(n);
                        if (string4.startsWith("__custom_field__")) {
                            String string5 = string4.substring("__custom_field__".length());
                            string5 = new String(Base32.decode(string5));
                            this.ps.setInfo(string5, Strings.normalize_space(attributes.getValue(n)));
                        }
                        ++n;
                    }
                    string4 = attributes.getValue("initial-destination");
                    if (string4 != null) {
                        this.ps.setInitialDestination(string4);
                    }
                    break;
                }
                case 1: {
                    float f = H4PS.parseLength(attributes.getValue("height"));
                    float f2 = H4PS.parseLength(attributes.getValue("width"));
                    this.ps.beginPage(f2, f, attributes.getValue("page-id"));
                    if (this.needsAnnotation) {
                        this.ps.addTextAnnotation(0.0f, f - Sticker.height, Sticker.width, f, Sticker.makeText(this.session.config.ANNOTATION), Sticker.title, Sticker.color);
                        this.needsAnnotation = false;
                    }
                    break;
                }
                case 2: {
                    this.ps.rotate(H4PS.parseAngle(attributes.getValue("phi")));
                    break;
                }
                case 3: {
                    this.ps.translate(H4PS.parseLength(attributes.getValue("x")), H4PS.parseLength(attributes.getValue("y")));
                    break;
                }
                case 4: {
                    this.ps.transform(H4PS.parseFloat(attributes.getValue("a")), H4PS.parseFloat(attributes.getValue("b")), H4PS.parseFloat(attributes.getValue("c")), H4PS.parseFloat(attributes.getValue("d")), H4PS.parseFloat(attributes.getValue("e")), H4PS.parseFloat(attributes.getValue("f")));
                    break;
                }
                case 6: {
                    this.ps.setWordSpacing(H4PS.parseLength(attributes.getValue("value")));
                    break;
                }
                case 7: {
                    this.ps.setCharSpacing(H4PS.parseLength(attributes.getValue("value")));
                    break;
                }
                case 8: {
                    float f = H4PS.parseFloat(attributes.getValue("value"));
                    if (f <= 0.0f) {
                        this.session.error("negative font stretch is not allowed (" + f + ")");
                        break;
                    }
                    this.ps.setFontStretch(f);
                    break;
                }
                case 9: {
                    this.ps.u28.selectFont(attributes.getValue("family"), H4PS.parseInteger(attributes.getValue("weight")), attributes.getValue("style"), attributes.getValue("variant"));
                    this.ps.setFontSize(H4PS.parseLength(attributes.getValue("size")));
                    break;
                }
                case 10: 
                case 45: {
                    this.ps.setTextPos(H4PS.parseLength(attributes.getValue("x")), H4PS.parseLength(attributes.getValue("y")));
                    this.ps.u28.processText(attributes.getValue("value"));
                    break;
                }
                case 11: {
                    float f = H4PS.parseLength(attributes.getValue("thickness"));
                    if (!(f <= 0.0f)) {
                        float f3 = H4PS.parseLength(attributes.getValue("x-from"));
                        float f4 = H4PS.parseLength(attributes.getValue("y-from"));
                        float f5 = H4PS.parseLength(attributes.getValue("x-till"));
                        float f6 = H4PS.parseLength(attributes.getValue("y-till"));
                        this.ps.gsave();
                        String string6 = attributes.getValue("style");
                        if (string6.equals("dotted")) {
                            float f7 = H4PS.getLineLength(f3, f4, f5, f6) / f;
                            float f8 = f7 - (float)(2.0 * Math.floor(f7 / 2.0f));
                            float f9 = 2.0f - f8 / 2.0f;
                            if (f7 > 2.0f && (double)f9 > 1.5) {
                                f9 -= 1.0f;
                            }
                            this.ps.setDash(0.0f, 2.0f * f, f9 * f);
                            this.ps.setLineCap(1);
                        } else if (string6.equals("dashed")) {
                            float f10 = H4PS.getLineLength(f3, f4, f5, f6) / f;
                            float f11 = f10 + 4.0f - (float)(10.0 * Math.floor((f10 + 4.0f) / 10.0f));
                            float f12 = 10.0f - f11 / 2.0f;
                            if (f12 < 8.0f || f10 < 6.0f) {
                                f12 -= 5.0f;
                            }
                            if (f12 == 10.0f) {
                                f12 = 0.0f;
                            }
                            this.ps.setDash(6.0f * f, 4.0f * f, f12 * f);
                            this.ps.setLineCap(0);
                        } else {
                            this.ps.setLineCap(0);
                        }
                        this.ps.setLineWidth(f);
                        this.ps.moveTo(f3, f4);
                        this.ps.lineTo(f5, f6);
                        this.ps.stroke();
                        this.ps.grestore();
                    }
                    break;
                }
                case 15: {
                    float f = H4PS.parseFloat(attributes.getValue("scale-x"));
                    float f13 = H4PS.parseFloat(attributes.getValue("scale-y"));
                    if (f != 0.0f && f13 != 0.0f) {
                        String string7 = attributes.getValue("src");
                        String string8 = attributes.getValue("base");
                        String string9 = attributes.getValue("type");
                        URLSpec uRLSpec = new URLSpec(string8 == null ? null : new URLSpec(string8), string7);
                        this.ps.gsave();
                        this.ps.translate(H4PS.parseLength(attributes.getValue("x-from")), H4PS.parseLength(attributes.getValue("y-from")));
                        this.ps.scale(f, f13);
                        this.ps.placeImage(uRLSpec, string9);
                        this.ps.grestore();
                    }
                    break;
                }
                case 17: {
                    this.ps.setOverprintFlag(attributes.getValue("overprint"));
                    this.ps.setGrayColor(H4PS.parseFloat(attributes.getValue("gray")));
                    break;
                }
                case 16: {
                    this.ps.setOverprintFlag(attributes.getValue("overprint"));
                    this.ps.setRGBColor(H4PS.parseFloat(attributes.getValue("red")), H4PS.parseFloat(attributes.getValue("green")), H4PS.parseFloat(attributes.getValue("blue")));
                    break;
                }
                case 18: {
                    this.ps.setOverprintFlag(attributes.getValue("overprint"));
                    this.ps.setCMYKColor(H4PS.parseFloat(attributes.getValue("cyan")), H4PS.parseFloat(attributes.getValue("magenta")), H4PS.parseFloat(attributes.getValue("yellow")), H4PS.parseFloat(attributes.getValue("black")));
                    break;
                }
                case 19: {
                    this.ps.setOverprintFlag(attributes.getValue("overprint"));
                    String string10 = attributes.getValue("colorant");
                    float f = H4PS.parseFloat(attributes.getValue("tint"));
                    if (attributes.getValue("alt-gray") != null) {
                        this.ps.setSpotColor(f, string10, new float[]{H4PS.parseFloat(attributes.getValue("alt-gray"))});
                        break;
                    }
                    if (attributes.getValue("alt-red") != null) {
                        this.ps.setSpotColor(f, string10, new float[]{H4PS.parseFloat(attributes.getValue("alt-red")), H4PS.parseFloat(attributes.getValue("alt-green")), H4PS.parseFloat(attributes.getValue("alt-blue"))});
                        break;
                    }
                    if (attributes.getValue("alt-cyan") != null) {
                        this.ps.setSpotColor(f, string10, new float[]{H4PS.parseFloat(attributes.getValue("alt-cyan")), H4PS.parseFloat(attributes.getValue("alt-magenta")), H4PS.parseFloat(attributes.getValue("alt-yellow")), H4PS.parseFloat(attributes.getValue("alt-black"))});
                        break;
                    }
                    this.ps.setSpotColor(f, string10, new float[]{0.0f});
                    break;
                }
                case 20: {
                    this.ps.setOverprintFlag(attributes.getValue("overprint"));
                    this.ps.setSpotColor(H4PS.parseFloat(attributes.getValue("tint")), "All", new float[]{0.0f});
                    break;
                }
                case 12: {
                    float f = H4PS.parseLength(attributes.getValue("x-from"));
                    float f14 = H4PS.parseLength(attributes.getValue("y-from"));
                    float f15 = H4PS.parseLength(attributes.getValue("x-till")) - f;
                    float f16 = H4PS.parseLength(attributes.getValue("y-till")) - f14;
                    this.ps.rectangleFill(f, f14, f15, f16);
                    break;
                }
                case 5: {
                    float f = H4PS.parseLength(attributes.getValue("x-from"));
                    float f17 = H4PS.parseLength(attributes.getValue("y-from"));
                    float f18 = H4PS.parseLength(attributes.getValue("x-till")) - f;
                    float f19 = H4PS.parseLength(attributes.getValue("y-till")) - f17;
                    this.ps.gsave();
                    this.ps.rectclip(f, f17, f18, f19);
                    break;
                }
                case 13: {
                    this.ps.newpath();
                    this.ps.moveTo(H4PS.parseLength(attributes.getValue("x-from")), H4PS.parseLength(attributes.getValue("y-from")));
                    break;
                }
                case 14: {
                    this.ps.lineTo(H4PS.parseLength(attributes.getValue("x-till")), H4PS.parseLength(attributes.getValue("y-till")));
                    break;
                }
                case 22: {
                    this.ps.addLocalLink(H4PS.parseLength(attributes.getValue("x-from")), H4PS.parseLength(attributes.getValue("y-from")), H4PS.parseLength(attributes.getValue("x-till")), H4PS.parseLength(attributes.getValue("y-till")), attributes.getValue("destination-id"));
                    break;
                }
                case 23: {
                    this.ps.addWebLink(H4PS.parseLength(attributes.getValue("x-from")), H4PS.parseLength(attributes.getValue("y-from")), H4PS.parseLength(attributes.getValue("x-till")), H4PS.parseLength(attributes.getValue("y-till")), attributes.getValue("destination"), "new".equals(attributes.getValue("show-destination")));
                    break;
                }
                case 24: {
                    this.ps.addLocalBookmark(Strings.normalize_space(attributes.getValue("label")), H4PS.parseInteger(attributes.getValue("id")), H4PS.parseInteger(attributes.getValue("parent-id")), attributes.getValue("destination-id"), "false".equals(attributes.getValue("collapse-subtree")));
                    break;
                }
                case 25: {
                    this.ps.addWebBookmark(Strings.normalize_space(attributes.getValue("label")), H4PS.parseInteger(attributes.getValue("id")), H4PS.parseInteger(attributes.getValue("parent-id")), attributes.getValue("destination"), "false".equals(attributes.getValue("collapse-subtree")), "new".equals(attributes.getValue("show-destination")));
                    break;
                }
                case 26: {
                    break;
                }
                case 21: {
                    this.ps.addNamedDestination(attributes.getValue("name"), H4PS.parseLength(attributes.getValue("x")), H4PS.parseLength(attributes.getValue("y")));
                    break;
                }
                case 27: {
                    this.skip = 1;
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 46: {
                    break;
                }
                default: {
                    throw new InternalException("unknown instruction '" + string2 + "'");
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new InternalException("fatal error at element: " + string2 + " : " + exception);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.skip > 0) {
            --this.skip;
            return;
        }
        if (!"http://www.renderx.com/XEP/xep".equals(string)) {
            --this.skip;
            return;
        }
        try {
            switch ((Short)H4base.idtab.get(string2)) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.session.config.CUSTOM_STAMP == null & this.session.config.PUT_STAMP) {
                        Stamp.put(this, this.session);
                    }
                    if (this.session.config.CUSTOM_STAMP != null) {
                        this.putCustomStamp();
                    }
                    this.ps.endPage();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    break;
                }
                case 5: {
                    this.ps.grestore();
                    break;
                }
                case 13: {
                    this.ps.closePath();
                    this.ps.fill();
                    break;
                }
                case 14: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    break;
                }
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: {
                    break;
                }
                default: {
                    throw new InternalException("unknown instruction '" + string2 + "'");
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new InternalException("fatal error at element: " + string2 + " : " + exception);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        String string3;
        String string4 = this.getProcessingInstructionPrefix();
        if (string.startsWith(string4) && (string3 = string.substring(string4.length())).indexOf(46) == -1) {
            this.setOption(string3.replace('-', '_').toUpperCase(), string2);
        }
    }

    private static final int parseInteger(String string) {
        return Integer.valueOf(string);
    }

    private static final float parseFloat(String string) {
        return Float.valueOf(string).floatValue();
    }

    private static final float parseAngle(String string) {
        return H4PS.parseFloat(string);
    }

    private static final float parseLength(String string) {
        return H4PS.parseFloat(string) / 1000.0f;
    }

    private static final int parseCount(String string) {
        return H4PS.parseInteger(string);
    }

    private static final float getLineLength(float f, float f2, float f3, float f4) {
        if (f == f3) {
            return f2 > f4 ? f2 - f4 : f4 - f2;
        }
        if (f2 == f4) {
            return f > f3 ? f - f3 : f3 - f;
        }
        float f5 = f - f3;
        float f6 = f2 - f4;
        return (float)Math.sqrt(f5 * f5 + f6 * f6);
    }

    static {
        optab.put("LANGUAGE_LEVEL", new Short(0));
        optab.put("UNICODE_ANNOTATIONS", new Short(1));
        optab.put("DROP_UNUSED_DESTINATIONS", new Short(2));
        optab.put("CLONE_EPS", new Short(3));
        optab.put("PAGE_DEVICE", new Short(4));
        optab.put("INITIAL_ZOOM", new Short(5));
        optab.put("VIEW_MODE", new Short(6));
        optab.put("CROP_OFFSET", new Short(7));
        optab.put("CROP_MARK_WIDTH", new Short(8));
        optab.put("BLEED", new Short(9));
        optab.put("BLEED_MARK_WIDTH", new Short(10));
        optab.put("PRINTER_MARK", new Short(11));
        optab.put("CUSTOM_COMMENT", new Short(12));
        optab.put("PAGE_LABEL", new Short(13));
        optab.put("IMAGE_INLINE_THRESHOLD", new Short(14));
    }
}

