/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep;

import com.jclark.xsl.sax.XSLProcessor;
import com.jclark.xsl.sax.XSLProcessorImpl;
import com.renderx.sax.InputSource;
import com.renderx.sax.XMLReaderAdapter;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.URLSpec;
import com.renderx.xep.ValidationEventHandler;
import java.io.IOException;
import java.util.StringTokenizer;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

class ValidatorCore {
    private XSLProcessor xt = new XSLProcessorImpl();
    private MessageHandler handler = new MessageHandler();

    public ValidatorCore(URLSpec uRLSpec, int n) throws SAXException, IOException {
        this.setXMLReader(XMLReaderFactory.createXMLReader());
        this.xt.setDocumentHandler(new HandlerBase());
        this.xt.setErrorHandler(this.handler);
        this.handler.setValidationEventHandler(new DefaultValidationEventHandler());
        this.xt.loadStylesheet(new InputSource(uRLSpec));
        this.xt.setParameter("strictness", "" + n);
    }

    public int validate(org.xml.sax.InputSource inputSource, XMLReader xMLReader) throws SAXException, IOException {
        this.handler.reset();
        this.setXMLReader(xMLReader);
        this.xt.parse(inputSource);
        return this.handler.getErrorCount();
    }

    public int getErrorCount() {
        return this.handler.getErrorCount();
    }

    public int getWarningCount() {
        return this.handler.getWarningCount();
    }

    private void setXMLReader(XMLReader xMLReader) throws SAXException {
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.xt.setParser(new org.xml.sax.helpers.XMLReaderAdapter(xMLReader));
        }
        catch (SAXException sAXException) {
            this.xt.setParser(new XMLReaderAdapter(xMLReader));
        }
    }

    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        this.handler.setValidationEventHandler(validationEventHandler);
    }

    protected static class DefaultValidationEventHandler
    implements ValidationEventHandler {
        protected DefaultValidationEventHandler() {
        }

        public void warning(String string, String string2, String string3, int n, int n2) {
            this.formatMessage("warning", string, string2, string3, n, n2);
        }

        public void error(String string, String string2, String string3, int n, int n2) {
            this.formatMessage("error", string, string2, string3, n, n2);
        }

        private void formatMessage(String string, String string2, String string3, String string4, int n, int n2) {
            System.err.print(string4);
            if (n != -1) {
                System.err.print(": line " + n);
                if (n2 != -1) {
                    System.err.print(", column " + n2);
                }
            }
            System.err.println();
            int n3 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                if (n3 + string5.length() > 71) {
                    System.err.println();
                    System.err.print(string5);
                    n3 = string5.length();
                    continue;
                }
                if (n3 > 0) {
                    System.err.print(" ");
                    ++n3;
                }
                System.err.print(string5);
                n3 += string5.length();
            }
            System.err.println();
            System.err.println();
        }
    }

    protected static class MessageHandler
    implements ErrorHandler {
        private int warningCount = 0;
        private int errorCount = 0;
        private ValidationEventHandler handler = null;

        protected MessageHandler() {
        }

        public void reset() {
            this.warningCount = 0;
            this.errorCount = 0;
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public int getWarningCount() {
            return this.warningCount;
        }

        protected void dispatchMessage(SAXParseException sAXParseException) throws SAXParseException {
            String string = sAXParseException.getMessage();
            if (string != null && string.startsWith("[warning]")) {
                ++this.warningCount;
                this.handler.warning(string.substring("[warning]".length()).trim(), sAXParseException.getPublicId(), sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
            } else if (string != null && string.startsWith("[error]")) {
                ++this.errorCount;
                this.handler.error(string.substring("[error]".length()).trim(), sAXParseException.getPublicId(), sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
            } else {
                ++this.errorCount;
                this.handler.error(string, sAXParseException.getPublicId(), sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
            }
        }

        public void warning(SAXParseException sAXParseException) throws SAXParseException {
            this.dispatchMessage(sAXParseException);
        }

        public void error(SAXParseException sAXParseException) throws SAXParseException {
            this.dispatchMessage(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            this.dispatchMessage(sAXParseException);
        }

        public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
            this.handler = validationEventHandler;
        }
    }
}

