/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep;

import com.renderx.sax.InputSource;
import com.renderx.sax.NullSource;
import com.renderx.sax.SAXStorage;
import com.renderx.util.List;
import com.renderx.util.URLSpec;
import com.renderx.xep.ValidationEventHandler;
import com.renderx.xep.ValidatorCore;
import com.renderx.xep.cmp.FO;
import com.renderx.xep.fmt.BkMaker;
import com.renderx.xep.gen.H4base;
import com.renderx.xep.gen.SAX;
import com.renderx.xep.lib.Conf;
import com.renderx.xep.lib.ConfigurationException;
import com.renderx.xep.lib.FormatterException;
import com.renderx.xep.lib.Logger;
import com.renderx.xep.lib.Session;
import com.renderx.xep.pre.Parser;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FormatterCore {
    protected final Conf config;
    static /* synthetic */ Class class$com$renderx$xep$gen$H4base;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$com$renderx$xep$lib$Session;
    static /* synthetic */ Class class$java$util$Properties;

    public FormatterCore(Conf conf) {
        this.config = conf;
    }

    public synchronized void cleanup() {
        this.config.cleanup();
    }

    public void render(org.xml.sax.InputSource inputSource, XMLReader xMLReader, ContentHandler contentHandler, Logger logger) throws SAXException, IOException {
        ContentHandlerDriver contentHandlerDriver = new ContentHandlerDriver(inputSource.getSystemId(), contentHandler, logger);
        xMLReader.setContentHandler(contentHandlerDriver);
        xMLReader.setErrorHandler(contentHandlerDriver);
        xMLReader.parse(inputSource);
    }

    public ContentHandler createContentHandler(String string, ContentHandler contentHandler, Logger logger) throws ConfigurationException {
        return new ContentHandlerDriver(string, contentHandler, logger);
    }

    private static String getValidationMessage(int n, int n2) {
        String string = "OK";
        if (n > 0 || n2 > 0) {
            string = "total: ";
            if (n > 0) {
                string = string + "" + n + " error";
                if (n > 1) {
                    string = string + "s";
                }
                if (n2 > 0) {
                    string = string + ", ";
                }
            }
            if (n2 > 0) {
                string = string + "" + n2 + " warning";
                if (n2 > 1) {
                    string = string + "s";
                }
            }
        }
        return string;
    }

    private static String formatSAXParserMessage(String string, String string2, String string3, int n, int n2) {
        String string4;
        String string5 = string4 = string3 == null ? "" : string3 + ": ";
        if (n != -1) {
            string4 = string4 + "line " + n;
            if (n2 != -1) {
                string4 = string4 + ", column " + n2;
            }
        }
        if (string4.length() > 0) {
            string4 = string4 + ": ";
        }
        string4 = string4 + string;
        return string4;
    }

    private static String formatSAXParserMessage(SAXParseException sAXParseException) {
        return FormatterCore.formatSAXParserMessage(sAXParseException.getMessage(), sAXParseException.getPublicId(), sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
    }

    public ContentHandler createGenerator(OutputStream outputStream, String string, Properties properties, Logger logger) throws ConfigurationException {
        return this.createGenerator(outputStream, string, properties, new Session(this.config, logger));
    }

    protected ContentHandler createGenerator(OutputStream outputStream, String string, Properties properties, Session session) throws ConfigurationException {
        String string2;
        Object object;
        if (string == null) {
            throw new ConfigurationException("Format cannot be 'null'");
        }
        Class<?> clazz = null;
        String string3 = Conf.getBackendClassName(string);
        if (string3 == null) {
            throw new ConfigurationException("Unknown output format: " + string);
        }
        try {
            clazz = Class.forName(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationException("Cannot locate generator for '" + string + "': class " + string3 + " not found in the classpath");
        }
        catch (Exception exception) {
            throw new ConfigurationException("Cannot access generator class for '" + string + "' (class " + string3 + ")", exception);
        }
        if (!(class$com$renderx$xep$gen$H4base == null ? (class$com$renderx$xep$gen$H4base = FormatterCore.class$("com.renderx.xep.gen.H4base")) : class$com$renderx$xep$gen$H4base).isAssignableFrom(clazz)) {
            throw new ConfigurationException("Invalid generator for '" + string + "': class " + clazz.getName() + " is not a subclass of com.renderx.xep.gen.H4base");
        }
        Properties properties2 = new Properties();
        Properties properties3 = this.config.getBackendOptions(string);
        if (properties3 != null) {
            object = properties3.propertyNames();
            while (object.hasMoreElements()) {
                string2 = (String)object.nextElement();
                properties2.put(string2, properties3.get(string2));
            }
        }
        if (properties != null) {
            object = properties.propertyNames();
            while (object.hasMoreElements()) {
                string2 = (String)object.nextElement();
                properties2.put(string2, properties.getProperty(string2));
            }
        }
        object = null;
        try {
            object = (H4base)clazz.getDeclaredConstructor(class$java$io$OutputStream == null ? (class$java$io$OutputStream = FormatterCore.class$("java.io.OutputStream")) : class$java$io$OutputStream, class$com$renderx$xep$lib$Session == null ? (class$com$renderx$xep$lib$Session = FormatterCore.class$("com.renderx.xep.lib.Session")) : class$com$renderx$xep$lib$Session, class$java$util$Properties == null ? (class$java$util$Properties = FormatterCore.class$("java.util.Properties")) : class$java$util$Properties).newInstance(outputStream, session, properties2);
        }
        catch (Exception exception) {
            throw new ConfigurationException("Cannot instantiate generator for '" + string + "' (class " + clazz.getName() + ")", exception);
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ContentHandlerDriver
    extends DefaultHandler {
        private final ContentHandler generator;
        private String systemId = null;
        private Session session = null;
        private ValidatorCore validator = null;
        private SAXStorage storage = null;
        private FO fo = null;
        private ContentHandler handler = null;

        ContentHandlerDriver(String string, ContentHandler contentHandler, Logger logger) {
            this.generator = contentHandler;
            this.systemId = string;
            this.session = new Session(FormatterCore.this.config, logger);
        }

        private void inputTransformation(URLSpec uRLSpec, String string) throws SAXException {
            SAXTransformerFactory sAXTransformerFactory;
            SAXStorage sAXStorage = null;
            sAXStorage = new SAXStorage();
            SAXResult sAXResult = new SAXResult(sAXStorage);
            try {
                sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                sAXTransformerFactory.setErrorListener(new XSLTErrorListenerToSessionAdapter());
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                throw new RuntimeException(transformerFactoryConfigurationError.toString());
            }
            TransformerHandler transformerHandler = null;
            try {
                InputSource inputSource = new InputSource(uRLSpec);
                SAXSource sAXSource = new SAXSource(inputSource);
                transformerHandler = sAXTransformerFactory.newTransformerHandler(sAXSource);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new FormatterException("Cannot initialize transformer for " + string + " transformation: " + transformerConfigurationException.toString());
            }
            catch (IOException iOException) {
                throw new FormatterException("Cannot retrieve " + string + " stylesheet from `" + uRLSpec.toString() + "': " + iOException.toString());
            }
            transformerHandler.setResult(sAXResult);
            this.storage.setContentHandler(transformerHandler);
            try {
                this.storage.play();
            }
            catch (SAXException sAXException) {
                throw new FormatterException(sAXException);
            }
            this.storage = sAXStorage;
        }

        public void startDocument() throws SAXException {
            if (this.session == null) {
                throw new RuntimeException("Attempt to reuse a ContentHandlerDriver object returned by com.renderx.xep.FormatterCore");
            }
            this.session.openDocument();
            if (this.systemId != null) {
                this.session.event("system-id", this.systemId);
            }
            if (FormatterCore.this.config.VALIDATE) {
                try {
                    this.validator = new ValidatorCore(FormatterCore.this.config.VALIDATOR_STYLESHEET, FormatterCore.this.config.STRICTNESS);
                    this.validator.setValidationEventHandler(new ValidationLogger(this.session));
                }
                catch (Exception exception) {
                    this.session.exception("Cannot initialize validator; validation is turned off", exception);
                }
            }
            this.storage = new SAXStorage();
            this.handler = this.storage;
            this.handler.startDocument();
        }

        public void endDocument() throws SAXException {
            if (this.handler == null) {
                return;
            }
            this.handler.endDocument();
            this.handler = null;
            if (FormatterCore.this.config.SUPPORT_XSL11) {
                this.inputTransformation(FormatterCore.this.config.XSL11_TO_XSL10RX_STYLESHEET, "XSL-FO 1.1 to XSL-FO 1.0");
            }
            if (FormatterCore.this.config.FOOTNOTE_REORDERING) {
                this.inputTransformation(FormatterCore.this.config.FOOTNOTE_REORDERING_STYLESHEET, "Footnote Reordering");
            }
            if (this.validator != null) {
                this.session.openState("validate");
                try {
                    this.validator.validate(new NullSource(this.systemId), this.storage);
                }
                catch (IOException iOException) {
                    throw new FormatterException(iOException);
                }
                int n = this.validator.getWarningCount();
                int n2 = this.validator.getErrorCount();
                this.session.event("validation", FormatterCore.getValidationMessage(n2, n));
                if (n2 != 0 && FormatterCore.this.config.DISCARD_IF_NOT_VALID) {
                    throw new FormatterException("Invalid XSL FO source" + (this.systemId == null ? ": " : " '" + this.systemId + "': ") + n2 + " error" + (n2 == 1 ? "" : "s") + " found during validation");
                }
                this.session.closeState("validate");
            }
            this.session.openState("compile");
            Parser parser = new Parser(this.session);
            this.fo = new FO();
            this.storage.setContentHandler(parser.createContentHandler(this.systemId, this.fo));
            this.storage.play();
            this.storage = null;
            this.session.closeState("compile");
            this.session.openState("format");
            List list = new BkMaker(this.fo.sequences, this.fo.outline, this.session).mkBook();
            this.fo.masters = null;
            this.fo.sequences = null;
            this.session.closeState("format");
            this.session.openState("generate");
            if (this.generator instanceof H4base) {
                this.session.event("output-format", ((H4base)this.generator).outFormat());
            }
            SAX sAX = new SAX(list, this.fo, this.session);
            sAX.setContentHandler(this.generator);
            sAX.traverse();
            this.session.closeState("generate");
            this.session.closeDocument();
            this.session = null;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.handler != null) {
                this.handler.startElement(string, string2, string3, attributes);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.handler != null) {
                this.handler.endElement(string, string2, string3);
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.handler != null) {
                this.handler.characters(cArray, n, n2);
            }
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            if (this.handler != null) {
                this.handler.ignorableWhitespace(cArray, n, n2);
            }
        }

        public void processingInstruction(String string, String string2) throws SAXException {
            if (this.handler != null) {
                this.handler.processingInstruction(string, string2);
            }
        }

        public void skippedEntity(String string) throws SAXException {
            if (this.handler != null) {
                this.handler.skippedEntity(string);
            }
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
            if (this.handler != null) {
                this.handler.startPrefixMapping(string, string2);
            }
        }

        public void endPrefixMapping(String string) throws SAXException {
            if (this.handler != null) {
                this.handler.endPrefixMapping(string);
            }
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.session.warning("Parse warning: " + FormatterCore.formatSAXParserMessage(sAXParseException));
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.session.error("Parse error: " + FormatterCore.formatSAXParserMessage(sAXParseException));
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.session.error("Fatal parse error: " + FormatterCore.formatSAXParserMessage(sAXParseException));
            if (this.handler == null) {
                return;
            }
            this.handler.endDocument();
            this.handler = null;
            if (this.validator == null) {
                this.session.closeState("compile");
                this.fo = null;
            } else {
                this.storage = null;
            }
            throw sAXParseException;
        }

        private class XSLTErrorListenerToSessionAdapter
        implements ErrorListener {
            private XSLTErrorListenerToSessionAdapter() {
            }

            public void fatalError(TransformerException transformerException) throws TransformerException {
                ContentHandlerDriver.this.session.exception(transformerException.getMessage(), transformerException);
                throw transformerException;
            }

            public void warning(TransformerException transformerException) throws TransformerException {
                ContentHandlerDriver.this.session.warning(transformerException.getMessage());
            }

            public void error(TransformerException transformerException) throws TransformerException {
                ContentHandlerDriver.this.session.error(transformerException.getMessage());
            }
        }
    }

    private static final class ValidationLogger
    implements ValidationEventHandler {
        private final Logger logger;

        public ValidationLogger(Logger logger) {
            this.logger = logger;
        }

        public void warning(String string, String string2, String string3, int n, int n2) {
            if (this.logger != null) {
                this.logger.warning(FormatterCore.formatSAXParserMessage(string, string2, string3, n, n2));
            }
        }

        public void error(String string, String string2, String string3, int n, int n2) {
            if (this.logger != null) {
                this.logger.error(FormatterCore.formatSAXParserMessage(string, string2, string3, n, n2));
            }
        }
    }
}

