/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.svg;

import com.renderx.fonts.FontCatalog;
import com.renderx.fonts.FontConfigurationException;
import com.renderx.graphics.ImageFactory;
import com.renderx.graphics.SvgLevelParams;
import com.renderx.graphics.VectorImage;
import com.renderx.graphics.vector.ImageTree;
import com.renderx.sax.InputSource;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.sax.XPP;
import com.renderx.svg.AfpSvgParserHandler;
import com.renderx.svg.ParserHandler;
import com.renderx.svg.SVGParseException;
import com.renderx.svg.SVGParserHandler;
import com.renderx.util.DefaultErrorHandler;
import com.renderx.util.ErrorHandler;
import com.renderx.util.URLCache;
import com.renderx.util.URLSpec;
import com.renderx.util.User;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class Parser {
    private XPP xpp;
    private static final String DEFAULT_STYLESHEET = "resource:com/renderx/svg/preprocessor.xsl";
    private final ErrorHandler errHandler;
    private final ImageFactory imageFactory;
    private final FontCatalog fontCatalog;

    protected Parser() throws IOException, SAXException, FontConfigurationException {
        this(new URLCache(new DefaultErrorHandler()), new DefaultErrorHandler());
    }

    private Parser(URLCache uRLCache, ErrorHandler errorHandler) throws IOException, SAXException, FontConfigurationException {
        this(new FontCatalog(uRLCache, errorHandler), uRLCache, errorHandler);
    }

    private Parser(FontCatalog fontCatalog, URLCache uRLCache, ErrorHandler errorHandler) throws IOException, SAXException {
        this(new ImageFactory(fontCatalog, uRLCache, errorHandler), fontCatalog, errorHandler);
    }

    public Parser(ImageFactory imageFactory, FontCatalog fontCatalog, ErrorHandler errorHandler) throws IOException, SAXException {
        this.imageFactory = imageFactory;
        this.fontCatalog = fontCatalog;
        this.errHandler = errorHandler;
        String string = User.getProperty("com.renderx.svg.preprocessor");
        if (string == null) {
            string = DEFAULT_STYLESHEET;
        }
        this.xpp = new XPP(XMLReaderFactory.createXMLReader(), new InputSource(string));
    }

    public void setErrorHandler(org.xml.sax.ErrorHandler errorHandler) {
        this.xpp.setErrorHandler(errorHandler);
    }

    public ImageTree parse(XMLReader xMLReader, org.xml.sax.InputSource inputSource, URLSpec uRLSpec, int n, SvgLevelParams svgLevelParams, double d, double d2) throws IOException, SAXException {
        ParserHandlerFactory parserHandlerFactory = new ParserHandlerFactory();
        ParserHandler parserHandler = parserHandlerFactory.createParserHandler(n, svgLevelParams, d, d2);
        parserHandler.setBaseURL(uRLSpec);
        this.xpp.setXMLReader(new FNFilter(xMLReader));
        this.xpp.parse(inputSource, parserHandler);
        if (parserHandler.tree == null || parserHandler.tree.root == null) {
            throw new SVGParseException("Internal error: SVG parser misconfigured");
        }
        return parserHandler.tree;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = null;
        if (stringArray.length == 1) {
            string = stringArray[0] + ".ps";
            System.out.println("Dumping graphic tree to " + string);
        } else if (stringArray.length == 2) {
            string = stringArray[1];
        } else {
            System.out.println("Usage: com.renderx.svg.Parser <input file name> [<output file name>]");
            System.exit(0);
        }
        URLSpec uRLSpec = new URLSpec(stringArray[0]);
        new Parser().parse(XMLReaderFactory.createXMLReader(), new InputSource(uRLSpec), uRLSpec, VectorImage.IMAGE_TYPE_DEFAULT, new SvgLevelParams(0, 0), 0.0, 0.0).dump(new PrintStream(new FileOutputStream(string)), "");
    }

    class ParserHandlerFactory {
        ParserHandlerFactory() {
        }

        public ParserHandler createParserHandler(int n, SvgLevelParams svgLevelParams, double d, double d2) {
            ParserHandler parserHandler = null;
            parserHandler = n == VectorImage.IMAGE_TYPE_SVG_AFP ? new AfpSvgParserHandler(Parser.this.imageFactory, Parser.this.fontCatalog, Parser.this.errHandler, svgLevelParams, d, d2) : new SVGParserHandler(Parser.this.imageFactory, Parser.this.fontCatalog, Parser.this.errHandler, d, d2);
            return parserHandler;
        }
    }

    class FNFilter
    extends XMLFilterImpl {
        public FNFilter(XMLReader xMLReader) {
            super(xMLReader);
        }

        public void parse(org.xml.sax.InputSource inputSource) throws SAXException, IOException {
            try {
                super.parse(inputSource);
            }
            catch (IOException iOException) {
                if (Parser.this.errHandler != null) {
                    Parser.this.errHandler.error("File could not be retrieved from " + inputSource.getSystemId() + "; skipped");
                }
                super.parse(new org.xml.sax.InputSource(new StringReader("<void/>")));
            }
        }

        public void parse(String string) throws SAXException, IOException {
            try {
                super.parse(string);
            }
            catch (IOException iOException) {
                if (Parser.this.errHandler != null) {
                    Parser.this.errHandler.error("File could not be retrieved from " + string + "; skipped");
                }
                super.parse(new org.xml.sax.InputSource(new StringReader("<void/>")));
            }
        }
    }
}

