/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.sax;

import com.renderx.sax.XMLPlayer;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import java.util.Enumeration;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SAXStorage
extends XMLPlayer
implements ContentHandler {
    private List queue = new List();
    private StringStorage cacheURI = new StringStorage();
    private StringStorage cacheLocalName = new StringStorage();
    private StringStorage cacheQName = new StringStorage();
    private StringStorage cachePrefix = new StringStorage();
    private StringStorage cacheAttrLocalName = new StringStorage();
    private StringStorage cacheAttrQName = new StringStorage();
    private StringStorage cacheAttrType = new StringStorage();
    private StringStorage cacheAttrValue = new StringStorage();
    private StringStorage cachePITarget = new StringStorage();
    private StringStorage cachePIData = new StringStorage();

    public void startDocument() throws SAXException {
        this.queue.append(new StartDocumentRecord());
    }

    public void endDocument() throws SAXException {
        this.queue.append(new EndDocumentRecord());
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.queue.append(new StartElementRecord(string, string2, string3, attributes));
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.queue.append(new EndElementRecord(string, string2, string3));
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.queue.append(new ProcessingInstructionRecord(string, string2));
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.queue.append(new CharactersRecord(cArray, n, n2));
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.queue.append(new IgnorableWhitespaceRecord(cArray, n, n2));
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.queue.append(new StartPrefixMappingRecord(string, string2));
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.queue.append(new EndPrefixMappingRecord(string));
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) {
    }

    public void play() throws SAXException {
        Enumeration enumeration = this.queue.elements();
        while (enumeration.hasMoreElements()) {
            ((SAXRecord)enumeration.nextElement()).play();
        }
    }

    public void clear() {
        this.queue.clear();
        this.cacheURI.clear();
        this.cacheLocalName.clear();
        this.cacheQName.clear();
        this.cacheAttrLocalName.clear();
        this.cacheAttrQName.clear();
        this.cacheAttrType.clear();
        this.cacheAttrValue.clear();
        this.cachePITarget.clear();
        this.cachePIData.clear();
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.clear();
    }

    private static class StringStorage
    extends Hashtable {
        private StringStorage() {
        }

        public String store(String string) {
            if (string == null) {
                return string;
            }
            String string2 = (String)this.get(string);
            if (string2 != null) {
                return string2;
            }
            this.put(string, string);
            return string;
        }
    }

    class EndPrefixMappingRecord
    implements SAXRecord {
        private String prefix;

        EndPrefixMappingRecord(String string) {
            this.prefix = SAXStorage.this.cachePrefix.store(string);
        }

        public void play() throws SAXException {
            SAXStorage.this.handler.endPrefixMapping(this.prefix);
        }
    }

    class StartPrefixMappingRecord
    implements SAXRecord {
        private String uri;
        private String prefix;

        StartPrefixMappingRecord(String string, String string2) {
            this.prefix = SAXStorage.this.cachePrefix.store(string);
            this.uri = SAXStorage.this.cacheURI.store(string2);
        }

        public void play() throws SAXException {
            SAXStorage.this.handler.startPrefixMapping(this.prefix, this.uri);
        }
    }

    class IgnorableWhitespaceRecord
    implements SAXRecord {
        private char[] whitespace;

        IgnorableWhitespaceRecord(char[] cArray, int n, int n2) {
            this.whitespace = new char[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.whitespace[n3] = cArray[n + n3];
                ++n3;
            }
        }

        public void play() throws SAXException {
            SAXStorage.this.handler.ignorableWhitespace(this.whitespace, 0, this.whitespace.length);
        }
    }

    class CharactersRecord
    implements SAXRecord {
        private char[] text;

        CharactersRecord(char[] cArray, int n, int n2) {
            this.text = new char[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.text[n3] = cArray[n + n3];
                ++n3;
            }
        }

        public void play() throws SAXException {
            SAXStorage.this.handler.characters(this.text, 0, this.text.length);
        }
    }

    class ProcessingInstructionRecord
    implements SAXRecord {
        private String target;
        private String data;

        ProcessingInstructionRecord(String string, String string2) {
            this.target = SAXStorage.this.cachePITarget.store(string);
            this.data = SAXStorage.this.cachePIData.store(string2);
        }

        public void play() throws SAXException {
            SAXStorage.this.handler.processingInstruction(this.target, this.data);
        }
    }

    class EndElementRecord
    implements SAXRecord {
        private String uri;
        private String localName;
        private String qName;

        EndElementRecord(String string, String string2, String string3) {
            this.uri = SAXStorage.this.cacheURI.store(string);
            this.localName = SAXStorage.this.cacheLocalName.store(string2);
            this.qName = SAXStorage.this.cacheQName.store(string3);
        }

        public void play() throws SAXException {
            SAXStorage.this.handler.endElement(this.uri, this.localName, this.qName);
        }
    }

    class StartElementRecord
    implements SAXRecord {
        private String uri;
        private String localName;
        private String qName;
        private AttributesImpl atts;

        StartElementRecord(String string, String string2, String string3, Attributes attributes) {
            this.uri = SAXStorage.this.cacheURI.store(string);
            this.localName = SAXStorage.this.cacheLocalName.store(string2);
            this.qName = SAXStorage.this.cacheQName.store(string3);
            if (attributes == null) {
                this.atts = null;
            } else {
                this.atts = new AttributesImpl();
                int n = 0;
                while (n < attributes.getLength()) {
                    String string4 = attributes.getQName(n);
                    if (string4 == null || !string4.startsWith("xmlns:") && !string4.equals("xmlns")) {
                        this.atts.addAttribute(SAXStorage.this.cacheURI.store(attributes.getURI(n)), SAXStorage.this.cacheAttrLocalName.store(attributes.getLocalName(n)), SAXStorage.this.cacheAttrQName.store(string4), SAXStorage.this.cacheAttrType.store(attributes.getType(n)), SAXStorage.this.cacheAttrValue.store(attributes.getValue(n)));
                    }
                    ++n;
                }
            }
        }

        public void play() throws SAXException {
            SAXStorage.this.handler.startElement(this.uri, this.localName, this.qName, this.atts);
        }
    }

    class EndDocumentRecord
    implements SAXRecord {
        EndDocumentRecord() {
        }

        public void play() throws SAXException {
            SAXStorage.this.handler.endDocument();
        }
    }

    class StartDocumentRecord
    implements SAXRecord {
        StartDocumentRecord() {
        }

        public void play() throws SAXException {
            SAXStorage.this.handler.startDocument();
        }
    }

    static interface SAXRecord {
        public void play() throws SAXException;
    }
}

