/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFIOException;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class XMPInfo
extends PDFObject {
    private String keywords;
    private String subject;
    private String title;
    private String creator;
    private String author;
    private String producer;
    private String publisher;
    private Calendar modDate;
    private Calendar creationDate;
    private byte[] xmpText;
    private static int ONE_HOUR = 3600000;

    XMPInfo(IndirectObject indirectObject) {
        super(indirectObject);
    }

    public void setKeywords(String string) {
        this.keywords = string;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setCreator(String string) {
        this.creator = string;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public void setProducer(String string) {
        this.producer = string;
    }

    public void setPublisher(String string) {
        this.publisher = string;
    }

    public void setModDate(Calendar calendar) {
        this.modDate = calendar;
    }

    public void setCreationDate(Calendar calendar) {
        this.creationDate = calendar;
    }

    void writeBody(PDFOutputStream pDFOutputStream) throws PDFIOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xpacket begin='' id='W5M0MpCehiHzreSzNTczkc9d'?>\n");
        stringBuffer.append("<x:xmpmeta xmlns:x='adobe:ns:meta/'>\n");
        stringBuffer.append("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n");
        stringBuffer.append("<rdf:Description rdf:about=\"\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\">\n");
        stringBuffer.append("<dc:format>application/pdf</dc:format>\n");
        if (this.title != null) {
            stringBuffer.append("<dc:title>\n");
            stringBuffer.append(" <rdf:Alt>\n");
            stringBuffer.append("  <rdf:li xml:lang=\"x-default\">" + this.escapeXml(this.title) + "</rdf:li>\n");
            stringBuffer.append(" </rdf:Alt>\n");
            stringBuffer.append("</dc:title>\n");
        }
        if (this.subject != null) {
            stringBuffer.append("<dc:description>\n");
            stringBuffer.append(" <rdf:Alt>\n");
            stringBuffer.append("  <rdf:li xml:lang=\"x-default\">" + this.escapeXml(this.subject) + "</rdf:li>\n");
            stringBuffer.append(" </rdf:Alt>\n");
            stringBuffer.append("</dc:description>\n");
        }
        if (this.author != null) {
            stringBuffer.append("<dc:creator>\n");
            stringBuffer.append(" <rdf:Seq>\n");
            stringBuffer.append("  <rdf:li>" + this.escapeXml(this.author) + "</rdf:li>\n");
            stringBuffer.append(" </rdf:Seq>\n");
            stringBuffer.append("</dc:creator>\n");
        }
        if (this.publisher != null) {
            stringBuffer.append("<dc:publisher>\n");
            stringBuffer.append(" <rdf:Bag>\n");
            StringTokenizer stringTokenizer = new StringTokenizer(this.publisher, ";;");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                string = string.trim();
                stringBuffer.append("  <rdf:li>" + this.escapeXml(string) + "</rdf:li>\n");
            }
            stringBuffer.append(" </rdf:Bag>\n");
            stringBuffer.append("</dc:publisher>\n");
        }
        stringBuffer.append("</rdf:Description>\n");
        if (this.keywords != null || this.producer != null) {
            stringBuffer.append("<rdf:Description rdf:about=\"\" xmlns:pdf=\"http://ns.adobe.com/pdf/1.3/\">\n");
            if (this.keywords != null) {
                stringBuffer.append("<pdf:Keywords>" + this.escapeXml(this.keywords) + "</pdf:Keywords>\n");
            }
            if (this.producer != null) {
                stringBuffer.append("<pdf:Producer>" + this.escapeXml(this.producer) + "</pdf:Producer>\n");
            }
            stringBuffer.append("</rdf:Description>\n");
        }
        stringBuffer.append("<rdf:Description rdf:about=\"\" xmlns:xmp=\"http://ns.adobe.com/xap/1.0/\">\n");
        if (this.creator != null) {
            stringBuffer.append("<xmp:CreatorTool>" + this.escapeXml(this.creator) + "</xmp:CreatorTool>\n");
        }
        stringBuffer.append("<xmp:CreateDate>" + this.calendarToString(this.creationDate) + "</xmp:CreateDate>\n");
        stringBuffer.append("<xmp:ModifyDate>" + this.calendarToString(this.modDate) + "</xmp:ModifyDate>\n");
        stringBuffer.append("</rdf:Description>\n");
        if (pDFOutputStream.doc.hasPDFA()) {
            stringBuffer.append("<rdf:Description rdf:about=\"\" xmlns:pdfaid=\"http://www.aiim.org/pdfa/ns/id/\">\n");
            stringBuffer.append("<pdfaid:part>1</pdfaid:part>\n");
            stringBuffer.append("<pdfaid:conformance>");
            if ("PDF/A-1a".equals(pDFOutputStream.doc.pdfaConformanceStatus)) {
                stringBuffer.append("A");
            } else {
                stringBuffer.append("B");
            }
            stringBuffer.append("</pdfaid:conformance>\n");
            stringBuffer.append("</rdf:Description>\n");
        }
        stringBuffer.append("</rdf:RDF>\n");
        stringBuffer.append("</x:xmpmeta>\n");
        stringBuffer.append("<?xpacket end='r'?>\n");
        try {
            this.xmpText = stringBuffer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        pDFOutputStream.print("/Type /Metadata /Subtype /XML /Length " + this.xmpText.length);
    }

    void writeTail(PDFOutputStream pDFOutputStream) throws PDFIOException {
        pDFOutputStream.println(">>");
        pDFOutputStream.println("stream");
        pDFOutputStream.print(this.xmpText);
        pDFOutputStream.println("\nendstream");
        pDFOutputStream.println("endobj");
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) throws PDFIOException {
    }

    private String calendarToString(Calendar calendar) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
        ((Calendar)gregorianCalendar).add(11, -(calendar.get(15) / ONE_HOUR + calendar.get(16) / ONE_HOUR));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XMPInfo.format(gregorianCalendar.get(1)));
        stringBuffer.append("-");
        stringBuffer.append(XMPInfo.format(gregorianCalendar.get(2) + 1));
        stringBuffer.append("-");
        stringBuffer.append(XMPInfo.format(gregorianCalendar.get(5)));
        stringBuffer.append("T");
        stringBuffer.append(XMPInfo.format(gregorianCalendar.get(11)));
        stringBuffer.append(":");
        stringBuffer.append(XMPInfo.format(gregorianCalendar.get(12)));
        stringBuffer.append(":");
        stringBuffer.append(XMPInfo.format(gregorianCalendar.get(13)));
        stringBuffer.append("Z");
        return stringBuffer.toString();
    }

    private static String format(int n) {
        return n < 10 ? "0" + n : Integer.toString(n);
    }

    private String substitute(String string, String string2, String string3) {
        if (string != null) {
            int n = string2.length();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = -1;
            int n3 = 0;
            while ((n2 = string.indexOf(string2, n3)) != -1) {
                stringBuffer.append(string.substring(n3, n2));
                stringBuffer.append(string3);
                n3 = n2 + n;
            }
            stringBuffer.append(string.substring(n3));
            return stringBuffer.toString();
        }
        return "";
    }

    private String escapeXml(String string) {
        if (string == null) {
            return "";
        }
        String string2 = this.substitute(string, "&", "&amp;");
        String string3 = this.substitute(string2, "\"", "&quot");
        String string4 = this.substitute(string3, "<", "&lt;");
        return this.substitute(string4, ">", "&gt;");
    }
}

