/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.graphics.BitmapImage;
import com.renderx.graphics.Image;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.PNGImage;
import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.graphics.VectorImage;
import com.renderx.graphics.vector.Contour;
import com.renderx.graphics.vector.ExternalImage;
import com.renderx.graphics.vector.Gradient;
import com.renderx.graphics.vector.GraphicGroup;
import com.renderx.graphics.vector.GraphicObject;
import com.renderx.graphics.vector.ImageTree;
import com.renderx.graphics.vector.Link;
import com.renderx.graphics.vector.OpaqueColor;
import com.renderx.graphics.vector.PaintServer;
import com.renderx.graphics.vector.PaintSpec;
import com.renderx.graphics.vector.Path;
import com.renderx.graphics.vector.StrokeSpec;
import com.renderx.graphics.vector.Subpath;
import com.renderx.graphics.vector.Text;
import com.renderx.pdflib.ColorSpace;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFException;
import com.renderx.pdflib.PDFExternalFileException;
import com.renderx.pdflib.PDFIOException;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.Page;
import com.renderx.pdflib.Resources;
import com.renderx.pdflib.SMask;
import com.renderx.pdflib.parser.PDFDictionary;
import com.renderx.pdflib.parser.PDFIndirectObject;
import com.renderx.pdflib.parser.PDFInstance;
import com.renderx.pdflib.parser.PDFNumeric;
import com.renderx.pdflib.parser.PDFStream;
import com.renderx.pdflib.parser.PDFUniversalObject;
import com.renderx.pdflib.parser.Rectangle;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import java.io.IOException;
import java.util.Enumeration;

public class PDFImage
extends PDFObject {
    Image image;
    ImageTree imageTree;
    int length;
    IndirectObject length_id;
    IndirectObject cspace_id = null;
    IndirectObject smask_id = null;
    PDFDictionary resources = null;
    Resources formResources = null;
    boolean isSoftMask = false;
    boolean clippingPending = false;
    boolean simpleClipping = false;
    Hashtable subTrees = new Hashtable();
    Hashtable subIds = new Hashtable();
    String lastSubobjName;
    double[] clipMatrix = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
    double[] contentMatrix = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
    int subcount = 0;
    int markedContentsCount = -1;
    ColorSpace colorSpace = ColorSpace.cs_undefined;
    PDFImageColorSpace colorSpaceObject = null;

    PDFImage(IndirectObject indirectObject, Image image) throws UnregisteredMIMETypeException {
        super(indirectObject);
        this.image = image;
        this.imageTree = null;
        try {
            if (this.image instanceof VectorImage) {
                VectorImage vectorImage = (VectorImage)this.image;
                if (vectorImage.supportsVectorRendering) {
                    this.imageTree = vectorImage.getImageTree();
                    return;
                }
                if (vectorImage.hasBitmapPreview) {
                    this.image = vectorImage.getBitmapPreview();
                    return;
                }
                if (vectorImage.supportsRasterizing) {
                    this.image = vectorImage.rasterize(300.0);
                    return;
                }
                throw new UnregisteredMIMETypeException("Unsupported format " + image.mimetype + " for image '" + image.toDisplayString() + "'");
            }
        }
        catch (ImageFormatException imageFormatException) {
            this.image = null;
            throw new PDFException(imageFormatException);
        }
        catch (IOException iOException) {
            this.image = null;
            throw new PDFException(iOException);
        }
    }

    void checkPDFXColorSpace() {
        if (this.image instanceof BitmapImage) {
            BitmapImage bitmapImage = (BitmapImage)this.image;
            if (bitmapImage.colorSpace == 1) {
                throw new PDFException("Image '" + this.image.toDisplayString() + "' has RGB color space " + "that is not allowed in PDF/X");
            }
            if (bitmapImage.colorSpace == 6) {
                throw new PDFException("Image '" + this.image.toDisplayString() + "' has Indexed color space " + "with RGB colorants that is not allowed in PDF/X");
            }
        }
        if (this.image instanceof PDFInstance) {
            throw new PDFException("Image '" + this.image.toDisplayString() + "' is a PDF image " + "that is not allowed in PDF/X");
        }
    }

    double getWidth() {
        return this.image == null ? 0.0 : this.image.width;
    }

    double getHeight() {
        return this.image == null ? 0.0 : this.image.height;
    }

    String getType() {
        return "XObject";
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        if (this.image == null) {
            return;
        }
        this.length_id = pDFOutputStream.getNextID();
        if (this.image instanceof BitmapImage) {
            int n;
            pDFOutputStream.println("/Subtype/Image");
            BitmapImage bitmapImage = (BitmapImage)this.image;
            pDFOutputStream.println("/Width " + bitmapImage.pxWidth);
            pDFOutputStream.println("/Height " + bitmapImage.pxHeight);
            if (this.isSoftMask) {
                pDFOutputStream.println("/ColorSpace /DeviceGray");
            } else {
                switch (bitmapImage.colorSpace) {
                    case 1: {
                        pDFOutputStream.println("/ColorSpace /DeviceRGB");
                        break;
                    }
                    case 2: {
                        pDFOutputStream.println("/ColorSpace /DeviceCMYK");
                        break;
                    }
                    case 3: {
                        pDFOutputStream.println("/ColorSpace /DeviceCMYK");
                        pDFOutputStream.println("/Decode [1 0 1 0 1 0 1 0]");
                        break;
                    }
                    case 4: {
                        pDFOutputStream.println("/ColorSpace /DeviceGray");
                        break;
                    }
                    case 5: {
                        pDFOutputStream.println("/ColorSpace /DeviceGray");
                        pDFOutputStream.println("/Decode [1 0]");
                        break;
                    }
                    case 6: {
                        n = bitmapImage.colorTable.length / 3;
                        this.cspace_id = pDFOutputStream.getNextID();
                        pDFOutputStream.getNextID();
                        pDFOutputStream.println("/ColorSpace [/Indexed /DeviceRGB " + (n - 1) + " " + this.cspace_id.toStringR() + "]");
                    }
                }
            }
            pDFOutputStream.println("/BitsPerComponent " + bitmapImage.bitsPerComponent);
            if (bitmapImage.transparentColor != null && !this.isSoftMask) {
                pDFOutputStream.print("/Mask [");
                n = 0;
                while (n < bitmapImage.transparentColor.length) {
                    if (n > 0) {
                        pDFOutputStream.print(" ");
                    }
                    int n2 = bitmapImage.transparentColor[n] & 0xFF;
                    pDFOutputStream.print("" + n2 + " " + n2);
                    ++n;
                }
                pDFOutputStream.println("]");
            }
            if (bitmapImage.separatedAlphaChannel && !this.isSoftMask) {
                if (pDFOutputStream.doc.getPDFVersion_major() != 1 || pDFOutputStream.doc.getPDFVersion_minor() < 4) {
                    pDFOutputStream.warning("PDF version " + pDFOutputStream.doc.pdfVersion + " does not support opacity; " + "an image may have look as fully opaque; please set PDF 1.4.");
                }
                this.smask_id = pDFOutputStream.getNextID();
                pDFOutputStream.println("/SMask " + this.smask_id.toStringR());
            }
        }
    }

    void writeTail(PDFOutputStream pDFOutputStream) {
        if (this.image == null) {
            pDFOutputStream.println(">>\nendobj");
            return;
        }
        if (this.image instanceof BitmapImage) {
            BitmapImage bitmapImage = (BitmapImage)this.image;
            if (bitmapImage.canCopyData) {
                this.copyBitmapData(pDFOutputStream);
            } else {
                this.expandBitmapData(pDFOutputStream);
            }
        } else if (this.image instanceof PDFInstance) {
            try {
                this.copyContent(pDFOutputStream);
            }
            catch (Exception exception) {
                pDFOutputStream.exception("Cannot copy the contents of a PDF image", exception);
            }
        } else if (this.image instanceof VectorImage && this.imageTree != null) {
            this.writeImageTree(pDFOutputStream);
        }
    }

    private void copyContent(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.println("/Subtype/Form");
        PDFInstance pDFInstance = (PDFInstance)((PDFInstance)this.image).clone();
        pDFInstance.converObjects.clear();
        pDFInstance.pendingObjects.clear();
        PDFDictionary pDFDictionary = null;
        try {
            try {
                pDFInstance.open();
                try {
                    try {
                        Rectangle rectangle = pDFInstance.getMediaBox();
                        pDFDictionary = pDFInstance.getDictionary(pDFInstance.getPage());
                        pDFOutputStream.println("/BBox [" + PDFOutputStream.pdf_float(rectangle.x1) + " " + PDFOutputStream.pdf_float(rectangle.y1) + " " + PDFOutputStream.pdf_float(rectangle.x2) + " " + PDFOutputStream.pdf_float(rectangle.y2) + "]");
                        float f = 1.0f;
                        float f2 = 1.0f;
                        double[] dArray = new double[6];
                        switch (pDFInstance.angle) {
                            case 0: {
                                dArray[0] = f;
                                dArray[1] = 0.0;
                                dArray[2] = 0.0;
                                dArray[3] = f2;
                                dArray[4] = -rectangle.x1 * (double)f;
                                dArray[5] = -rectangle.y1 * (double)f2;
                                break;
                            }
                            case 90: {
                                dArray[0] = 0.0;
                                dArray[1] = -f;
                                dArray[2] = f2;
                                dArray[3] = 0.0;
                                dArray[4] = -rectangle.y1 * (double)f2;
                                dArray[5] = rectangle.x2 * (double)f;
                                break;
                            }
                            case 180: {
                                dArray[0] = -f;
                                dArray[1] = 0.0;
                                dArray[2] = 0.0;
                                dArray[3] = -f2;
                                dArray[4] = rectangle.x2 * (double)f;
                                dArray[5] = rectangle.y2 * (double)f2;
                                break;
                            }
                            case 270: {
                                dArray[0] = 0.0;
                                dArray[1] = f;
                                dArray[2] = -f2;
                                dArray[3] = 0.0;
                                dArray[4] = rectangle.y2 * (double)f2;
                                dArray[5] = -rectangle.x1 * (double)f;
                            }
                        }
                        pDFOutputStream.println("/Matrix [" + PDFOutputStream.pdf_float(dArray[0]) + " " + PDFOutputStream.pdf_float(dArray[1]) + " " + PDFOutputStream.pdf_float(dArray[2]) + " " + PDFOutputStream.pdf_float(dArray[3]) + " " + PDFOutputStream.pdf_float(dArray[4]) + " " + PDFOutputStream.pdf_float(dArray[5]) + "]");
                        if (pDFDictionary.dict.containsKey("/Filter")) {
                            pDFOutputStream.println("/Filter " + pDFDictionary.dict.get("/Filter").toString());
                        } else if (pDFOutputStream.compression) {
                            pDFOutputStream.println("/Filter /FlateDecode");
                        }
                        try {
                            this.resources = pDFInstance.getResources();
                        }
                        catch (ClassCastException classCastException) {
                            throw new PDFExternalFileException("Broken pdf file " + pDFInstance.toDisplayString());
                        }
                    }
                    catch (IOException iOException) {
                        pDFOutputStream.exception("", iOException);
                        pDFOutputStream.println(">>\nendobj");
                        Object var10_16 = null;
                        pDFInstance.close();
                        PDFInstance pDFInstance2 = pDFInstance;
                        synchronized (pDFInstance2) {
                            ((PDFInstance)this.image).converObjects = (Hashtable)pDFInstance.converObjects.clone();
                            ((PDFInstance)this.image).pendingObjects = (List)pDFInstance.pendingObjects.clone();
                        }
                        return;
                    }
                }
                catch (ImageFormatException imageFormatException) {
                    pDFOutputStream.exception("", imageFormatException);
                    pDFOutputStream.println(">>\nendobj");
                    Object var10_17 = null;
                    pDFInstance.close();
                    PDFInstance pDFInstance3 = pDFInstance;
                    synchronized (pDFInstance3) {
                        ((PDFInstance)this.image).converObjects = (Hashtable)pDFInstance.converObjects.clone();
                        ((PDFInstance)this.image).pendingObjects = (List)pDFInstance.pendingObjects.clone();
                    }
                    return;
                }
                try {
                    pDFOutputStream.println("/Resources");
                    this.resources.write(pDFOutputStream, pDFInstance);
                    pDFOutputStream.println("/Length " + this.length_id.toStringR());
                    pDFOutputStream.println(">>");
                }
                catch (IOException iOException) {
                    pDFOutputStream.exception("", iOException);
                    pDFOutputStream.println(">>\nendobj");
                    Object var10_18 = null;
                    pDFInstance.close();
                    PDFInstance pDFInstance4 = pDFInstance;
                    synchronized (pDFInstance4) {
                        ((PDFInstance)this.image).converObjects = (Hashtable)pDFInstance.converObjects.clone();
                        ((PDFInstance)this.image).pendingObjects = (List)pDFInstance.pendingObjects.clone();
                    }
                    return;
                }
                pDFOutputStream.println("stream");
                try {
                    try {
                        int n = pDFOutputStream.size();
                        if (pDFDictionary.dict.containsKey("/Filter")) {
                            pDFOutputStream.startCompressedStream();
                        } else {
                            pDFOutputStream.startStream();
                        }
                        pDFInstance.getContent(pDFOutputStream);
                        if (pDFDictionary.dict.containsKey("/Filter")) {
                            pDFOutputStream.finishCompressedStream();
                        } else {
                            pDFOutputStream.finishStream();
                        }
                        this.length = pDFOutputStream.size() - n;
                    }
                    catch (IOException iOException) {
                        pDFOutputStream.exception("", iOException);
                    }
                }
                catch (ImageFormatException imageFormatException) {
                    pDFOutputStream.exception("", imageFormatException);
                }
                pDFOutputStream.println("\nendstream");
                pDFOutputStream.println("endobj");
                Object var10_19 = null;
            }
            catch (Throwable throwable) {
                Object var10_20 = null;
                pDFInstance.close();
                PDFInstance pDFInstance5 = pDFInstance;
                synchronized (pDFInstance5) {
                    ((PDFInstance)this.image).converObjects = (Hashtable)pDFInstance.converObjects.clone();
                    ((PDFInstance)this.image).pendingObjects = (List)pDFInstance.pendingObjects.clone();
                }
                throw throwable;
            }
            pDFInstance.close();
            PDFInstance pDFInstance6 = pDFInstance;
            synchronized (pDFInstance6) {
                ((PDFInstance)this.image).converObjects = (Hashtable)pDFInstance.converObjects.clone();
                ((PDFInstance)this.image).pendingObjects = (List)pDFInstance.pendingObjects.clone();
            }
        }
        catch (IOException iOException) {
            pDFOutputStream.exception("", iOException);
        }
    }

    private void writeImageTree(PDFOutputStream pDFOutputStream) {
        boolean bl;
        pDFOutputStream.println("/Subtype/Form");
        IndirectObject indirectObject = pDFOutputStream.getNextID();
        pDFOutputStream.doc.currentResources = this.formResources = new Resources(indirectObject);
        pDFOutputStream.doc.currentColorSpace = this.colorSpace;
        pDFOutputStream.println("/BBox [" + PDFOutputStream.pdf_float(this.imageTree.startX) + " " + PDFOutputStream.pdf_float(this.imageTree.startY) + " " + PDFOutputStream.pdf_float(this.imageTree.startX + this.imageTree.width) + " " + PDFOutputStream.pdf_float(this.imageTree.startY + this.imageTree.height) + "]");
        pDFOutputStream.println("/Length " + this.length_id.toStringR());
        pDFOutputStream.println("/Resources " + indirectObject.toStringR());
        boolean bl2 = bl = ((VectorImage)this.image).transparencyGroup && !pDFOutputStream.doc.hasPDFA() && !pDFOutputStream.doc.hasPDFX() && pDFOutputStream.doc.getPDFVersion_major() >= 1 && pDFOutputStream.doc.getPDFVersion_minor() >= 4;
        if (bl) {
            this.colorSpaceObject = new PDFImageColorSpace(pDFOutputStream.getNextID(), this.colorSpace);
            pDFOutputStream.print("/Group " + this.colorSpaceObject.getID().toStringR());
        }
        if (pDFOutputStream.compression) {
            pDFOutputStream.println("/Filter /FlateDecode");
        }
        pDFOutputStream.println(">>");
        pDFOutputStream.println("stream");
        try {
            int n = pDFOutputStream.size();
            pDFOutputStream.startStream();
            pDFOutputStream.doc.setCharSpacing(0.0f);
            pDFOutputStream.doc.setWordSpacing(0.0f);
            this.PaintGraphicObject(pDFOutputStream, this.imageTree.root);
            pDFOutputStream.finishStream();
            this.length = pDFOutputStream.size() - n;
        }
        catch (IOException iOException) {
            pDFOutputStream.exception("", iOException);
        }
        pDFOutputStream.println("\nendstream");
        pDFOutputStream.println("endobj");
        pDFOutputStream.doc.currentColorSpace = null;
        pDFOutputStream.doc.currentResources = null;
    }

    void PaintGraphicObject(PDFOutputStream pDFOutputStream, GraphicObject graphicObject) throws IOException {
        if (graphicObject instanceof GraphicGroup) {
            GraphicGroup graphicGroup = (GraphicGroup)graphicObject;
            boolean bl = false;
            boolean bl2 = false;
            double[] dArray = this.contentMatrix;
            double[] dArray2 = this.contentMatrix;
            if (!this.clippingPending) {
                boolean bl3 = bl = !graphicGroup.isIdentityTransform() || graphicGroup.clippath != null || graphicGroup.opacity != 1.0;
                if (bl) {
                    pDFOutputStream.println("q");
                }
                if (!graphicGroup.isIdentityTransform()) {
                    this.printMatrix(pDFOutputStream, graphicGroup.matrix);
                    dArray2 = GraphicObject.multipleMatrix(this.contentMatrix, graphicGroup.matrix);
                }
                if (graphicGroup.clippath != null) {
                    bl2 = true;
                    this.clippingPending = true;
                    GraphicGroup graphicGroup2 = graphicGroup.clippath;
                    this.simpleClipping = graphicGroup2.isSimple();
                    graphicGroup = (GraphicGroup)graphicGroup.clone();
                    graphicGroup.clippath = null;
                    graphicGroup.matrix = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                    if (!this.simpleClipping) {
                        this.addVectorImageSubObject(pDFOutputStream, graphicGroup, dArray2);
                    }
                    this.PaintGraphicObject(pDFOutputStream, graphicGroup2);
                    if (this.simpleClipping) {
                        this.clippingPending = false;
                        this.PaintGraphicObject(pDFOutputStream, graphicGroup);
                    }
                } else if (graphicGroup.opacity != 1.0) {
                    double d = graphicGroup.opacity;
                    graphicGroup = (GraphicGroup)graphicGroup.clone();
                    graphicGroup.opacity = 1.0;
                    graphicGroup.matrix = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                    this.addVectorImageSubObject(pDFOutputStream, graphicGroup, dArray2);
                    pDFOutputStream.doc.setAlphaIsShape(false);
                    pDFOutputStream.doc.setOpacityFill(d);
                    pDFOutputStream.doc.setOpacityStroke(d);
                    pDFOutputStream.println("/" + this.lastSubobjName + " Do");
                } else if (PDFImage.isPaintServer(graphicGroup.fill) || graphicGroup.stroke != null && PDFImage.isPaintServer(graphicGroup.stroke.paint)) {
                    if (PDFImage.isPaintServer(graphicGroup.fill)) {
                        this.writePaintServer(graphicGroup.fill, graphicGroup, dArray2, pDFOutputStream);
                    }
                    if (graphicGroup.stroke != null && PDFImage.isPaintServer(graphicGroup.stroke.paint)) {
                        this.writePaintServer(graphicGroup.stroke.paint, graphicGroup, dArray2, pDFOutputStream);
                    }
                } else {
                    Enumeration enumeration = graphicGroup.children.elements();
                    while (enumeration.hasMoreElements()) {
                        this.contentMatrix = dArray2;
                        this.PaintGraphicObject(pDFOutputStream, (GraphicObject)enumeration.nextElement());
                    }
                    this.contentMatrix = dArray;
                }
                if (bl2) {
                    this.clippingPending = false;
                }
                if (bl) {
                    pDFOutputStream.println("Q");
                }
            } else {
                double[] dArray3;
                if (graphicGroup.clippath != null) {
                    // empty if block
                }
                double[] dArray4 = this.clipMatrix;
                double[] dArray5 = dArray3 = graphicGroup.isIdentityTransform() ? this.clipMatrix : GraphicObject.multipleMatrix(this.clipMatrix, graphicGroup.matrix);
                if (this.simpleClipping && graphicGroup.children.length() > 1) {
                    pDFOutputStream.error("Unexpected number of elements in the clipPath; expected zero or one, found: " + graphicGroup.children.length());
                }
                Enumeration enumeration = graphicGroup.children.elements();
                while (enumeration.hasMoreElements()) {
                    this.clipMatrix = dArray3;
                    GraphicObject graphicObject2 = (GraphicObject)enumeration.nextElement();
                    if (graphicObject2 instanceof Contour) {
                        if (!this.simpleClipping) {
                            pDFOutputStream.println("q");
                        }
                        if (!GraphicObject.isIdentityTransform(this.clipMatrix)) {
                            this.printMatrix(pDFOutputStream, this.clipMatrix);
                        }
                        this.PaintGraphicObject(pDFOutputStream, graphicObject2);
                        if (!GraphicObject.isIdentityTransform(this.clipMatrix)) {
                            this.printMatrix(pDFOutputStream, GraphicObject.reverseMatrix(this.clipMatrix));
                        }
                        if (this.simpleClipping) continue;
                        pDFOutputStream.println("/" + this.lastSubobjName + " Do");
                        pDFOutputStream.println("Q");
                        continue;
                    }
                    if (graphicObject2 instanceof GraphicGroup) {
                        this.PaintGraphicObject(pDFOutputStream, graphicObject2);
                        continue;
                    }
                    pDFOutputStream.warning("Unexpected element in the clipPath: " + graphicObject2.getClass() + " skipping...");
                }
                this.clipMatrix = dArray4;
            }
        } else if (graphicObject instanceof Contour) {
            boolean bl;
            Contour contour = (Contour)graphicObject;
            boolean bl4 = contour.fill != null;
            boolean bl5 = bl = contour.stroke != null && contour.stroke.paint != null;
            if (!(bl4 || bl || this.clippingPending)) {
                return;
            }
            if (this.isNewGS(contour)) {
                pDFOutputStream.println("q");
            }
            if (bl4) {
                this.PaintFillSpec(pDFOutputStream, contour.fill, contour.fillOpacity);
            }
            if (bl) {
                this.PaintStrokeSpec(pDFOutputStream, contour.stroke, contour.strokeOpacity);
            }
            if (contour instanceof Path) {
                Enumeration enumeration = ((Path)contour).subs.elements();
                while (enumeration.hasMoreElements()) {
                    this.PaintSubpath(pDFOutputStream, (Subpath)enumeration.nextElement());
                }
                if (this.clippingPending) {
                    pDFOutputStream.println(contour.clipRule == 0 ? "W" : "W*");
                    pDFOutputStream.println("n");
                } else if (bl4 && bl) {
                    if (contour.strokeOpacity != 1.0) {
                        pDFOutputStream.println(contour.fillRule == 0 ? "f" : "f*");
                        enumeration = ((Path)contour).subs.elements();
                        while (enumeration.hasMoreElements()) {
                            this.PaintSubpath(pDFOutputStream, (Subpath)enumeration.nextElement());
                        }
                        pDFOutputStream.println("S");
                    } else {
                        pDFOutputStream.println(contour.fillRule == 0 ? "B" : "B*");
                    }
                } else if (bl4) {
                    pDFOutputStream.println(contour.fillRule == 0 ? "f" : "f*");
                } else if (bl) {
                    pDFOutputStream.println("S");
                }
            } else if (contour instanceof Text) {
                Text text = (Text)contour;
                pDFOutputStream.startText();
                pDFOutputStream.doc.setFontSize((float)text.font.size);
                pDFOutputStream.doc.setHorzScale((float)text.font.stretch);
                pDFOutputStream.doc.u28.selectFont(text.font.family, text.font.weight, text.font.style, text.font.variant);
                if (this.clippingPending) {
                    pDFOutputStream.println("7 Tr");
                } else if (bl4 && bl) {
                    if (contour.strokeOpacity != 1.0) {
                        pDFOutputStream.println("0 Tr");
                        pDFOutputStream.doc.setTextPos((float)text.x, (float)text.y);
                        pDFOutputStream.doc.u28.processText(new String(text.value));
                        pDFOutputStream.endText();
                        pDFOutputStream.startText();
                        pDFOutputStream.println("1 Tr");
                    } else {
                        pDFOutputStream.println("2 Tr");
                    }
                } else if (bl) {
                    pDFOutputStream.println("1 Tr");
                } else if (bl4) {
                    pDFOutputStream.println("0 Tr");
                }
                pDFOutputStream.doc.setTextPos((float)text.x, (float)text.y);
                pDFOutputStream.doc.u28.processText(new String(text.value));
                pDFOutputStream.endText();
            }
            if (this.isNewGS(contour)) {
                pDFOutputStream.println("Q");
            }
        } else if (graphicObject instanceof ExternalImage) {
            ExternalImage externalImage = (ExternalImage)graphicObject;
            try {
                pDFOutputStream.doc.placeImage(externalImage.image);
            }
            catch (Exception exception) {
                pDFOutputStream.exception("Cannot parse image: ", exception);
            }
        } else if (graphicObject instanceof Link) {
            Link link = (Link)graphicObject;
            pDFOutputStream.doc.addWebLink((float)link.xfrom, (float)link.yfrom, (float)link.xtill, (float)link.ytill, link.dest, link.show, null);
        }
    }

    boolean isNewGS(Contour contour) {
        return contour.fill != null && contour.fillOpacity != 1.0 || contour.stroke != null && contour.strokeOpacity != 1.0 || PDFImage.isPaintServer(contour.fill) || contour.stroke != null && PDFImage.isPaintServer(contour.stroke.paint);
    }

    void addVectorImageSubObject(PDFOutputStream pDFOutputStream, GraphicGroup graphicGroup, double[] dArray) {
        IndirectObject indirectObject = pDFOutputStream.getNextID();
        this.lastSubobjName = "Img" + this.subcount;
        this.formResources.addImage("/" + this.lastSubobjName + " " + indirectObject.toStringR());
        double[] dArray2 = PDFImage.calcBBox(this.imageTree.startX, this.imageTree.startY, this.imageTree.width, this.imageTree.height, GraphicObject.reverseMatrix(dArray));
        ImageTree imageTree = new ImageTree(dArray2[0], dArray2[1], dArray2[2] - dArray2[0], dArray2[3] - dArray2[1]);
        imageTree.root = graphicGroup;
        SubTreeVectorImage subTreeVectorImage = new SubTreeVectorImage(imageTree);
        subTreeVectorImage.supportsVectorRendering = true;
        this.subTrees.put(this.lastSubobjName, subTreeVectorImage);
        this.subIds.put(this.lastSubobjName, indirectObject);
        ++this.subcount;
    }

    void PaintSubpath(PDFOutputStream pDFOutputStream, Subpath subpath) throws IOException {
        pDFOutputStream.println("" + PDFOutputStream.pdf_float(subpath.startX) + " " + PDFOutputStream.pdf_float(subpath.startY) + " m");
        Enumeration enumeration = subpath.segs.elements();
        while (enumeration.hasMoreElements()) {
            Subpath.Segment segment;
            Subpath.Segment segment2 = (Subpath.Segment)enumeration.nextElement();
            if (segment2 instanceof Subpath.Line) {
                segment = (Subpath.Line)segment2;
                pDFOutputStream.println("" + PDFOutputStream.pdf_float(segment.xend) + " " + PDFOutputStream.pdf_float(segment.yend) + " l");
                continue;
            }
            if (!(segment2 instanceof Subpath.Curve)) continue;
            segment = (Subpath.Curve)segment2;
            pDFOutputStream.println("" + PDFOutputStream.pdf_float(((Subpath.Curve)segment).cpx1) + " " + PDFOutputStream.pdf_float(((Subpath.Curve)segment).cpy1) + " " + PDFOutputStream.pdf_float(((Subpath.Curve)segment).cpx2) + " " + PDFOutputStream.pdf_float(((Subpath.Curve)segment).cpy2) + " " + PDFOutputStream.pdf_float(((Subpath.Curve)segment).xend) + " " + PDFOutputStream.pdf_float(((Subpath.Curve)segment).yend) + " c");
        }
        if (subpath.closed) {
            pDFOutputStream.println("h");
        }
    }

    void PaintFillSpec(PDFOutputStream pDFOutputStream, PaintSpec paintSpec, double d) throws IOException {
        if (d != 1.0) {
            pDFOutputStream.doc.setOpacityFill(d);
            pDFOutputStream.doc.setAlphaIsShape(false);
        }
        if (paintSpec instanceof OpaqueColor.Grayscale) {
            OpaqueColor.Grayscale grayscale = (OpaqueColor.Grayscale)paintSpec;
            pDFOutputStream.doc.setGrayFill((float)grayscale.g);
        } else if (paintSpec instanceof OpaqueColor.RGB) {
            OpaqueColor.RGB rGB = (OpaqueColor.RGB)paintSpec;
            pDFOutputStream.doc.setRGBColorFill((float)rGB.r, (float)rGB.g, (float)rGB.b);
        } else if (paintSpec instanceof OpaqueColor.CMYK) {
            OpaqueColor.CMYK cMYK = (OpaqueColor.CMYK)paintSpec;
            pDFOutputStream.doc.setCMYKColorFill((float)cMYK.c, (float)cMYK.m, (float)cMYK.y, (float)cMYK.k);
        } else if (paintSpec instanceof OpaqueColor.SpotColor) {
            OpaqueColor.SpotColor spotColor = (OpaqueColor.SpotColor)paintSpec;
            float[] fArray = new float[]{0.0f};
            if (spotColor.altcolor != null) {
                if (spotColor.altcolor instanceof OpaqueColor.Grayscale) {
                    OpaqueColor.Grayscale grayscale = (OpaqueColor.Grayscale)spotColor.altcolor;
                    fArray = new float[]{(float)grayscale.g};
                } else if (spotColor.altcolor instanceof OpaqueColor.RGB) {
                    OpaqueColor.RGB rGB = (OpaqueColor.RGB)spotColor.altcolor;
                    fArray = new float[]{(float)rGB.r, (float)rGB.g, (float)rGB.b};
                } else if (spotColor.altcolor instanceof OpaqueColor.CMYK) {
                    OpaqueColor.CMYK cMYK = (OpaqueColor.CMYK)spotColor.altcolor;
                    fArray = new float[]{(float)cMYK.c, (float)cMYK.m, (float)cMYK.y, (float)cMYK.k};
                }
            }
            pDFOutputStream.doc.setSpotColorFill((float)spotColor.tint, spotColor.colorant, fArray);
        } else if (paintSpec instanceof OpaqueColor.Registration) {
            OpaqueColor.Registration registration = (OpaqueColor.Registration)paintSpec;
            pDFOutputStream.doc.setSpotColorFill((float)registration.tint, "All", new float[]{0.0f});
        } else if (paintSpec instanceof PaintServer) {
            if (this.isSoftMask) {
                Gradient gradient = ((Gradient)paintSpec).createSoftMaskGradient();
                pDFOutputStream.doc.setPatternFill(gradient);
            } else {
                if (PDFImage.isOpacityGradient(paintSpec)) {
                    pDFOutputStream.doc.setSoftMask((Gradient)paintSpec);
                }
                pDFOutputStream.doc.setPatternFill((PaintServer)paintSpec);
            }
        }
    }

    void PaintStrokeSpec(PDFOutputStream pDFOutputStream, StrokeSpec strokeSpec, double d) throws IOException {
        OpaqueColor opaqueColor;
        if (d != 1.0) {
            pDFOutputStream.doc.setOpacityStroke(d);
            pDFOutputStream.doc.setAlphaIsShape(false);
        }
        if (strokeSpec.paint instanceof OpaqueColor.Grayscale) {
            opaqueColor = (OpaqueColor.Grayscale)strokeSpec.paint;
            pDFOutputStream.doc.setGrayStroke((float)opaqueColor.g);
        } else if (strokeSpec.paint instanceof OpaqueColor.RGB) {
            opaqueColor = (OpaqueColor.RGB)strokeSpec.paint;
            pDFOutputStream.doc.setRGBColorStroke((float)((OpaqueColor.RGB)opaqueColor).r, (float)((OpaqueColor.RGB)opaqueColor).g, (float)((OpaqueColor.RGB)opaqueColor).b);
        } else if (strokeSpec.paint instanceof OpaqueColor.CMYK) {
            opaqueColor = (OpaqueColor.CMYK)strokeSpec.paint;
            pDFOutputStream.doc.setCMYKColorStroke((float)((OpaqueColor.CMYK)opaqueColor).c, (float)((OpaqueColor.CMYK)opaqueColor).m, (float)((OpaqueColor.CMYK)opaqueColor).y, (float)((OpaqueColor.CMYK)opaqueColor).k);
        } else if (strokeSpec.paint instanceof OpaqueColor.SpotColor) {
            opaqueColor = (OpaqueColor.SpotColor)strokeSpec.paint;
            float[] fArray = new float[]{0.0f};
            if (((OpaqueColor.SpotColor)opaqueColor).altcolor != null) {
                OpaqueColor opaqueColor2;
                if (((OpaqueColor.SpotColor)opaqueColor).altcolor instanceof OpaqueColor.Grayscale) {
                    opaqueColor2 = (OpaqueColor.Grayscale)((OpaqueColor.SpotColor)opaqueColor).altcolor;
                    fArray = new float[]{(float)opaqueColor2.g};
                } else if (((OpaqueColor.SpotColor)opaqueColor).altcolor instanceof OpaqueColor.RGB) {
                    opaqueColor2 = (OpaqueColor.RGB)((OpaqueColor.SpotColor)opaqueColor).altcolor;
                    fArray = new float[]{(float)((OpaqueColor.RGB)opaqueColor2).r, (float)((OpaqueColor.RGB)opaqueColor2).g, (float)((OpaqueColor.RGB)opaqueColor2).b};
                } else if (((OpaqueColor.SpotColor)opaqueColor).altcolor instanceof OpaqueColor.CMYK) {
                    opaqueColor2 = (OpaqueColor.CMYK)((OpaqueColor.SpotColor)opaqueColor).altcolor;
                    fArray = new float[]{(float)((OpaqueColor.CMYK)opaqueColor2).c, (float)((OpaqueColor.CMYK)opaqueColor2).m, (float)((OpaqueColor.CMYK)opaqueColor2).y, (float)((OpaqueColor.CMYK)opaqueColor2).k};
                }
            }
            pDFOutputStream.doc.setSpotColorStroke((float)((OpaqueColor.SpotColor)opaqueColor).tint, ((OpaqueColor.SpotColor)opaqueColor).colorant, fArray);
        } else if (strokeSpec.paint instanceof OpaqueColor.Registration) {
            opaqueColor = (OpaqueColor.Registration)strokeSpec.paint;
            pDFOutputStream.doc.setSpotColorStroke((float)((OpaqueColor.Registration)opaqueColor).tint, "All", new float[]{0.0f});
        } else if (strokeSpec.paint instanceof PaintServer) {
            if (PDFImage.isOpacityGradient(strokeSpec.paint)) {
                pDFOutputStream.doc.setSoftMask((Gradient)strokeSpec.paint);
            }
            pDFOutputStream.doc.setPatternStroke((PaintServer)strokeSpec.paint);
        }
        pDFOutputStream.println("" + PDFOutputStream.pdf_float(strokeSpec.thickness) + " w ");
        pDFOutputStream.println("" + strokeSpec.lineCap + " J");
        pDFOutputStream.println("" + strokeSpec.lineJoin + " j");
        if (strokeSpec.lineJoin == 0) {
            pDFOutputStream.println("" + PDFOutputStream.pdf_float(strokeSpec.miterLimit) + " M");
        }
        if (strokeSpec.dashArray == null) {
            pDFOutputStream.println("[] 0 d");
        } else {
            pDFOutputStream.print("[");
            int n = 0;
            while (n < strokeSpec.dashArray.length) {
                if (n > 0) {
                    pDFOutputStream.print(" ");
                }
                pDFOutputStream.print("" + PDFOutputStream.pdf_float(strokeSpec.dashArray[n]));
                ++n;
            }
            pDFOutputStream.println("] " + PDFOutputStream.pdf_float(strokeSpec.dashPhase) + " d");
        }
    }

    private void writePaintServer(PaintSpec paintSpec, GraphicGroup graphicGroup, double[] dArray, PDFOutputStream pDFOutputStream) {
        Gradient gradient;
        graphicGroup = (GraphicGroup)graphicGroup.clone();
        graphicGroup.fill = null;
        graphicGroup.stroke = null;
        graphicGroup.matrix = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
        this.addVectorImageSubObject(pDFOutputStream, graphicGroup, dArray);
        pDFOutputStream.println("/" + this.lastSubobjName + " Do");
        Gradient gradient2 = gradient = paintSpec instanceof Gradient ? (Gradient)paintSpec : null;
        if (gradient != null && gradient.hasStopOpacity) {
            SMask sMask = pDFOutputStream.doc.getSoftMask(gradient);
            try {
                sMask.setContent(pDFOutputStream.getNextID(), graphicGroup, this.calcImageTreeBBox(dArray));
            }
            catch (UnregisteredMIMETypeException unregisteredMIMETypeException) {
                throw new PDFException(unregisteredMIMETypeException);
            }
        }
    }

    private void copyBitmapData(PDFOutputStream pDFOutputStream) {
        BitmapImage bitmapImage = (BitmapImage)this.image;
        switch (bitmapImage.compressionMethod) {
            case 7: {
                pDFOutputStream.println("/Filter /LZWDecode");
                pDFOutputStream.print("/DecodeParms <</EarlyChange 0");
                this.writePredictor(pDFOutputStream, bitmapImage, true);
                pDFOutputStream.println(">>");
                break;
            }
            case 8: {
                pDFOutputStream.println("/Filter /LZWDecode");
                this.writePredictor(pDFOutputStream, bitmapImage, false);
                break;
            }
            case 2: {
                pDFOutputStream.println("/Filter /FlateDecode");
                this.writePredictor(pDFOutputStream, bitmapImage, false);
                break;
            }
            case 4: {
                pDFOutputStream.println("/Filter /CCITTFaxDecode");
                pDFOutputStream.println("/DecodeParms <</K 0 /Columns " + bitmapImage.pxWidth + " /Rows " + bitmapImage.pxHeight + ">>");
                break;
            }
            case 5: {
                pDFOutputStream.println("/Filter /CCITTFaxDecode");
                pDFOutputStream.println("/DecodeParms <</K 1 /Columns " + bitmapImage.pxWidth + " /Rows " + bitmapImage.pxHeight + ">>");
                break;
            }
            case 6: {
                pDFOutputStream.println("/Filter /CCITTFaxDecode");
                pDFOutputStream.println("/DecodeParms <</K -1 /Columns " + bitmapImage.pxWidth + " /Rows " + bitmapImage.pxHeight + ">>");
                break;
            }
            case 3: {
                pDFOutputStream.println("/Filter /DCTDecode");
                break;
            }
            case 1: {
                pDFOutputStream.println("/Filter /RunLengthDecode");
                break;
            }
            default: {
                this.expandBitmapData(pDFOutputStream);
                return;
            }
        }
        pDFOutputStream.println("/Length " + this.length_id.toStringR());
        pDFOutputStream.println(">>");
        pDFOutputStream.println("stream");
        int n = pDFOutputStream.size();
        pDFOutputStream.startCompressedStream();
        try {
            bitmapImage.copyData(pDFOutputStream.getCurrentOutputStream());
        }
        catch (IOException iOException) {
            pDFOutputStream.exception("Image '" + bitmapImage.toDisplayString() + "' is not correct", iOException);
        }
        catch (ImageFormatException imageFormatException) {
            pDFOutputStream.exception("Image '" + bitmapImage.toDisplayString() + "' has broken format", imageFormatException);
        }
        pDFOutputStream.finishCompressedStream();
        this.length = pDFOutputStream.size() - n;
        pDFOutputStream.println("\nendstream");
        pDFOutputStream.println("endobj");
    }

    private void expandBitmapData(PDFOutputStream pDFOutputStream) {
        if (pDFOutputStream.compression) {
            pDFOutputStream.println("/Filter [/FlateDecode]");
        }
        pDFOutputStream.println("/Length " + this.length_id.toStringR());
        pDFOutputStream.println(">>");
        pDFOutputStream.println("stream");
        int n = pDFOutputStream.size();
        pDFOutputStream.startStream();
        try {
            if (this.isSoftMask) {
                if (this.image instanceof PNGImage) {
                    ((PNGImage)this.image).expandData(pDFOutputStream.getCurrentOutputStream(), null, true);
                }
            } else {
                ((BitmapImage)this.image).expandData(pDFOutputStream.getCurrentOutputStream());
            }
        }
        catch (IOException iOException) {
            pDFOutputStream.exception("Image '" + this.image.toDisplayString() + "' cannot be processed", iOException);
        }
        catch (ImageFormatException imageFormatException) {
            pDFOutputStream.exception("Image '" + this.image.toDisplayString() + "' has unrecognizable format", imageFormatException);
        }
        pDFOutputStream.finishStream();
        this.length = pDFOutputStream.size() - n;
        pDFOutputStream.println("\nendstream");
        pDFOutputStream.println("endobj");
    }

    /*
     * Unable to fully structure code
     */
    void writeSubObjects(PDFOutputStream var1_1) {
        block24: {
            if (this.image == null) {
                return;
            }
            var1_1.printLength(this.length_id, this.length);
            if (this.cspace_id != null) {
                var1_1.beginStream(this.cspace_id);
                var1_1.print(((BitmapImage)this.image).colorTable);
                var1_1.endStream();
            }
            if (this.formResources != null) {
                this.formResources.write(var1_1);
            }
            if (this.smask_id != null) {
                try {
                    var2_2 = new PDFImage(this.smask_id, this.image);
                    var2_2.isSoftMask = true;
                    var2_2.write(var1_1);
                }
                catch (UnregisteredMIMETypeException var2_3) {
                    throw new PDFException(var2_3);
                }
            }
            if (this.colorSpaceObject != null) {
                this.colorSpaceObject.write(var1_1);
            }
            var2_2 = this.subTrees.keys();
            while (var2_2.hasMoreElements()) {
                var3_4 = (String)var2_2.nextElement();
                var4_6 = (SubTreeVectorImage)this.subTrees.get(var3_4);
                var4_6.supportsVectorRendering = true;
                try {
                    var5_7 = new PDFImage((IndirectObject)this.subIds.get(var3_4), (Image)var4_6);
                    var5_7.write(var1_1);
                }
                catch (UnregisteredMIMETypeException var5_8) {
                    throw new PDFException(var5_8);
                }
            }
            if (this.image instanceof PDFInstance) {
                try {
                    var3_4 = (PDFInstance)((PDFInstance)this.image).clone();
                    var3_4.open();
                    var4_6 = "0";
                    var5_7 = new Integer(0);
                    try {
                        var6_9 = var3_4.getAnnotations();
                        var7_11 = 0;
                        while (var7_11 < var6_9.array.length()) {
                            var8_13 = (PDFIndirectObject)var6_9.array.get(var7_11);
                            var9_14 = var3_4.getObject(var8_13.intValue());
                            var10_15 = var3_4.getDictionary(var9_14);
                            var11_16 = (Rectangle)var10_15.dict.get("/Rect");
                            var12_17 = var3_4.parentPages.elements();
                            while (var12_17.hasMoreElements()) {
                                ++var1_1.lastObjectNumber;
                                var14_19 = (Object[])var12_17.nextElement();
                                var15_20 = (Page)var14_19[0];
                                var15_20.addLinkID(new IndirectObject(var13_18));
                                var11_16.setMatrix((double[])var14_19[1]);
                                var9_14.setID(var13_18);
                                var9_14.write(var1_1, (PDFInstance)var3_4);
                            }
                            ++var7_11;
                        }
                        while (!var3_4.pendingObjects.isEmpty()) {
                            var4_6 = (String)var3_4.pendingObjects.shift();
                            var5_7 = (Integer)var3_4.converObjects.get(var4_6);
                            var8_13 = var3_4.getObject(new Integer((String)var4_6));
                            if (var8_13.objdata instanceof PDFStream) {
                                var8_13.objdata = var3_4.getStream((PDFUniversalObject)var8_13);
                            }
                            var8_13.setID(var5_7.intValue());
                            var8_13.write(var1_1, (PDFInstance)var3_4);
                        }
                        var17_21 = null;
                        ** while (!var3_4.pendingObjects.isEmpty())
                    }
                    catch (Throwable var16_27) {
                        var17_23 = null;
                        ** while (!var3_4.pendingObjects.isEmpty())
                    }
lbl-1000:
                    // 1 sources

                    {
                        var4_6 = (String)var3_4.pendingObjects.shift();
                        var5_7 = (Integer)var3_4.converObjects.get(var4_6);
                        var18_24 = new PDFUniversalObject(var5_7.intValue());
                        var18_24.write(var1_1, (PDFInstance)var3_4);
                        continue;
                    }
lbl75:
                    // 1 sources

                    var3_4.close();
                    {
                        break block24;
                        catch (ImageFormatException var6_10) {
                            var1_1.warning(var6_10.getMessage());
                            var7_12 = new PDFUniversalObject(var5_7.intValue());
                            var7_12.objdata = new PDFNumeric("0", true);
                            var7_12.write(var1_1, (PDFInstance)var3_4);
                            var17_22 = null;
                            ** while (!var3_4.pendingObjects.isEmpty())
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        var4_6 = (String)var3_4.pendingObjects.shift();
                        var5_7 = (Integer)var3_4.converObjects.get(var4_6);
                        var18_25 = new PDFUniversalObject(var5_7.intValue());
                        var18_25.write(var1_1, (PDFInstance)var3_4);
                        continue;
                    }
lbl90:
                    // 1 sources

                    var3_4.close();
                    {
                        break block24;
                    }
lbl-1000:
                    // 1 sources

                    {
                        var4_6 = (String)var3_4.pendingObjects.shift();
                        var5_7 = (Integer)var3_4.converObjects.get(var4_6);
                        var18_26 = new PDFUniversalObject(var5_7.intValue());
                        var18_26.write(var1_1, (PDFInstance)var3_4);
                        continue;
                    }
lbl101:
                    // 1 sources

                    var3_4.close();
                    throw var16_27;
                }
                catch (IOException var3_5) {
                    var1_1.exception("", var3_5);
                }
            }
        }
    }

    private void writePredictor(PDFOutputStream pDFOutputStream, BitmapImage bitmapImage, boolean bl) {
        if (bitmapImage.predictor == 0) {
            return;
        }
        pDFOutputStream.print(bl ? " " : "/DecodeParms <<");
        switch (bitmapImage.predictor) {
            case 1: {
                pDFOutputStream.print("/Predictor 2");
                break;
            }
            case 2: {
                pDFOutputStream.print("/Predictor 15");
            }
        }
        pDFOutputStream.print(" /Columns " + bitmapImage.pxWidth);
        if (bitmapImage.bitsPerComponent != 8) {
            pDFOutputStream.print(" /BitsPerComponent " + bitmapImage.bitsPerComponent);
        }
        switch (bitmapImage.colorSpace) {
            case 1: {
                pDFOutputStream.print(" /Colors 3");
                break;
            }
            case 2: 
            case 3: {
                pDFOutputStream.print(" /Colors 4");
            }
        }
        if (!bl) {
            pDFOutputStream.println(">>");
        }
    }

    private void printMatrix(PDFOutputStream pDFOutputStream, double[] dArray) {
        pDFOutputStream.println("" + PDFOutputStream.pdf_float(dArray[0]) + " " + PDFOutputStream.pdf_float(dArray[1]) + " " + PDFOutputStream.pdf_float(dArray[2]) + " " + PDFOutputStream.pdf_float(dArray[3]) + " " + PDFOutputStream.pdf_float(dArray[4]) + " " + PDFOutputStream.pdf_float(dArray[5]) + " cm");
    }

    double[] calcImageTreeBBox(double[] dArray) {
        return PDFImage.calcBBox(this.imageTree.startX, this.imageTree.startY, this.image.width, this.imageTree.height, dArray);
    }

    static double[] calcBBox(double d, double d2, double d3, double d4, double[] dArray) {
        double[] dArray2;
        double[] dArray3 = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] dArray4 = GraphicObject.transformPoint(dArray, d, d2);
        if (dArray4[0] < (dArray2 = GraphicObject.transformPoint(dArray, d + d3, d2 + d4))[0]) {
            dArray3[0] = dArray4[0];
            dArray3[2] = dArray2[0];
        } else {
            dArray3[0] = dArray2[0];
            dArray3[2] = dArray4[0];
        }
        if (dArray4[1] < dArray2[1]) {
            dArray3[1] = dArray4[1];
            dArray3[3] = dArray2[1];
        } else {
            dArray3[1] = dArray2[1];
            dArray3[3] = dArray4[1];
        }
        return dArray3;
    }

    private static boolean isPaintServer(PaintSpec paintSpec) {
        if (paintSpec == null) {
            return false;
        }
        return paintSpec instanceof PaintServer;
    }

    static boolean isOpacityGradient(PaintSpec paintSpec) {
        if (paintSpec == null) {
            return false;
        }
        return paintSpec instanceof Gradient && ((Gradient)paintSpec).hasStopOpacity;
    }

    void setMarkedContentID() {
        ++this.markedContentsCount;
    }

    int getMarkedContentID() {
        return this.markedContentsCount;
    }

    static class PDFImageColorSpace
    extends PDFObject {
        ColorSpace cs;

        PDFImageColorSpace(IndirectObject indirectObject, ColorSpace colorSpace) {
            super(indirectObject);
            this.cs = colorSpace;
        }

        void writeBody(PDFOutputStream pDFOutputStream) throws PDFIOException {
            pDFOutputStream.print("/Type/Group /S/Transparency");
            if (this.cs.cs == 2) {
                pDFOutputStream.print(" /CS/DeviceCMYK");
            } else if (this.cs.cs == 1) {
                pDFOutputStream.print(" /CS/DeviceRGB");
            } else if (this.cs.cs == 4) {
                pDFOutputStream.print(" /CS/DeviceGray");
            }
            pDFOutputStream.println();
        }

        void writeSubObjects(PDFOutputStream pDFOutputStream) throws PDFIOException {
        }
    }

    static class SubTreeVectorImage
    extends VectorImage {
        ImageTree imageTree = null;

        public void parse() throws IOException, ImageFormatException {
        }

        public SubTreeVectorImage(ImageTree imageTree) {
            this.imageTree = imageTree;
        }

        public ImageTree getImageTree() throws IOException, ImageFormatException {
            return this.imageTree;
        }
    }
}

