/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.fonts.FontCatalog;
import com.renderx.fonts.FontConfigurationException;
import com.renderx.graphics.ImageFactory;
import com.renderx.graphics.ImageFormatException;
import com.renderx.pdflib.Encrypt;
import com.renderx.pdflib.GenericHintRecord;
import com.renderx.pdflib.HintStream;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.Linearized;
import com.renderx.pdflib.PDFDocument;
import com.renderx.pdflib.PDFException;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.PDFTrailer;
import com.renderx.pdflib.PDFXRefTable;
import com.renderx.pdflib.PageOffsetHintRecord;
import com.renderx.pdflib.SharedObjectsHintRecord;
import com.renderx.pdflib.parser.PDFArray;
import com.renderx.pdflib.parser.PDFDictionary;
import com.renderx.pdflib.parser.PDFIndirectObject;
import com.renderx.pdflib.parser.PDFInstance;
import com.renderx.pdflib.parser.PDFStream;
import com.renderx.pdflib.parser.PDFString;
import com.renderx.pdflib.parser.PDFUniversalObject;
import com.renderx.util.Array;
import com.renderx.util.DefaultErrorHandler;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.SeekableFileInputStream;
import com.renderx.util.SeekableInput;
import com.renderx.util.URLCache;
import com.renderx.util.URLSpec;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import junit.framework.Assert;
import junit.framework.TestCase;

public class Linearize {
    private final FontCatalog fontCatalog;
    private final ImageFactory imageFactory;
    private final ErrorHandler errorHandler;
    OutputStream output;
    PDFInstance source;
    boolean compressed;
    boolean encrypted;
    Encrypt encrypt;
    Hashtable objs;
    Hashtable lengths;
    Hashtable streamLengths;
    Array pages;
    Hashtable pagesh;
    Hashtable firstPageSubObjects;
    Hashtable unicalSubObjects;
    Hashtable unicalSubObjectsList;
    Hashtable sharedSubObjects;
    Hashtable nonPageObjects;
    Hashtable outlines;
    Hashtable names;
    long firstPageOffset;
    long firstOutlineOffset;
    long firstNamedDestinationOffset;
    int linearize_id;
    int catalog_id;
    int info_id;
    int pages_id;
    int outlines_id;
    int names_id;
    int counter;
    long filesize;
    long tr2itemnumber;
    long tr2sizewhioutIndirectObjects;
    long xrefOffset;
    long headerSize;

    protected Linearize(SeekableInput seekableInput, OutputStream outputStream) throws IOException, ImageFormatException, FontConfigurationException {
        this(seekableInput, outputStream, new DefaultErrorHandler());
    }

    private Linearize(SeekableInput seekableInput, OutputStream outputStream, ErrorHandler errorHandler) throws IOException, ImageFormatException, FontConfigurationException {
        this(seekableInput, outputStream, new URLCache(errorHandler), errorHandler);
    }

    private Linearize(SeekableInput seekableInput, OutputStream outputStream, URLCache uRLCache, ErrorHandler errorHandler) throws IOException, ImageFormatException, FontConfigurationException {
        this(seekableInput, outputStream, new FontCatalog(uRLCache, errorHandler), uRLCache, errorHandler);
    }

    private Linearize(SeekableInput seekableInput, OutputStream outputStream, FontCatalog fontCatalog, URLCache uRLCache, ErrorHandler errorHandler) throws IOException, ImageFormatException {
        this(seekableInput, outputStream, new ImageFactory(fontCatalog, uRLCache, errorHandler), fontCatalog, errorHandler);
    }

    public Linearize(SeekableInput seekableInput, OutputStream outputStream, ImageFactory imageFactory, FontCatalog fontCatalog, ErrorHandler errorHandler) throws IOException, ImageFormatException {
        this.imageFactory = imageFactory;
        this.fontCatalog = fontCatalog;
        this.errorHandler = errorHandler;
        this.source = new PDFInstance();
        this.source.parse(seekableInput);
        this.source.renumber = false;
        this.source.converObjects.put("0", new Integer(0));
        this.pagesh = new Hashtable();
        this.output = outputStream;
        this.encrypt = null;
    }

    public void setUseCompression(boolean bl) {
        this.compressed = bl;
    }

    public void setUseEncryption(Encrypt encrypt) {
        this.encrypted = true;
        this.encrypt = encrypt;
    }

    public void setUseEncryption(String string, String string2, int n) {
        this.encrypted = true;
        this.encrypt = new Encrypt(new IndirectObject(0), string, string2, n, this.output.toString());
    }

    Hashtable addHashtable(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            hashtable.put(e, hashtable2.get(e));
        }
        return hashtable;
    }

    Hashtable getSubObjects(int n) {
        return this.getSubObjects(n, new Hashtable());
    }

    Hashtable getSubObjects(int n, Hashtable hashtable) {
        PDFUniversalObject pDFUniversalObject = (PDFUniversalObject)this.objs.get(new Integer(n));
        if (pDFUniversalObject == null) {
            throw new PDFException("Can not find object " + n);
        }
        List list = pDFUniversalObject.getIndirectObjects();
        while (!list.isEmpty()) {
            Integer n2 = (Integer)list.shift();
            PDFUniversalObject pDFUniversalObject2 = (PDFUniversalObject)this.objs.get(n2);
            if (hashtable.containsKey(n2) || "/Pages".equals(pDFUniversalObject2.getType()) || "/Page".equals(pDFUniversalObject2.getType())) continue;
            hashtable.put(n2, "");
            hashtable = this.addHashtable(hashtable, this.getSubObjects(n2, hashtable));
        }
        return hashtable;
    }

    void separateSubobjects() {
        Object object;
        Object object2;
        this.firstPageSubObjects = new Hashtable();
        this.unicalSubObjects = new Hashtable();
        this.unicalSubObjectsList = new Hashtable();
        this.sharedSubObjects = new Hashtable();
        this.nonPageObjects = new Hashtable();
        this.firstPageSubObjects = this.getSubObjects((Integer)this.pages.get(0));
        Hashtable hashtable = new Hashtable();
        int n = 1;
        while (n < this.pages.length()) {
            hashtable.put(new Integer(n), this.getSubObjects((Integer)this.pages.get(n)));
            ++n;
        }
        int n2 = 1;
        while (n2 < this.pages.length()) {
            object2 = (Hashtable)hashtable.get(new Integer(n2));
            object = ((Hashtable)object2).keys();
            Hashtable hashtable2 = new Hashtable();
            Hashtable hashtable3 = new Hashtable();
            while (object.hasMoreElements()) {
                Integer n3 = (Integer)object.nextElement();
                if (this.firstPageSubObjects.containsKey(n3) || this.outlines.containsKey(n3) || this.names.containsKey(n3)) continue;
                boolean bl = true;
                int n4 = 1;
                while (n4 < this.pages.length() && bl) {
                    if (n4 != n2) {
                        Hashtable hashtable4 = (Hashtable)hashtable.get(new Integer(n4));
                        Enumeration enumeration = hashtable4.keys();
                        while (enumeration.hasMoreElements() && bl) {
                            Integer n5 = (Integer)enumeration.nextElement();
                            if (n3.intValue() != n5.intValue()) continue;
                            bl = false;
                        }
                    }
                    ++n4;
                }
                if (bl) {
                    hashtable2.put(n3, "");
                    continue;
                }
                hashtable3.put(n3, "");
            }
            this.unicalSubObjects.put(new Integer(n2), hashtable2);
            this.unicalSubObjectsList = this.addHashtable(this.unicalSubObjectsList, hashtable2);
            this.sharedSubObjects = this.addHashtable(this.sharedSubObjects, hashtable3);
            ++n2;
        }
        object2 = this.objs.keys();
        while (object2.hasMoreElements()) {
            object = (Integer)object2.nextElement();
            if (this.firstPageSubObjects.containsKey(object) || this.outlines.containsKey(object) || this.names.containsKey(object) || this.unicalSubObjectsList.containsKey(object) || this.sharedSubObjects.containsKey(object) || this.pagesh.containsKey(object) || ((PDFUniversalObject)this.objs.get(object)).getType().equals("/Catalog")) continue;
            if (((PDFUniversalObject)this.objs.get((Object)object)).objdata instanceof PDFDictionary) {
                if (this.isLinearized((PDFDictionary)((PDFUniversalObject)this.objs.get((Object)object)).objdata) || this.isHintStream((PDFDictionary)((PDFUniversalObject)this.objs.get((Object)object)).objdata)) continue;
                this.nonPageObjects.put(object, "");
                continue;
            }
            this.nonPageObjects.put(object, "");
        }
    }

    boolean isLinearized(PDFDictionary pDFDictionary) {
        return pDFDictionary.dict.containsKey("/Linearized") && pDFDictionary.dict.containsKey("/L") && pDFDictionary.dict.containsKey("/H") && pDFDictionary.dict.containsKey("/O") && pDFDictionary.dict.containsKey("/E") && pDFDictionary.dict.containsKey("/N") && pDFDictionary.dict.containsKey("/T");
    }

    boolean isHintStream(PDFDictionary pDFDictionary) {
        return pDFDictionary.dict.containsKey("/Length") && pDFDictionary.dict.containsKey("/S");
    }

    Array getPages(int n) {
        PDFUniversalObject pDFUniversalObject = (PDFUniversalObject)this.objs.get(new Integer(n));
        Array array = ((PDFArray)((PDFDictionary)pDFUniversalObject.objdata).dict.get((Object)"/Kids")).array;
        Array array2 = new Array();
        int n2 = 0;
        int n3 = array.length();
        int n4 = 0;
        while (n4 < n3) {
            PDFUniversalObject pDFUniversalObject2 = this.getObject((PDFIndirectObject)array.get(n4));
            String string = pDFUniversalObject2.getType();
            if (string.equals("/Page")) {
                array2.put(n2, new Integer(pDFUniversalObject2.obj_id));
                ++n2;
                this.pagesh.put(new Integer(pDFUniversalObject2.obj_id), "");
            } else if (string.equals("/Pages")) {
                Array array3 = this.getPages(pDFUniversalObject2.obj_id);
                int n5 = array3.length();
                int n6 = 0;
                while (n6 < n5) {
                    array2.put(n2, array3.get(n6));
                    ++n2;
                    ++n6;
                }
            }
            ++n4;
        }
        return array2;
    }

    void getOutlines(int n) {
        if (n == 0) {
            return;
        }
        PDFUniversalObject pDFUniversalObject = (PDFUniversalObject)this.objs.get(new Integer(n));
        this.outlines.put(new Integer(n), "");
        if (pDFUniversalObject != null) {
            int n2;
            if (((PDFDictionary)pDFUniversalObject.objdata).dict.containsKey("/First")) {
                n2 = ((PDFIndirectObject)((PDFDictionary)pDFUniversalObject.objdata).dict.get("/First")).intValue();
                this.getOutlines(n2);
            }
            if (((PDFDictionary)pDFUniversalObject.objdata).dict.containsKey("/Next")) {
                n2 = ((PDFIndirectObject)((PDFDictionary)pDFUniversalObject.objdata).dict.get("/Next")).intValue();
                this.getOutlines(n2);
            }
        }
    }

    void getNamedDestinations(int n) {
        PDFUniversalObject pDFUniversalObject = (PDFUniversalObject)this.objs.get(new Integer(n));
        this.names.put(new Integer(n), "");
        if (pDFUniversalObject != null) {
            PDFIndirectObject pDFIndirectObject;
            int n2;
            if (((PDFDictionary)pDFUniversalObject.objdata).dict.containsKey("/Dests")) {
                int n3 = ((PDFIndirectObject)((PDFDictionary)pDFUniversalObject.objdata).dict.get("/Dests")).intValue();
                this.getNamedDestinations(n3);
            }
            if (((PDFDictionary)pDFUniversalObject.objdata).dict.containsKey("/Kids")) {
                PDFArray pDFArray = (PDFArray)((PDFDictionary)pDFUniversalObject.objdata).dict.get("/Kids");
                n2 = 0;
                while (n2 < pDFArray.array.length()) {
                    pDFIndirectObject = (PDFIndirectObject)pDFArray.array.get(n2);
                    this.getNamedDestinations(pDFIndirectObject.intValue());
                    ++n2;
                }
            }
            if (((PDFDictionary)pDFUniversalObject.objdata).dict.containsKey("/Names")) {
                PDFArray pDFArray = (PDFArray)((PDFDictionary)pDFUniversalObject.objdata).dict.get("/Names");
                n2 = 0;
                while (n2 < pDFArray.array.length() / 2) {
                    pDFIndirectObject = (PDFIndirectObject)pDFArray.array.get(2 * n2 + 1);
                    this.names.put(new Integer(pDFIndirectObject.intValue()), "");
                    ++n2;
                }
            }
        }
    }

    void readPages() {
        PDFUniversalObject pDFUniversalObject = (PDFUniversalObject)this.objs.get(new Integer(this.catalog_id));
        this.pages_id = ((PDFIndirectObject)((PDFDictionary)pDFUniversalObject.objdata).dict.get("/Pages")).intValue();
        this.pages = this.getPages(this.pages_id);
        this.outlines = new Hashtable();
        this.names = new Hashtable();
        if (((PDFDictionary)pDFUniversalObject.objdata).dict.containsKey("/Outlines")) {
            this.outlines_id = ((PDFIndirectObject)((PDFDictionary)pDFUniversalObject.objdata).dict.get("/Outlines")).intValue();
            this.getOutlines(this.outlines_id);
        }
        if (((PDFDictionary)pDFUniversalObject.objdata).dict.containsKey("/Names")) {
            this.names_id = ((PDFIndirectObject)((PDFDictionary)pDFUniversalObject.objdata).dict.get("/Names")).intValue();
            this.getNamedDestinations(this.names_id);
        }
    }

    PDFUniversalObject getObject(PDFIndirectObject pDFIndirectObject) {
        return this.getObject(pDFIndirectObject.intValue());
    }

    PDFUniversalObject getObject(int n) {
        return (PDFUniversalObject)this.objs.get(new Integer(n));
    }

    void readObjects() throws IOException, ImageFormatException {
        Enumeration enumeration = this.source.xRefTable.obj_offset.keys();
        this.objs = new Hashtable();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            PDFUniversalObject pDFUniversalObject = this.source.getObject(n);
            this.objs.put(n, pDFUniversalObject);
        }
        this.catalog_id = this.source.xRefTable.getRoot();
        this.info_id = this.source.xRefTable.getInfo();
    }

    void renumberObjects() {
        Enumeration enumeration;
        Integer n;
        this.counter = 1;
        int n2 = 1;
        while (n2 < this.pages.length()) {
            n = (Integer)this.pages.get(n2);
            this.counter = this.source.addNewID(n, this.counter);
            Hashtable hashtable = (Hashtable)this.unicalSubObjects.get(new Integer(n2));
            if (hashtable != null) {
                enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    this.counter = this.source.addNewID((Integer)enumeration.nextElement(), this.counter);
                }
            }
            ++n2;
        }
        enumeration = this.sharedSubObjects.keys();
        while (enumeration.hasMoreElements()) {
            this.counter = this.source.addNewID((Integer)enumeration.nextElement(), this.counter);
        }
        this.counter = this.source.addNewID(this.pages_id, this.counter);
        this.counter = this.source.addNewID(this.info_id, this.counter);
        enumeration = this.nonPageObjects.keys();
        while (enumeration.hasMoreElements()) {
            n = (Integer)enumeration.nextElement();
            this.counter = this.source.addNewID(n, this.counter);
        }
        this.linearize_id = this.counter++;
        this.counter = this.source.addNewID(this.catalog_id, this.counter);
        this.counter = this.source.addNewID((Integer)this.pages.get(0), this.counter);
        enumeration = this.outlines.keys();
        while (enumeration.hasMoreElements()) {
            this.counter = this.source.addNewID((Integer)enumeration.nextElement(), this.counter);
        }
        enumeration = this.names.keys();
        while (enumeration.hasMoreElements()) {
            this.counter = this.source.addNewID((Integer)enumeration.nextElement(), this.counter);
        }
        enumeration = this.firstPageSubObjects.keys();
        while (enumeration.hasMoreElements()) {
            this.counter = this.source.addNewID((Integer)enumeration.nextElement(), this.counter);
        }
        this.firstPageSubObjects = this.addHashtable(this.firstPageSubObjects, this.outlines);
        this.firstPageSubObjects = this.addHashtable(this.firstPageSubObjects, this.names);
    }

    void calcSizeOfObjects() throws IOException, ImageFormatException {
        Enumeration enumeration = this.objs.keys();
        PDFDocument pDFDocument = new PDFDocument((OutputStream)new NullOutputStream(), this.imageFactory, this.fontCatalog, this.errorHandler);
        pDFDocument.setCompression(this.compressed);
        if (this.encrypted) {
            pDFDocument.outputPDF.encrypt = this.encrypt;
            pDFDocument.outputPDF.useEncryption = true;
        }
        this.lengths = new Hashtable();
        this.streamLengths = new Hashtable();
        this.source.renumber = true;
        PDFTrailer pDFTrailer = new PDFTrailer();
        this.tr2itemnumber = 0L;
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            Integer n2 = this.source.newID(n);
            if (n2 == null) continue;
            PDFUniversalObject pDFUniversalObject = (PDFUniversalObject)this.objs.get(n);
            if (!this.firstPageSubObjects.containsKey(new Integer(pDFUniversalObject.obj_id)) && pDFUniversalObject.obj_id != this.catalog_id) {
                ++this.tr2itemnumber;
            }
            pDFUniversalObject.setID(n2);
            if (pDFUniversalObject.objdata instanceof PDFStream) {
                pDFUniversalObject.objdata = this.source.getStream(pDFUniversalObject);
            }
            int n3 = pDFDocument.outputPDF.size();
            pDFUniversalObject.write(pDFDocument.outputPDF, this.source);
            this.lengths.put(n, new Long(pDFDocument.outputPDF.size() - n3));
            if (!(pDFUniversalObject.objdata instanceof PDFStream)) continue;
            this.streamLengths.put(n, new Long(((PDFStream)pDFUniversalObject.objdata).stream_size));
        }
        this.tr2sizewhioutIndirectObjects = this.tr2itemnumber * PDFXRefTable.itemSize + (long)(("" + this.tr2itemnumber).length() * 2) + 62L + 74L;
        this.filesize = pDFDocument.outputPDF.size();
        pDFDocument.outputPDF.close();
    }

    PDFDocument createDestination() throws IOException, ImageFormatException {
        PDFDocument pDFDocument = new PDFDocument(this.output, this.imageFactory, this.fontCatalog, this.errorHandler);
        pDFDocument.setCompression(this.compressed);
        pDFDocument.startDocument();
        return pDFDocument;
    }

    Linearized createLinearizedDictionary(IndirectObject indirectObject) {
        Linearized linearized = new Linearized(indirectObject);
        linearized.firstPageID = this.source.newID((Integer)this.pages.get(0));
        linearized.numberOfPages = this.pagesh.size();
        return linearized;
    }

    void calcFirstLocations() {
        PDFTrailer pDFTrailer = new PDFTrailer();
        pDFTrailer.xref.xrefSize = PDFXRefTable.bodySize + PDFXRefTable.itemSize * (long)(this.firstPageSubObjects.size() + 4);
        this.headerSize = Linearized.smallHeaderSize + pDFTrailer.xref.xrefSize;
        this.firstPageOffset = this.headerSize + (Long)this.lengths.get(new Integer(this.catalog_id));
        this.firstNamedDestinationOffset = this.firstOutlineOffset = this.firstPageOffset + (Long)this.lengths.get(this.pages.get(0));
        Enumeration enumeration = this.outlines.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            this.firstNamedDestinationOffset += ((Long)this.lengths.get(n)).longValue();
        }
    }

    PDFTrailer createFirstTrailer(Linearized linearized, byte[] byArray) {
        PDFTrailer pDFTrailer = new PDFTrailer();
        pDFTrailer.xref.xrefSize = PDFXRefTable.bodySize + PDFXRefTable.itemSize * (long)(this.firstPageSubObjects.size() + 4);
        if (this.encrypted) {
            pDFTrailer.xref.xrefSize += PDFXRefTable.itemSize;
        }
        long l = this.headerSize = Linearized.smallHeaderSize + pDFTrailer.xref.xrefSize;
        if (this.encrypted) {
            pDFTrailer.xref.addObjectOffset(new IndirectObject(this.encrypt.obj_id.num), l);
            l += (long)byArray.length;
        }
        pDFTrailer.xref.addObjectOffset(new IndirectObject(this.source.newID(this.catalog_id)), l);
        pDFTrailer.xref.addObjectOffset(new IndirectObject(this.source.newID((Integer)this.pages.get(0))), l += ((Long)this.lengths.get(new Integer(this.catalog_id))).longValue());
        l += ((Long)this.lengths.get(this.pages.get(0))).longValue();
        Enumeration enumeration = this.firstPageSubObjects.keys();
        int n = Integer.MAX_VALUE;
        Array array = new Array();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            Long l2 = (Long)this.lengths.get(n2);
            if (this.source.newID(n2) < n) {
                n = this.source.newID(n2);
            }
            array.put(this.source.newID(n2), n2);
        }
        int n3 = n;
        while (n3 < array.length()) {
            pDFTrailer.xref.addObjectOffset(new IndirectObject(n3), l);
            l += ((Long)this.lengths.get(array.get(n3))).longValue();
            ++n3;
        }
        pDFTrailer.catalog_id = this.source.newID(this.catalog_id);
        pDFTrailer.info_id = this.source.newID(this.info_id);
        pDFTrailer.encrypt = this.encrypt;
        linearized.fileLength = this.filesize + this.headerSize + this.tr2sizewhioutIndirectObjects;
        return pDFTrailer;
    }

    HintStream createFirstHintStream(IndirectObject indirectObject, PDFDocument pDFDocument) {
        this.calcFirstLocations();
        HintStream hintStream = new HintStream(indirectObject);
        hintStream.pageOffset = new PageOffsetHintRecord(this.pages, this.firstPageSubObjects, this.lengths, this.unicalSubObjects);
        hintStream.pageOffset.firstObjectLocation = this.firstPageOffset;
        hintStream.sharedObjects = new SharedObjectsHintRecord(this.pages, this.sharedSubObjects, this.firstPageSubObjects, this.lengths, this.source);
        if (this.outlines.size() > 0) {
            hintStream.outlines = new GenericHintRecord(this.outlines, this.lengths, this.source);
            hintStream.outlines.firstLocation = this.firstOutlineOffset;
        }
        if (this.names.size() > 0) {
            hintStream.namedDestinations = new GenericHintRecord(this.names, this.lengths, this.source);
            hintStream.namedDestinations.firstLocation = this.firstNamedDestinationOffset;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = pDFDocument.outputPDF.output;
        pDFDocument.outputPDF.output = new DataOutputStream(byteArrayOutputStream);
        pDFDocument.outputPDF.currentOS = pDFDocument.outputPDF.output;
        hintStream.write(pDFDocument.outputPDF);
        hintStream.bytes = byteArrayOutputStream.toByteArray();
        pDFDocument.outputPDF.output = dataOutputStream;
        pDFDocument.outputPDF.currentOS = pDFDocument.outputPDF.output;
        hintStream.length = hintStream.bytes.length;
        return hintStream;
    }

    void appendLinearizedData(Linearized linearized, long l, HintStream hintStream) {
        linearized.hintStreamObjectOffset = (int)this.headerSize + ((Long)this.lengths.get(new Integer(this.catalog_id))).intValue();
        linearized.hintStreamObjectLength = hintStream.length;
    }

    long calcfirstPageEndOffset(HintStream hintStream, byte[] byArray) {
        long l = this.headerSize + (long)hintStream.length;
        l += (long)((Long)this.lengths.get(this.pages.get(0))).intValue();
        l += (long)((Long)this.lengths.get(new Integer(this.catalog_id))).intValue();
        Enumeration enumeration = this.firstPageSubObjects.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            l += (long)((Long)this.lengths.get(n)).intValue();
        }
        if (this.encrypted) {
            l += (long)byArray.length;
        }
        return l;
    }

    byte[] createEncryptObj(PDFDocument pDFDocument) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = pDFDocument.outputPDF.output;
        pDFDocument.outputPDF.output = new DataOutputStream(byteArrayOutputStream);
        pDFDocument.outputPDF.currentOS = pDFDocument.outputPDF.output;
        this.encrypt.write(pDFDocument.outputPDF);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        pDFDocument.outputPDF.output = dataOutputStream;
        pDFDocument.outputPDF.currentOS = pDFDocument.outputPDF.output;
        return byArray;
    }

    void writeLinearized() throws IOException, ImageFormatException {
        PDFDocument pDFDocument = this.createDestination();
        HintStream hintStream = this.createFirstHintStream(new IndirectObject(this.counter++), pDFDocument);
        Linearized linearized = this.createLinearizedDictionary(new IndirectObject(this.source.newID(this.catalog_id) - 1));
        linearized.firstPageEndOffset = this.firstPageOffset;
        byte[] byArray = new byte[]{};
        if (this.encrypted) {
            this.encrypt.obj_id = new IndirectObject(this.counter++);
            byArray = this.createEncryptObj(pDFDocument);
            pDFDocument.outputPDF.encrypt = this.encrypt;
            pDFDocument.outputPDF.useEncryption = true;
        }
        PDFTrailer pDFTrailer = this.createFirstTrailer(linearized, byArray);
        this.appendLinearizedData(linearized, pDFTrailer.xref.xrefSize, hintStream);
        pDFTrailer.xref.addObjectOffset(linearized.obj_id, pDFDocument.outputPDF.size());
        pDFTrailer.xref.addObjectOffset(hintStream.obj_id, this.headerSize + (Long)this.lengths.get(new Integer(this.catalog_id)) + (long)byArray.length);
        int n = this.source.newID(this.catalog_id) + 1;
        while (n < hintStream.obj_id.num) {
            long l = (Long)pDFTrailer.xref.offsets.get(n) + (long)hintStream.length;
            pDFTrailer.xref.offsets.put(n, new Long(l));
            ++n;
        }
        pDFTrailer.prev = this.headerSize + (long)hintStream.length;
        pDFTrailer.prev += (long)byArray.length;
        Enumeration enumeration = this.lengths.keys();
        while (enumeration.hasMoreElements()) {
            pDFTrailer.prev += ((Long)this.lengths.get(enumeration.nextElement())).longValue();
        }
        linearized.fileLength += (long)(hintStream.length + ("" + this.source.newID(this.info_id) + " 0 R").length() + ("" + this.source.newID(this.catalog_id) + " 0 R").length());
        linearized.mainXRefFirstLineOffset = this.headerSize + (long)hintStream.length + this.filesize + 8L + (long)("" + this.tr2itemnumber).length();
        linearized.mainXRefFirstLineOffset += (long)byArray.length;
        linearized.fileLength += (long)byArray.length;
        linearized.firstPageEndOffset = this.calcfirstPageEndOffset(hintStream, byArray);
        linearized.write(pDFDocument.outputPDF);
        long l = pDFDocument.outputPDF.size();
        this.xrefOffset = pDFDocument.outputPDF.size();
        pDFTrailer.xref.offset = 0L;
        pDFTrailer.write(pDFDocument.outputPDF);
        long l2 = (long)pDFDocument.outputPDF.size() - l;
        while (l2 < pDFTrailer.xref.xrefSize) {
            pDFDocument.outputPDF.print(" ");
            ++l2;
        }
        if (this.encrypted) {
            pDFDocument.outputPDF.write(byArray);
        }
        PDFUniversalObject pDFUniversalObject = (PDFUniversalObject)this.objs.get(new Integer(this.catalog_id));
        pDFUniversalObject.setID(this.source.newID(this.catalog_id));
        pDFUniversalObject.write(pDFDocument.outputPDF, this.source);
        pDFDocument.outputPDF.write(hintStream.bytes);
        pDFUniversalObject = (PDFUniversalObject)this.objs.get(this.pages.get(0));
        pDFUniversalObject.setID(this.source.newID(this.pages.get(0)));
        pDFUniversalObject.write(pDFDocument.outputPDF, this.source);
        this.writeObjectOrderedByNewID(this.firstPageSubObjects, pDFDocument.outputPDF, this.source);
        int n2 = 1;
        while (n2 < this.pages.length()) {
            pDFUniversalObject = (PDFUniversalObject)this.objs.get(this.pages.get(n2));
            pDFUniversalObject.setID(this.source.newID(this.pages.get(n2)));
            pDFUniversalObject.write(pDFDocument.outputPDF, this.source);
            this.writeObjectOrderedByNewID((Hashtable)this.unicalSubObjects.get(new Integer(n2)), pDFDocument.outputPDF, this.source);
            ++n2;
        }
        this.writeObjectOrderedByNewID(this.sharedSubObjects, pDFDocument.outputPDF, this.source);
        this.writeObjectOrderedByNewID(this.nonPageObjects, pDFDocument.outputPDF, this.source);
        pDFDocument.outputPDF.trailer.catalog.obj_id = new IndirectObject(this.source.newID(this.catalog_id));
        pDFDocument.outputPDF.trailer.info.obj_id = new IndirectObject(this.source.newID(this.info_id));
        pDFDocument.outputPDF.trailer.xref.offset = this.xrefOffset;
        Array array = pDFDocument.outputPDF.trailer.xref.offsets;
        Array array2 = new Array();
        int n3 = 1;
        while (n3 < this.linearize_id) {
            array2.put(n3, array.get(n3));
            ++n3;
        }
        this.source.close();
        this.source = null;
        pDFDocument.outputPDF.trailer.xref.offsets = array2;
        if (pDFDocument.outputPDF.useEncryption) {
            pDFDocument.outputPDF.useEncryption = false;
        }
        pDFDocument.printTail();
    }

    void writeObjectOrderedByNewID(Hashtable hashtable, PDFOutputStream pDFOutputStream, PDFInstance pDFInstance) {
        PDFUniversalObject pDFUniversalObject;
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        int n = Integer.MAX_VALUE;
        Array array = new Array();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            pDFUniversalObject = (PDFUniversalObject)this.objs.get(n2);
            pDFUniversalObject.setID(this.source.newID(n2));
            if (pDFUniversalObject.obj_id < n) {
                n = pDFUniversalObject.obj_id;
            }
            array.put(pDFUniversalObject.obj_id, pDFUniversalObject);
        }
        int n3 = n;
        while (n3 < array.length()) {
            pDFUniversalObject = (PDFUniversalObject)array.get(n3);
            pDFUniversalObject.write(pDFOutputStream, pDFInstance);
            ++n3;
        }
    }

    String printHashtable(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        String string = "";
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            string = string + e + " " + hashtable.get(e) + "\n";
        }
        return string;
    }

    long getLength(int n) {
        return this.getLength(new Integer(n));
    }

    long getLength(Integer n) {
        return (Long)this.lengths.get(n);
    }

    void linearize() throws IOException, ImageFormatException {
        this.readObjects();
        this.readPages();
        this.separateSubobjects();
        this.renumberObjects();
        this.calcSizeOfObjects();
        this.writeLinearized();
    }

    public static void main(String[] stringArray) throws Exception {
        SeekableFileInputStream seekableFileInputStream = new SeekableFileInputStream(stringArray[0]);
        FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1]);
        Linearize linearize = new Linearize(seekableFileInputStream, fileOutputStream);
        linearize.linearize();
        seekableFileInputStream.close();
        ((OutputStream)fileOutputStream).close();
    }

    private static final class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int n) {
        }

        public void write(byte[] byArray) {
        }

        public void write(byte[] byArray, int n, int n2) {
        }
    }

    public static class Test
    extends TestCase {
        String testPDFFileName = "jUnitTestSimple.pdf";
        String testPDFFileName2 = "jUnitTest2pages.pdf";
        String testPDFFileName3 = "jUnitTest2pagesandimagefor12.pdf";
        String testPDFFileName4 = "jUnitTest3pagesandimagefor23.pdf";
        String rezPDFFileName = "jUnitTestLinearized.pdf";
        ErrorHandler errorHandler = new DefaultErrorHandler();
        URLCache urlcache;
        FontCatalog fontCatalog;
        ImageFactory imageFactory;

        public void setUp() {
            try {
                this.urlcache = new URLCache(this.errorHandler);
                this.fontCatalog = new FontCatalog(this.urlcache, this.errorHandler);
                this.imageFactory = new ImageFactory(this.fontCatalog, this.urlcache, this.errorHandler);
            }
            catch (IOException iOException) {
                Assert.fail((String)("Cannot create font catalog or image factory: " + iOException));
            }
            catch (FontConfigurationException fontConfigurationException) {
                Assert.fail((String)("Cannot create font catalog: " + fontConfigurationException));
            }
        }

        void createTestPDF() throws IOException {
            PDFDocument pDFDocument = new PDFDocument(this.testPDFFileName, this.imageFactory, this.fontCatalog, this.errorHandler);
            pDFDocument.setCompression(false);
            pDFDocument.startDocument();
            pDFDocument.beginPage(100.0f, 100.0f, "1");
            pDFDocument.setRGBColor(0.0f, 0.0f, 0.0f);
            pDFDocument.setLineWidth(10.0f);
            pDFDocument.moveTo(10.0f, 10.0f);
            pDFDocument.lineTo(50.0f, 10.0f);
            pDFDocument.lineTo(50.0f, 50.0f);
            pDFDocument.lineTo(10.0f, 50.0f);
            pDFDocument.closePath();
            pDFDocument.fill();
            pDFDocument.endPage();
            pDFDocument.endDocument();
        }

        void createTestPDF2() throws IOException {
            PDFDocument pDFDocument = new PDFDocument(this.testPDFFileName2, this.imageFactory, this.fontCatalog, this.errorHandler);
            pDFDocument.setCompression(false);
            pDFDocument.startDocument();
            pDFDocument.beginPage(100.0f, 100.0f, "1");
            pDFDocument.setRGBColor(0.0f, 0.0f, 0.0f);
            pDFDocument.setLineWidth(10.0f);
            pDFDocument.moveTo(10.0f, 10.0f);
            pDFDocument.lineTo(50.0f, 10.0f);
            pDFDocument.lineTo(50.0f, 50.0f);
            pDFDocument.lineTo(10.0f, 50.0f);
            pDFDocument.fill();
            pDFDocument.closePath();
            pDFDocument.endPage();
            pDFDocument.beginPage(100.0f, 100.0f, "2");
            pDFDocument.setRGBColor(0.0f, 100.0f, 0.0f);
            pDFDocument.moveTo(20.0f, 10.0f);
            pDFDocument.lineTo(60.0f, 10.0f);
            pDFDocument.lineTo(60.0f, 50.0f);
            pDFDocument.lineTo(20.0f, 50.0f);
            pDFDocument.closePath();
            pDFDocument.fill();
            pDFDocument.endPage();
            pDFDocument.endDocument();
        }

        void createTestPDF3() throws IOException {
            PDFDocument pDFDocument = new PDFDocument(this.testPDFFileName3, this.imageFactory, this.fontCatalog, this.errorHandler);
            this.resourceToFile("com/renderx/pdflib/TEST_DATA/test_gif.gif", "1.gif");
            pDFDocument.setCompression(false);
            pDFDocument.startDocument();
            pDFDocument.beginPage(100.0f, 100.0f, "1");
            pDFDocument.setRGBColor(0.0f, 0.0f, 0.0f);
            pDFDocument.setLineWidth(10.0f);
            pDFDocument.moveTo(10.0f, 10.0f);
            pDFDocument.lineTo(50.0f, 10.0f);
            pDFDocument.lineTo(50.0f, 50.0f);
            pDFDocument.lineTo(10.0f, 50.0f);
            pDFDocument.closePath();
            pDFDocument.fill();
            pDFDocument.placeImage(new URLSpec("1.gif"), "image/gif");
            pDFDocument.endPage();
            pDFDocument.beginPage(100.0f, 100.0f, "2");
            pDFDocument.setRGBColor(0.0f, 100.0f, 0.0f);
            pDFDocument.moveTo(20.0f, 10.0f);
            pDFDocument.lineTo(60.0f, 10.0f);
            pDFDocument.lineTo(60.0f, 50.0f);
            pDFDocument.lineTo(20.0f, 50.0f);
            pDFDocument.closePath();
            pDFDocument.fill();
            pDFDocument.placeImage(new URLSpec("1.gif"), "image/gif");
            pDFDocument.endPage();
            pDFDocument.endDocument();
        }

        void createTestPDF4() throws IOException {
            PDFDocument pDFDocument = new PDFDocument(this.testPDFFileName4, this.imageFactory, this.fontCatalog, this.errorHandler);
            this.resourceToFile("com/renderx/pdflib/TEST_DATA/test_gif.gif", "1.gif");
            this.resourceToFile("com/renderx/pdflib/TEST_DATA/test_jpeg.jpg", "1.jpg");
            pDFDocument.setCompression(false);
            pDFDocument.startDocument();
            pDFDocument.beginPage(100.0f, 100.0f, "1");
            pDFDocument.setRGBColor(0.0f, 0.0f, 0.0f);
            pDFDocument.setLineWidth(10.0f);
            pDFDocument.moveTo(10.0f, 10.0f);
            pDFDocument.lineTo(50.0f, 10.0f);
            pDFDocument.lineTo(50.0f, 50.0f);
            pDFDocument.lineTo(10.0f, 50.0f);
            pDFDocument.closePath();
            pDFDocument.fill();
            pDFDocument.endPage();
            pDFDocument.beginPage(100.0f, 100.0f, "2");
            pDFDocument.setRGBColor(0.0f, 100.0f, 0.0f);
            pDFDocument.moveTo(20.0f, 10.0f);
            pDFDocument.lineTo(60.0f, 10.0f);
            pDFDocument.lineTo(60.0f, 50.0f);
            pDFDocument.lineTo(20.0f, 50.0f);
            pDFDocument.closePath();
            pDFDocument.fill();
            pDFDocument.placeImage(new URLSpec("1.gif"), "image/gif");
            pDFDocument.endPage();
            pDFDocument.beginPage(100.0f, 100.0f, "3");
            pDFDocument.setRGBColor(0.0f, 0.0f, 100.0f);
            pDFDocument.moveTo(20.0f, 10.0f);
            pDFDocument.lineTo(60.0f, 10.0f);
            pDFDocument.lineTo(60.0f, 50.0f);
            pDFDocument.lineTo(20.0f, 50.0f);
            pDFDocument.closePath();
            pDFDocument.fill();
            pDFDocument.placeImage(new URLSpec("1.gif"), "image/gif");
            pDFDocument.endPage();
            pDFDocument.endDocument();
        }

        Linearize createTestLinearize() {
            Linearize linearize = null;
            try {
                try {
                    this.createTestPDF();
                    SeekableFileInputStream seekableFileInputStream = new SeekableFileInputStream(this.testPDFFileName);
                    FileOutputStream fileOutputStream = new FileOutputStream(this.rezPDFFileName);
                    linearize = new Linearize(seekableFileInputStream, fileOutputStream, this.fontCatalog, this.urlcache, this.errorHandler);
                }
                catch (IOException iOException) {
                    Assert.assertTrue((boolean)false);
                }
            }
            catch (ImageFormatException imageFormatException) {
                Assert.assertTrue((boolean)false);
            }
            return linearize;
        }

        Linearize createTestLinearize2() {
            Linearize linearize = null;
            try {
                try {
                    this.createTestPDF2();
                    SeekableFileInputStream seekableFileInputStream = new SeekableFileInputStream(this.testPDFFileName2);
                    FileOutputStream fileOutputStream = new FileOutputStream(this.rezPDFFileName);
                    linearize = new Linearize(seekableFileInputStream, fileOutputStream, this.fontCatalog, this.urlcache, this.errorHandler);
                }
                catch (IOException iOException) {
                    Assert.fail((String)("Error:" + iOException));
                }
            }
            catch (ImageFormatException imageFormatException) {
                Assert.assertTrue((boolean)false);
            }
            return linearize;
        }

        Linearize createTestLinearize3() {
            Linearize linearize = null;
            try {
                try {
                    this.createTestPDF3();
                    SeekableFileInputStream seekableFileInputStream = new SeekableFileInputStream(this.testPDFFileName3);
                    FileOutputStream fileOutputStream = new FileOutputStream(this.rezPDFFileName);
                    linearize = new Linearize(seekableFileInputStream, fileOutputStream, this.fontCatalog, this.urlcache, this.errorHandler);
                }
                catch (IOException iOException) {
                    Assert.fail((String)("Error:" + iOException));
                }
            }
            catch (ImageFormatException imageFormatException) {
                Assert.assertTrue((boolean)false);
            }
            return linearize;
        }

        Linearize createTestLinearize4() {
            Linearize linearize = null;
            try {
                try {
                    this.createTestPDF4();
                    SeekableFileInputStream seekableFileInputStream = new SeekableFileInputStream(this.testPDFFileName4);
                    FileOutputStream fileOutputStream = new FileOutputStream(this.rezPDFFileName);
                    linearize = new Linearize(seekableFileInputStream, fileOutputStream, this.fontCatalog, this.urlcache, this.errorHandler);
                }
                catch (IOException iOException) {
                    Assert.fail((String)("Error:" + iOException));
                }
            }
            catch (ImageFormatException imageFormatException) {
                Assert.assertTrue((boolean)false);
            }
            return linearize;
        }

        public void testAddHashtableEmpty(Linearize linearize) {
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = new Hashtable();
            Hashtable hashtable3 = linearize.addHashtable(hashtable, hashtable2);
            if (hashtable3.size() != 0) {
                Assert.fail((String)("Size of rezult Hashtable " + hashtable3.size()));
            }
        }

        public void testAddHashtableDifferent(Linearize linearize) {
            Hashtable hashtable = new Hashtable();
            hashtable.put("1", "");
            hashtable.put("2", "");
            Hashtable hashtable2 = new Hashtable();
            hashtable2.put("3", "");
            hashtable2.put("4", "");
            Hashtable hashtable3 = linearize.addHashtable(hashtable, hashtable2);
            int n = 1;
            while (n < 5) {
                if (!hashtable3.containsKey("" + n)) {
                    Assert.fail((String)("Can not find key " + n));
                }
                ++n;
            }
            if (hashtable3.size() != 4) {
                Assert.fail((String)("Size of rezult Hashtable " + hashtable3.size()));
            }
        }

        public void testAddHashtableSame(Linearize linearize) {
            Hashtable hashtable = new Hashtable();
            hashtable.put("1", "");
            hashtable.put("2", "");
            Hashtable hashtable2 = new Hashtable();
            hashtable2.put("2", "");
            Hashtable hashtable3 = linearize.addHashtable(hashtable, hashtable2);
            if (!hashtable3.containsKey("1") || !hashtable3.containsKey("2") || hashtable3.size() != 2) {
                Assert.assertTrue((boolean)false);
            }
            hashtable = new Hashtable();
            hashtable.put("1", "");
            hashtable2 = new Hashtable();
            hashtable2.put("1", "");
            hashtable2.put("2", "");
            hashtable3 = linearize.addHashtable(hashtable, hashtable2);
            int n = 1;
            while (n < 2) {
                if (!hashtable3.containsKey("" + n)) {
                    Assert.fail((String)("Can not find key " + n));
                }
                ++n;
            }
            if (hashtable3.size() != 2) {
                Assert.fail((String)("Size of rezult Hashtable " + hashtable3.size()));
            }
        }

        public void testAddHashtable() {
            Linearize linearize = this.createTestLinearize();
            this.testAddHashtableEmpty(linearize);
            this.testAddHashtableDifferent(linearize);
            this.testAddHashtableSame(linearize);
        }

        public void testGetSubObjectsFromArray() {
            Linearize linearize = this.createTestLinearize();
            linearize.objs = new Hashtable();
            PDFUniversalObject pDFUniversalObject = new PDFUniversalObject(1);
            PDFArray pDFArray = new PDFArray();
            pDFArray.array.put(0, new PDFIndirectObject("2"));
            pDFArray.array.put(1, new PDFString("3"));
            pDFArray.array.put(2, new PDFIndirectObject("3"));
            pDFUniversalObject.objdata = pDFArray;
            if (pDFUniversalObject.getIndirectObjects().isEmpty()) {
                Assert.fail((String)"Test PDFArray don`t contains indirect objects!");
            }
            linearize.objs.put(new Integer(1), pDFUniversalObject);
            PDFUniversalObject pDFUniversalObject2 = new PDFUniversalObject(2);
            pDFUniversalObject2.objdata = new PDFString("1");
            linearize.objs.put(new Integer(pDFUniversalObject2.obj_id), pDFUniversalObject2);
            pDFUniversalObject2 = new PDFUniversalObject(3);
            pDFUniversalObject2.objdata = new PDFString("1");
            linearize.objs.put(new Integer(pDFUniversalObject2.obj_id), pDFUniversalObject2);
            Hashtable hashtable = linearize.getSubObjects(1);
            if (hashtable.size() != 2) {
                Assert.fail((String)("Number of subobjects is  " + hashtable.size()));
            }
            int n = 2;
            while (n < 4) {
                if (!hashtable.containsKey(new Integer(n))) {
                    Assert.fail((String)("Can not find indirect object " + n));
                }
                ++n;
            }
        }

        public void testGetSubObjectsFromDictionary() {
            Linearize linearize = this.createTestLinearize();
            linearize.objs = new Hashtable();
            PDFUniversalObject pDFUniversalObject = new PDFUniversalObject(1);
            PDFArray pDFArray = new PDFArray();
            pDFArray.array.put(0, new PDFIndirectObject("2"));
            pDFArray.array.put(1, new PDFString("3"));
            pDFArray.array.put(2, new PDFIndirectObject("3"));
            PDFIndirectObject pDFIndirectObject = new PDFIndirectObject("4");
            PDFDictionary pDFDictionary = new PDFDictionary();
            pDFDictionary.dict.put("/1", pDFArray);
            pDFDictionary.dict.put("/2", pDFIndirectObject);
            pDFDictionary.dict.put("/3", new PDFString("3"));
            pDFUniversalObject.objdata = pDFDictionary;
            if (pDFUniversalObject.getIndirectObjects().isEmpty()) {
                Assert.fail((String)"Test PDFArray don`t contains indirect objects!");
            }
            linearize.objs.put(new Integer(1), pDFUniversalObject);
            PDFUniversalObject pDFUniversalObject2 = new PDFUniversalObject(2);
            pDFUniversalObject2.objdata = new PDFString("1");
            linearize.objs.put(new Integer(2), pDFUniversalObject2);
            pDFUniversalObject2 = new PDFUniversalObject(3);
            pDFUniversalObject2.objdata = new PDFString("1");
            linearize.objs.put(new Integer(3), pDFUniversalObject2);
            pDFUniversalObject2 = new PDFUniversalObject(4);
            pDFUniversalObject2.objdata = new PDFIndirectObject("5");
            linearize.objs.put(new Integer(4), pDFUniversalObject2);
            pDFUniversalObject2 = new PDFUniversalObject(5);
            pDFUniversalObject2.objdata = new PDFString("1");
            linearize.objs.put(new Integer(5), pDFUniversalObject2);
            Hashtable hashtable = null;
            try {
                hashtable = linearize.getSubObjects(1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Assert.fail((String)("Error " + exception));
                return;
            }
            if (hashtable.size() != 4) {
                Assert.fail((String)("Number of subobjects is  " + hashtable.size()));
            }
            int n = 2;
            while (n < 6) {
                if (!hashtable.containsKey(new Integer(n))) {
                    Assert.fail((String)("Can not find key " + n));
                }
                ++n;
            }
        }

        public void testGetSubObjectsFromIndirectObject() {
            Linearize linearize = this.createTestLinearize();
            linearize.objs = new Hashtable();
            PDFUniversalObject pDFUniversalObject = new PDFUniversalObject(1);
            PDFIndirectObject pDFIndirectObject = new PDFIndirectObject("2");
            if (pDFIndirectObject.getIndirectObjects().isEmpty()) {
                Assert.fail((String)"Test PDFIndirectObject don`t contains indirect objects!");
            }
            pDFUniversalObject.objdata = pDFIndirectObject;
            if (pDFUniversalObject.getIndirectObjects().isEmpty()) {
                Assert.fail((String)"Test PDFUniversalObject don`t contains indirect objects!");
            }
            linearize.objs.put(new Integer(1), pDFUniversalObject);
            PDFUniversalObject pDFUniversalObject2 = new PDFUniversalObject(2);
            pDFUniversalObject2.objdata = new PDFString("1");
            linearize.objs.put(new Integer(2), pDFUniversalObject2);
            Hashtable hashtable = linearize.getSubObjects(1);
            if (hashtable.size() != 1) {
                Assert.fail((String)("Number of subobjects is  " + hashtable.size()));
            }
            if (!hashtable.containsKey(new Integer(2))) {
                Assert.fail((String)"Indirect object 2 not founded.");
            }
        }

        public void testReadPages() {
            Linearize linearize = this.createTestLinearize();
            try {
                linearize.readObjects();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                Assert.fail((String)("Error in reading objects " + exception));
            }
            linearize.readPages();
            if (linearize.pages.length() != 1) {
                Assert.fail((String)("Wrong number of pages " + linearize.pages.length()));
            }
            if ((Integer)linearize.pages.get(0) != 5) {
                Assert.fail((String)("Wrong id of page " + linearize.pages.get(0)));
            }
        }

        public void testSeparateObjects() {
            Linearize linearize = this.createTestLinearize();
            try {
                linearize.readObjects();
            }
            catch (Exception exception) {
                Assert.fail((String)("Error in reading objects " + exception));
            }
            linearize.readPages();
            linearize.separateSubobjects();
            if (linearize.firstPageSubObjects.size() != 5) {
                Assert.fail((String)("Wrong number of first page subobjects " + linearize.firstPageSubObjects.size()));
            }
            int n = 6;
            while (n < 11) {
                if (!linearize.firstPageSubObjects.containsKey(new Integer(n))) {
                    Assert.fail((String)("Can not find first page subobject " + n));
                }
                ++n;
            }
            if (linearize.unicalSubObjects.size() != 0) {
                Assert.fail((String)("Wrong number of unical subobjects " + linearize.unicalSubObjects.size()));
            }
            if (linearize.sharedSubObjects.size() != 0) {
                Assert.fail((String)("Wrong number of shared subobjects  " + linearize.sharedSubObjects.size()));
            }
            if (linearize.nonPageObjects.size() != 3) {
                Assert.fail((String)("Wrong number of non page objects " + linearize.nonPageObjects.size()));
            }
            int n2 = 2;
            while (n2 < 5) {
                if (!linearize.nonPageObjects.containsKey(new Integer(n2))) {
                    Assert.fail((String)("Can not find non page object " + n2));
                }
                ++n2;
            }
        }

        public void testRenumberObjects() {
            Linearize linearize = this.createTestLinearize();
            try {
                linearize.readObjects();
            }
            catch (Exception exception) {
                Assert.fail((String)("Error in reading objects " + exception));
            }
            linearize.readPages();
            linearize.separateSubobjects();
            linearize.renumberObjects();
        }

        public Linearize createAndRenumber() {
            Linearize linearize = this.createTestLinearize();
            try {
                linearize.readObjects();
            }
            catch (Exception exception) {
                Assert.fail((String)("Error in reading objects " + exception));
            }
            linearize.readPages();
            linearize.separateSubobjects();
            linearize.renumberObjects();
            return linearize;
        }

        public Linearize createAndRenumber2() {
            Linearize linearize = this.createTestLinearize2();
            try {
                linearize.readObjects();
            }
            catch (Exception exception) {
                Assert.fail((String)("Error in reading objects " + exception));
            }
            linearize.readPages();
            linearize.separateSubobjects();
            linearize.renumberObjects();
            return linearize;
        }

        public Linearize createAndRenumber3() {
            Linearize linearize = this.createTestLinearize3();
            try {
                linearize.readObjects();
            }
            catch (Exception exception) {
                Assert.fail((String)("Error in reading objects " + exception));
            }
            linearize.readPages();
            linearize.separateSubobjects();
            linearize.renumberObjects();
            return linearize;
        }

        public Linearize createAndRenumber4() {
            Linearize linearize = this.createTestLinearize4();
            try {
                linearize.readObjects();
            }
            catch (Exception exception) {
                Assert.fail((String)("Error in reading objects " + exception));
            }
            linearize.readPages();
            linearize.separateSubobjects();
            linearize.renumberObjects();
            return linearize;
        }

        public void testcreateLinearizedDictionary() {
            Linearize linearize = this.createAndRenumber();
            Linearized linearized = linearize.createLinearizedDictionary(new IndirectObject(1));
            if (linearized.firstPageID != 6) {
                Assert.fail((String)("Wrong firstPageID " + linearized.firstPageID));
            }
            if (linearized.numberOfPages != 1) {
                Assert.fail((String)("Wrong numberOfPages " + linearized.numberOfPages));
            }
        }

        public void testcreateHintStreamDictionary() {
            Linearize linearize = this.createAndRenumber();
            PDFDocument pDFDocument = null;
            try {
                pDFDocument = linearize.createDestination();
            }
            catch (Exception exception) {
                Assert.fail((String)("Error in createDestination " + exception));
            }
            try {
                linearize.calcSizeOfObjects();
            }
            catch (Exception exception) {
                Assert.fail((String)("Error in calcSizeOfObjects " + exception));
            }
            HintStream hintStream = linearize.createFirstHintStream(new IndirectObject(linearize.counter++), pDFDocument);
            Linearized linearized = linearize.createLinearizedDictionary(new IndirectObject(linearize.counter++));
            PDFTrailer pDFTrailer = linearize.createFirstTrailer(linearized, null);
            linearize.appendLinearizedData(linearized, pDFTrailer.xref.xrefSize, hintStream);
            if (hintStream.pageOffset.leastNumber != 6) {
                Assert.fail((String)("Wrong least number of Page Hint Table " + hintStream.pageOffset.leastNumber));
            }
        }

        public void testFirstPageWithImagePDF() {
            Hashtable hashtable;
            Linearize linearize = this.createAndRenumber3();
            if (linearize.firstPageSubObjects.size() != 9) {
                Assert.fail((String)("Wrong number of first page subobjects " + linearize.firstPageSubObjects.size()));
            }
            if (linearize.unicalSubObjects.size() != 1) {
                Assert.fail((String)("Wrong number of unical subobjects " + linearize.unicalSubObjects.size()));
            }
            if ((hashtable = (Hashtable)linearize.unicalSubObjects.get(new Integer(1))).size() != 5) {
                Assert.fail((String)("Wrong number of unical subobjects for page 1 - " + hashtable.size()));
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                if (n < 11 || n > 20) {
                    Assert.fail((String)("Cannot find unical subobject for page 1 - " + n));
                }
                if (linearize.source.newID(n) <= 6) continue;
                Assert.fail((String)("Wrong new number of unical subobject for page 1 - " + n + " -> " + linearize.source.newID(n)));
            }
            if (linearize.sharedSubObjects.size() != 0) {
                Assert.fail((String)("Wrong number of shared subobjects  " + linearize.sharedSubObjects.size()));
            }
            if (linearize.nonPageObjects.size() != 3) {
                Assert.fail((String)("Wrong number of non page objects " + linearize.nonPageObjects.size()));
            }
            int n = 2;
            while (n < 5) {
                if (!linearize.nonPageObjects.containsKey(new Integer(n))) {
                    Assert.fail((String)("Can not find non page object " + n));
                }
                ++n;
            }
        }

        public void testPDFWithSharedObjects() {
            Integer n;
            Hashtable hashtable;
            Linearize linearize = this.createAndRenumber4();
            if (linearize.firstPageSubObjects.size() != 5) {
                Assert.fail((String)("Wrong number of first page subobjects " + linearize.firstPageSubObjects.size()));
            }
            int n2 = 6;
            while (n2 < 9) {
                if (!linearize.firstPageSubObjects.containsKey(new Integer(n2))) {
                    Assert.fail((String)("Can not find first page subobject " + n2));
                }
                ++n2;
            }
            if (linearize.unicalSubObjects.size() != 2) {
                Assert.fail((String)("Wrong number of unical subobjects " + linearize.unicalSubObjects.size()));
            }
            if ((hashtable = (Hashtable)linearize.unicalSubObjects.get(new Integer(1))).size() != 5) {
                Assert.fail((String)("Wrong number of unical subobjects for page 1 - " + hashtable.size()));
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                n = (Integer)enumeration.nextElement();
                if (n < 10 || n > 24) {
                    Assert.fail((String)("Cannot find unical subobject for page 1 - " + n));
                }
                if (linearize.source.newID(n) <= 6) continue;
                Assert.fail((String)("Wrong new number of unical subobject for page 1 - " + n + " -> " + linearize.source.newID(n)));
            }
            hashtable = (Hashtable)linearize.unicalSubObjects.get(new Integer(2));
            if (hashtable.size() != 5) {
                Assert.fail((String)("Wrong number of unical subobjects for page 2 - " + linearize.unicalSubObjects.size()));
            }
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                n = (Integer)enumeration.nextElement();
                if (n < 15 || n > 26) {
                    Assert.fail((String)("Cannot find unical subobject for page 2 - " + n));
                }
                if (linearize.source.newID(n) >= 8 && linearize.source.newID(n) <= 12) continue;
                Assert.fail((String)("Wrong new number of unical subobject for page 2 - " + n + " -> " + linearize.source.newID(n)));
            }
            if (linearize.sharedSubObjects.size() != 4) {
                Assert.fail((String)("Wrong number of shared subobjects  " + linearize.sharedSubObjects.size()));
            }
            if (linearize.nonPageObjects.size() != 3) {
                Assert.fail((String)("Wrong number of non page objects " + linearize.nonPageObjects.size()));
            }
            int n3 = 2;
            while (n3 < 5) {
                if (!linearize.nonPageObjects.containsKey(new Integer(n3))) {
                    Assert.fail((String)("Can not find non page object " + n3));
                }
                ++n3;
            }
        }

        public void test2PagePDF() {
            Hashtable hashtable;
            Linearize linearize = this.createAndRenumber2();
            if (linearize.firstPageSubObjects.size() != 5) {
                Assert.fail((String)("Wrong number of first page subobjects " + linearize.firstPageSubObjects.size()));
            }
            if (linearize.unicalSubObjects.size() != 1) {
                Assert.fail((String)("Wrong number of unical subobjects " + linearize.unicalSubObjects.size()));
            }
            if ((hashtable = (Hashtable)linearize.unicalSubObjects.get(new Integer(1))).size() != 5) {
                Assert.fail((String)("Wrong number of unical subobjects for page 1 - " + hashtable.size()));
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                if (n < 10 || n > 16) {
                    Assert.fail((String)("Cannot find subobject for page 1 - " + n));
                }
                if (linearize.source.newID(n) >= 2 && linearize.source.newID(n) <= 6) continue;
                Assert.fail((String)("Wrong new number of unical subobject for page 1 - " + n + " -> " + linearize.source.newID(n)));
            }
            if (linearize.sharedSubObjects.size() != 0) {
                Assert.fail((String)("Wrong number of shared subobjects  " + linearize.sharedSubObjects.size()));
            }
            if (linearize.nonPageObjects.size() != 3) {
                Assert.fail((String)("Wrong number of non page objects " + linearize.nonPageObjects.size()));
            }
            int n = 2;
            while (n < 5) {
                if (!linearize.nonPageObjects.containsKey(new Integer(n))) {
                    Assert.fail((String)("Can not find non page object " + n));
                }
                ++n;
            }
        }

        private void resourceToFile(String string, String string2) throws IOException {
            int n;
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray, 0, 1024)) >= 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
        }
    }
}

