/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.GenericHintRecord;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFException;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.PageOffsetHintRecord;
import com.renderx.pdflib.SharedObjectsHintRecord;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class HintStream
extends PDFObject {
    int length;
    PageOffsetHintRecord pageOffset;
    SharedObjectsHintRecord sharedObjects;
    GenericHintRecord outlines;
    GenericHintRecord namedDestinations;
    GenericHintRecord pageLabel;
    private ByteArrayOutputStream baos;
    byte[] bytes;

    HintStream(IndirectObject indirectObject) {
        super(indirectObject);
    }

    void setType() {
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        this.baos = new ByteArrayOutputStream();
        long l = 0L;
        try {
            byte[] byArray;
            byte[] byArray2;
            byte[] byArray3 = this.pageOffset.getBytes();
            int n = 0;
            if (byArray3 != null) {
                l += (long)byArray3.length;
                this.baos.write(byArray3);
                n = byArray3.length;
            }
            if ((byArray2 = this.sharedObjects.getBytes()) != null) {
                pDFOutputStream.write(("/S " + l + "\n").getBytes());
                this.baos.write(byArray2);
                l += (long)byArray2.length;
                n += byArray2.length;
            }
            if (this.outlines != null && (byArray = this.outlines.getBytes()) != null) {
                this.baos.write(byArray);
                pDFOutputStream.write(("/O " + l + "\n").getBytes());
                n += byArray.length;
                l += (long)byArray.length;
            }
            if (this.namedDestinations != null && (byArray = this.namedDestinations.getBytes()) != null) {
                this.baos.write(byArray);
                pDFOutputStream.write(("/E " + l + "\n").getBytes());
                n += byArray.length;
                l += (long)byArray.length;
            }
            pDFOutputStream.write(("/Length " + n + "\n").getBytes());
            if (pDFOutputStream.compression) {
                pDFOutputStream.write("/Filter /FlateDecode\n".getBytes());
            }
        }
        catch (IOException iOException) {
            throw new PDFException(iOException);
        }
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
    }

    void writeTail(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.println(">>");
        pDFOutputStream.println("stream");
        int n = pDFOutputStream.size();
        pDFOutputStream.startStream();
        try {
            pDFOutputStream.write(this.baos.toByteArray());
        }
        catch (IOException iOException) {
            throw new PDFException(iOException);
        }
        pDFOutputStream.finishStream();
        this.length = pDFOutputStream.size() - n;
        pDFOutputStream.println("\nendstream");
        pDFOutputStream.println("endobj");
    }
}

