/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics.vector;

import com.renderx.graphics.vector.GraphicObject;
import com.renderx.graphics.vector.PaintSpec;
import java.io.IOException;
import java.io.PrintStream;

public class StrokeSpec
extends GraphicObject {
    public PaintSpec paint = null;
    public double thickness = 0.0;
    public static final int LINECAP_BUTT = 0;
    public static final int LINECAP_ROUND = 1;
    public static final int LINECAP_SQUARE = 2;
    public int lineCap = 0;
    public static final int LINEJOIN_MITER = 0;
    public static final int LINEJOIN_ROUND = 1;
    public static final int LINEJOIN_BEVEL = 2;
    public int lineJoin = 0;
    public double miterLimit = 10.0;
    public double[] dashArray = null;
    public double dashPhase = 0.0;

    public StrokeSpec(PaintSpec paintSpec, double d) {
        this.paint = paintSpec;
        this.thickness = d;
    }

    public StrokeSpec cc() {
        StrokeSpec strokeSpec = new StrokeSpec(this.paint, this.thickness);
        strokeSpec.lineCap = this.lineCap;
        strokeSpec.lineJoin = this.lineJoin;
        strokeSpec.miterLimit = this.miterLimit;
        strokeSpec.dashArray = this.dashArray;
        strokeSpec.dashPhase = this.dashPhase;
        return strokeSpec;
    }

    public void dump(PrintStream printStream, String string) throws IOException {
        int n;
        if (this.paint == null) {
            return;
        }
        printStream.print(string + "%<stroke thickness=\"" + this.thickness + "\"");
        switch (this.lineCap) {
            case 0: {
                printStream.print(" line-cap=\"butt\"");
                break;
            }
            case 1: {
                printStream.print(" line-cap=\"round\"");
                break;
            }
            case 2: {
                printStream.print(" line-cap=\"square\"");
            }
        }
        switch (this.lineJoin) {
            case 0: {
                printStream.print(" line-join=\"miter\" miter-limit=\"" + this.miterLimit + "\"");
                break;
            }
            case 1: {
                printStream.print(" line-join=\"round\"");
                break;
            }
            case 2: {
                printStream.print(" line-join=\"bevel\"");
            }
        }
        if (this.dashArray != null) {
            printStream.print(" dash-array=\"");
            n = 0;
            while (n < this.dashArray.length) {
                if (n > 0) {
                    printStream.print(" ");
                }
                printStream.print("" + this.dashArray[n]);
                ++n;
            }
            printStream.print("\" dash-phase=\"" + this.dashPhase + "\"");
        }
        printStream.println(">");
        printStream.println(string + "  " + this.thickness + " setlinewidth");
        printStream.println(string + "  " + this.lineCap + " setlinecap");
        printStream.println(string + "  " + this.lineJoin + " setlinejoin");
        if (this.lineJoin == 0) {
            printStream.println(string + "  " + this.miterLimit + " setmiterlimit");
        }
        this.paint.dump(printStream, string + "  ");
        if (this.dashArray != null) {
            printStream.print(string + "  [");
            n = 0;
            while (n < this.dashArray.length) {
                if (n > 0) {
                    printStream.print(" ");
                }
                printStream.print("" + this.dashArray[n]);
                ++n;
            }
            printStream.println("] " + this.dashPhase + " setdash");
        }
        printStream.println(string + "%</stroke>");
    }
}

