/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts;

import com.renderx.fonts.CharMetrics;
import com.renderx.fonts.Encoding;
import com.renderx.fonts.FontCatalog;
import com.renderx.fonts.FontDescriptor;
import com.renderx.fonts.FontRecord;
import com.renderx.fonts.UsedGlyphs;
import com.renderx.util.Array;
import com.renderx.util.Hashtable;
import java.io.IOException;

public abstract class U28 {
    public final Hashtable fontStateTable = new Hashtable();
    protected FontDescriptor curFont = null;
    protected boolean fontSpecified = false;
    protected boolean forceAddFont = false;
    protected int fontEncoding = 0;
    protected final FontCatalog catalog;
    protected Hashtable encodingTablesCache = new Hashtable();
    protected Hashtable usedGlyphsCache = new Hashtable();
    protected char[] txt = new char[32];
    protected int itxt = 0;

    public U28(FontCatalog fontCatalog) {
        this.catalog = fontCatalog;
    }

    protected abstract void flushTextBuffer() throws IOException;

    protected abstract boolean isOneByteText(FontRecord var1);

    protected abstract boolean isProcessAsUnicode(FontRecord var1);

    public void resetFont() {
        this.fontSpecified = false;
    }

    public void selectFont(String string, int n, String string2, String string3) {
        this.selectFont(string, n, string2, string3, false);
    }

    public void selectFont(String string, int n, String string2, String string3, boolean bl) {
        this.fontSpecified = false;
        this.fontEncoding = 0;
        FontRecord fontRecord = this.catalog.getFontRecord(string, n, string2, string3);
        this.curFont = (FontDescriptor)this.fontStateTable.get(fontRecord);
        if (this.curFont != null) {
            return;
        }
        String string4 = fontRecord.getMetric().fontName;
        Array array = (Array)this.encodingTablesCache.get(string4);
        UsedGlyphs usedGlyphs = (UsedGlyphs)this.usedGlyphsCache.get(string4);
        this.curFont = new FontDescriptor(fontRecord, array, usedGlyphs, bl);
        this.fontStateTable.put(fontRecord, this.curFont);
        this.encodingTablesCache.put(string4, this.curFont.encodingTable);
        this.usedGlyphsCache.put(string4, this.curFont.used);
    }

    public void processText(String string) throws IOException {
        this.processText(string, false, false);
    }

    public void processText(String string, boolean bl, boolean bl2) throws IOException {
        this.forceAddFont = bl;
        if (this.isOneByteText(this.curFont.record)) {
            if (bl2) {
                this.processFormFieldCaption(string);
            } else {
                this.processOneByteText(string);
            }
        } else if (this.isProcessAsUnicode(this.curFont.record)) {
            this.processMultiByteTextUnicode(string);
        } else {
            this.processMultiByteTextCID(string);
        }
    }

    private Encoding getEncoding() {
        Encoding encoding = null;
        if (!this.curFont.canExtend) {
            if (this.curFont.encodingTable.length() == 0) {
                throw new RuntimeException("Empty encoding table in font descriptor");
            }
            encoding = (Encoding)this.curFont.encodingTable.get(this.fontEncoding);
        } else if (this.curFont.encodingTable.length() != 0) {
            try {
                encoding = (Encoding)this.curFont.encodingTable.get(this.fontEncoding);
            }
            catch (Exception exception) {
                throw new RuntimeException("Wrong encoding is specified");
            }
        } else {
            encoding = new Encoding();
            this.curFont.encodingTable.put(0, encoding);
        }
        return encoding;
    }

    private void processFormFieldCaption(String string) throws IOException {
        if (this.txt.length < string.length()) {
            this.txt = new char[string.length()];
        }
        Encoding encoding = this.getEncoding();
        int n = 0;
        while (n < string.length()) {
            block7: {
                int n2;
                char c;
                block6: {
                    c = string.charAt(n);
                    n2 = encoding.getCode(c);
                    CharMetrics charMetrics = this.curFont.record.getMetric().ucm(c);
                    if (charMetrics != null) break block6;
                    charMetrics = this.curFont.record.getMetric().missingGlyph;
                    if (charMetrics == null) break block7;
                    c = charMetrics.uc;
                    n2 = encoding.getCode(c);
                }
                if (n2 != -1) {
                    this.txt[this.itxt++] = (char)n2;
                    this.curFont.used.markGlyph(c);
                }
            }
            ++n;
        }
        this.flushTextBuffer();
    }

    private void processOneByteText(String string) throws IOException {
        if (this.txt.length < string.length()) {
            this.txt = new char[string.length()];
        }
        Encoding encoding = this.getEncoding();
        int n = 0;
        while (n < string.length()) {
            block8: {
                int n2;
                char c;
                block9: {
                    int n3;
                    Encoding encoding2;
                    block10: {
                        CharMetrics charMetrics;
                        block11: {
                            block7: {
                                c = string.charAt(n);
                                n2 = encoding.getCode(c);
                                charMetrics = this.curFont.record.getMetric().ucm(c);
                                if (charMetrics != null) break block7;
                                charMetrics = this.curFont.record.getMetric().missingGlyph;
                                if (charMetrics == null) break block8;
                                c = charMetrics.uc;
                                n2 = encoding.getCode(c);
                            }
                            if (n2 != -1) break block9;
                            encoding2 = null;
                            n3 = 0;
                            while (n3 < this.curFont.encodingTable.length()) {
                                encoding2 = (Encoding)this.curFont.encodingTable.get(n3);
                                if (encoding2 == null) {
                                    throw new RuntimeException("Null encoding in font descriptor");
                                }
                                n2 = encoding2.getCode(c);
                                if (n2 != -1) break;
                                ++n3;
                            }
                            if (n2 != -1) break block10;
                            if (this.curFont.canExtend) break block11;
                            this.curFont.hasUnmappedChars = true;
                            n3 = this.fontEncoding;
                            charMetrics = this.curFont.record.getMetric().ucm(' ');
                            if (charMetrics == null && (charMetrics = this.curFont.record.getMetric().missingGlyph) == null) break block8;
                            c = charMetrics.uc;
                            n2 = encoding.getCode(c);
                            break block10;
                        }
                        if (encoding2.hasRoom()) {
                            --n3;
                        } else {
                            encoding2 = new Encoding();
                            this.curFont.encodingTable.put(n3, encoding2);
                        }
                        n2 = encoding2.assignCode(c, charMetrics);
                    }
                    if (n3 != this.fontEncoding) {
                        this.flushTextBuffer();
                        this.fontSpecified = false;
                        this.fontEncoding = n3;
                        encoding = encoding2;
                    }
                }
                this.txt[this.itxt++] = (char)n2;
                this.curFont.used.markGlyph(c);
            }
            ++n;
        }
        this.flushTextBuffer();
    }

    public void processMultiByteTextUnicode(String string) throws IOException {
        if (this.txt.length < 2 * string.length()) {
            this.txt = new char[2 * string.length()];
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            this.txt[this.itxt++] = (char)(c >> 8 & 0xFF);
            this.txt[this.itxt++] = (char)(c & 0xFF);
            this.curFont.used.markGlyph(c);
            ++n;
        }
        this.flushTextBuffer();
    }

    public void processMultiByteTextCID(String string) throws IOException {
        if (this.txt.length < 2 * string.length()) {
            this.txt = new char[2 * string.length()];
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            CharMetrics charMetrics = this.curFont.record.getMetric().ucm(c);
            if (charMetrics == null) {
                c = '\u0000';
            } else {
                this.curFont.used.markGlyph(c);
                c = (char)charMetrics.c;
            }
            this.txt[this.itxt++] = (char)(c >> 8 & 0xFF);
            this.txt[this.itxt++] = (char)(c & 0xFF);
            ++n;
        }
        this.flushTextBuffer();
    }
}

