/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afplib.AFP;
import com.renderx.afplib.AFPException;
import com.renderx.afplib.AFPInternalException;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.xep.pre.Attr;
import java.io.IOException;

public class HighlightColorRegistry {
    private static final int MIN_COLOR_ID = 256;
    private static final int MAX_COLOR_ID = 65279;
    private static final int COLOR_MAPPING_TABLE_TYPE_CMT = 1;
    private static final int COLOR_MAPPING_TABLE_TYPE_RESET = 129;
    protected Hashtable colors = new Hashtable();
    public int nextColorId = 256;

    public int registerColor(Attr.Color.SpotColor spotColor, ErrorHandler errorHandler) throws AFPInternalException {
        int n = this.nextColorId + 1;
        if (n > 65279) {
            throw new AFPException("Color Table ID overflow");
        }
        int n2 = this.registerColor(spotColor, n, errorHandler, false);
        if (n2 == n) {
            this.nextColorId = n;
        }
        return n2;
    }

    public int registerColor(Attr.Color.SpotColor spotColor, int n, ErrorHandler errorHandler) throws AFPInternalException {
        return this.registerColor(spotColor, n, errorHandler, true);
    }

    protected int registerColor(Attr.Color.SpotColor spotColor, int n, ErrorHandler errorHandler, boolean bl) throws AFPInternalException {
        int n2 = this.getColorIndex(spotColor.colorant);
        if (n2 == 0) {
            this.colors.put(spotColor.colorant.toUpperCase(), new Entry(spotColor, n));
            n2 = n;
        } else if (bl) {
            errorHandler.warning("Duplicate Highlight Color ID: colorant=[" + spotColor.colorant + "], id=[" + n + "]; alreagy registered id=[" + n2 + "]");
        }
        return n2;
    }

    public int getColorIndex(String string) {
        Entry entry = (Entry)this.colors.get(string.toUpperCase());
        return entry == null ? 0 : entry.Id;
    }

    public void writeToAfp(AFP aFP) throws IOException {
    }

    public void clear() {
        this.colors.clear();
    }

    private final class Entry {
        public int Id;
        public Attr.Color.SpotColor color;

        public Entry(Attr.Color.SpotColor spotColor, int n) {
            this.Id = n;
            this.color = spotColor;
        }
    }
}

