/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xpslib;

import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.VectorImage;
import com.renderx.graphics.vector.Contour;
import com.renderx.graphics.vector.ExternalImage;
import com.renderx.graphics.vector.Gradient;
import com.renderx.graphics.vector.GraphicGroup;
import com.renderx.graphics.vector.GraphicObject;
import com.renderx.graphics.vector.ImageTree;
import com.renderx.graphics.vector.Link;
import com.renderx.graphics.vector.OpaqueColor;
import com.renderx.graphics.vector.PaintServer;
import com.renderx.graphics.vector.PaintSpec;
import com.renderx.graphics.vector.Path;
import com.renderx.graphics.vector.Pattern;
import com.renderx.graphics.vector.StrokeSpec;
import com.renderx.graphics.vector.Subpath;
import com.renderx.graphics.vector.Text;
import com.renderx.util.List;
import com.renderx.util.URLSpec;
import com.renderx.xpslib.XPSDocument;
import java.io.IOException;
import java.util.Enumeration;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGImageHandler {
    List subimages = new List();
    boolean clippingPending = false;
    boolean simpleClipping = false;
    VectorImage lastSubobj;
    double[] clipMatrix = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
    double[] contentMatrix = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
    String d = "";
    private String svgID = "";
    private boolean written = false;
    ImageTree imageTree = null;
    private int nestingLevel = 0;
    private AttributesImpl attrs = new AttributesImpl();

    public SVGImageHandler(String string) {
        this.svgID = string;
    }

    public String getID() {
        return this.svgID;
    }

    public void write(ImageTree imageTree, XPSDocument xPSDocument, float f, boolean bl) throws IOException, SAXException {
        this.imageTree = imageTree;
        this.attrs.clear();
        this.attrs.addAttribute("", "RenderTransform", "RenderTransform", "CDATA", "1,0,0,1,0,0");
        if (bl) {
            this.attrs.addAttribute("", "x:Key", "x:Key", "CDATA", this.svgID);
        }
        xPSDocument.openElement("Canvas", this.attrs);
        this.attrs.clear();
        this.writeImageTree(xPSDocument);
        xPSDocument.closeCanvas();
        this.written = true;
    }

    public void write(ImageTree imageTree, XPSDocument xPSDocument, float f) throws IOException, SAXException {
        this.write(imageTree, xPSDocument, f, true);
    }

    private void writeImageTree(XPSDocument xPSDocument) throws IOException, SAXException {
        this.PaintGraphicObject(xPSDocument, this.imageTree.root);
    }

    private void PaintGraphicObject(XPSDocument xPSDocument, GraphicObject graphicObject) throws IOException, SAXException {
        if (graphicObject instanceof GraphicGroup) {
            GraphicGroup graphicGroup = (GraphicGroup)graphicObject;
            boolean bl = false;
            boolean bl2 = false;
            double[] dArray = this.contentMatrix;
            double[] dArray2 = this.contentMatrix;
            if (!this.clippingPending) {
                boolean bl3 = bl = !graphicGroup.isIdentityTransform() || graphicGroup.clippath != null;
                if (!graphicGroup.isIdentityTransform()) {
                    this.setMatrix(graphicGroup.matrix);
                    dArray2 = GraphicObject.multipleMatrix(this.contentMatrix, graphicGroup.matrix);
                }
                if (bl) {
                    xPSDocument.openElement("Canvas", this.attrs);
                    this.attrs.clear();
                }
                if (graphicGroup.clippath != null) {
                    this.attrs.clear();
                    xPSDocument.openElement("Canvas.Clip", this.attrs);
                    bl2 = !this.clippingPending;
                    this.clippingPending = true;
                    GraphicGroup graphicGroup2 = graphicGroup.clippath;
                    this.simpleClipping = graphicGroup2.isSimple();
                    graphicGroup = (GraphicGroup)graphicGroup.clone();
                    graphicGroup.clippath = null;
                    graphicGroup.matrix = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                    this.PaintGraphicObject(xPSDocument, graphicGroup2);
                    this.attrs.addAttribute("", "Figures", "Figures", "CDATA", this.d);
                    xPSDocument.openElement("PathGeometry", this.attrs);
                    xPSDocument.closeElement("PathGeometry");
                    this.attrs.clear();
                    this.d = "";
                    xPSDocument.closeElement("Canvas.Clip");
                    this.clippingPending = false;
                    this.PaintGraphicObject(xPSDocument, graphicGroup);
                } else {
                    Enumeration enumeration = graphicGroup.children.elements();
                    while (enumeration.hasMoreElements()) {
                        this.contentMatrix = dArray2;
                        this.PaintGraphicObject(xPSDocument, (GraphicObject)enumeration.nextElement());
                    }
                    this.contentMatrix = dArray;
                }
                if (bl2) {
                    this.clippingPending = false;
                }
                if (bl) {
                    xPSDocument.closeElement("Canvas");
                }
            } else {
                double[] dArray3;
                if (graphicGroup.clippath != null) {
                    // empty if block
                }
                double[] dArray4 = this.clipMatrix;
                double[] dArray5 = dArray3 = graphicGroup.isIdentityTransform() ? this.clipMatrix : GraphicObject.multipleMatrix(this.clipMatrix, graphicGroup.matrix);
                if (!this.simpleClipping || graphicGroup.children.length() > 1) {
                    // empty if block
                }
                Enumeration enumeration = graphicGroup.children.elements();
                while (enumeration.hasMoreElements()) {
                    this.clipMatrix = dArray3;
                    GraphicObject graphicObject2 = (GraphicObject)enumeration.nextElement();
                    if (graphicObject2 instanceof Contour) {
                        if (!GraphicObject.isIdentityTransform(this.clipMatrix)) {
                            this.setMatrix(this.clipMatrix);
                        }
                        this.PaintGraphicObject(xPSDocument, graphicObject2);
                        if (!GraphicObject.isIdentityTransform(this.clipMatrix)) {
                            this.setMatrix(GraphicObject.reverseMatrix(this.clipMatrix));
                        }
                        if (this.simpleClipping) continue;
                        continue;
                    }
                    if (!(graphicObject2 instanceof GraphicGroup)) continue;
                    this.PaintGraphicObject(xPSDocument, graphicObject2);
                }
                this.clipMatrix = dArray4;
            }
        } else if (graphicObject instanceof Contour) {
            boolean bl;
            Contour contour = (Contour)graphicObject;
            boolean bl4 = contour.fill != null;
            boolean bl5 = bl = contour.stroke != null && contour.stroke.paint != null;
            if (contour instanceof Path) {
                Path path = (Path)contour;
                boolean bl6 = this.isPaintServered(path.fill);
                if (bl4 && !this.clippingPending && !bl6) {
                    this.attrs.addAttribute("", "Fill", "Fill", "CDATA", "#" + this.getPaintSpec(path.fill));
                }
                if (bl && !this.clippingPending) {
                    this.setStrokeSpec(path.stroke);
                }
                Enumeration enumeration = path.subs.elements();
                while (enumeration.hasMoreElements()) {
                    String string = this.GenerateSubpath((Subpath)enumeration.nextElement());
                    this.d = this.d + string;
                }
                if (!this.clippingPending) {
                    if (!this.d.equals("")) {
                        this.attrs.addAttribute("", "Data", "Data", "CDATA", this.d);
                        xPSDocument.openElement("Path", this.attrs);
                        this.attrs.clear();
                        this.d = "";
                        this.writePaintServer(xPSDocument, path.fill);
                        xPSDocument.closeElement("Path");
                    }
                    this.attrs.clear();
                }
            } else if (graphicObject instanceof Text) {
                Text text = (Text)contour;
                if (!this.clippingPending) {
                    String string = "";
                    this.attrs.clear();
                    if (bl) {
                        string = this.getPaintSpec(text.stroke.paint);
                    }
                    if (bl4) {
                        string = this.getPaintSpec(text.fill);
                    }
                    xPSDocument.selectFont(text.font.family, text.font.weight, text.font.style, text.font.variant, (float)text.font.size);
                    xPSDocument.transform((float)text.font.stretch, 0.0f, 0.0f, -1.0f, (float)text.x, (float)text.y);
                    xPSDocument.printText(new String(text.value), string);
                    xPSDocument.closeCanvas();
                }
            }
        } else if (graphicObject instanceof ExternalImage) {
            ExternalImage externalImage = (ExternalImage)graphicObject;
            String string = externalImage.image.mimetype;
            xPSDocument.drawImage(externalImage.image.source, string, 0.0f, 0.0f, 0.001f, 0.001f, false);
        } else if (graphicObject instanceof Link) {
            Link link = (Link)graphicObject;
            xPSDocument.putExternalLink((float)link.xfrom, (float)link.yfrom, (float)link.xtill, (float)link.ytill, link.dest);
        }
    }

    String GenerateSubpath(Subpath subpath) throws IOException {
        String string = "M " + (float)subpath.startX + "," + (float)subpath.startY;
        Enumeration enumeration = subpath.segs.elements();
        while (enumeration.hasMoreElements()) {
            Subpath.Segment segment;
            Subpath.Segment segment2 = (Subpath.Segment)enumeration.nextElement();
            if (segment2 instanceof Subpath.Line) {
                segment = (Subpath.Line)segment2;
                string = string + " L " + (float)segment.xend + "," + (float)segment.yend;
                continue;
            }
            if (!(segment2 instanceof Subpath.Curve)) continue;
            segment = (Subpath.Curve)segment2;
            string = string + " C " + (float)((Subpath.Curve)segment).cpx1 + "," + (float)((Subpath.Curve)segment).cpy1 + " " + (float)((Subpath.Curve)segment).cpx2 + "," + (float)((Subpath.Curve)segment).cpy2 + " " + (float)((Subpath.Curve)segment).xend + "," + (float)((Subpath.Curve)segment).yend;
        }
        if (subpath.closed) {
            string = string + " z ";
        }
        return string;
    }

    void setStrokeSpec(StrokeSpec strokeSpec) throws IOException {
        this.attrs.addAttribute("", "StrokeThickness", "StrokeThickness", "CDATA", "" + (float)strokeSpec.thickness);
        String string = "";
        string = strokeSpec.lineCap == 1 ? "Round" : (strokeSpec.lineCap == 2 ? "Square" : "Flat");
        this.attrs.addAttribute("", "StrokeEndLineCap", "StrokeEndLineCap", "CDATA", string);
        this.attrs.addAttribute("", "StrokeStartLineCap", "StrokeStartLineCap", "CDATA", string);
        String string2 = "";
        string2 = strokeSpec.lineJoin == 1 ? "Round" : (strokeSpec.lineJoin == 2 ? "Bevel" : "Miter");
        this.attrs.addAttribute("", "StrokeLineJoin", "StrokeLineJoin", "CDATA", string2);
        if (strokeSpec.lineJoin == 0) {
            this.attrs.addAttribute("", "StrokeMiterLimit", "StrokeMiterLimit", "CDATA", "" + (float)strokeSpec.miterLimit);
        }
        this.attrs.addAttribute("", "Stroke", "Stroke", "CDATA", "#" + this.getPaintSpec(strokeSpec.paint));
        String string3 = "";
        if (strokeSpec.dashArray != null) {
            int n = 0;
            while (n < strokeSpec.dashArray.length) {
                if (n > 0) {
                    string3 = string3 + " ";
                }
                string3 = string3 + (float)strokeSpec.dashArray[n];
                ++n;
            }
            this.attrs.addAttribute("", "StrokeDashOffset", "StrokeDashOffset", "CDATA", "" + (float)strokeSpec.dashPhase);
        }
    }

    void writePaintServer(XPSDocument xPSDocument, PaintSpec paintSpec) throws IOException, SAXException {
        if (paintSpec instanceof PaintServer) {
            PaintServer paintServer = (PaintServer)paintSpec;
            if (paintServer instanceof Pattern) {
                this.writePattern(xPSDocument, (Pattern)paintServer);
            } else if (paintServer instanceof Gradient) {
                this.writeGradient(xPSDocument, (Gradient)paintServer);
            }
        }
    }

    void writePattern(XPSDocument xPSDocument, Pattern pattern) throws IOException, SAXException {
        xPSDocument.openElement("Path.Fill", this.attrs);
        this.attrs.addAttribute("", "TileMode", "Tilemode", "CDATA", "Tile");
        this.attrs.addAttribute("", "ViewportUnits", "ViewportUnits", "CDATA", "Absolute");
        this.attrs.addAttribute("", "ViewboxUnits", "ViewboxUnits", "CDATA", "Absolute");
        this.attrs.addAttribute("", "Viewbox", "Viewbox", "CDATA", "0,0," + pattern.xstep + "," + pattern.ystep);
        this.attrs.addAttribute("", "Viewport", "Viewport", "CDATA", "0,0," + pattern.xstep + "," + pattern.ystep);
        String string = "" + pattern.matrix[0];
        int n = 1;
        while (n < pattern.matrix.length) {
            string = string + "," + pattern.matrix[n];
            ++n;
        }
        this.attrs.addAttribute("", "Transform", "Transform", "CDATA", string);
        xPSDocument.openElement("VisualBrush", this.attrs);
        this.attrs.clear();
        xPSDocument.openElement("VisualBrush.Visual", this.attrs);
        this.PaintGraphicObject(xPSDocument, pattern.content);
        xPSDocument.closeElement("VisualBrush.Visual");
        xPSDocument.closeElement("VisualBrush");
        xPSDocument.closeElement("Path.Fill");
    }

    void writeGradient(XPSDocument xPSDocument, Gradient gradient) throws IOException, SAXException {
        Object object;
        String string = "";
        if (gradient instanceof Gradient.LinearGradient) {
            string = "Linear";
            object = (Gradient.LinearGradient)gradient;
            this.attrs.addAttribute("", "StartPoint", "StartPoint", "CDATA", "" + ((Gradient.LinearGradient)object).xbeg + "," + ((Gradient.LinearGradient)object).ybeg);
            this.attrs.addAttribute("", "EndPoint", "EndPoint", "CDATA", "" + ((Gradient.LinearGradient)object).xend + "," + ((Gradient.LinearGradient)object).yend);
        } else if (gradient instanceof Gradient.RadialGradient) {
            string = "Radial";
            object = (Gradient.RadialGradient)gradient;
            this.attrs.addAttribute("", "Center", "Center", "CDATA", "" + ((Gradient.RadialGradient)object).xend + "," + ((Gradient.RadialGradient)object).yend);
            this.attrs.addAttribute("", "GradientOrigin", "GradientOrigin", "CDATA", "" + ((Gradient.RadialGradient)object).xbeg + "," + ((Gradient.RadialGradient)object).ybeg);
            this.attrs.addAttribute("", "RadiusX", "RadiusX", "CDATA", "" + ((Gradient.RadialGradient)object).rend);
            this.attrs.addAttribute("", "RadiusY", "RadiusY", "CDATA", "" + ((Gradient.RadialGradient)object).rend);
        }
        if (string == "") {
            return;
        }
        xPSDocument.openElement("Path.Fill", null);
        object = "" + gradient.matrix[0];
        int n = 1;
        while (n < gradient.matrix.length) {
            object = (String)object + "," + gradient.matrix[n];
            ++n;
        }
        this.attrs.addAttribute("", "Transform", "Transform", "CDATA", (String)object);
        this.attrs.addAttribute("", "MappingMode", "MappingMode", "CDATA", "Absolute");
        xPSDocument.openElement(string + "GradientBrush", this.attrs);
        this.attrs.clear();
        xPSDocument.openElement(string + "GradientBrush.GradientStops", this.attrs);
        Enumeration enumeration = gradient.stoplist.elements();
        while (enumeration.hasMoreElements()) {
            Gradient.Stop stop = (Gradient.Stop)enumeration.nextElement();
            this.attrs.addAttribute("", "Offset", "Offset", "CDATA", "" + stop.offset);
            this.attrs.addAttribute("", "Color", "Color", "CDATA", "#" + this.getPaintSpec(stop.color));
            xPSDocument.injectElement("GradientStop", this.attrs);
            this.attrs.clear();
        }
        xPSDocument.closeElement(string + "GradientBrush.GradientStops");
        xPSDocument.closeElement(string + "GradientBrush");
        xPSDocument.closeElement("Path.Fill");
    }

    String getPaintSpec(PaintSpec paintSpec) throws IOException {
        PaintServer paintServer;
        if (paintSpec instanceof OpaqueColor.Grayscale) {
            OpaqueColor.Grayscale grayscale = (OpaqueColor.Grayscale)paintSpec;
            return this.getXPSGreyColor((float)grayscale.g);
        }
        if (paintSpec instanceof OpaqueColor.RGB) {
            OpaqueColor.RGB rGB = (OpaqueColor.RGB)paintSpec;
            return this.getXPSRGBColor((float)rGB.r, (float)rGB.g, (float)rGB.b);
        }
        if (paintSpec instanceof OpaqueColor.CMYK) {
            OpaqueColor.CMYK cMYK = (OpaqueColor.CMYK)paintSpec;
            return this.getXPSCMYKColor((float)cMYK.c, (float)cMYK.m, (float)cMYK.y, (float)cMYK.k);
        }
        if (!(paintSpec instanceof OpaqueColor.SpotColor) && !(paintSpec instanceof OpaqueColor.Registration) && paintSpec instanceof PaintServer && (paintServer = (PaintServer)paintSpec) instanceof Gradient) {
            Gradient gradient = (Gradient)paintServer;
        }
        return "000000";
    }

    boolean isPaintServered(PaintSpec paintSpec) {
        return paintSpec instanceof PaintServer;
    }

    private void setMatrix(double[] dArray) {
        this.attrs.addAttribute("", "RenderTransform", "RenderTransform", "CDATA", "" + (float)dArray[0] + "," + (float)dArray[1] + "," + (float)dArray[2] + "," + (float)dArray[3] + "," + (float)dArray[4] + "," + (float)dArray[5]);
    }

    private VectorImage getVectorImageSubObject(GraphicGroup graphicGroup, double[] dArray) throws IOException {
        double[] dArray2 = SVGImageHandler.calcBBox(this.imageTree.startX, this.imageTree.startY, this.imageTree.width, this.imageTree.height, GraphicObject.reverseMatrix(dArray));
        ImageTree imageTree = new ImageTree(dArray2[0], dArray2[1], dArray2[2] - dArray2[0], dArray2[3] - dArray2[1]);
        imageTree.root = graphicGroup;
        SubTreeVectorImage subTreeVectorImage = new SubTreeVectorImage(imageTree);
        subTreeVectorImage.supportsVectorRendering = true;
        return subTreeVectorImage;
    }

    private static double[] calcBBox(double d, double d2, double d3, double d4, double[] dArray) {
        double[] dArray2;
        double[] dArray3 = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] dArray4 = GraphicObject.transformPoint(dArray, d, d2);
        if (dArray4[0] < (dArray2 = GraphicObject.transformPoint(dArray, d + d3, d2 + d4))[0]) {
            dArray3[0] = dArray4[0];
            dArray3[2] = dArray2[0];
        } else {
            dArray3[0] = dArray2[0];
            dArray3[2] = dArray4[0];
        }
        if (dArray4[1] < dArray2[1]) {
            dArray3[1] = dArray4[1];
            dArray3[3] = dArray2[1];
        } else {
            dArray3[1] = dArray2[1];
            dArray3[3] = dArray4[1];
        }
        return dArray3;
    }

    public String getXPSRGBColor(float f, float f2, float f3) {
        String string = Integer.toHexString(Math.round(255.0f * f));
        String string2 = Integer.toHexString(Math.round(255.0f * f2));
        String string3 = Integer.toHexString(Math.round(255.0f * f3));
        if (string.length() < 2) {
            string = "0" + string;
        }
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (string3.length() < 2) {
            string3 = "0" + string3;
        }
        return string + string2 + string3;
    }

    public String getXPSGreyColor(float f) {
        String string = Integer.toHexString(Math.round(255.0f * f));
        if (string.length() < 2) {
            string = "0" + string;
        }
        return string + string + string;
    }

    public String getXPSCMYKColor(float f, float f2, float f3, float f4) {
        float f5 = 1.0f - f4;
        int n = f5 > f ? Math.round((f5 - f) * 255.0f) : 0;
        int n2 = f5 > f2 ? Math.round((f5 - f2) * 255.0f) : 0;
        int n3 = f5 > f3 ? Math.round((f5 - f3) * 255.0f) : 0;
        String string = Integer.toHexString(n);
        String string2 = Integer.toHexString(n2);
        String string3 = Integer.toHexString(n3);
        if (string.length() < 2) {
            string = "0" + string;
        }
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (string3.length() < 2) {
            string3 = "0" + string3;
        }
        return string + string2 + string3;
    }

    static class SubTreeVectorImage
    extends VectorImage {
        ImageTree imageTree = null;

        public void parse() throws IOException, ImageFormatException {
        }

        public SubTreeVectorImage(ImageTree imageTree) throws IOException {
            this.imageTree = imageTree;
            this.source = new URLSpec("data:,");
        }

        public ImageTree getImageTree() throws IOException, ImageFormatException {
            return this.imageTree;
        }
    }
}

