/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre.att;

import com.renderx.util.Array;
import com.renderx.util.Hashtable;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.AttributeParser;
import com.renderx.xep.pre.ParserContext;
import com.renderx.xep.pre.ParserException;
import com.renderx.xep.pre.Token;
import com.renderx.xep.pre.att.Literal;
import java.util.Stack;

public class TextShadow
extends Literal {
    private Hashtable colors = new Hashtable();

    public TextShadow(String string, String string2) throws ParserException {
        super(string, string2);
        this.colors.put("black", AttributeParser.parse("#000000"));
        this.colors.put("gray", AttributeParser.parse("#808080"));
        this.colors.put("silver", AttributeParser.parse("#C0C0C0"));
        this.colors.put("white", AttributeParser.parse("#FFFFFF"));
        this.colors.put("maroon", AttributeParser.parse("#800000"));
        this.colors.put("red", AttributeParser.parse("#FF0000"));
        this.colors.put("purple", AttributeParser.parse("#800080"));
        this.colors.put("fuchsia", AttributeParser.parse("#FF00FF"));
        this.colors.put("green", AttributeParser.parse("#008000"));
        this.colors.put("lime", AttributeParser.parse("#00FF00"));
        this.colors.put("olive", AttributeParser.parse("#808000"));
        this.colors.put("yellow", AttributeParser.parse("#FFFF00"));
        this.colors.put("navy", AttributeParser.parse("#000080"));
        this.colors.put("blue", AttributeParser.parse("#0000FF"));
        this.colors.put("teal", AttributeParser.parse("#008080"));
        this.colors.put("aqua", AttributeParser.parse("#00FFFF"));
    }

    public void process(String string, ParserContext parserContext) throws ParserException {
        Attr[] attrArray;
        Object object;
        Array array = new Array();
        ShadowDescriptor shadowDescriptor = null;
        Stack stack = AttributeParser.parseShorthand(string);
        if (stack.size() == 1) {
            object = (Token)stack.pop();
            if (((Token)object).type == 8192 && ((attrArray = ((Token)object).value.evaluate(parserContext, this)) == Attr.none || attrArray instanceof Attr.Composite)) {
                parserContext.addAttribute(this, (Attr)attrArray);
                return;
            }
            parserContext.session.warning("Invalid value of " + this.name + " attribute: " + ((Token)object).value.toString() + "; shadow set to none.");
            parserContext.addAttribute(this, Attr.none);
        }
        object = stack.elements();
        while (object.hasMoreElements()) {
            attrArray = (Attr[])object.nextElement();
            if (attrArray.type == 8) {
                if (shadowDescriptor == null) continue;
                if (shadowDescriptor.lcount >= 2) {
                    array.put(array.length(), shadowDescriptor);
                } else {
                    parserContext.session.warning("Invalid structure of " + this.name + " attribute: too few consecutive lengths");
                }
                shadowDescriptor = null;
                continue;
            }
            if (attrArray.type != 8192) {
                parserContext.session.warning("Unexpected token in " + this.name + ": " + attrArray.getTypeName());
                continue;
            }
            Attr attr = attrArray.value.evaluate(parserContext, this);
            if (attr instanceof Attr.Color) {
                if (shadowDescriptor == null) {
                    shadowDescriptor = new ShadowDescriptor();
                }
                if (shadowDescriptor.value[0] == null) {
                    shadowDescriptor.value[0] = attr;
                    continue;
                }
                parserContext.session.warning("Repeated color specification in " + this.name + " ignored");
                continue;
            }
            if (attr instanceof Attr.Length) {
                if (shadowDescriptor == null) {
                    shadowDescriptor = new ShadowDescriptor();
                }
                if (shadowDescriptor.lcount < 3) {
                    shadowDescriptor.value[++shadowDescriptor.lcount] = attr;
                    continue;
                }
                parserContext.session.warning("Too many length specifiers in " + this.name + ": extra tokens ignored");
                continue;
            }
            if (attr instanceof Attr.Word) {
                if (stack.size() == 1 && "none".equals(attr.word())) {
                    parserContext.inherited.remove(this);
                    return;
                }
                if (this.colors.containsKey(attr.word())) {
                    if (shadowDescriptor == null) {
                        shadowDescriptor = new ShadowDescriptor();
                    }
                    if (shadowDescriptor.value[0] == null) {
                        shadowDescriptor.value[0] = (Attr)this.colors.get(attr.word());
                        continue;
                    }
                    parserContext.session.warning("Repeated color specification in " + this.name + " ignored");
                    continue;
                }
                parserContext.session.warning("Invalid keyword in " + this.name + ": " + attr.word());
                continue;
            }
            if (attr instanceof Attr.Composite) {
                Attr[] attrArray2 = ((Attr.Composite)attr).vector;
                int n = 0;
                while (n < attrArray2.length) {
                    Attr[] attrArray3;
                    if (attrArray2[n] != null && attrArray2[n] instanceof Attr.Composite && (attrArray3 = ((Attr.Composite)attrArray2[n]).vector).length == 4 && (attrArray3[0] == null || attrArray3[0] instanceof Attr.Color) && attrArray3[1] instanceof Attr.Length && attrArray3[2] instanceof Attr.Length && (attrArray3[3] == null || attrArray3[3] instanceof Attr.Length)) {
                        array.put(array.length(), new ShadowDescriptor(attrArray3));
                    }
                    ++n;
                }
                continue;
            }
            parserContext.session.warning("Invalid token type in " + this.name + ": " + attr.getTypeName());
        }
        if (shadowDescriptor != null) {
            if (shadowDescriptor.value[0] == null) {
                shadowDescriptor.value[0] = parserContext.color;
            }
            if (shadowDescriptor.lcount >= 2) {
                array.put(array.length(), shadowDescriptor);
            } else {
                parserContext.session.warning("Invalid structure of " + this.name + " attribute: too few consecutive lengths");
            }
            shadowDescriptor = null;
        }
        attrArray = new Attr[array.length()];
        int n = 0;
        while (n < attrArray.length) {
            attrArray[n] = new Attr.Composite(((ShadowDescriptor)array.get((int)n)).value);
            ++n;
        }
        parserContext.addAttribute(this, new Attr.Composite(attrArray));
    }

    class ShadowDescriptor {
        Attr[] value = new Attr[4];
        int lcount = 0;

        ShadowDescriptor() {
            this.value[0] = null;
            this.value[2] = null;
            this.value[1] = null;
            this.value[3] = Attr.zerolength;
        }

        ShadowDescriptor(Attr[] attrArray) {
            this.value = attrArray;
        }
    }
}

