/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre;

import com.renderx.xep.lib.InternalException;
import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attributed;
import com.renderx.xep.pre.ParserContext;
import com.renderx.xep.pre.ParserException;
import com.renderx.xep.pre.att.ResolvablePercents;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public abstract class Attr {
    private Object key;
    public static final Bool trueval = Bool.create(true);
    public static final Bool falseval = Bool.create(false);
    public static final Length zerolength = Length.create(0);
    public static Word after;
    public static Word all;
    public static Word always;
    public static Word auto;
    public static Word baseline;
    public static Word before;
    public static Word center;
    public static Word consider_shifts;
    public static Word discard;
    public static Word font_height;
    public static Word footer;
    public static Word force;
    public static Word header;
    public static Word hidden;
    public static Word ignore;
    public static Word lr_tb;
    public static Word ltr;
    public static Word max_height;
    public static Word none;
    public static Word relative;
    public static Word retain;
    public static Word rl_tb;
    public static Word rtl;
    public static Word sub;
    public static Word supper;
    public static Word treat_as_space;
    public static Word wrap;
    public static Count count0;
    public static Ratio ratio1;
    private static boolean initialized;

    public abstract String toString();

    public abstract String getTypeName();

    public Attr cast(int n) {
        return null;
    }

    public Attr evaluate(ParserContext parserContext, Attn attn) throws ParserException {
        return this;
    }

    public Attr preevaluate() throws ParserException {
        return this;
    }

    public final int length_or_ratio(int n) {
        if (this instanceof Length) {
            return this.length();
        }
        if (this instanceof Ratio) {
            return (int)Math.round(this.ratio() * (double)n);
        }
        if (this == auto) {
            return n;
        }
        throw new InternalException(this.getClass().getName() + " is illegal type for length_or_ratio()");
    }

    public final int length() {
        return ((Length)this).length;
    }

    public final int count() {
        return ((Count)this).count;
    }

    public final double ratio() {
        return ((Ratio)this).ratio;
    }

    public final boolean bool() {
        return ((Bool)this).bool;
    }

    public final String word() {
        return ((Word)this).word;
    }

    public final Attr[] vector() {
        return ((Composite)this).vector;
    }

    public final double percentage() {
        return ((Percentage)this).percentage;
    }

    public final double emlength() {
        return ((EMLength)this).emlength;
    }

    public final double angle() {
        return ((Angle)this).angle;
    }

    public static Word newWord(String string) {
        return Word.create(string);
    }

    public static Length newLength(int n) {
        return Length.create(n);
    }

    public static Ratio newRatio(double d) {
        return Ratio.create(d);
    }

    public static Count newCount(int n) {
        return Count.create(n);
    }

    public static int dim_range(Attributed attributed, Attn attn, Attn attn2, Attn attn3, int n) {
        Attr attr = attributed.get(attn);
        Attr attr2 = attributed.get(attn2);
        Attr attr3 = attributed.get(attn3);
        return attr == auto && attr2 == auto && attr3 == auto ? Integer.MIN_VALUE : Attr.a_range(attributed, attn, attn2, attn3, attr, attr2, attr3, n);
    }

    public static int length_range(Attributed attributed, Attn attn, Attn attn2, Attn attn3, int n) {
        return Attr.a_range(attributed, attn, attn2, attn3, attributed.get(attn), attributed.get(attn2), attributed.get(attn3), n);
    }

    private static int a_range(Attributed attributed, Attn attn, Attn attn2, Attn attn3, Attr attr, Attr attr2, Attr attr3, int n) {
        int n2 = attr.length_or_ratio(n);
        int n3 = attr2.length_or_ratio(n);
        int n4 = attr3.length_or_ratio(n);
        if (n2 > n4) {
            if (attributed.containsKey(attn3)) {
                n2 = n4;
            } else {
                n4 = n2;
            }
        }
        if (!attributed.containsKey(attn2)) {
            n3 = n2;
        }
        return n3;
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        after = Word.create("after");
        all = Word.create("all");
        always = Word.create("always");
        auto = Word.create("auto");
        baseline = Word.create("baseline");
        before = Word.create("before");
        center = Word.create("center");
        consider_shifts = Word.create("consider-shifts");
        discard = Word.create("discard");
        font_height = Word.create("font-height");
        footer = Word.create("footer");
        force = Word.create("force");
        header = Word.create("header");
        hidden = Word.create("hidden");
        ignore = Word.create("ignore");
        lr_tb = Word.create("lr-tb");
        ltr = Word.create("ltr");
        max_height = Word.create("max-height");
        none = Word.create("none");
        relative = Word.create("relative");
        retain = Word.create("retain");
        rl_tb = Word.create("rl-tb");
        rtl = Word.create("rtl");
        sub = Word.create("sub");
        supper = Word.create("super");
        treat_as_space = Word.create("treat-as-space");
        wrap = Word.create("wrap");
        count0 = Count.create(0);
        ratio1 = Ratio.create(1.0);
        initialized = true;
    }

    static {
        initialized = false;
    }

    public static final class Percentage
    extends Numeric
    implements Scalable {
        public final double percentage;
        private static final ValueCache valueCache = new ValueCache();

        public static Percentage create(double d) {
            Double d2 = new Double(d);
            Object object = valueCache.get(d2);
            if (object == null) {
                ValueCache valueCache = Percentage.valueCache;
                synchronized (valueCache) {
                    object = Percentage.valueCache.get(d2);
                    if (object == null) {
                        object = new Percentage(d);
                        Percentage.valueCache.put(d2, object);
                    }
                }
            }
            return (Percentage)object;
        }

        public Percentage(double d) {
            this.percentage = d;
        }

        public String toString() {
            return String.valueOf(this.percentage) + "%";
        }

        public final String getTypeName() {
            return "Percentage";
        }

        public Attr cast(int n) {
            return (n & 4) > 0 ? Ratio.create(this.percentage / 100.0) : null;
        }

        public Attr evaluate(ParserContext parserContext, Attn attn) throws ParserException {
            Scalable scalable;
            if (attn instanceof ResolvablePercents && (scalable = ((ResolvablePercents)((Object)attn)).getPercentBase(parserContext)) != null) {
                return scalable.scale(this.percentage / 100.0);
            }
            return this;
        }

        public Attr scale(double d) {
            return Percentage.create(this.percentage * d);
        }

        public Numeric minus() {
            return Percentage.create(-this.percentage);
        }

        public Numeric abs() {
            return this.percentage >= 0.0 ? this : this.minus();
        }

        public boolean greater(Numeric numeric) throws ParserException {
            if (numeric instanceof Percentage) {
                return this.percentage > numeric.percentage();
            }
            throw new ParserException("Cannot compare Percentage to " + numeric.getTypeName());
        }

        public Numeric add(Numeric numeric) throws ParserException {
            if (numeric instanceof Percentage) {
                return Percentage.create(this.percentage + numeric.percentage());
            }
            throw new ParserException("Cannot add " + numeric.getTypeName() + " to Percentage");
        }

        public Numeric subtract(Numeric numeric) throws ParserException {
            if (numeric instanceof Percentage) {
                return Percentage.create(this.percentage - numeric.percentage());
            }
            throw new ParserException("Cannot subtract " + numeric.getTypeName() + " from Percentage");
        }

        public Numeric multiply(Numeric numeric) throws ParserException {
            if (numeric instanceof Count) {
                return Percentage.create(this.percentage * (double)numeric.count());
            }
            if (numeric instanceof Ratio) {
                return Percentage.create(this.percentage * numeric.ratio());
            }
            throw new ParserException("Cannot multiply Percentage by " + numeric.getTypeName());
        }

        public Numeric divide(Numeric numeric) throws ParserException {
            if (numeric instanceof Count || numeric instanceof Ratio) {
                double d;
                double d2 = d = numeric instanceof Count ? (double)numeric.count() : numeric.ratio();
                if (d == 0.0) {
                    throw new ParserException("Divide by zero in expression");
                }
                return Percentage.create(this.percentage / d);
            }
            if (numeric instanceof Percentage) {
                double d = numeric.percentage();
                if (d == 0.0) {
                    throw new ParserException("Divide by zero in expression");
                }
                return Ratio.create(this.percentage / d);
            }
            throw new ParserException("Cannot divide Percentage by " + numeric.getTypeName());
        }

        public Numeric modulo(Numeric numeric) throws ParserException {
            if (numeric instanceof Percentage) {
                double d = numeric.percentage();
                if (d == 0.0) {
                    throw new ParserException("Divide by zero in expression");
                }
                return Percentage.create(this.percentage % d);
            }
            throw new ParserException("Cannot calculate Percentage modulo " + numeric.getTypeName());
        }
    }

    public static final class EMLength
    extends Numeric
    implements Scalable {
        public final double emlength;
        private static final ValueCache valueCache = new ValueCache();

        public static EMLength create(double d) {
            Double d2 = new Double(d);
            Object object = valueCache.get(d2);
            if (object == null) {
                ValueCache valueCache = EMLength.valueCache;
                synchronized (valueCache) {
                    object = EMLength.valueCache.get(d2);
                    if (object == null) {
                        object = new EMLength(d);
                        EMLength.valueCache.put(d2, object);
                    }
                }
            }
            return (EMLength)object;
        }

        public EMLength(double d) {
            this.emlength = d;
        }

        public String toString() {
            return String.valueOf(this.emlength) + "em";
        }

        public final String getTypeName() {
            return "Length (em)";
        }

        public Attr evaluate(ParserContext parserContext, Attn attn) throws ParserException {
            return parserContext.fontSize.scale(this.emlength);
        }

        public Attr scale(double d) {
            return EMLength.create(this.emlength * d);
        }

        public Numeric minus() {
            return EMLength.create(-this.emlength);
        }

        public Numeric abs() {
            return this.emlength >= 0.0 ? this : this.minus();
        }

        public boolean greater(Numeric numeric) throws ParserException {
            if (numeric instanceof EMLength) {
                return this.emlength > numeric.emlength();
            }
            throw new ParserException("Cannot compare Length (em) to " + numeric.getTypeName());
        }

        public Numeric add(Numeric numeric) throws ParserException {
            if (numeric instanceof EMLength) {
                return EMLength.create(this.emlength + numeric.emlength());
            }
            throw new ParserException("Cannot add " + numeric.getTypeName() + " to Length (em)");
        }

        public Numeric subtract(Numeric numeric) throws ParserException {
            if (numeric instanceof EMLength) {
                return EMLength.create(this.emlength - numeric.emlength());
            }
            throw new ParserException("Cannot subtract " + numeric.getTypeName() + " from Length (em)");
        }

        public Numeric multiply(Numeric numeric) throws ParserException {
            if (numeric instanceof Count) {
                return EMLength.create(this.emlength * (double)numeric.count());
            }
            if (numeric instanceof Ratio) {
                return EMLength.create(this.emlength * numeric.ratio());
            }
            throw new ParserException("Cannot multiply Length (em) by " + numeric.getTypeName());
        }

        public Numeric divide(Numeric numeric) throws ParserException {
            if (numeric instanceof Count || numeric instanceof Ratio) {
                double d;
                double d2 = d = numeric instanceof Count ? (double)numeric.count() : numeric.ratio();
                if (d == 0.0) {
                    throw new ParserException("Divide by zero in expression");
                }
                return EMLength.create(this.emlength / d);
            }
            if (numeric instanceof EMLength) {
                double d = numeric.emlength();
                if (d == 0.0) {
                    throw new ParserException("Divide by zero in expression");
                }
                return Ratio.create(this.emlength / d);
            }
            throw new ParserException("Cannot divide Length (em) by " + numeric.getTypeName());
        }

        public Numeric modulo(Numeric numeric) throws ParserException {
            if (numeric instanceof EMLength) {
                double d = numeric.emlength();
                if (d == 0.0) {
                    throw new ParserException("Divide by zero in expression");
                }
                return EMLength.create(this.emlength % d);
            }
            throw new ParserException("Cannot calculate Length (em) modulo " + numeric.getTypeName());
        }
    }

    public static final class Composite
    extends Attr {
        public final Attr[] vector;

        public Composite(Attr[] attrArray) {
            this.vector = attrArray;
        }

        public String toString() {
            String string = "[";
            int n = 0;
            while (n < this.vector.length) {
                if (n > 0) {
                    string = string + ", ";
                }
                string = string + (this.vector[n] == null ? "NULL" : this.vector[n].toString());
                ++n;
            }
            string = string + "]";
            return string;
        }

        public final String getTypeName() {
            return "Attribute vector";
        }
    }

    public static abstract class Color
    extends Attr {
        public boolean overprint = false;
        public static Transparent transparent = Transparent.create();

        public static final class CMYK
        extends Opaque {
            public final long cmyk;
            private static final ValueCache valueCache = new ValueCache();

            public static CMYK create(long l) {
                Long l2 = new Long(l);
                Object object = valueCache.get(l2);
                if (object == null) {
                    ValueCache valueCache = CMYK.valueCache;
                    synchronized (valueCache) {
                        object = CMYK.valueCache.get(l2);
                        if (object == null) {
                            object = new CMYK(l);
                            CMYK.valueCache.put(l2, object);
                        }
                    }
                }
                return (CMYK)object;
            }

            public final double[] c_m_y_k() {
                return new double[]{(double)(this.cmyk >> 48 & 0xFFFFL) / 65535.0, (double)(this.cmyk >> 32 & 0xFFFFL) / 65535.0, (double)(this.cmyk >> 16 & 0xFFFFL) / 65535.0, (double)(this.cmyk & 0xFFFFL) / 65535.0};
            }

            public CMYK(long l) {
                this.cmyk = l;
            }

            public final boolean equals(Object object) {
                return object instanceof CMYK && ((CMYK)object).cmyk == this.cmyk;
            }

            public String toString() {
                double d = (double)(this.cmyk >> 48 & 0xFFFFL) / 65535.0;
                double d2 = (double)(this.cmyk >> 32 & 0xFFFFL) / 65535.0;
                double d3 = (double)(this.cmyk >> 16 & 0xFFFFL) / 65535.0;
                double d4 = (double)(this.cmyk & 0xFFFFL) / 65535.0;
                double d5 = 1.0 - d4;
                double d6 = d5 > d ? d5 - d : 0.0;
                double d7 = d5 > d2 ? d5 - d2 : 0.0;
                double d8 = d5 > d3 ? d5 - d3 : 0.0;
                return "rgb-icc(" + d6 * 255.0 + ", " + d7 * 255.0 + ", " + d8 * 255.0 + ", #CMYK, " + d + ", " + d2 + ", " + d3 + ", " + d4 + ")";
            }

            public final String getTypeName() {
                return "CMYK color";
            }

            public static final CMYK create(double d, double d2, double d3, double d4) {
                if (d < 0.0) {
                    d = 0.0;
                } else if (d > 1.0) {
                    d = 1.0;
                }
                if (d2 < 0.0) {
                    d2 = 0.0;
                } else if (d2 > 1.0) {
                    d2 = 1.0;
                }
                if (d3 < 0.0) {
                    d3 = 0.0;
                } else if (d3 > 1.0) {
                    d3 = 1.0;
                }
                if (d4 < 0.0) {
                    d4 = 0.0;
                } else if (d4 > 1.0) {
                    d4 = 1.0;
                }
                long l = Math.round(d * 65535.0);
                l <<= 16;
                l |= Math.round(d2 * 65535.0);
                l <<= 16;
                l |= Math.round(d3 * 65535.0);
                l <<= 16;
                return CMYK.create(l |= Math.round(d4 * 65535.0));
            }

            public Opaque darkerColor() {
                double[] dArray = this.c_m_y_k();
                double d = 1.0 - dArray[0];
                double d2 = 1.0 - dArray[1];
                double d3 = 1.0 - dArray[2];
                double d4 = 1.0 - dArray[3];
                double d5 = (d + d2 + d3) / 3.0;
                double d6 = d5 < 0.5 ? d5 : 1.0 - 0.25 / d5;
                return CMYK.create(1.0 - d * d6, 1.0 - d2 * d6, 1.0 - d3 * d6, 1.0 - (d4 < 0.5 ? d4 * d4 : d4 - 0.25));
            }

            public Opaque lighterColor() {
                double[] dArray = this.c_m_y_k();
                double d = dArray[0];
                double d2 = dArray[1];
                double d3 = dArray[2];
                double d4 = dArray[3];
                double d5 = (d + d2 + d3) / 3.0;
                double d6 = d5 < 0.5 ? d5 : 1.0 - 0.25 / d5;
                return CMYK.create(d * d6, d2 * d6, d3 * d6, d4 < 0.5 ? d4 * d4 : d4 - 0.25);
            }
        }

        public static final class RGB
        extends Opaque {
            public final long rgb;
            private static final ValueCache valueCache = new ValueCache();

            public static RGB create(long l) {
                Long l2 = new Long(l);
                Object object = valueCache.get(l2);
                if (object == null) {
                    ValueCache valueCache = RGB.valueCache;
                    synchronized (valueCache) {
                        object = RGB.valueCache.get(l2);
                        if (object == null) {
                            object = new RGB(l);
                            RGB.valueCache.put(l2, object);
                        }
                    }
                }
                return (RGB)object;
            }

            public final double[] r_g_b() {
                return new double[]{(double)(this.rgb >> 32 & 0xFFFFL) / 65535.0, (double)(this.rgb >> 16 & 0xFFFFL) / 65535.0, (double)(this.rgb & 0xFFFFL) / 65535.0};
            }

            public RGB(long l) {
                this.rgb = l;
            }

            public final boolean equals(Object object) {
                return object instanceof RGB && ((RGB)object).rgb == this.rgb;
            }

            public String toString() {
                double d = (double)(this.rgb >> 32 & 0xFFFFL) / 65535.0;
                double d2 = (double)(this.rgb >> 16 & 0xFFFFL) / 65535.0;
                double d3 = (double)(this.rgb & 0xFFFFL) / 65535.0;
                return "rgb(" + d * 255.0 + ", " + d2 * 255.0 + ", " + d3 * 255.0 + ")";
            }

            public final String getTypeName() {
                return "RGB color";
            }

            public static final RGB create(double d, double d2, double d3) {
                if (d < 0.0) {
                    d = 0.0;
                } else if (d > 1.0) {
                    d = 1.0;
                }
                if (d2 < 0.0) {
                    d2 = 0.0;
                } else if (d2 > 1.0) {
                    d2 = 1.0;
                }
                if (d3 < 0.0) {
                    d3 = 0.0;
                } else if (d3 > 1.0) {
                    d3 = 1.0;
                }
                long l = Math.round(d * 65535.0);
                l <<= 16;
                l |= Math.round(d2 * 65535.0);
                l <<= 16;
                return RGB.create(l |= Math.round(d3 * 65535.0));
            }

            public Opaque darkerColor() {
                double d;
                double d2;
                double[] dArray = this.r_g_b();
                double d3 = dArray[0];
                double d4 = (d3 + (d2 = dArray[1]) + (d = dArray[2])) / 3.0;
                double d5 = d4 < 0.5 ? d4 : 1.0 - 0.25 / d4;
                return RGB.create(d3 * d5, d2 * d5, d * d5);
            }

            public Opaque lighterColor() {
                double d;
                double d2;
                double[] dArray = this.r_g_b();
                double d3 = 1.0 - dArray[0];
                double d4 = (d3 + (d2 = 1.0 - dArray[1]) + (d = 1.0 - dArray[2])) / 3.0;
                double d5 = d4 < 0.5 ? d4 : 1.0 - 0.25 / d4;
                return RGB.create(1.0 - d3 * d5, 1.0 - d2 * d5, 1.0 - d * d5);
            }
        }

        public static final class SpotColor
        extends Opaque {
            public final int tint;
            public final String colorant;
            public final Opaque altColor;
            private static final ValueCache valueCache = new ValueCache();

            public static final SpotColor create(String string, Opaque opaque, int n) {
                String string2 = "" + n + " " + opaque.hashCode() + " " + string;
                Object object = valueCache.get(string2);
                if (object == null) {
                    ValueCache valueCache = SpotColor.valueCache;
                    synchronized (valueCache) {
                        object = SpotColor.valueCache.get(string2);
                        if (object == null) {
                            object = new SpotColor(string, opaque, n);
                            SpotColor.valueCache.put(string2, object);
                        }
                    }
                }
                return (SpotColor)object;
            }

            public final double tint() {
                return (double)(this.tint & 0xFFFF) / 65535.0;
            }

            public SpotColor(String string, Opaque opaque, int n) {
                this.colorant = string;
                this.altColor = opaque;
                this.tint = n;
            }

            public final boolean equals(Object object) {
                if (object instanceof SpotColor) {
                    SpotColor spotColor = (SpotColor)object;
                    return spotColor.tint == this.tint && spotColor.colorant.equals(this.colorant) && spotColor.altColor.equals(this.altColor);
                }
                return false;
            }

            public String toString() {
                double d = (double)this.tint / 65535.0;
                return "rgb-icc(" + d * 255.0 + ", " + d * 255.0 + ", " + d * 255.0 + ", #SpotColor, '" + this.colorant + "', " + this.altColor.toString() + ", " + d + ")";
            }

            public final String getTypeName() {
                return "Spot color";
            }

            public static final SpotColor create(String string, Opaque opaque, double d) {
                if (d < 0.0) {
                    d = 0.0;
                } else if (d > 1.0) {
                    d = 1.0;
                }
                return SpotColor.create(string, opaque, (int)Math.round(d * 65535.0));
            }

            public Opaque darkerColor() {
                double d = 1.0 - this.tint();
                return SpotColor.create(this.colorant, this.altColor, 1.0 - (d < 0.5 ? d * d : d - 0.25));
            }

            public Opaque lighterColor() {
                double d = this.tint();
                return SpotColor.create(this.colorant, this.altColor, d < 0.5 ? d * d : d - 0.25);
            }
        }

        public static final class Registration
        extends Opaque {
            private static final ValueCache valueCache = new ValueCache();
            public final int tint;

            public static Registration create(int n) {
                Integer n2 = new Integer(n);
                Object object = valueCache.get(n2);
                if (object == null) {
                    ValueCache valueCache = Registration.valueCache;
                    synchronized (valueCache) {
                        object = Registration.valueCache.get(n2);
                        if (object == null) {
                            object = new Registration(n);
                            Registration.valueCache.put(n2, object);
                        }
                    }
                }
                return (Registration)object;
            }

            public final double tint() {
                return (double)(this.tint & 0xFFFF) / 65535.0;
            }

            public Registration(int n) {
                this.tint = n;
            }

            public final boolean equals(Object object) {
                return object instanceof Registration && ((Registration)object).tint == this.tint;
            }

            public String toString() {
                double d = (double)this.tint / 65535.0;
                return "rgb-icc(" + d * 255.0 + ", " + d * 255.0 + ", " + d * 255.0 + ", #Registration, " + d + ")";
            }

            public final String getTypeName() {
                return "Registration color";
            }

            public static final Registration create(double d) {
                if (d < 0.0) {
                    d = 0.0;
                } else if (d > 1.0) {
                    d = 1.0;
                }
                return Registration.create((int)Math.round(d * 65535.0));
            }

            public Opaque darkerColor() {
                double d = this.tint();
                return Registration.create(d < 0.5 ? d * d : d - 0.25);
            }

            public Opaque lighterColor() {
                double d = 1.0 - this.tint();
                return Registration.create(1.0 - (d < 0.5 ? d * d : d - 0.25));
            }
        }

        public static final class Grayscale
        extends Opaque {
            public final int gray;
            private static final ValueCache valueCache = new ValueCache();

            public static Grayscale create(int n) {
                Integer n2 = new Integer(n);
                Object object = valueCache.get(n2);
                if (object == null) {
                    ValueCache valueCache = Grayscale.valueCache;
                    synchronized (valueCache) {
                        object = Grayscale.valueCache.get(n2);
                        if (object == null) {
                            object = new Grayscale(n);
                            Grayscale.valueCache.put(n2, object);
                        }
                    }
                }
                return (Grayscale)object;
            }

            public final double gray() {
                return (double)(this.gray & 0xFFFF) / 65535.0;
            }

            public Grayscale(int n) {
                this.gray = n;
            }

            public final boolean equals(Object object) {
                return object instanceof Grayscale && ((Grayscale)object).gray == this.gray;
            }

            public String toString() {
                double d = (double)this.gray / 65535.0;
                return "rgb-icc(" + d * 255.0 + ", " + d * 255.0 + ", " + d * 255.0 + ", #Grayscale, " + d + ")";
            }

            public final String getTypeName() {
                return "Grayscale color";
            }

            public static final Grayscale create(double d) {
                if (d < 0.0) {
                    d = 0.0;
                } else if (d > 1.0) {
                    d = 1.0;
                }
                return Grayscale.create((int)Math.round(d * 65535.0));
            }

            public Opaque darkerColor() {
                double d = this.gray();
                return Grayscale.create(d < 0.5 ? d * d : d - 0.25);
            }

            public Opaque lighterColor() {
                double d = 1.0 - this.gray();
                return Grayscale.create(1.0 - (d < 0.5 ? d * d : d - 0.25));
            }
        }

        public static abstract class Opaque
        extends Color {
            public static final int BIT_DEPTH = 16;
            public static final int BASE = 65536;
            public static final int MAXVALUE = 65535;

            public abstract Opaque lighterColor();

            public abstract Opaque darkerColor();
        }

        private static final class Transparent
        extends Color {
            private static Transparent the_only_instance = new Transparent();

            private Transparent() {
            }

            public boolean equals(Object object) {
                return object instanceof Transparent;
            }

            public String toString() {
                return "transparent";
            }

            public final String getTypeName() {
                return "Transparent color";
            }

            public static Transparent create() {
                return the_only_instance;
            }
        }
    }

    public static final class Bool
    extends Attr {
        public final boolean bool;
        private static Bool true_instance = new Bool(true);
        private static Bool false_instance = new Bool(false);

        private Bool(boolean bl) {
            this.bool = bl;
        }

        public String toString() {
            return this.bool ? "true" : "false";
        }

        public final String getTypeName() {
            return "Boolean";
        }

        public static Bool create(boolean bl) {
            return bl ? true_instance : false_instance;
        }
    }

    public static final class Ratio
    extends Numeric
    implements Scalable {
        public final double ratio;
        private static final ValueCache valueCache = new ValueCache();

        public static Ratio create(double d) {
            Double d2 = new Double(d);
            Object object = valueCache.get(d2);
            if (object == null) {
                ValueCache valueCache = Ratio.valueCache;
                synchronized (valueCache) {
                    object = Ratio.valueCache.get(d2);
                    if (object == null) {
                        object = new Ratio(d);
                        Ratio.valueCache.put(d2, object);
                    }
                }
            }
            return (Ratio)object;
        }

        public Ratio(double d) {
            this.ratio = d;
        }

        public String toString() {
            return String.valueOf(this.ratio);
        }

        public final String getTypeName() {
            return "Real number";
        }

        public Attr cast(int n) {
            if ((n & 2) > 0) {
                return this;
            }
            if ((n & 1) > 0) {
                return Count.create((int)Math.round(this.ratio));
            }
            if (this.ratio == 0.0) {
                if ((n & 8) > 0) {
                    return Length.create(0);
                }
                if ((n & 0x10) > 0) {
                    return Angle.create(0.0);
                }
            }
            return null;
        }

        public Attr scale(double d) {
            return Ratio.create(this.ratio * d);
        }

        public Numeric minus() {
            return Ratio.create(-this.ratio);
        }

        public Numeric abs() {
            return this.ratio >= 0.0 ? this : this.minus();
        }

        public boolean greater(Numeric numeric) throws ParserException {
            if (numeric instanceof Count) {
                return this.ratio > (double)numeric.count();
            }
            if (numeric instanceof Ratio) {
                return this.ratio > numeric.ratio();
            }
            throw new ParserException("Cannot compare Real number to " + numeric.getTypeName());
        }

        public Numeric add(Numeric numeric) throws ParserException {
            if (numeric instanceof Count) {
                return Ratio.create(this.ratio + (double)numeric.count());
            }
            if (numeric instanceof Ratio) {
                return Ratio.create(this.ratio + numeric.ratio());
            }
            throw new ParserException("Cannot add " + numeric.getTypeName() + " to Real number");
        }

        public Numeric subtract(Numeric numeric) throws ParserException {
            if (numeric instanceof Count) {
                return Ratio.create(this.ratio - (double)numeric.count());
            }
            if (numeric instanceof Ratio) {
                return Ratio.create(this.ratio - numeric.ratio());
            }
            throw new ParserException("Cannot subtract " + numeric.getTypeName() + " from Real number");
        }

        public Numeric multiply(Numeric numeric) throws ParserException {
            if (numeric instanceof Count) {
                return Ratio.create(this.ratio * (double)numeric.count());
            }
            if (numeric instanceof Ratio) {
                return Ratio.create(this.ratio * numeric.ratio());
            }
            return numeric.multiply(this);
        }

        public Numeric divide(Numeric numeric) throws ParserException {
            if (numeric instanceof Count || numeric instanceof Ratio) {
                double d;
                double d2 = d = numeric instanceof Count ? (double)numeric.count() : numeric.ratio();
                if (d == 0.0) {
                    throw new ParserException("Divide by zero in expression");
                }
                return Ratio.create(this.ratio / d);
            }
            throw new ParserException("Cannot divide Real number by " + numeric.getTypeName());
        }

        public Numeric modulo(Numeric numeric) throws ParserException {
            if (numeric instanceof Count || numeric instanceof Ratio) {
                double d;
                double d2 = d = numeric instanceof Count ? (double)numeric.count() : numeric.ratio();
                if (d == 0.0) {
                    throw new ParserException("Divide by zero in expression");
                }
                return Ratio.create(this.ratio % d);
            }
            throw new ParserException("Cannot calculate Real number modulo " + numeric.getTypeName());
        }
    }

    public static final class Count
    extends Numeric {
        public final int count;
        private static final ValueCache valueCache = new ValueCache();

        public static Count create(int n) {
            Integer n2 = new Integer(n);
            Object object = valueCache.get(n2);
            if (object == null) {
                ValueCache valueCache = Count.valueCache;
                synchronized (valueCache) {
                    object = Count.valueCache.get(n2);
                    if (object == null) {
                        object = new Count(n);
                        Count.valueCache.put(n2, object);
                    }
                }
            }
            return (Count)object;
        }

        public Count(int n) {
            this.count = n;
        }

        public String toString() {
            return String.valueOf(this.count);
        }

        public final String getTypeName() {
            return "Integer";
        }

        public Attr cast(int n) {
            if ((n & 1) > 0) {
                return this;
            }
            if ((n & 2) > 0) {
                return Ratio.create(this.count);
            }
            if (this.count == 0) {
                if ((n & 8) > 0) {
                    return Length.create(0);
                }
                if ((n & 0x10) > 0) {
                    return Angle.create(0.0);
                }
            }
            return null;
        }

        public Numeric minus() {
            return Count.create(-this.count);
        }

        public Numeric abs() {
            return this.count >= 0 ? this : this.minus();
        }

        public boolean greater(Numeric numeric) throws ParserException {
            if (numeric instanceof Count) {
                return this.count > numeric.count();
            }
            if (numeric instanceof Ratio) {
                return (double)this.count > numeric.ratio();
            }
            throw new ParserException("Cannot compare Integer to " + numeric.getTypeName());
        }

        public Numeric add(Numeric numeric) throws ParserException {
            if (numeric instanceof Count) {
                return Count.create(this.count + numeric.count());
            }
            if (numeric instanceof Ratio) {
                return Ratio.create((double)this.count + numeric.ratio());
            }
            throw new ParserException("Cannot add " + numeric.getTypeName() + " to Integer");
        }

        public Numeric subtract(Numeric numeric) throws ParserException {
            if (numeric instanceof Count) {
                return Count.create(this.count - numeric.count());
            }
            if (numeric instanceof Ratio) {
                return Ratio.create((double)this.count - numeric.ratio());
            }
            throw new ParserException("Cannot subtract " + numeric.getTypeName() + " from Integer");
        }

        public Numeric multiply(Numeric numeric) throws ParserException {
            if (numeric instanceof Count) {
                return Count.create(this.count * numeric.count());
            }
            if (numeric instanceof Ratio) {
                return Ratio.create((double)this.count * numeric.ratio());
            }
            return numeric.multiply(this);
        }

        public Numeric divide(Numeric numeric) throws ParserException {
            if (numeric instanceof Count) {
                int n = numeric.count();
                if (n == 0) {
                    throw new ParserException("Divide by zero in expression");
                }
                if (this.count % n == 0) {
                    return Count.create(this.count / n);
                }
                return Ratio.create((double)this.count / (double)n);
            }
            if (numeric instanceof Ratio) {
                double d = numeric.ratio();
                if (d == 0.0) {
                    throw new ParserException("Divide by zero in expression");
                }
                return Ratio.create((double)this.count / d);
            }
            throw new ParserException("Cannot divide Integer by " + numeric.getTypeName());
        }

        public Numeric modulo(Numeric numeric) throws ParserException {
            if (numeric instanceof Count) {
                int n = numeric.count();
                if (n == 0) {
                    throw new ParserException("Divide by zero in expression");
                }
                return Count.create(this.count % n);
            }
            if (numeric instanceof Ratio) {
                double d = numeric.ratio();
                if (d == 0.0) {
                    throw new ParserException("Divide by zero in expression");
                }
                return Ratio.create((double)this.count % d);
            }
            throw new ParserException("Cannot calculate Integer modulo " + numeric.getTypeName());
        }
    }

    public static final class Angle
    extends Numeric
    implements Scalable {
        public final double angle;
        private static final ValueCache valueCache = new ValueCache();

        public static Angle create(double d) {
            Double d2 = new Double(d);
            Object object = valueCache.get(d2);
            if (object == null) {
                ValueCache valueCache = Angle.valueCache;
                synchronized (valueCache) {
                    object = Angle.valueCache.get(d2);
                    if (object == null) {
                        object = new Angle(d);
                        Angle.valueCache.put(d2, object);
                    }
                }
            }
            return (Angle)object;
        }

        public Angle(double d) {
            this.angle = d;
        }

        public String toString() {
            return String.valueOf(this.angle) + "deg";
        }

        public final String getTypeName() {
            return "Angle";
        }

        public Attr cast(int n) {
            return (n & 0x10) > 0 ? this : null;
        }

        public Attr scale(double d) {
            return Angle.create(this.angle * d);
        }

        public Numeric minus() {
            return Angle.create(-this.angle);
        }

        public Numeric abs() {
            return this.angle >= 0.0 ? this : this.minus();
        }

        public boolean greater(Numeric numeric) throws ParserException {
            if (numeric instanceof Angle) {
                return this.angle > numeric.angle();
            }
            throw new ParserException("Cannot compare Angle to " + numeric.getTypeName());
        }

        public Numeric add(Numeric numeric) throws ParserException {
            if (numeric instanceof Angle) {
                return Angle.create(this.angle + numeric.angle());
            }
            throw new ParserException("Cannot add " + numeric.getTypeName() + " to Angle");
        }

        public Numeric subtract(Numeric numeric) throws ParserException {
            if (numeric instanceof Angle) {
                return Angle.create(this.angle - numeric.angle());
            }
            throw new ParserException("Cannot subtract " + numeric.getTypeName() + " from Angle");
        }

        public Numeric multiply(Numeric numeric) throws ParserException {
            if (numeric instanceof Count) {
                return Angle.create(this.angle * (double)numeric.count());
            }
            if (numeric instanceof Ratio) {
                return Angle.create(this.angle * numeric.ratio());
            }
            throw new ParserException("Cannot multiply Angle by " + numeric.getTypeName());
        }

        public Numeric divide(Numeric numeric) throws ParserException {
            if (numeric instanceof Count || numeric instanceof Ratio) {
                double d;
                double d2 = d = numeric instanceof Count ? (double)numeric.count() : numeric.ratio();
                if (d == 0.0) {
                    throw new ParserException("Divide by zero in expression");
                }
                return Angle.create(this.angle / d);
            }
            if (numeric instanceof Angle) {
                double d = numeric.angle();
                if (d == 0.0) {
                    throw new ParserException("Divide by zero in expression");
                }
                return Ratio.create(this.angle / d);
            }
            throw new ParserException("Cannot divide Angle by " + numeric.getTypeName());
        }

        public Numeric modulo(Numeric numeric) throws ParserException {
            if (numeric instanceof Angle) {
                double d = numeric.angle();
                if (d == 0.0) {
                    throw new ParserException("Divide by zero in expression");
                }
                return Angle.create(this.angle % d);
            }
            throw new ParserException("Cannot calculate Angle modulo " + numeric.getTypeName());
        }
    }

    public static final class Length
    extends Numeric
    implements Scalable {
        public final int length;
        private static final ValueCache valueCache = new ValueCache();

        public static Length create(int n) {
            Integer n2 = new Integer(n);
            Object object = valueCache.get(n2);
            if (object == null) {
                ValueCache valueCache = Length.valueCache;
                synchronized (valueCache) {
                    object = Length.valueCache.get(n2);
                    if (object == null) {
                        object = new Length(n);
                        Length.valueCache.put(n2, object);
                    }
                }
            }
            return (Length)object;
        }

        public Length(int n) {
            this.length = n;
        }

        public String toString() {
            return String.valueOf((double)this.length / 1000.0) + "pt";
        }

        public final String getTypeName() {
            return "Length";
        }

        public Attr cast(int n) {
            return (n & 8) > 0 ? this : null;
        }

        public Attr scale(double d) {
            return Length.create((int)Math.round((double)this.length * d));
        }

        public Numeric minus() {
            return Length.create(-this.length);
        }

        public Numeric abs() {
            return this.length >= 0 ? this : this.minus();
        }

        public boolean greater(Numeric numeric) throws ParserException {
            if (numeric instanceof Length) {
                return this.length > numeric.length();
            }
            throw new ParserException("Cannot compare Length to " + numeric.getTypeName());
        }

        public Numeric add(Numeric numeric) throws ParserException {
            if (numeric instanceof Length) {
                return Length.create(this.length + numeric.length());
            }
            throw new ParserException("Cannot add " + numeric.getTypeName() + " to Length");
        }

        public Numeric subtract(Numeric numeric) throws ParserException {
            if (numeric instanceof Length) {
                return Length.create(this.length - numeric.length());
            }
            throw new ParserException("Cannot subtract " + numeric.getTypeName() + " from Length");
        }

        public Numeric multiply(Numeric numeric) throws ParserException {
            if (numeric instanceof Count) {
                return Length.create(this.length * numeric.count());
            }
            if (numeric instanceof Ratio) {
                return Length.create((int)Math.round((double)this.length * numeric.ratio()));
            }
            throw new ParserException("Cannot multiply Length by " + numeric.getTypeName());
        }

        public Numeric divide(Numeric numeric) throws ParserException {
            if (numeric instanceof Count || numeric instanceof Ratio) {
                double d;
                double d2 = d = numeric instanceof Count ? (double)numeric.count() : numeric.ratio();
                if (d == 0.0) {
                    throw new ParserException("Divide by zero in expression");
                }
                return Length.create((int)Math.round((double)this.length / d));
            }
            if (numeric instanceof Length) {
                double d = numeric.length();
                if (d == 0.0) {
                    throw new ParserException("Divide by zero in expression");
                }
                return Ratio.create((double)this.length / d);
            }
            throw new ParserException("Cannot divide Length by " + numeric.getTypeName());
        }

        public Numeric modulo(Numeric numeric) throws ParserException {
            if (numeric instanceof Length) {
                int n = numeric.length();
                if (n == 0) {
                    throw new ParserException("Divide by zero in expression");
                }
                return Length.create(this.length % n);
            }
            throw new ParserException("Cannot calculate Length modulo " + numeric.getTypeName());
        }
    }

    public static final class Word
    extends Attr {
        public final String word;
        private static final ValueCache valueCache = new ValueCache();

        public static Word create(String string) {
            String string2 = string;
            Object object = valueCache.get(string2);
            if (object == null) {
                ValueCache valueCache = Word.valueCache;
                synchronized (valueCache) {
                    object = Word.valueCache.get(string2);
                    if (object == null) {
                        object = new Word(string);
                        Word.valueCache.put(string2, object);
                    }
                }
            }
            return (Word)object;
        }

        public Word(String string) {
            this.word = string;
        }

        public String toString() {
            return String.valueOf(this.word);
        }

        public final String getTypeName() {
            return "Word";
        }

        public static Word createUncached(String string) {
            return new Word(string);
        }

        public Attr cast(int n) {
            return (n & 0x20) > 0 ? this : null;
        }
    }

    public static interface Scalable {
        public Attr scale(double var1);
    }

    public static abstract class Numeric
    extends Attr {
        public abstract boolean greater(Numeric var1) throws ParserException;

        public abstract Numeric abs() throws ParserException;

        public abstract Numeric minus() throws ParserException;

        public abstract Numeric add(Numeric var1) throws ParserException;

        public abstract Numeric subtract(Numeric var1) throws ParserException;

        public abstract Numeric multiply(Numeric var1) throws ParserException;

        public abstract Numeric divide(Numeric var1) throws ParserException;

        public abstract Numeric modulo(Numeric var1) throws ParserException;
    }

    private static class ValueCache {
        private WeakHashMap t = new WeakHashMap();

        private ValueCache() {
        }

        Object get(Object object) {
            Object v = this.t.get(object);
            return v == null ? null : ((Reference)v).get();
        }

        void put(Object object, Object object2) {
            this.t.remove(object);
            ((Attr)object2).key = object;
            this.t.put(object, new WeakReference<Object>(object2));
        }
    }
}

