/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.svg;

import com.renderx.svg.SVGParseException;
import com.renderx.svg.Token;
import java.io.IOException;
import java.io.InputStreamReader;

public class Lexer {
    public static final String blanks = " \t\r\n\f";
    public static final String token_delimiters = " \t\r\n\f'\"+()[]{},/:;";
    public static final String single_chars = "()[]{},/:;";
    public static final String quotes = "'\"";
    public static final String digits = "0123456789";
    public static final String hexdigits = "0123456789ABCDEFabcdef";
    private char[] data = null;
    private int length = 0;
    private int cursor = 0;

    public Lexer() {
    }

    public Lexer(String string) {
        this();
        this.setSource(string);
    }

    public Lexer(char[] cArray) {
        this();
        this.setSource(cArray);
    }

    public void setSource(String string) {
        this.setSource(string.toCharArray());
    }

    public void setSource(char[] cArray) {
        this.setSource(cArray, 0, cArray.length);
    }

    public void setSource(char[] cArray, int n, int n2) {
        this.data = cArray;
        this.cursor = n;
        this.length = n + n2;
    }

    private void skip_whitespace() {
        while (this.cursor < this.length) {
            if (blanks.indexOf(this.data[this.cursor]) == -1) break;
            ++this.cursor;
        }
    }

    public int nextToken(Token token) throws SVGParseException {
        token.reset();
        this.skip_whitespace();
        if (this.cursor >= this.length) {
            token.type = 1;
            return 1;
        }
        if (single_chars.indexOf(this.data[this.cursor]) != -1) {
            switch (this.data[this.cursor++]) {
                case '(': {
                    token.type = 2;
                    return 2;
                }
                case ')': {
                    token.type = 3;
                    return 3;
                }
                case '[': {
                    token.type = 4;
                    return 4;
                }
                case ']': {
                    token.type = 5;
                    return 5;
                }
                case '{': {
                    token.type = 6;
                    return 6;
                }
                case '}': {
                    token.type = 7;
                    return 7;
                }
                case ',': {
                    token.type = 8;
                    return 8;
                }
                case '/': {
                    token.type = 9;
                    return 9;
                }
                case ':': {
                    token.type = 10;
                    return 10;
                }
                case ';': {
                    token.type = 11;
                    return 11;
                }
            }
            throw new SVGParseException("Internal error: unrecognized separator character");
        }
        if (quotes.indexOf(this.data[this.cursor]) != -1) {
            char c = this.data[this.cursor];
            int n = ++this.cursor;
            do {
                if (this.cursor != this.length) continue;
                throw new SVGParseException("Unterminated quoted string");
            } while (this.data[this.cursor++] != c);
            token.stringValue = new String(this.data, n, this.cursor - n - 1);
            token.type = 14;
            return 14;
        }
        int n = this.cursor++;
        while (this.cursor < this.length) {
            if (token_delimiters.indexOf(this.data[this.cursor]) != -1) break;
            ++this.cursor;
        }
        if (this.data[n] == '#') {
            if (this.cursor - n == 7 && hexdigits.indexOf(this.data[n + 1]) != -1 && hexdigits.indexOf(this.data[n + 2]) != -1 && hexdigits.indexOf(this.data[n + 3]) != -1 && hexdigits.indexOf(this.data[n + 4]) != -1 && hexdigits.indexOf(this.data[n + 5]) != -1 && hexdigits.indexOf(this.data[n + 6]) != -1) {
                int n2 = Integer.parseInt(new String(this.data, n + 1, 2), 16);
                int n3 = Integer.parseInt(new String(this.data, n + 3, 2), 16);
                int n4 = Integer.parseInt(new String(this.data, n + 5, 2), 16);
                token.numValue = (n2 << 16) + (n3 << 8) + n4;
                token.type = 12;
                return 12;
            }
            if (this.cursor - n == 4 && hexdigits.indexOf(this.data[n + 1]) != -1 && hexdigits.indexOf(this.data[n + 2]) != -1 && hexdigits.indexOf(this.data[n + 3]) != -1) {
                int n5 = Integer.parseInt(new String(this.data, n + 1, 1), 16) * 17;
                int n6 = Integer.parseInt(new String(this.data, n + 2, 1), 16) * 17;
                int n7 = Integer.parseInt(new String(this.data, n + 3, 1), 16) * 17;
                token.numValue = (n5 << 16) + (n6 << 8) + n7;
                token.type = 12;
                return 12;
            }
        }
        int n8 = n;
        int n9 = 1;
        if (this.data[n8] == '-') {
            ++n8;
            n9 = -1;
        } else if (this.data[n8] == '+') {
            ++n8;
        }
        if (n8 < this.cursor && digits.indexOf(this.data[n8]) != -1 || n8 < this.cursor - 1 && this.data[n8] == '.' && digits.indexOf(this.data[n8 + 1]) != -1) {
            int n10;
            boolean bl = false;
            double d = 1.0;
            token.numValue = 0.0;
            while (n8 < this.cursor) {
                if (digits.indexOf(this.data[n8]) != -1) {
                    n10 = this.data[n8] - 48;
                    if (bl) {
                        token.numValue += (d /= 10.0) * (double)n10;
                    } else {
                        token.numValue *= 10.0;
                        token.numValue += (double)n10;
                    }
                } else {
                    if (this.data[n8] != '.' || bl) break;
                    bl = true;
                }
                ++n8;
            }
            token.numValue *= (double)n9;
            if (n8 < this.cursor && (this.data[n8] == 'e' || this.data[n8] == 'E') && (n8 < this.cursor - 1 && digits.indexOf(this.data[n8 + 1]) != -1 || n8 < this.cursor - 2 && (this.data[n8 + 1] == '+' || this.data[n8 + 1] == '-') && digits.indexOf(this.data[n8 + 2]) != -1)) {
                n10 = 1;
                if (this.data[++n8] == '-') {
                    ++n8;
                    n10 = -1;
                } else if (this.data[n8] == '+') {
                    ++n8;
                }
                int n11 = 0;
                while (n8 < this.cursor && digits.indexOf(this.data[n8]) != -1) {
                    n11 = (int)((double)n11 * 10.0);
                    n11 += this.data[n8] - 48;
                    ++n8;
                }
                token.numValue *= Math.pow(10.0, n11 *= n10);
            }
            if (n8 != this.cursor) {
                token.stringValue = new String(this.data, n8, this.cursor - n8);
            }
            token.type = 15;
            return 15;
        }
        token.stringValue = new String(this.data, n, this.cursor - n);
        token.type = 13;
        return 13;
    }

    public static Token getSingleToken(String string) throws SVGParseException {
        Lexer lexer = new Lexer(string);
        Token token = new Token();
        if (lexer.nextToken(token) == 1) {
            throw new SVGParseException("No meaningful data");
        }
        Token token2 = new Token();
        if (lexer.nextToken(token2) != 1) {
            throw new SVGParseException("Extra tokens in \"" + string.trim() + "\"");
        }
        return token;
    }

    public static void main(String[] stringArray) {
        char[] cArray = new char[8192];
        int n = 0;
        Lexer lexer = new Lexer();
        Token token = new Token();
        while (true) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(System.in);
                n = inputStreamReader.read(cArray);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                System.exit(1);
            }
            if (n < 0) {
                System.exit(0);
            }
            lexer.setSource(new String(cArray, 0, n).trim());
            try {
                do {
                    lexer.nextToken(token);
                    token.dump(System.out);
                } while (token.type != 1);
            }
            catch (SVGParseException sVGParseException) {
                System.err.println(sVGParseException.toString());
            }
            System.out.println();
        }
    }
}

