/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib.parser;

import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFIOException;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.parser.PDFDictionary;
import com.renderx.pdflib.parser.PDFElement;
import com.renderx.pdflib.parser.PDFInstance;
import com.renderx.pdflib.parser.PDFStream;
import com.renderx.util.List;
import java.io.IOException;

public class PDFUniversalObject {
    public int obj_id;
    public PDFElement objdata = null;

    public PDFUniversalObject(int n) {
        this.obj_id = n;
    }

    public String getType() {
        if (this.objdata instanceof PDFDictionary) {
            return ((PDFDictionary)this.objdata).getType();
        }
        return "";
    }

    int getID() {
        return this.obj_id;
    }

    public void setID(int n) {
        this.obj_id = n;
    }

    void writeBody(PDFOutputStream pDFOutputStream) throws PDFIOException {
    }

    public void write(PDFOutputStream pDFOutputStream, PDFInstance pDFInstance) throws PDFIOException {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<UniversalObject number=\"" + this.obj_id + "\">");
        }
        if (PDFOutputStream.dump != null && this.objdata instanceof PDFDictionary && ((PDFDictionary)this.objdata).dict.containsKey("/Type")) {
            PDFOutputStream.dump.println("<type name=\"" + ((PDFDictionary)this.objdata).dict.get("/Type") + "\"/>");
        }
        pDFOutputStream.trailer.xref.addObjectOffset(new IndirectObject(this.obj_id), pDFOutputStream.size());
        pDFOutputStream.generateCurrentKey(this.getID());
        this.writeHead(pDFOutputStream);
        try {
            if (this.objdata != null) {
                if (this.objdata instanceof PDFStream) {
                    ((PDFStream)this.objdata).write(pDFOutputStream, pDFInstance, this.obj_id);
                } else {
                    this.objdata.write(pDFOutputStream, pDFInstance);
                }
            }
        }
        catch (IOException iOException) {
            pDFOutputStream.exception("", iOException);
        }
        this.writeTail(pDFOutputStream);
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("</UniversalObject>");
        }
    }

    public void writeHead(PDFOutputStream pDFOutputStream) throws PDFIOException {
        pDFOutputStream.println(this.obj_id + " 0 obj");
    }

    void writeTail(PDFOutputStream pDFOutputStream) throws PDFIOException {
        pDFOutputStream.println("\nendobj");
    }

    public List getIndirectObjects() {
        if (this.objdata != null) {
            return this.objdata.getIndirectObjects();
        }
        return new List();
    }
}

