/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib.parser;

import com.renderx.fonts.FontCatalog;
import com.renderx.fonts.FontConfigurationException;
import com.renderx.graphics.Image;
import com.renderx.graphics.ImageFactory;
import com.renderx.graphics.ImageFormatException;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.parser.ElementParser;
import com.renderx.pdflib.parser.Lexer;
import com.renderx.pdflib.parser.PDFArray;
import com.renderx.pdflib.parser.PDFDictionary;
import com.renderx.pdflib.parser.PDFElement;
import com.renderx.pdflib.parser.PDFIndirectObject;
import com.renderx.pdflib.parser.PDFName;
import com.renderx.pdflib.parser.PDFNumeric;
import com.renderx.pdflib.parser.PDFStream;
import com.renderx.pdflib.parser.PDFString;
import com.renderx.pdflib.parser.PDFUniversalObject;
import com.renderx.pdflib.parser.ParseUtils;
import com.renderx.pdflib.parser.Rectangle;
import com.renderx.pdflib.parser.XRefTable;
import com.renderx.util.Array;
import com.renderx.util.DefaultErrorHandler;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.SeekableByteArrayInputStream;
import com.renderx.util.SeekableInput;
import com.renderx.util.URLCache;
import com.renderx.util.URLSpec;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import junit.framework.Assert;
import junit.framework.TestCase;

public class PDFInstance
extends Image
implements Cloneable {
    Lexer input = null;
    public XRefTable xRefTable = null;
    int root_obj = 0;
    int pages_obj = 0;
    public boolean renumber = true;
    public int angle = 0;
    private boolean isLZW = false;
    Hashtable pagestoobj = new Hashtable();
    Hashtable pagesparent = new Hashtable();
    public Hashtable converObjects = new Hashtable();
    public List pendingObjects = new List();
    public List parentPages = new List();
    Hashtable lastPageFonts = new Hashtable();
    Hashtable lastPageImages = new Hashtable();
    private int countPages = 0;

    public PDFInstance() {
        this.mimetype = "application/pdf";
    }

    public void parse() throws IOException, ImageFormatException {
        try {
            this.parse(this.openSeekableImageStream());
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.close();
            throw throwable;
        }
        this.close();
    }

    public void parse(SeekableInput seekableInput) throws IOException, ImageFormatException {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<parsepdf>");
        }
        this.open(seekableInput);
        this.init();
        Rectangle rectangle = this.getMediaBox();
        if (this.angle == 0 || this.angle == 180) {
            this.width = rectangle.getWidth();
            this.height = rectangle.getHeight();
        } else {
            this.width = rectangle.getHeight();
            this.height = rectangle.getWidth();
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("</parsepdf>");
        }
    }

    private void init() throws IOException, ImageFormatException {
        this.checkHeader();
        this.xRefTable = new XRefTable(this.input.raf);
        this.readRoot(this.xRefTable.getRoot());
        this.readPages(this.pages_obj, -1);
        if (this.page >= this.countPages) {
            this.factory.errHandler.warning("Page " + (this.page + 1) + " not found in '" + this.source.toString() + "'; the first page selected.");
            this.page = 0;
        }
    }

    private void checkHeader() throws IOException, ImageFormatException {
        this.input.seek(0L);
        byte[] byArray = new byte[6];
        this.input.raf.readFully(byArray);
        if (byArray[0] != 37 || byArray[1] != 80 || byArray[2] != 68 || byArray[3] != 70 || byArray[4] != 45 || byArray[5] != 49) {
            throw new ImageFormatException("Wrong PDF file header");
        }
    }

    public void readRoot(int n) throws IOException, ImageFormatException {
        PDFDictionary pDFDictionary = this.getDictionary(this.getObject(n));
        if (pDFDictionary.dict.containsKey("/Pages") && this.pages_obj == 0) {
            this.pages_obj = ParseUtils.getIntFromIndirectObject((PDFElement)pDFDictionary.dict.get("/Pages"));
        }
    }

    public void readPages(int n, int n2) throws IOException, ImageFormatException {
        PDFDictionary pDFDictionary;
        if (n2 != -1) {
            this.pagesparent.put(new Integer(n), new Integer(n2));
        }
        if ("/Page".equals((pDFDictionary = this.getDictionary(this.getObject(n))).getType())) {
            this.pagestoobj.put(new Integer(this.countPages), new Integer(n));
            ++this.countPages;
            return;
        }
        if (pDFDictionary.dict.containsKey("/Kids")) {
            PDFArray pDFArray = (PDFArray)pDFDictionary.dict.get("/Kids");
            int n3 = 0;
            while (n3 < pDFArray.array.length()) {
                this.readPages(ParseUtils.getIntFromIndirectObject((PDFElement)pDFArray.array.get(n3)), n);
                ++n3;
            }
        }
    }

    public int getCountPages() {
        return this.countPages;
    }

    public short getColorSpace() throws IOException, ImageFormatException {
        return this.getColorSpace(this.page);
    }

    public short getColorSpace(int n) throws IOException, ImageFormatException {
        PDFDictionary pDFDictionary = this.getDictionary(this.getPage(n));
        if (pDFDictionary.dict.containsKey("/Group")) {
            PDFDictionary pDFDictionary2 = this.getDictionary(this.readTillUnIndirectObject((PDFElement)pDFDictionary.dict.get("/Group")));
            if (pDFDictionary2.dict.containsKey("/CS")) {
                PDFName pDFName;
                PDFElement pDFElement = this.readTillUnIndirectObject((PDFElement)pDFDictionary2.dict.get("/CS"));
                PDFName pDFName2 = pDFName = pDFElement instanceof PDFName ? (PDFName)pDFElement : (PDFName)((PDFArray)pDFElement).array.get(0);
                if ("/DeviceCMYK".equals(pDFName.value)) {
                    return 2;
                }
                if ("/DeviceRGB".equals(pDFName.value)) {
                    return 1;
                }
            }
        }
        return 0;
    }

    public PDFArray getAnnotations() throws IOException, ImageFormatException {
        return this.getAnnotations(this.page);
    }

    public PDFArray getAnnotations(int n) throws IOException, ImageFormatException {
        PDFArray pDFArray = new PDFArray();
        PDFDictionary pDFDictionary = this.getDictionary(this.getPage(n));
        if (pDFDictionary.dict.containsKey("/Annots")) {
            PDFElement pDFElement = this.readTillUnIndirectObject((PDFElement)pDFDictionary.dict.get("/Annots"));
            List list = pDFElement.getIndirectObjects();
            while (!list.isEmpty()) {
                int n2 = (Integer)list.shift();
                PDFUniversalObject pDFUniversalObject = this.getObject(n2);
                PDFDictionary pDFDictionary2 = this.getDictionary(pDFUniversalObject);
                if (pDFDictionary2.dict.containsKey("/Dest")) continue;
                pDFArray.array.put(pDFArray.array.length(), new PDFIndirectObject(String.valueOf(n2)));
            }
        }
        return pDFArray;
    }

    public PDFDictionary getResources() throws IOException, ImageFormatException {
        return this.getResources(this.page);
    }

    public PDFDictionary getResources(int n) throws IOException, ImageFormatException {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<getResources page=\"" + n + "\"/>");
        }
        return this.getResourcesByObject(ParseUtils.getIntFromHash(this.pagestoobj, n), n);
    }

    public PDFDictionary getResourcesByObject(int n, int n2) throws IOException, ImageFormatException {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<getResources page_obj=\"" + n + "\"/>");
        }
        PDFUniversalObject pDFUniversalObject = this.getObject(n);
        PDFDictionary pDFDictionary = this.getDictionary(pDFUniversalObject);
        PDFDictionary pDFDictionary2 = null;
        if (pDFDictionary.dict.containsKey("/Resources")) {
            pDFDictionary2 = (PDFDictionary)this.readTillUnIndirectObject((PDFElement)pDFDictionary.dict.get("/Resources"));
        } else {
            if (this.pagesparent.get(new Integer(n)) != null) {
                return this.getResourcesByObject(ParseUtils.getIntFromHash(this.pagesparent, n), n2);
            }
            pDFDictionary2 = new PDFDictionary();
        }
        return pDFDictionary2;
    }

    public Rectangle getMediaBox() throws IOException, ImageFormatException {
        return this.getMediaBox(this.page);
    }

    public Rectangle getMediaBox(int n) throws IOException, ImageFormatException {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<getMediaBox page=\"" + n + "\"/>");
        }
        return this.getMediaBoxByObject(ParseUtils.getIntFromHash(this.pagestoobj, n), n);
    }

    public Rectangle getMediaBoxByObject(int n, int n2) throws IOException, ImageFormatException {
        PDFElement pDFElement;
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<getMediaBoxByObject page_obj=\"" + n + "\"/>");
        }
        PDFUniversalObject pDFUniversalObject = this.getObject(n);
        PDFDictionary pDFDictionary = this.getDictionary(pDFUniversalObject);
        if (pDFDictionary.dict.containsKey("/Rotate")) {
            pDFElement = (PDFElement)pDFDictionary.dict.get("/Rotate");
            if (!(pDFElement instanceof PDFNumeric)) {
                throw new ImageFormatException("Broken pdf file " + this.toDisplayString() + ". Wrong rotate paremeter for page " + n2 + " (object " + ParseUtils.getIntFromHash(this.pagestoobj, n2) + ").");
            }
            this.angle = new Integer(((PDFNumeric)pDFElement).value);
            this.angle %= 360;
            int n3 = this.angle = this.angle < 0 ? 360 + this.angle : this.angle;
            if (this.angle != 0 && this.angle != 90 && this.angle != 180 && this.angle != 270) {
                throw new ImageFormatException("Broken pdf file " + this.toDisplayString() + ". Wrong rotate paremeter for page " + n2 + " (object " + ParseUtils.getIntFromHash(this.pagestoobj, n2) + ").");
            }
        }
        if (pDFDictionary.dict.containsKey("/CropBox")) {
            pDFElement = (PDFArray)this.readTillUnIndirectObject((PDFElement)pDFDictionary.dict.get("/CropBox"));
        } else if (pDFDictionary.dict.containsKey("/MediaBox")) {
            pDFElement = (PDFArray)this.readTillUnIndirectObject((PDFElement)pDFDictionary.dict.get("/MediaBox"));
        } else if (pDFDictionary.dict.containsKey("/ArtBox")) {
            pDFElement = (PDFArray)this.readTillUnIndirectObject((PDFElement)pDFDictionary.dict.get("/ArtBox"));
        } else {
            if (this.pagesparent.get(new Integer(n)) != null) {
                return this.getMediaBoxByObject(ParseUtils.getIntFromHash(this.pagesparent, n), n2);
            }
            throw new ImageFormatException("Broken pdf file " + this.toDisplayString() + ". None of /ArtBox, /CropBox, or /MediaBox for page " + n2 + " (object " + ParseUtils.getIntFromHash(this.pagestoobj, n2) + ") is found.");
        }
        return this.getRectangle((PDFArray)pDFElement);
    }

    public void getContent(OutputStream outputStream) throws IOException, ImageFormatException {
        this.getContent(this.page, outputStream);
    }

    public void parsePageHeader() throws IOException, ImageFormatException {
        this.parsePageHeader(this.page);
    }

    public PDFUniversalObject getPage() throws IOException, ImageFormatException {
        return this.getPage(this.page);
    }

    public PDFUniversalObject getPage(int n) throws IOException, ImageFormatException {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<getPage number=\"" + n + "\">");
        }
        PDFUniversalObject pDFUniversalObject = this.getObject(ParseUtils.getIntFromHash(this.pagestoobj, n));
        PDFDictionary pDFDictionary = this.getDictionary(pDFUniversalObject);
        String string = null;
        if (pDFDictionary.dict.containsKey("/Contents")) {
            PDFElement pDFElement = (PDFElement)pDFDictionary.dict.get("/Contents");
            if (pDFElement instanceof PDFArray) {
                string = this.checkFilters(pDFElement);
            } else if (pDFElement instanceof PDFIndirectObject) {
                PDFElement pDFElement2 = this.readTillUnIndirectObject(pDFElement);
                if (pDFElement2 instanceof PDFDictionary) {
                    PDFDictionary pDFDictionary2 = this.getDictionary(pDFElement2);
                    if (pDFDictionary2.dict.containsKey("/Filter")) {
                        string = pDFDictionary2.dict.get("/Filter").toString();
                    }
                } else if (pDFElement2 instanceof PDFArray) {
                    string = this.checkFilters(pDFElement2);
                }
            }
        }
        if (string != null && !string.equals("/FlateDecode")) {
            if (string.equals("/LZWDecode")) {
                pDFDictionary.dict.put("/Filter", new PDFString(string));
            } else if (string.equals("/ASCIIHexDecode") || string.equals("/ASCII85Decode") || string.equals("/RunLengthDecode")) {
                // empty if block
            }
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("</getPage>");
        }
        return pDFUniversalObject;
    }

    public String checkFilters(PDFElement pDFElement) throws IOException, ImageFormatException {
        boolean bl = false;
        int n = 0;
        while (n < ((PDFArray)pDFElement).array.length()) {
            PDFElement pDFElement2 = this.readTillUnIndirectObject((PDFElement)((PDFArray)pDFElement).array.get(n));
            PDFDictionary pDFDictionary = this.getDictionary(pDFElement2);
            boolean bl2 = false;
            if (pDFDictionary.dict.containsKey("/Filter")) {
                PDFElement pDFElement3;
                PDFElement pDFElement4 = this.readTillUnIndirectObject((PDFElement)pDFDictionary.dict.get("/Filter"));
                if (pDFElement4 instanceof PDFName) {
                    pDFElement3 = (PDFName)pDFElement4;
                    bl2 = pDFElement3.value.equals("/LZWDecode");
                } else if (pDFElement4 instanceof PDFArray) {
                    pDFElement3 = (PDFArray)pDFElement4;
                    int n2 = 0;
                    while (n2 < ((PDFArray)pDFElement3).array.length() && !bl2) {
                        Object object = ((PDFArray)pDFElement3).array.get(n2);
                        if (!(object instanceof PDFName)) {
                            throw new ImageFormatException("Filter array contains objects that are not names");
                        }
                        bl2 = ((PDFName)object).value.equals("/LZWDecode");
                        ++n2;
                    }
                }
            }
            if (n == 0) {
                bl = bl2;
            } else if (bl != bl2) {
                throw new ImageFormatException("LZW and non-LZW compression mixed in the content array of a page");
            }
            ++n;
        }
        if (bl) {
            return "/LZWDecode";
        }
        return null;
    }

    public void parseStreamObject(PDFUniversalObject pDFUniversalObject) throws IOException, ImageFormatException {
        if (pDFUniversalObject.objdata instanceof PDFStream) {
            PDFStream pDFStream = (PDFStream)pDFUniversalObject.objdata;
            if (!pDFStream.dict.containsKey("/Length")) {
                throw new ImageFormatException("Stream object " + pDFUniversalObject.obj_id + " has no length");
            }
            pDFStream.streamLength = this.readLength((PDFElement)pDFStream.dict.get("/Length"));
            int n = this.xRefTable.getIndex(pDFUniversalObject.obj_id);
            if (n != Integer.MIN_VALUE) {
                if (!"/ObjStm".equals(pDFStream.getType())) {
                    throw new ImageFormatException("Invalid stream object " + pDFUniversalObject.objdata);
                }
                pDFStream = this.getStream(pDFUniversalObject);
                pDFStream.decompress();
                int n2 = Integer.parseInt(((PDFNumeric)pDFStream.dict.get((Object)"/First")).value);
                byte[] byArray = new byte[n2];
                System.arraycopy(pDFStream.array, 0, byArray, 0, n2);
                String string = new String(byArray, "UTF-8");
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                int n3 = -1;
                int n4 = -1;
                int n5 = -1;
                int n6 = 0;
                while (n6 <= n) {
                    n5 = Integer.parseInt(stringTokenizer.nextToken());
                    n4 = Integer.parseInt(stringTokenizer.nextToken()) + n2;
                    ++n6;
                }
                if (n + 1 == Integer.parseInt(((PDFNumeric)pDFStream.dict.get((Object)"/N")).value)) {
                    n3 = pDFStream.array.length;
                } else {
                    stringTokenizer.nextToken();
                    n3 = Integer.parseInt(stringTokenizer.nextToken()) + n2;
                }
                byte[] byArray2 = new byte[n3 - n4 + 8];
                System.arraycopy(pDFStream.array, n4, byArray2, 0, n3 - n4);
                byArray2[byArray2.length - 8] = 10;
                byArray2[byArray2.length - 7] = 101;
                byArray2[byArray2.length - 6] = 110;
                byArray2[byArray2.length - 5] = 100;
                byArray2[byArray2.length - 4] = 111;
                byArray2[byArray2.length - 3] = 98;
                byArray2[byArray2.length - 2] = 106;
                byArray2[byArray2.length - 1] = 10;
                SeekableByteArrayInputStream seekableByteArrayInputStream = new SeekableByteArrayInputStream(byArray2);
                Lexer lexer = new Lexer(seekableByteArrayInputStream);
                lexer.seek(0L);
                pDFUniversalObject.objdata = ElementParser.parse(lexer);
            }
        }
    }

    public PDFUniversalObject getObject(int n) throws IOException, ImageFormatException {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<readObject number=\"" + n + "\">");
        }
        long l = this.xRefTable.getOffset(n);
        this.input.raf.seek(l);
        this.input.needReadNext = true;
        PDFUniversalObject pDFUniversalObject = new PDFUniversalObject(n);
        this.input.nextToken();
        this.input.nextToken();
        this.input.nextToken();
        pDFUniversalObject.objdata = ElementParser.parse(this.input);
        this.parseStreamObject(pDFUniversalObject);
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("</readObject>");
        }
        return pDFUniversalObject;
    }

    public void parsePageHeader(int n) throws IOException, ImageFormatException {
        this.getObject(ParseUtils.getIntFromHash(this.pagestoobj, n));
    }

    public void getContent(int n, OutputStream outputStream) throws IOException, ImageFormatException {
        Object object;
        PDFUniversalObject pDFUniversalObject = this.getObject(ParseUtils.getIntFromHash(this.pagestoobj, n));
        PDFDictionary pDFDictionary = this.getDictionary(pDFUniversalObject);
        Array array = new Array(0);
        if (pDFDictionary.dict.containsKey("/Contents")) {
            PDFElement pDFElement = (PDFElement)pDFDictionary.dict.get("/Contents");
            if (pDFElement instanceof PDFArray) {
                array = this.composeArray(pDFElement, outputStream);
            } else if (pDFElement instanceof PDFIndirectObject) {
                object = this.getObject(((PDFIndirectObject)pDFElement).intValue());
                if (((PDFUniversalObject)object).objdata instanceof PDFDictionary) {
                    PDFStream pDFStream;
                    block14: {
                        pDFStream = this.getStream((PDFUniversalObject)object);
                        try {
                            pDFStream.decompress();
                        }
                        catch (EOFException eOFException) {
                            if (this.factory.errHandler == null) break block14;
                            this.factory.errHandler.warning("'" + eOFException.getMessage() + "' in " + this.toDisplayString() + "; some data may be lost.");
                        }
                    }
                    array.put(0, pDFStream);
                    if (pDFStream.minFilter().equals("/LZWDecode")) {
                        this.isLZW = true;
                    }
                } else if (((PDFUniversalObject)object).objdata instanceof PDFArray) {
                    array = this.composeArray(((PDFUniversalObject)object).objdata, outputStream);
                }
            } else {
                throw new ImageFormatException("Broken pdf file " + this.toDisplayString() + ". Wrong page contents value");
            }
        }
        if (this.isLZW) {
            this.copyLZWStrips(outputStream, array);
        } else {
            int n2 = 0;
            while (n2 < array.length()) {
                object = (PDFStream)array.get(n2);
                outputStream.write(((PDFStream)object).array);
                ++n2;
            }
        }
    }

    Array composeArray(PDFElement pDFElement, OutputStream outputStream) throws IOException, ImageFormatException {
        Array array = new Array(0);
        int n = 0;
        int n2 = 0;
        while (n2 < ((PDFArray)pDFElement).array.length()) {
            PDFElement pDFElement2 = (PDFElement)((PDFArray)pDFElement).array.get(n2);
            if (pDFElement2 instanceof PDFIndirectObject) {
                PDFUniversalObject pDFUniversalObject = this.getObject(((PDFIndirectObject)((PDFArray)pDFElement).array.get(n2)).intValue());
                PDFStream pDFStream = this.getStream(pDFUniversalObject);
                pDFStream.decompress();
                if (pDFStream.minFilter().equals("/LZWDecode")) {
                    this.isLZW = true;
                }
                array.put(n, pDFStream);
                ++n;
            } else {
                throw new ImageFormatException("Broken pdf file " + this.toDisplayString() + ". Wrong page contents array");
            }
            ++n2;
        }
        return array;
    }

    private void copyLZWStrips(OutputStream outputStream, Array array) throws IOException, ImageFormatException {
        int n;
        int n2;
        byte[] byArray = new byte[8192];
        byte by = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < array.length()) {
            int n5;
            n2 = ((PDFStream)array.get((int)n4)).array.length;
            if (n2 < 4) {
                throw new ImageFormatException("An LZW-encoded strip is too short, only " + n2 + " bytes long - data format error in PDF file " + this.toDisplayString());
            }
            if (byArray.length < n2) {
                byArray = new byte[n2];
            }
            if ((n = (((byArray = ((PDFStream)array.get((int)n4)).array)[0] & 0xFF) << 1) + ((byArray[1] & 0xFF) >> 7)) != 256) {
                throw new ImageFormatException("An LZW-encoded strip does not start with ClearCode pattern (100000000) - data format error in PDF image " + this.toDisplayString());
            }
            long l = (byArray[n2 - 4] << 24 & 0xFF000000) + (byArray[n2 - 3] << 16 & 0xFF0000) + (byArray[n2 - 2] << 8 & 0xFF00) + (byArray[n2 - 1] & 0xFF);
            int n6 = 0;
            while (n6 < 24) {
                if ((l >> n6 & 0x1FFL) == 257L) break;
                ++n6;
            }
            if (n6 == 24) {
                throw new ImageFormatException("An LZW-encoded strip does not end with EOI pattern (100000001) - data format error in PDF file " + this.toDisplayString());
            }
            if (n3 != 0) {
                by = (byte)(by | (0xFF & byArray[0]) >>> n3);
                byArray[0] = (byte)(byArray[0] << 8 - n3);
                n5 = 0;
                while (n5 < n2 - 1) {
                    int n7 = n5;
                    byArray[n7] = (byte)(byArray[n7] | (0xFF & byArray[n5 + 1]) >>> n3);
                    int n8 = n5 + 1;
                    byArray[n8] = (byte)(byArray[n8] << 8 - n3);
                    ++n5;
                }
                outputStream.write(by);
            }
            n5 = 8 * n2 - 9 - n6 - (8 - n3) % 8;
            n2 = n5 / 8;
            n3 = n5 % 8;
            by = (byte)(byArray[n2] & (byte)(255 << 8 - n3));
            outputStream.write(byArray, 0, n2);
            ++n4;
        }
        n2 = (byte)(by | (byte)(128 >>> n3));
        n = 128 >>> n3;
        outputStream.write(n2);
        outputStream.write(n);
    }

    public Rectangle getRectangle(PDFArray pDFArray) throws IOException, ImageFormatException {
        return new Rectangle(new Double(this.readTillUnIndirectObject((PDFElement)pDFArray.array.get(0)).toString()), new Double(this.readTillUnIndirectObject((PDFElement)pDFArray.array.get(1)).toString()), new Double(this.readTillUnIndirectObject((PDFElement)pDFArray.array.get(2)).toString()), new Double(this.readTillUnIndirectObject((PDFElement)pDFArray.array.get(3)).toString()));
    }

    public PDFDictionary getDictionary(PDFUniversalObject pDFUniversalObject) throws ImageFormatException {
        if (!(pDFUniversalObject.objdata instanceof PDFDictionary)) {
            throw new ImageFormatException("Broken page tree object " + pDFUniversalObject.obj_id);
        }
        return (PDFDictionary)pDFUniversalObject.objdata;
    }

    public PDFDictionary getDictionary(PDFElement pDFElement) throws ImageFormatException {
        if (!(pDFElement instanceof PDFDictionary)) {
            throw new ImageFormatException("Broken page dictionary " + pDFElement);
        }
        return (PDFDictionary)pDFElement;
    }

    public PDFElement readTillUnIndirectObject(PDFElement pDFElement) throws IOException, ImageFormatException {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<readTillUnIndirectObject/>");
        }
        if (!(pDFElement instanceof PDFIndirectObject)) {
            return pDFElement;
        }
        PDFUniversalObject pDFUniversalObject = this.getObject(((PDFIndirectObject)pDFElement).intValue());
        while (pDFUniversalObject.objdata instanceof PDFIndirectObject) {
            pDFUniversalObject = this.getObject(((PDFIndirectObject)pDFUniversalObject.objdata).intValue());
        }
        return pDFUniversalObject.objdata;
    }

    long readLength(PDFElement pDFElement) throws IOException, ImageFormatException {
        PDFElement pDFElement2;
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<readLength/>");
        }
        if ((pDFElement2 = this.readTillUnIndirectObject(pDFElement)) instanceof PDFNumeric && ((PDFNumeric)pDFElement2).isUnsignedInteger) {
            return ParseUtils.readDigits(((PDFNumeric)pDFElement2).value);
        }
        throw new ImageFormatException("Wrong Length element " + pDFElement2);
    }

    public PDFStream getStream(PDFUniversalObject pDFUniversalObject) throws IOException, ImageFormatException {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<getStream>");
        }
        PDFStream pDFStream = (PDFStream)pDFUniversalObject.objdata;
        pDFStream.filters = this.readTillUnIndirectObject((PDFElement)pDFStream.dict.get("/Filter"));
        pDFStream.array = ParseUtils.getStreamData(this.input.raf, pDFStream.streamOffset, pDFStream.streamLength);
        if (pDFStream.minFilter().equals("/LZWDecode")) {
            this.isLZW = true;
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("</getStream>");
        }
        return pDFStream;
    }

    public Integer newID(Object object) {
        return this.newID((Integer)object);
    }

    public Integer newID(Integer n) {
        return (Integer)this.converObjects.get("" + n);
    }

    public Integer newID(int n) {
        return (Integer)this.converObjects.get("" + n);
    }

    public int addNewID(String string, Integer n) {
        if (!this.converObjects.containsKey(string)) {
            this.converObjects.put("" + string, n);
            return n + 1;
        }
        return n;
    }

    public int addNewID(int n, int n2) {
        return this.addNewID("" + n, new Integer(n2));
    }

    public int addNewID(Integer n, int n2) {
        return this.addNewID("" + n, new Integer(n2));
    }

    public void open() throws IOException {
        this.open(this.openSeekableImageStream());
    }

    public void open(SeekableInput seekableInput) throws IOException {
        this.input = new Lexer(seekableInput);
    }

    public void close() throws IOException {
        this.input.raf.close();
        this.input = null;
    }

    public Object clone() {
        PDFInstance pDFInstance = new PDFInstance();
        pDFInstance.xRefTable = this.xRefTable;
        pDFInstance.root_obj = this.root_obj;
        pDFInstance.pages_obj = this.pages_obj;
        pDFInstance.countPages = this.countPages;
        pDFInstance.renumber = this.renumber;
        pDFInstance.angle = this.angle;
        pDFInstance.page = this.page;
        pDFInstance.isLZW = this.isLZW;
        pDFInstance.pagestoobj = this.pagestoobj;
        pDFInstance.pagesparent = this.pagesparent;
        pDFInstance.converObjects = (Hashtable)this.converObjects.clone();
        pDFInstance.pendingObjects = (List)this.pendingObjects.clone();
        pDFInstance.parentPages = (List)this.parentPages.clone();
        pDFInstance.lastPageFonts = this.lastPageFonts;
        pDFInstance.lastPageImages = this.lastPageImages;
        pDFInstance.factory = this.factory;
        pDFInstance.source = this.source;
        return pDFInstance;
    }

    public static final class Test
    extends TestCase {
        ErrorHandler errorHandler = new DefaultErrorHandler();
        URLCache urlcache;
        FontCatalog fontCatalog;
        ImageFactory imageFactory;

        public void setUp() {
            try {
                this.urlcache = new URLCache(this.errorHandler);
                this.fontCatalog = new FontCatalog(this.urlcache, this.errorHandler);
                this.imageFactory = new ImageFactory(this.fontCatalog, this.urlcache, this.errorHandler);
            }
            catch (IOException iOException) {
                Assert.fail((String)("Cannot create font catalog or image factory: " + iOException));
            }
            catch (FontConfigurationException fontConfigurationException) {
                Assert.fail((String)("Cannot create font catalog: " + fontConfigurationException));
            }
        }

        public void testMediaBoxSimple() {
            try {
                this.resourceToFile("com/renderx/pdflib/parser/TEST_DATA/mediaBoxSimple.pdf", "1.tst");
                PDFInstance pDFInstance = (PDFInstance)this.imageFactory.makeImage(new URLSpec("1.tst"), "application/pdf");
                pDFInstance.open();
                Rectangle rectangle = pDFInstance.getMediaBox();
                NameHashtable nameHashtable = new NameHashtable("com/renderx/pdflib/parser/TEST_DATA/mediaBoxSimple.test");
                Assert.assertTrue((boolean)((String)nameHashtable.ht.get("MediaBox")).equals(rectangle.toString()));
                pDFInstance = null;
                rectangle = null;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                Assert.assertTrue((boolean)false);
            }
        }

        public void testMediaBoxComplicaded() {
            try {
                this.resourceToFile("com/renderx/pdflib/parser/TEST_DATA/mediaBoxComplicaded.pdf", "1.tst");
                PDFInstance pDFInstance = (PDFInstance)this.imageFactory.makeImage(new URLSpec("1.tst"), "application/pdf");
                pDFInstance.open();
                Rectangle rectangle = pDFInstance.getMediaBox();
                NameHashtable nameHashtable = new NameHashtable("com/renderx/pdflib/parser/TEST_DATA/mediaBoxComplicaded.test");
                Assert.assertTrue((boolean)((String)nameHashtable.ht.get("MediaBox")).equals(rectangle.toString()));
                pDFInstance = null;
                rectangle = null;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                Assert.assertTrue((boolean)false);
            }
        }

        public void testMediaBoxMoreComplicaded() {
            try {
                this.resourceToFile("com/renderx/pdflib/parser/TEST_DATA/mediaBoxMoreComplicaded.pdf", "1.tst");
                PDFInstance pDFInstance = (PDFInstance)this.imageFactory.makeImage(new URLSpec("1.tst"), "application/pdf");
                pDFInstance.open();
                Rectangle rectangle = pDFInstance.getMediaBox();
                NameHashtable nameHashtable = new NameHashtable("com/renderx/pdflib/parser/TEST_DATA/mediaBoxMoreComplicaded.test");
                Assert.assertTrue((boolean)((String)nameHashtable.ht.get("MediaBox")).equals(rectangle.toString()));
                pDFInstance = null;
                rectangle = null;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                Assert.assertTrue((boolean)false);
            }
        }

        private void resourceToFile(String string, String string2) throws IOException {
            int n;
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray, 0, 1024)) >= 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
        }

        class NameHashtable {
            Hashtable ht;

            NameHashtable(String string) throws Exception {
                String string2;
                DataInputStream dataInputStream = new DataInputStream(ClassLoader.getSystemResourceAsStream(string));
                this.ht = new Hashtable();
                while ((string2 = dataInputStream.readLine()) != null) {
                    this.ht.put(string2.substring(0, string2.indexOf(" ")), string2.substring(string2.indexOf(" ") + 1));
                }
                dataInputStream.close();
            }

            boolean equals(Hashtable hashtable) {
                if (this.ht.size() != hashtable.size()) {
                    return false;
                }
                Enumeration enumeration = this.ht.keys();
                while (enumeration.hasMoreElements()) {
                    String string;
                    String string2 = (String)enumeration.nextElement();
                    if (!hashtable.containsKey(string2)) {
                        return false;
                    }
                    String string3 = (String)this.ht.get(string2);
                    if (string3.equals(string = (String)hashtable.get(string2))) continue;
                    return false;
                }
                return true;
            }
        }
    }
}

