/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts.afp;

import com.renderx.fonts.afp.CodedFontIndexData;
import com.renderx.fonts.afp.FontResourceObject;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class CodedFont
extends FontResourceObject {
    public static final byte[] BCF = new byte[]{-45, -88, -118};
    public static final byte[] CFC = new byte[]{-45, -89, -118};
    public static final byte[] CFI = new byte[]{-45, -116, -118};
    private String name;
    private byte cfiGroupLength;
    private ArrayList codedFontIndex;

    public String getName() {
        return this.name;
    }

    public byte getCfiGroupLength() {
        return this.cfiGroupLength;
    }

    public ArrayList getCodedFontIndex() {
        return this.codedFontIndex;
    }

    public void load(String string) throws IOException {
        this.load(new FileInputStream(string));
    }

    public void load(InputStream inputStream) throws IOException {
        byte[] byArray = FontResourceObject.readStructuredField(inputStream, BCF);
        byte[] byArray2 = new byte[8];
        int n = 0;
        while (n < byArray.length) {
            if (n < 8) {
                byArray2[n] = byArray[n];
            }
            ++n;
        }
        this.name = new String(byArray2, this.getEncoding()).trim();
        byArray2 = null;
        byArray = FontResourceObject.readStructuredField(inputStream, CFC);
        int n2 = 0;
        while (n2 < byArray.length) {
            if (n2 == 0) {
                this.cfiGroupLength = byArray[n2];
            }
            ++n2;
        }
        byArray = FontResourceObject.readStructuredField(inputStream, CFI);
        this.codedFontIndex = new ArrayList();
        byte[] byArray3 = new byte[this.cfiGroupLength];
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            int n5 = n4 - this.cfiGroupLength * n3;
            byArray3[n5] = byArray[n4];
            if (n5 == this.cfiGroupLength - 1) {
                CodedFontIndexData codedFontIndexData = new CodedFontIndexData();
                codedFontIndexData.parse(byArray3, this.getEncoding());
                this.codedFontIndex.add(codedFontIndexData);
                byArray3 = new byte[this.cfiGroupLength];
                ++n3;
            }
            ++n4;
        }
        byArray3 = null;
        byArray = null;
    }
}

