/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afplib.AFP;
import com.renderx.afplib.AFPInternalException;
import com.renderx.afplib.Point2D;
import com.renderx.afplib.XGraphic;
import com.renderx.afplib.XImage;
import com.renderx.graphics.BitmapImage;
import com.renderx.xep.lib.Conf;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;

public class XNativeImage
extends XImage {
    short bitsPerPixel = 0;
    Conf.DataType dataType = null;

    protected XNativeImage(XGraphic xGraphic) {
        super(xGraphic.image);
        this.dataType = (Conf.DataType)xGraphic.page.getConfig().dataTypes.get(xGraphic.image.mimetype);
    }

    public void loadImage() throws MalformedURLException, IOException {
        BitmapImage bitmapImage = (BitmapImage)this.image;
        this.pixelSize = new Point2D(bitmapImage.pxWidth, bitmapImage.pxHeight);
        this.bitsPerPixel = (short)(XNativeImage.getRows(bitmapImage.colorSpace) * 8);
        this.resolution = new Point2D(bitmapImage.horzResolution, bitmapImage.vertResolution);
    }

    public void writeExtras(AFP aFP) throws IOException, AFPInternalException {
        aFP.writeIocaLSDF(151, 1);
        aFP.writeByte(0);
    }

    public int getExtrasSize() {
        return 3;
    }

    static short getRows(short s) {
        short s2 = 0;
        switch (s) {
            case 4: {
                s2 = 1;
                break;
            }
            case 1: {
                s2 = 3;
                break;
            }
            case 2: 
            case 3: {
                s2 = 4;
                break;
            }
            default: {
                s2 = 3;
            }
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeImageData(AFP aFP) throws IOException {
        InputStream inputStream = this.image.openImageStream();
        try {
            int n;
            byte[] byArray = new byte[32000];
            while ((n = inputStream.read(byArray)) != -1) {
                aFP.writeModcaSF("IPD", 12 + n);
                aFP.writeIocaESDF(65170, n);
                int n2 = aFP.writeBytes(byArray, 0, n);
                aFP.flush();
            }
        }
        finally {
            inputStream.close();
        }
    }

    public short getIOCAEncodingCode() {
        return (short)this.dataType.getCompressionCode();
    }

    public short getIDESize() {
        return this.bitsPerPixel;
    }
}

