/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afplib.AFP;
import com.renderx.afplib.AFPException;
import com.renderx.afplib.AFPInternalException;
import com.renderx.afplib.Point2D;
import com.renderx.afplib.Util;
import com.renderx.util.Array;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.Sort;
import java.io.IOException;

public class FormDef {
    private Point2D mediumSize = new Point2D(0, 0);
    private Array pageDefs = new Array();
    private Array copyGroups = new Array();
    private boolean isCorrect = false;

    public FormDef() {
    }

    public FormDef(int n, int n2) {
        this.mediumSize = new Point2D(n, n2);
        this.isCorrect = true;
    }

    public FormDef(int n, int n2, short s, short s2, int n3, int n4) {
        this.mediumSize = new Point2D(n, n2);
        this.pageDefs.put(0, new PageDef(s, s2, n3, n4));
        this.isCorrect = true;
    }

    public int nPageDefs() {
        return this.pageDefs == null ? 0 : this.pageDefs.length();
    }

    public void clearPageDefs() {
        this.pageDefs = new Array();
    }

    public void addPageDef(int n, PageDef pageDef) {
        if (this.pageDefs.get(n) == null) {
            this.pageDefs.put(this.pageDefs.length(), pageDef);
        }
    }

    public int nCopyGroups() {
        return this.copyGroups == null ? 0 : this.copyGroups.length();
    }

    public void clearCopyGroups() {
        this.copyGroups = new Array();
    }

    public void addCopyGroup(int n, CopyCountGroup copyCountGroup) {
        if (this.copyGroups.get(n) == null) {
            this.copyGroups.put(this.copyGroups.length(), copyCountGroup);
        }
    }

    public void writeToResource(AFP aFP, ErrorHandler errorHandler) throws AFPInternalException {
        if (!this.isCorrect) {
            return;
        }
        if (aFP == null) {
            return;
        }
        try {
            CopyCountGroup copyCountGroup;
            int n;
            int n2;
            aFP.writeModcaSFNamed("BFM", "F0000001");
            aFP.flush();
            aFP.writeModcaSFNamed("BMM", "MM000001");
            aFP.flush();
            aFP.startAccumulation();
            aFP.writeModcaSF("PGP");
            aFP.writeByte(1);
            for (n2 = 0; n2 < this.pageDefs.length(); ++n2) {
                PageDef pageDef = (PageDef)this.pageDefs.get(n2);
                aFP.writeByte(10);
                aFP.writePoint(new Point2D(pageDef.xOriginOnMedium, pageDef.yOriginOnMedium));
                aFP.writeShort(pageDef.orientation);
                aFP.writeByte(pageDef.pageType);
            }
            aFP.writeAccumulatedLength(1);
            this.mediumSize = this.mediumSize == null ? new Point2D(0, 0) : this.mediumSize.toAFPCoordinates();
            aFP.writeModcaSF("MDD", 20);
            aFP.writeMeasurementUnitBytes();
            aFP.writeResolutionBytes();
            aFP.writePoint(this.mediumSize);
            aFP.writeByte(0);
            aFP.flush();
            n2 = 0;
            for (n = 0; n < this.copyGroups.length(); ++n) {
                n2 += ((CopyCountGroup)this.copyGroups.get((int)n)).isDuplex ? 2 : 1;
            }
            aFP.writeModcaSF("MCC", 8 + n2 * 6);
            n = 1;
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.copyGroups.length()) {
                copyCountGroup = (CopyCountGroup)this.copyGroups.get(n4);
                aFP.writeShort(n);
                aFP.writeShort(n + copyCountGroup.numberOfCopies - 1);
                n += copyCountGroup.numberOfCopies;
                aFP.writeByte(0);
                aFP.writeByte(n4 & 0x7F);
                if (copyCountGroup.isDuplex) {
                    aFP.writeShort(n);
                    aFP.writeShort(n + copyCountGroup.numberOfCopies - 1);
                    n += copyCountGroup.numberOfCopies;
                    aFP.writeByte(0);
                    aFP.writeByte(n4 & 0x7F);
                }
                ++n4;
                n3 = (short)(n3 + 1);
            }
            aFP.flush();
            n4 = 0;
            while (n4 < this.copyGroups.length()) {
                copyCountGroup = (CopyCountGroup)this.copyGroups.get(n4);
                CopyCountGroup.KeywordValueTuple[] keywordValueTupleArray = copyCountGroup.getOptions();
                aFP.writeModcaSF("MMC", 10 + 2 * keywordValueTupleArray.length);
                aFP.writeByte(n4 & 0x7F);
                aFP.writeByte(255);
                for (int i = 0; i < keywordValueTupleArray.length; ++i) {
                    aFP.writeByte(keywordValueTupleArray[i].keyword);
                    aFP.writeByte(keywordValueTupleArray[i].value);
                }
                ++n4;
                n3 = (short)(n3 + 1);
            }
            aFP.flush();
            aFP.writeModcaSFNamed("EMM", "MM000001");
            aFP.flush();
            aFP.writeModcaSFNamed("EFM", "F0000001");
            aFP.flush();
        }
        catch (IOException iOException) {
            errorHandler.exception("Can't write form definition resource object", iOException);
        }
    }

    public static class PageDef {
        public final short pageType;
        public final short orientation;
        public final int xOriginOnMedium;
        public final int yOriginOnMedium;

        public PageDef() {
            this.xOriginOnMedium = 0;
            this.yOriginOnMedium = 0;
            this.orientation = 0;
            this.pageType = 0;
        }

        public PageDef(short s, short s2, int n, int n2) {
            this.pageType = s;
            this.xOriginOnMedium = n;
            this.yOriginOnMedium = n2;
            this.orientation = s2;
        }

        public static class PageType {
            public static final short FRONT_PAGE = 0;
            public static final short BACK_PAGE = 1;
            public static final short P1_FRONT_PAGE = 16;
            public static final short P1_BACK_PAGE = 17;
            public static final short P2_FRONT_PAGE = 32;
            public static final short P2_BACK_PAGE = 33;
            public static final short P3_FRONT_PAGE = 48;
            public static final short P3_BACK_PAGE = 49;
            public static final short P4_FRONT_PAGE = 64;
            public static final short P4_BACK_PAGE = 65;
            private static final Hashtable pageTypeDecoding = new Hashtable();

            public static short decode(String string) throws AFPException {
                Short s = (Short)pageTypeDecoding.get(string);
                if (s != null) {
                    return s;
                }
                throw new AFPException("Wrong value of AFP page type \"" + string + "\"");
            }

            static {
                pageTypeDecoding.put("default-front-page", new Short(0));
                pageTypeDecoding.put("default-back-page", new Short(1));
                pageTypeDecoding.put("p1-front-page", new Short(16));
                pageTypeDecoding.put("p1-back-page", new Short(17));
                pageTypeDecoding.put("p2-front-page", new Short(32));
                pageTypeDecoding.put("p2-back-page", new Short(33));
                pageTypeDecoding.put("p3-front-page", new Short(48));
                pageTypeDecoding.put("p3-back-page", new Short(49));
                pageTypeDecoding.put("p4-front-page", new Short(64));
                pageTypeDecoding.put("p4-back-page", new Short(65));
                pageTypeDecoding.put("default-front", new Short(0));
                pageTypeDecoding.put("default-back", new Short(1));
                pageTypeDecoding.put("p1-front", new Short(16));
                pageTypeDecoding.put("p1-back", new Short(17));
                pageTypeDecoding.put("p2-front", new Short(32));
                pageTypeDecoding.put("p2-back", new Short(33));
                pageTypeDecoding.put("p3-front", new Short(48));
                pageTypeDecoding.put("p3-back", new Short(49));
                pageTypeDecoding.put("p4-front", new Short(64));
                pageTypeDecoding.put("p4-back", new Short(65));
            }
        }

        public static class Orientation {
            public static final short $0_DEGRIES = 0;
            public static final short $90_DEGRIES = 11520;
            public static final short $180_DEGRIES = 23040;
            public static final short $270_DEGRIES = -30976;
            private static final Hashtable orientationDecoding = new Hashtable();

            public static short decode(String string) throws AFPException {
                Short s = (Short)orientationDecoding.get(string);
                if (s != null) {
                    return s;
                }
                throw new AFPException("Wrong value of AFP page orientation \"" + string + "\". Must be 0, 90, 180 or 270.");
            }

            static {
                orientationDecoding.put("0", new Short(0));
                orientationDecoding.put("90", new Short(11520));
                orientationDecoding.put("180", new Short(23040));
                orientationDecoding.put("270", new Short(-30976));
            }
        }
    }

    public static class CopyCountGroup {
        public final short numberOfCopies;
        public final boolean isDuplex;
        private Array options = new Array();

        public CopyCountGroup() {
            this.numberOfCopies = 1;
            this.isDuplex = false;
        }

        public CopyCountGroup(short s) {
            this(s, false, false);
        }

        public CopyCountGroup(short s, boolean bl) {
            this(s, bl, false);
        }

        public CopyCountGroup(short s, boolean bl, boolean bl2) {
            this.numberOfCopies = s;
            this.isDuplex = bl;
            if (bl) {
                this.options.put(this.options.length(), new KeywordValueTuple(244, bl2 ? 3 : 2));
            }
        }

        public void addOptionValue(KeywordValueTuple keywordValueTuple) {
            this.options.put(this.options.length(), keywordValueTuple);
        }

        public KeywordValueTuple[] getOptions() {
            Object[] objectArray = Sort.sort(this.options.datacopy(), new Sort.Cmp(this){
                private final /* synthetic */ CopyCountGroup this$0;
                {
                    this.this$0 = copyCountGroup;
                }

                public int cmp(Object object, Object object2) {
                    short s = Util.unsignedByteToUnsignedShort(((KeywordValueTuple)object).keyword);
                    short s2 = Util.unsignedByteToUnsignedShort(((KeywordValueTuple)object2).keyword);
                    int n = s - s2;
                    return n;
                }
            });
            KeywordValueTuple[] keywordValueTupleArray = new KeywordValueTuple[objectArray.length];
            for (int i = 0; i < keywordValueTupleArray.length; ++i) {
                keywordValueTupleArray[i] = (KeywordValueTuple)objectArray[i];
            }
            return keywordValueTupleArray;
        }

        public static class KeywordValueTuple {
            public final byte keyword;
            public final byte value;

            public KeywordValueTuple(short s, short s2) {
                this.keyword = (byte)s;
                this.value = (byte)s2;
            }

            public KeywordValueTuple(int n, int n2) {
                this((short)n, (short)n2);
            }
        }
    }
}

